<?php
/***************************************************************
 *  Copyright notice
 *
 *  (c) 2013 Heinz A. Krebs <heinz@chemit.at>
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 * Hint: use extdeveval to insert/update function index above.
 */
if (!class_exists('tslib_pibase')) {
    require_once (PATH_tslib . 'class.tslib_pibase.php');
}
/**
 * Plugin 'TISS Staffheader' for the 'tuw_informations' extension.
 *
 * @author    Heinz A. Krebs <heinz@chemit.at>
 * @package    TYPO3
 * @subpackage    tx_tuwinformations
 */
class tx_tuwinformations_pi4 extends tslib_pibase {
    var $prefixId = 'tx_tuwinformations_pi4'; // Same as class name
    var $scriptRelPath = 'pi4/class.tx_tuwinformations_pi4.php'; // Path to this script relative to the extension dir.
    var $extKey = 'tuw_informations'; // The extension key.
    var $pi_checkCHash = true;
    /**
     * The main method of the PlugIn
     *
     * @param    string        $content: The PlugIn content
     * @param    array        $conf: The PlugIn configuration
     * @return    The content that is displayed on the website
     */
    function main($content, $conf) {
        $this->conf = $conf;
        $this->pi_setPiVarDefaults();
        $this->pi_loadLL();
        $this->pi_initPIflexForm();
        $piFlexForm = $this->cObj->data['pi_flexform'];
        $this->template = $this->cObj->fileResource('EXT:tuw_informations/template.html');
        $subpart = $this->cObj->getSubpart($this->template, '###' . $this->pi_getFFvalue($piFlexForm, 'layout') . '###');
        $oid = $this->pi_getFFvalue($piFlexForm, 'oid');
        $res = $GLOBALS['TYPO3_DB']->exec_SELECTquery('*', 'tx_tuwinformations_persons', 'oid=' . $oid);
        if ($row = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
            $subpartArray = array();
            $markerArray['###OID###'] = $oid;
            $markerArray['###FIRSTNAME###'] = $row['firstname'];
            $markerArray['###LASTNAME###'] = $row['lastname'];
            $markerArray['###TITLE###'] = $row['title'];
            if ($row['postpositioned_titles'] != '') {
                $markerArray['###POSTTITLE###'] = $row['postpositioned_titles'];
                $markerArray['###POSTTITLESEPARATION###'] = ", ";
            } else {
                $markerArray['###POSTTITLE###'] = "";
                $markerArray['###POSTTITLESEPARATION###'] = "";
            }
            $markerArray['###STREET###'] = $row['street'];
            $markerArray['###CITY###'] = $row['zip'] . " " . $row['city'];
            $markerArray['###ROOM###'] = $row['room'];
            $mapfile = sprintf('/%sres/img/maps/%s.png', t3lib_extMgm::siteRelPath($this->extKey), substr($row['room'], 0, 2));
            if (file_exists(getcwd() . $mapfile)) {
                $markerArray['###MAPLINK###'].= ' <a href=javascript:peShowMap(\'' . $mapfile . '\');void(0);>view map</a>';
            };
            if ($row['room'] == '') {
                $subpartArray['###ROW_ROOM###'] = '';
            };
            if ($this->pi_getFFvalue($piFlexForm, 'picture') != '') {
                $img['file'] = $this->pi_getFFvalue($piFlexForm, 'picture');
                //$config['file.']['width'] = '80';
                $img['file.']['height'] = '240';
                //$img['params'] = 'height="240"';
                $image = $this->cObj->IMAGE($img);
                $markerArray['###PICTURE_URL###'] = $image;
            } else {
                $subpartArray['###ROW_PICTURE###'] = '';
            }
            $subparts['phone'] = $this->cObj->getSubpart($subpart, '###ROW_PHONE###');
            $res2 = $GLOBALS['TYPO3_DB']->exec_SELECTquery('phone', 'tx_tuwinformations_phones', 'oid=' . $oid, 'sort');
            $content = '';
            while ($row2 = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res2)) {
                $subpartArray['###PHONE###'] = $row2['phone'];
                $content.= $this->cObj->substituteMarkerArrayCached($subparts['phone'], $subpartArray);
            }
            $subpartArray['###ROW_PHONE###'] = $content;
            $GLOBALS['TYPO3_DB']->sql_free_result($res2);
            $subparts['fax'] = $this->cObj->getSubpart($subpart, '###ROW_FAX###');
            $res3 = $GLOBALS['TYPO3_DB']->exec_SELECTquery('fax', 'tx_tuwinformations_fax', 'oid=' . $oid, 'sort');
            $content = '';
            while ($row3 = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res3)) {
                $subpartArray['###FAX###'] = $row3['fax'];
                $content.= $this->cObj->substituteMarkerArrayCached($subparts['fax'], $subpartArray);
            }
            $subpartArray['###ROW_FAX###'] = $content;
            $GLOBALS['TYPO3_DB']->sql_free_result($res3);
            $subparts['email'] = $this->cObj->getSubpart($subpart, '###ROW_EMAIL###');
            $res4 = $GLOBALS['TYPO3_DB']->exec_SELECTquery('DISTINCT email', 'tx_tuwinformations_emails', 'oid=' . $oid);
            $content = '';
            while ($row4 = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res4)) {
                $subpartArray['###EMAIL###'] = $row4['email'];
                $content.= $this->cObj->substituteMarkerArrayCached($subparts['email'], $subpartArray);
            }
            $subpartArray['###ROW_EMAIL###'] = $content;
            $subpartArray['###ROW_PUBLICATION###'] = '';
            $GLOBALS['TYPO3_DB']->sql_free_result($res4);
        }
        $GLOBALS['TYPO3_DB']->sql_free_result($res);
        $content = $this->cObj->substituteMarkerArrayCached($subpart, $markerArray, $subpartArray, array());
        return $this->pi_wrapInBaseClass($content);
    }
    function vcard($content, $conf) {
        $v = "BEGIN:VCARD\n";
        $v.= "VERSION:4.0\n";
        $res = $GLOBALS['TYPO3_DB']->exec_SELECTquery('*', 'tx_tuwinformations_persons', 'oid=' . addslashes($_GET['oid']), '', '');
        if ($row = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
            $v.= sprintf("N:%s;%s;;%s;\n", $row['firstname'], $row['lastname'], $row['title']);
            $v.= sprintf("FN:%s\n", trim($row['title'] . " " . $row['firstname'] . " " . $row['lastname']));
            if ($row['postpositioned_titles'] != '') {
                $v.= ", " . $row['postpositioned_titles'];
            }
            $v.= sprintf("ADR;TYPE=work;LABEL=\"%s\\n%s %s\\nAustria\":;;%s;%s;;%s;Austria\n", $row['street'], $row['zip'], $row['city'], $row['street'], $row['city'], $row['zip'], $row['city']);
            $res2 = $GLOBALS['TYPO3_DB']->exec_SELECTquery('phone', 'tx_tuwinformations_phones', 'oid=' . addslashes($_GET['oid']), '', 'sort');
            while ($row2 = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res2)) {
                $v.= sprintf("TEL;TYPE=work,voice;VALUE=uri:tel:%s\n", $row2['phone']);
            }
            $res2 = $GLOBALS['TYPO3_DB']->exec_SELECTquery('email', 'tx_tuwinformations_emails', 'oid=' . addslashes($_GET['oid']), 'email', '');
            while ($row2 = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res2)) {
                $v.= sprintf("EMAIL:%s\n", $row2['email']);
            }
        }
        $v.= "REV:" . strftime("%Y%m%dT%H%M%SZ") . "\n";
        $v.= "END:VCARD";
        return $v;
    }
}
if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/tuw_informations/pi4/class.tx_tuwinformations_pi4.php']) {
    include_once ($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/tuw_informations/pi4/class.tx_tuwinformations_pi4.php']);
}
?>
