<?php
/***************************************************************
 *  Copyright notice
 *
 *  (c) 2013 Heinz A. Krebs <heinz@chemit.at>
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 * Hint: use extdeveval to insert/update function index above.
 */
if (!class_exists('tslib_pibase')) {
    require_once (PATH_tslib . 'class.tslib_pibase.php');
}
/**
 * Plugin 'TISS Publicationlist' for the 'tuw_informations' extension.
 *
 * @author    Heinz A. Krebs <heinz@chemit.at>
 * @package    TYPO3
 * @subpackage    tx_tuwinformations
 */
class tx_tuwinformations_pi3 extends tslib_pibase {
    var $prefixId = 'tx_tuwinformations_pi3'; // Same as class name
    var $scriptRelPath = 'pi3/class.tx_tuwinformations_pi3.php'; // Path to this script relative to the extension dir.
    var $extKey = 'tuw_informations'; // The extension key.
    var $pi_checkCHash = true;
    /**
     * The main method of the PlugIn
     *
     * @param    string        $content: The PlugIn content
     * @param    array        $conf: The PlugIn configuration
     * @return    The content that is displayed on the website
     */
    function main($content, $conf) {
        $this->conf = $conf;
        $this->pi_setPiVarDefaults();
        $this->pi_loadLL();
        $this->pi_initPIflexForm();
        $piFlexForm = $this->cObj->data['pi_flexform'];
        if ((is_numeric(t3lib_div::_GET('OID'))) && (intval(t3lib_div::_GET('OID')) > 0)) {
            $oid = t3lib_div::_GET('OID');
            $inst = '';
            $abt = '';
            $type_id = 1;
            $from = 1995;
            $sorting = 'STANDARD';
            $sorting_pattern = '';
            $display_impactfactor = 99;
        } else {
            $orgoid = $this->pi_getFFvalue($piFlexForm, 'orgoid');
            $abt = $this->pi_getFFvalue($piFlexForm, 'abt');
            $oid = $this->pi_getFFvalue($piFlexForm, 'oid');
            $type_id = $this->pi_getFFvalue($piFlexForm, 'type_id');
            $from = $this->pi_getFFvalue($piFlexForm, 'from');
            $sorting = $this->pi_getFFvalue($piFlexForm, 'sorting');
            $sorting_pattern = $this->pi_getFFvalue($piFlexForm, 'sorting_pattern');
            $display_impactfactor = $this->pi_getFFvalue($piFlexForm, 'display_impactfactor');
        }
        if ($this->pi_getFFValue($piFlexForm, 'group_types') == '1') {
            $ptype = "(CASE P.publicationtype
                           WHEN 'Herausgabe eines Bandes einer Buchreihe' THEN 'Book'
                           WHEN 'Buch-Herausgabe' THEN 'Book'
                           WHEN 'Zeitschriftenartikel' THEN 'Publication'
                           WHEN 'Beitrag in CD- oder Web-Zeitschrift' THEN 'Publication'
                           WHEN 'Buchbeitrag' THEN 'Bookcontribution'
                           WHEN 'Beitrag in e-Book' THEN 'Bookcontribution'
                           WHEN 'Beitrag in Tagungsband' THEN 'Bookcontribution'
                           WHEN 'Monographie (Erstauflage)' THEN 'Monograph'
                           WHEN 'Posterpräsentation mit CD- oder Web-Tagungsband' THEN 'Poster'
                           WHEN 'Vortrag mit Tagungsband' THEN 'Talk'
                           WHEN 'Posterpräsentation mit Tagungsband' THEN 'Poster'
                           WHEN 'Haupt-(Keynote-)Vortrag mit Tagungsband' THEN 'Keynote'
                           WHEN 'Haupt-(Keynote-)Vortrag mit CD- oder Web-Tagungsband' THEN 'Keynote'
                           WHEN 'Vortrag mit CD- oder Web-Tagungsband' THEN 'Talk'
                           WHEN 'Posterpräsentation ohne Tagungsband' THEN 'Poster'
                           WHEN 'Vortrag ohne Tagungsband' THEN 'Talk'
                           WHEN 'Haupt-(Keynote-)Vortrag ohne Tagungsband' THEN 'Keynote'
                           WHEN 'Patent (Erstanmeldung)' THEN 'Patent'
                           WHEN 'Patent (Folgeanmeldung)' THEN 'Patent'
                           WHEN 'Habilitationsschrift' THEN 'Habilitationthesis'
                           WHEN 'Dissertation' THEN 'Doctortheses'
                           WHEN 'Diplom- oder Master-Arbeit' THEN 'Diplomatheses'
                           WHEN 'Wissenschaftlicher Bericht' THEN 'Report'
                           WHEN 'Nichttextl. wiss. Veröffentlichung (gem. Wissensbilanz-VO)' THEN 'Nontextual'
                           ELSE P.publicationtype
                       END)";
            $order = "(CASE P.publicationtype
                           WHEN 'Herausgabe eines Bandes einer Buchreihe' THEN 10
                           WHEN 'Buch-Herausgabe' THEN 10
                           WHEN 'Zeitschriftenartikel' THEN 20
                           WHEN 'Beitrag in CD- oder Web-Zeitschrift' THEN 20
                           WHEN 'Buchbeitrag' THEN 30
                           WHEN 'Beitrag in e-Book' THEN 30
                           WHEN 'Beitrag in Tagungsband' THEN 30
                           WHEN 'Monographie (Erstauflage)' THEN 35
                           WHEN 'Posterpräsentation mit CD- oder Web-Tagungsband' THEN 60
                           WHEN 'Vortrag mit Tagungsband' THEN 50
                           WHEN 'Posterpräsentation mit Tagungsband' THEN 60
                           WHEN 'Haupt-(Keynote-)Vortrag mit Tagungsband' THEN 40
                           WHEN 'Haupt-(Keynote-)Vortrag mit CD- oder Web-Tagungsband' THEN 40
                           WHEN 'Vortrag mit CD- oder Web-Tagungsband' THEN 50
                           WHEN 'Posterpräsentation ohne Tagungsband' THEN 60
                           WHEN 'Vortrag ohne Tagungsband' THEN 50
                           WHEN 'Haupt-(Keynote-)Vortrag ohne Tagungsband' THEN 40
                           WHEN 'Patent (Erstanmeldung)' THEN 70
                           WHEN 'Patent (Folgeanmeldung)' THEN 70
                           WHEN 'Habilitationsschrift' THEN 75
                           WHEN 'Dissertation' THEN 80
                           WHEN 'Diplom- oder Master-Arbeit' THEN 90
                           WHEN 'Wissenschaftlicher Bericht' THEN 100
                           WHEN 'Nichttextl. wiss. Veröffentlichung (gem. Wissensbilanz-VO)' THEN 110
                           ELSE CRC32(P.publicationtype)
                       END),P.year DESC";
        } else {
            $ptype = 'P.publicationtype';
            $order = "(CASE P.publicationtype
                           WHEN 'Herausgabe eines Bandes einer Buchreihe' THEN 10
                           WHEN 'Buch-Herausgabe' THEN 20
                           WHEN 'Zeitschriftenartikel' THEN 30
                           WHEN 'Beitrag in CD- oder Web-Zeitschrift' THEN 40
                           WHEN 'Buchbeitrag' THEN 50
                           WHEN 'Monographie (Erstauflage)' THEN 55
                           WHEN 'Beitrag in e-Book' THEN 60
                           WHEN 'Beitrag in Tagungsband' THEN 70
                           WHEN 'Posterpräsentation mit CD- oder Web-Tagungsband' THEN 80
                           WHEN 'Vortrag mit Tagungsband' THEN 90
                           WHEN 'Posterpräsentation mit Tagungsband' THEN 100
                           WHEN 'Haupt-(Keynote-)Vortrag mit Tagungsband' THEN 110
                           WHEN 'Haupt-(Keynote-)Vortrag mit CD- oder Web-Tagungsband' THEN 120
                           WHEN 'Vortrag mit CD- oder Web-Tagungsband' THEN 130
                           WHEN 'Posterpräsentation ohne Tagungsband' THEN 140
                           WHEN 'Vortrag ohne Tagungsband' THEN 150
                           WHEN 'Haupt-(Keynote-)Vortrag ohne Tagungsband' THEN 160
                           WHEN 'Patent (Erstanmeldung)' THEN 170
                           WHEN 'Patent (Folgeanmeldung)' THEN 180
                           WHEN 'Habilitationsschrift' THEN 185
                           WHEN 'Dissertation' THEN 190
                           WHEN 'Diplom- oder Master-Arbeit' THEN 200
                           WHEN 'Wissenschaftlicher Bericht' THEN 210
                           WHEN 'Nichttextl. wiss. Veröffentlichung (gem. Wissensbilanz-VO)' THEN 220
                           ELSE CRC32(P.publicationtype)
                       END),P.year DESC";
        }
        $cond = 'P.year>=' . $from;
        //if ($abt == '') {
        //                    $res = $GLOBALS['TYPO3_DB']->exec_SELECTquery('P.*,'.$ptype.' AS ptype','tx_tuwinformations_publications P','P.year>='.$from.' AND P.institute='.$inst.($type_id != 1 ? ' AND P.publicationtypeid IN ('.$type_id.')' : ''),'',$order);
        //} else {
        //                    $res = $GLOBALS['TYPO3_DB']->exec_SELECTquery('P.*,'.$ptype.' AS ptype','tx_tuwinformations_publications P JOIN tx_tuwinformations_divisions D ON P.publicationid=D.publicationid','P.year>='.$from.' AND D.division='.$abt.($type_id != 1 ? ' AND P.publicationtypeid IN ('.$type_id.')' : ''),'',$order);
        //}
        //        if ($inst != '')   { $cond .= ' AND P.institute='.$inst; };
        if ($type_id != 1) {
            $cond.= ' AND P.publicationtypeid IN (' . $type_id . ')';
        };
        //print "<!-- type_id = ".$type_id. " -->";
        //        if ($abt != '')    { $cond .= ' AND D.division='.$abt; };
        if ($abt != '') {
            $cond.= ' AND D.division=' . $abt;
        } elseif ($orgoid != '') {
            $cond.= ' AND A.oid IN (SELECT PE.oid FROM tx_tuwinformations_persons PE WHERE PE.orgoid=' . $orgoid . ')';
        };
        if ($oid != '') {
            $cond.= ' AND A.oid=' . $oid;
        };
        //print "<!-- sorting = ".$sorting." -->";
        switch ($sorting) {
            case 'DATTYPSTD':
                $order = "P.year DESC,P.publicationtypeid";
            break;
            case 'DATTYPSEL':
                $order = "P.year DESC,FIELD(P.publicationtypeid," . $type_id . ")";
            break;
            case 'TYPSTDDAT':
                $order = "P.publicationtypeid,P.year DESC";
            break;
            case 'TYPSELDAT':
                $order = "FIELD(P.publicationtypeid," . $type_id . "),P.year DESC";
            break;
        }
        if ($sorting_pattern != '') {
            $order.= ",(CASE LOCATE('$sorting_pattern',citation) WHEN 0 THEN 90 ELSE 10 END),MID(citation,LOCATE('$sorting_pattern',citation)) DESC";
        }
        $res = $GLOBALS['TYPO3_DB']->exec_SELECTquery('P.*,' . $ptype . ' AS ptype,J.impact_factor', 'tx_tuwinformations_publications P 
                                           LEFT JOIN tx_tuwinformations_divisions D 
                                           ON P.publicationid=D.publicationid 
                                           JOIN tx_tuwinformations_authors A 
                                           ON P.publicationid=A.publicationid
                                           LEFT JOIN tx_tuwinformations_journals J 
                                           ON (P.issn=J.issn AND LENGTH(J.issn)=9) OR P.journal=J.title', $cond, 'P.publicationid', $order);
        //print "<!-- COND $cond -->\n";
        $last_type = '';
        $this->template = $this->cObj->fileResource('EXT:tuw_informations/template.html');
        $subpart = $this->cObj->getSubpart($this->template, '###' . $this->pi_getFFvalue($piFlexForm, 'layout') . '###');
        $singlerow = $this->cObj->getSubpart($subpart, '###ROW###');
        while ($row = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
            $markerArray['###PUBLICATIONID###'] = $row['publicationid'];
            unset($publ);
            if (($this->pi_getFFvalue($piFlexForm, 'hide_heading') != '1') && ($last_type != $row['ptype'])) {
                $markerArray['###HEADING###'] = '<div class="header">' . $this->pi_getLL($row['ptype'], $row['ptype']) . '</div>';
            } else {
                $markerArray['###HEADING###'] = '';
            }
            $citation = $row['citation'];
            if ($this->pi_getFFvalue($piFlexForm, 'remove_addition') == '1') {
                $citation = preg_replace('/<a .*?>(.*?)<\/a>/e', 'strpos("\\1","Zusätzliche Informationen") === false ? "\\0" : ""', $citation);
            }
            if ($this->pi_getFFvalue($piFlexForm, 'remove_links') == '1') {
                $citation = preg_replace("/<a .*?>(.*?)<\/a>/", '$1', $citation);
            }
            $markerArray['###CITATION###'] = preg_replace('/(( ){0,}(<br>){1,})+$/i', '', $citation);
            if ($row['impact_factor'] >= $display_impactfactor) {
                $markerArray['###IMPACTFACTOR###'] = sprintf("<i>Impact factor %0.1f</i>", $row['impact_factor']);
            } else {
                $markerArray['###IMPACTFACTOR###'] = '';
            }
            $last_type = $row['ptype'];
            $liste.= $this->cObj->substituteMarkerArrayCached($singlerow, $markerArray);
        }
        $subpartArray['###ROW###'] = $liste;
        $GLOBALS['TYPO3_DB']->sql_free_result($res);
        $content = $this->cObj->substituteMarkerArrayCached($subpart, $markerArray, $subpartArray, array());
        return $this->pi_wrapInBaseClass($content);
    }
}
if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/tuw_informations/pi3/class.tx_tuwinformations_pi3.php']) {
    include_once ($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/tuw_informations/pi3/class.tx_tuwinformations_pi3.php']);
}
?>

