<?php
/***************************************************************
 *  Copyright notice
 *
 *  (c) 2013 Heinz A. Krebs <heinz@chemit.at>
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 * Hint: use extdeveval to insert/update function index above.
 */
if (!class_exists('tslib_pibase')) {
    require_once (PATH_tslib . 'class.tslib_pibase.php');
}
/**
 * Plugin 'TISS Projectlist' for the 'tuw_informations' extension.
 *
 * @author    Heinz A. Krebs <heinz@chemit.at>
 * @package    TYPO3
 * @subpackage    tx_tuwinformations
 */
class tx_tuwinformations_pi2 extends tslib_pibase {
    var $prefixId = 'tx_tuwinformations_pi2'; // Same as class name
    var $scriptRelPath = 'pi2/class.tx_tuwinformations_pi2.php'; // Path to this script relative to the extension dir.
    var $extKey = 'tuw_informations'; // The extension key.
    var $pi_checkCHash = true;
    var $template;
    /**
     * The main method of the PlugIn
     *
     * @param    string        $content: The PlugIn content
     * @param    array        $conf: The PlugIn configuration
     * @return    The content that is displayed on the website
     */
    function main($content, $conf) {
        $this->conf = $conf;
        $this->pi_setPiVarDefaults();
        $this->pi_loadLL();
        $this->pi_initPIflexForm();
        $piFlexForm = $this->cObj->data['pi_flexform'];
        $orgoid = $this->pi_getFFvalue($piFlexForm, 'orgoid');
        $this->template = $this->cObj->fileResource('EXT:tuw_informations/template.html');
        $subpart = $this->cObj->getSubpart($this->template, '###PROJECTLIST1###');
        $singlerow = $this->cObj->getSubpart($subpart, '###ROW###');
        $liste = '';
        $res = $GLOBALS['TYPO3_DB']->exec_SELECTquery('PR.*,PE.lastname,PE.firstname', 'tx_tuwinformations_projects PR LEFT JOIN tx_tuwinformations_persons PE ON PR.manageroid=PE.oid', 'PR.orgoid=' . $orgoid . ' AND end>=NOW()', 'title_de');
        while ($row = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
            if ($GLOBALS['TSFE']->config['config']['language'] == 'de') {
                $markerArray['###TITLE###'] = $row['title_de'];
                $markerArray['###FUNDINGNAME###'] = $row['financed_de'];
            } else {
                $markerArray['###TITLE###'] = $row['title_en'];
                $markerArray['###FUNDINGNAME###'] = $row['financed_en'];
            }
            $markerArray['###FIRSTNAME###'] = $row['firstname'];
            $markerArray['###LASTNAME###'] = $row['lastname'];
            $res2 = $GLOBALS['TYPO3_DB']->exec_SELECTquery('uid', 'pages', 'nav_title=\'' . $row['manageroid'] . '\' AND hidden=0');
            if ($row2 = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res2)) {
                $markerArray['###LASTNAME###'] = sprintf('<a href="%s" target="_blank" class="stafflink">%s</a>', $this->pi_getPageLink($row2['uid']), $row['lastname']);
            }
            if (preg_match('/\(FFG\)/', $row['financed_de'])) {
                $markerArray['###FUNDINGIMG###'] = '<div class="fund_ffg"></div>';
            } elseif (preg_match('/\(FWF\)/', $row['financed_de'])) {
                $markerArray['###FUNDINGIMG###'] = '<div class="fund_fwf"></div>';
            } elseif (preg_match('/\(WWFT\)/', $row['financed_de'])) {
                $markerArray['###FUNDINGIMG###'] = '<div class="fund_wwft"></div>';
            } elseif (preg_match('/\(ÖAW\)/', $row['financed_de'])) {
                $markerArray['###FUNDINGIMG###'] = '<div class="fund_oeaw"></div>';
            } elseif (preg_match('/\(CDG\)/', $row['financed_de'])) {
                $markerArray['###FUNDINGIMG###'] = '<div class="fund_cdg"></div>';
            } elseif (preg_match('/^Glanzstoffwerke Austria/', $row['financed_de'])) {
                $markerArray['###FUNDINGIMG###'] = '<div class="fund_glanzstoff"></div>';
            } else {
                $markerArray['###FUNDINGIMG###'] = sprintf('<div class="fund_%s"></div>', preg_replace('/[^a-z]/', '', strtolower($row['financed_de'])));
            }
            $liste.= $this->cObj->substituteMarkerArrayCached($singlerow, $markerArray);
        }
        $subpartArray['###ROW###'] = $liste;
        $GLOBALS['TYPO3_DB']->sql_free_result($res);
        $content = $this->cObj->substituteMarkerArrayCached($subpart, $markerArray, $subpartArray, array());
        return $this->pi_wrapInBaseClass($content);
    }
}
if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/tuw_informations/pi2/class.tx_tuwinformations_pi2.php']) {
    include_once ($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/tuw_informations/pi2/class.tx_tuwinformations_pi2.php']);
}
?>
