<?php
/***************************************************************
 *  Copyright notice
 *
 *  (c) 2013 Heinz A. Krebs <heinz@chemit.at>
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 * Hint: use extdeveval to insert/update function index above.
 */
if (!class_exists('tslib_pibase')) {
    require_once (PATH_tslib . 'class.tslib_pibase.php');
}
/**
 * Plugin 'TISS Stafflist' for the 'tuw_informations' extension.
 *
 * @author    Heinz A. Krebs <heinz@chemit.at>
 * @package    TYPO3
 * @subpackage    tx_tuwinformations
 */
class tx_tuwinformations_pi1 extends tslib_pibase {
    var $prefixId = 'tx_tuwinformations_pi1'; // Same as class name
    var $scriptRelPath = 'pi1/class.tx_tuwinformations_pi1.php'; // Path to this script relative to the extension dir.
    var $extKey = 'tuw_informations'; // The extension key.
    var $pi_checkCHash = true;
    var $template;
    /**
     * The main method of the PlugIn
     *
     * @param    string        $content: The PlugIn content
     * @param    array        $conf: The PlugIn configuration
     * @return    The content that is displayed on the website
     */
    function main($content, $conf) {
        $this->conf = $conf;
        $this->pi_setPiVarDefaults();
        $this->pi_loadLL();
        $GLOBALS['TSFE']->additionalHeaderData[$this->prefixId] = '<script type="text/javascript" src="/' . t3lib_extMgm::siteRelPath($this->extKey) . 'res/javascript/procs.js"></script>';
        $statuslist = array('AA' => 'Professors', 'AU' => 'General', 'BA' => 'Bachelor Students', 'DA' => 'Ph.D. Students', 'DP' => 'Diploma Students', 'GA' => 'Guests', 'PD' => 'Postdocs', 'SP' => 'Senior Postdocs', 'VS' => 'General', 'ZU' => 'General',);
        $this->pi_initPIflexForm();
        $piFlexForm = $this->cObj->data['pi_flexform'];
        $orgoid = $this->pi_getFFvalue($piFlexForm, 'orgoid');
        $prior = array();
        $listtype = (t3lib_div::_GP('LIST') != '' ? t3lib_div::_GP('LIST') : $this->pi_getFFvalue($piFlexForm, 'defaultpage'));
        switch ($listtype) {
            case 'NAME':
                $sort = 'P.lastname,P.firstname';
            break;
            case 'STATUS':
                $sort = '(CASE SUBSTR(P.internalcode,8,2)
                     WHEN \'AA\' THEN 10
                     WHEN \'SP\' THEN 15
                     WHEN \'PD\' THEN 20
                     WHEN \'DA\' THEN 30
                     WHEN \'DP\' THEN 40
                     WHEN \'BA\' THEN 50
                     WHEN \'GA\' THEN 70
                     WHEN \'AU\' THEN 80
                     WHEN \'VS\' THEN 80
                     WHEN \'ZU\' THEN 80
                     ELSE 999 END),P.lastname,P.firstname';
            break;
            case 'FUNCTION':
                if ($this->pi_getFFvalue($piFlexForm, 'prioritize') == '') {
                    $sort1 = '';
                } else {
                    $nsort = 0;
                    $sort1 = '(CASE P.oid WHEN \'0\' THEN 0 ';
                    foreach (explode(",", $this->pi_getFFvalue($piFlexForm, 'prioritize')) as $pr) {
                        $pr1 = explode(":", $pr);
                        if (is_numeric($pr1[0])) {
                            $nsort++;
                            $prior[$pr1[0]] = $pr1[1];
                            $sort1.= sprintf('WHEN \'%s\' THEN %d ', $pr1[0], $nsort);
                        }
                    }
                    $sort1.= 'ELSE 999 END),';
                }
                $sort = $sort1 . '(CASE P.functioncategory
                     WHEN \'Vorstand\' THEN 10
                     WHEN \'Sekretariat\' THEN 20
                     WHEN \'Professoren/Professorinnen\' THEN 30
                     WHEN \'Wissenschaftliche Mitarbeiter/-innen\' THEN 40
                     WHEN \'Allgemeine Bedienstete\' THEN 50
                     WHEN \'Allgemeine Drittmittel-Bedienstete\' THEN 60
                     WHEN \'Lehrbeauftragt\' THEN 70
                     WHEN \'Tutoren/Tutorinnen\' THEN 80
                     WHEN \'Weitere Mitarbeiter/-innen\' THEN 90
                     WHEN \'Zugeordnet\' THEN 100
                     WHEN \'Karenziert\' THEN 110
                     ELSE 999 END),P.lastname,P.firstname';
            break;
            default:
                $sort = 'P.lastname,P.firstname';
            break;
        }
        $condition = 'P.orgoid=' . $orgoid . ' ';
        if ($this->pi_getFFvalue($piFlexForm, 'internalcode') != '') {
            $condition.= ' AND P.internalcode REGEXP \'' . $this->pi_getFFvalue($piFlexForm, 'internalcode') . '\'';
        }
        $res = $GLOBALS['TYPO3_DB']->exec_SELECTquery('P.*,E.email,GROUP_CONCAT(T.phone ORDER BY T.sort SEPARATOR \'<br />\') AS phones', 'tx_tuwinformations_persons P LEFT JOIN tx_tuwinformations_emails E ON P.oid=E.oid AND E.type=\'generic\' LEFT JOIN tx_tuwinformations_phones T ON P.oid=T.oid', $condition, 'P.oid', $sort);
        $last_status = '';
        $last_function = '';
        $this->template = $this->cObj->fileResource('EXT:tuw_informations/template.html');
        $subpart = $this->cObj->getSubpart($this->template, '###' . $this->pi_getFFvalue($piFlexForm, 'layout') . '###');
        $singlerow = $this->cObj->getSubpart($subpart, '###ROW###');
        $liste = '';
        while ($row = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
            $new_status = substr($row['internalcode'], 7, 2);
            if (($new_status != '') && (array_key_exists($new_status, $statuslist))) {
                $new_status = $statuslist[$new_status];
            } else {
                $new_status = 'Other';
            };
            $functioncategory = (array_key_exists($row['oid'], $prior) ? $prior[$row['oid']] : $row['functioncategory']);
            switch ($listtype) {
                case 'STATUS':
                    if ($last_status != $new_status) {
                        $markerArray['###HEADING###'] = sprintf('<div class="status">%s</div>', $this->pi_getLL($new_status, $new_status));
                    } else {
                        $markerArray['###HEADING###'] = '';
                    }
                break;
                case 'FUNCTION':
                    if ($last_function != $functioncategory) {
                        $markerArray['###HEADING###'] = sprintf('<div class="function">%s</div>', $this->pi_getLL($functioncategory, $functioncategory));
                    } else {
                        $markerArray['###HEADING###'] = '';
                    }
                break;
                case 'NAME':
                    $markerArray['###HEADING###'] = '';
                break;
                default:
                    $markerArray['###HEADING###'] = '';
                break;
            }
            $markerArray['###OID###'] = $row['oid'];
            $markerArray['###LASTNAME###'] = $row['lastname'];
            $markerArray['###FIRSTNAME###'] = $row['firstname'];
            $markerArray['###TITLE###'] = $row['title'];
            if ($row['postpositioned_titles'] != '') {
                $markerArray['###POSTTITLE###'] = $row['postpositioned_titles'];
                $markerArray['###POSTTITLESEPARATION###'] = ", ";
            } else {
                $markerArray['###POSTTITLE###'] = "";
                $markerArray['###POSTTITLESEPARATION###'] = "";
            }
            $markerArray['###FUNCTION###'] = $row['function'];
            $markerArray['###ROOM###'] = ($row['room'] != '' ? $row['room'] : '&nbsp;');
            $markerArray['###ROOM_LINK###'] = ($row['room'] != '' ? $row['room'] : '&nbsp;');
            $markerArray['###MAPFILE###'] = '';
            $mapfile = sprintf('/%sres/img/maps/%s.png', t3lib_extMgm::siteRelPath($this->extKey), substr($row['room'], 0, 2));
            if (file_exists(getcwd() . $mapfile)) {
                //            if (preg_match('/^(BA|BC|BI|BZ)/',$row['room'],$matches)) {
                $markerArray['###ROOM_LINK###'].= ' <a href=javascript:slShowMap(' . $row['oid'] . ',\\\'' . $mapfile . '\\\');void(0);>view map</a>';
                $markerArray['###MAPFILE###'] = $mapfile;
            };
            $markerArray['###PICTUREURI###'] = $row['picture'];
            $markerArray['###DETAILSIMG###'] = '<img src="/' . t3lib_extMgm::siteRelPath($this->extKey) . 'res/img/pic_info.png">';
            if ($row['email'] != '') {
                $markerArray['###EMAILIMG###'] = '<img src="/' . t3lib_extMgm::siteRelPath($this->extKey) . 'res/img/pic_email.gif">';
                $markerArray['###EMAILLINK###'] = '<a href="mailto:' . $row['email'] . '" class="emaillink">email</a>';
                $markerArray['###EMAIL###'] = $row['email'];
            } else {
                $markerArray['###EMAILIMG###'] = '';
                $markerArray['###EMAILLINK###'] = '&nbsp;';
                $markerArray['###EMAIL###'] = '&nbsp;';
            }
            $res2 = $GLOBALS['TYPO3_DB']->exec_SELECTquery('uid', 'pages', 'nav_title=\'' . $row['oid'] . '\' AND hidden=0');
            if ($row2 = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res2)) {
                $markerArray['###WEBPAGEIMG###'] = '<img src="/' . t3lib_extMgm::siteRelPath($this->extKey) . 'res/img/link.gif">';
                $markerArray['###WEBPAGE###'] = $this->pi_linkToPage("Webpage", $row2['uid'], "", array());
                //$markerArray['###WEBPAGE###'] = sprintf('<a href="/staff/%d/" target="_blank">Webpage</a>',$row['oid']);
                
            } else {
                $markerArray['###WEBPAGEIMG###'] = '';
                $markerArray['###WEBPAGE###'] = '&nbsp;';
            }
            if (preg_match('/^\+43 \(1\) 58801 \- ([0-9 ]*)/', $row['phones'], $res3)) {
                $markerArray['###PHONEIMG###'] = '<img src="/' . t3lib_extMgm::siteRelPath($this->extKey) . 'res/img/pic_tel.gif">';
                $markerArray['###PHONE###'] = sprintf('+43 (1) 58801 - %s', str_replace(' ', '', $res3[1]));
                $markerArray['###PHONELIST###'] = $row['phones'];
            } else {
                $markerArray['###PHONEIMG###'] = '';
                $markerArray['###PHONE###'] = '&nbsp;';
                $markerArray['###PHONELIST###'] = '&nbsp;';
            }
            $grp = '';
            foreach (explode("\n", $this->pi_getFFvalue($piFlexForm, 'show_group_details')) as $groupline) {
                if (preg_match('/^(.*):(.*)$/', $groupline, $reg)) {
                    if (preg_match('/' . $reg[1] . '/', $row['internalcode'])) {
                        $grp = $reg[2];
                    }
                }
            }
            $markerArray['###GROUP###'] = $grp;
            $GLOBALS['TYPO3_DB']->sql_free_result($res2);
            $addFlds = array('CLICK_INFORMATION', 'FIRSTNAME', 'LASTNAME', 'FUNCTION', 'ROOM', 'PHONE', 'EMAIL', 'DETAILS');
            foreach ($addFlds as $addFld) {
                $markerArray['###TXT_' . $addFld . '###'] = $this->pi_getLL('TXT_' . $addFld, 'ERROR [' . $addFld . ']');
            }
            $liste.= $this->cObj->substituteMarkerArrayCached($singlerow, $markerArray);
            $last_status = $new_status;
            $last_function = $functioncategory;
        }
        $subpartArray['###ROW###'] = $liste;
        $lists = array();
        if (($this->pi_getFFvalue($piFlexForm, 'order_alphabetical') == 1) && ($listtype != 'NAME')) {
            $lists[] = $this->pi_linkTP($this->pi_getLL('family name', 'family name'), array('LIST' => 'NAME'));
        };
        if (($this->pi_getFFvalue($piFlexForm, 'order_scientific') == 1) && ($listtype != 'STATUS')) {
            $lists[] = $this->pi_linkTP($this->pi_getLL('scientific status', 'scientific status'), array('LIST' => 'STATUS'));
        };
        if (($this->pi_getFFvalue($piFlexForm, 'order_function') == 1) && ($listtype != 'FUNCTION')) {
            $lists[] = $this->pi_linkTP($this->pi_getLL('function', 'function'), array('LIST' => 'FUNCTION'));
        };
        if (sizeOf($lists) != 0) {
            $markerArray['###SUBPAGELINKS###'] = '<p align="center">' . $this->pi_getLL('Sort by', 'Sort by') . ' ' . implode(' ' . $this->pi_getLL('or') . ' ', $lists) . '</p>' . $s;
        } else {
            $markerArray['###SUBPAGELINKS###'] = '';
        }
        $GLOBALS['TYPO3_DB']->sql_free_result($res);
        $content = $this->cObj->substituteMarkerArrayCached($subpart, $markerArray, $subpartArray, array());
        return $this->pi_wrapInBaseClass($content);
    }
}
if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/tuw_informations/pi1/class.tx_tuwinformations_pi1.php']) {
    include_once ($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/tuw_informations/pi1/class.tx_tuwinformations_pi1.php']);
}
?>
