#
# Table structure for table 'tx_tuwinformations_persons'
#
CREATE TABLE tx_tuwinformations_persons (
    uid int(11) NOT NULL auto_increment,
    pid int(11) DEFAULT '0' NOT NULL,
    tstamp int(11) DEFAULT '0' NOT NULL,
    crdate int(11) DEFAULT '0' NOT NULL,
    cruser_id int(11) DEFAULT '0' NOT NULL,
    orgoid int(11) DEFAULT '0' NOT NULL,
    oid int(11) DEFAULT '0' NOT NULL,
    firstname varchar(64) DEFAULT '' NOT NULL,
    lastname varchar(64) DEFAULT '' NOT NULL,
    title varchar(64) DEFAULT '',
    postpositioned_titles varchar(64) DEFAULT '',
    function varchar(64) DEFAULT '' NOT NULL,
    functioncategory varchar(64) DEFAULT '' NOT NULL,
    street varchar(64) DEFAULT '',
    zip varchar(8) DEFAULT '',
    city varchar(64) DEFAULT '',    
    room varchar(32) DEFAULT '',
    internalcode varchar(32) DEFAULT '',
    picture varchar(256) DEFAULT '',
    updated datetime DEFAULT '2000-01-01 00:00:00',

    PRIMARY KEY (uid),
    KEY parent (pid)
);

#
# Table structure for table 'tx_tuwinformations_emails'
#
CREATE TABLE tx_tuwinformations_emails (
    uid int(11) NOT NULL auto_increment,
    pid int(11) DEFAULT '0' NOT NULL,
    tstamp int(11) DEFAULT '0' NOT NULL,
    crdate int(11) DEFAULT '0' NOT NULL,
    cruser_id int(11) DEFAULT '0' NOT NULL,
    oid int(11) DEFAULT '0' NOT NULL,
    email varchar(64) DEFAULT '' NOT NULL,
    type varchar(16) DEFAULT '' NOT NULL,
    updated datetime DEFAULT '2000-01-01 00:00:00',

    PRIMARY KEY (uid),
    KEY parent (pid),
    UNIQUE KEY idx1 (oid,email,type)
);

#
# Table structure for table 'tx_tuwinformations_phones'
#
CREATE TABLE tx_tuwinformations_phones (
    uid int(11) NOT NULL auto_increment,
    pid int(11) DEFAULT '0' NOT NULL,
    tstamp int(11) DEFAULT '0' NOT NULL,
    crdate int(11) DEFAULT '0' NOT NULL,
    cruser_id int(11) DEFAULT '0' NOT NULL,
    oid int(11) DEFAULT '0' NOT NULL,
    phone varchar(32) DEFAULT '' NOT NULL,
    sort int(11) DEFAULT '0' NOT NULL,
    updated datetime DEFAULT '2000-01-01 00:00:00',
    
    PRIMARY KEY (uid),
    KEY parent (pid)
    UNIQUE KEY idx1 (oid,phone)
);

#
# Table structure for table 'tx_tuwinformations_fax'
#
CREATE TABLE tx_tuwinformations_fax (
    uid int(11) NOT NULL auto_increment,
    pid int(11) DEFAULT '0' NOT NULL,
    tstamp int(11) DEFAULT '0' NOT NULL,
    crdate int(11) DEFAULT '0' NOT NULL,
    cruser_id int(11) DEFAULT '0' NOT NULL,
    oid int(11) DEFAULT '0' NOT NULL,
    fax varchar(32) DEFAULT '' NOT NULL,
    sort int(11) DEFAULT '0' NOT NULL,
    updated datetime DEFAULT '2000-01-01 00:00:00',
    
    PRIMARY KEY (uid),
    KEY parent (pid)
    UNIQUE KEY idx1 (oid,fax)
);

#
# Table structure for table 'tx_tuwinformations_projects'
#
CREATE TABLE tx_tuwinformations_projects (
    uid int(11) NOT NULL auto_increment,
    pid int(11) DEFAULT '0' NOT NULL,
    tstamp int(11) DEFAULT '0' NOT NULL,
    crdate int(11) DEFAULT '0' NOT NULL,
    cruser_id int(11) DEFAULT '0' NOT NULL,
    orgoid int(11) DEFAULT '0' NOT NULL,
    projectid int(11) DEFAULT '0' NOT NULL,
    short_description varchar(64) DEFAULT '' NOT NULL,
    title_de varchar(256) DEFAULT '' NOT NULL,
    title_en varchar(256) DEFAULT '' NOT NULL,
    projectform varchar(64) DEFAULT '' NOT NULL,
    projecttype varchar(64) DEFAULT '' NOT NULL,
    manageroid int(11) DEFAULT '0' NOT NULL,
    financed_de varchar(64) DEFAULT '' NOT NULL,
    financed_en varchar(64) DEFAULT '' NOT NULL,
    end date DEFAULT NULL,
    updated datetime DEFAULT '2000-01-01 00:00:00',
    
    PRIMARY KEY (uid),
    KEY parent (pid)
    UNIQUE KEY idx1 (projectid)
);

#
# Table structure for table 'tx_tuwinformations_publications'
#
CREATE TABLE tx_tuwinformations_publications (
    uid int(11) NOT NULL auto_increment,
    pid int(11) DEFAULT '0' NOT NULL,
    tstamp int(11) DEFAULT '0' NOT NULL,
    crdate int(11) DEFAULT '0' NOT NULL,
    cruser_id int(11) DEFAULT '0' NOT NULL,
    institute int(11) DEFAULT '0' NOT NULL, 
    publicationid int(11) DEFAULT '0' NOT NULL,
    publicationtype varchar(64) DEFAULT '' NOT NULL,
    publicationtypeid int(11) DEFAULT '0' NOT NULL,
    title varchar(256) DEFAULT '' NOT NULL,
    citation varchar(1024) DEFAULT '',
    year int(11) DEFAULT '0' NOT NULL,
    doi varchar(64) DEFAULT '',
    updated datetime DEFAULT '2000-01-01 00:00:00',
    journal varchar(255) DEFAULT '' NOT NULL,
    issn char(9) DEFAULT '' NOT NULL,
    
    PRIMARY KEY (uid),
    KEY parent (pid),
    KEY idx1 (publicationid,uid),
    KEY idx2 (issn,uid),
    KEY idx3 (journal,uid)
);   

#
# Table structure for table 'tx_tuwinformations_authors'
#
CREATE TABLE tx_tuwinformations_authors (
    uid int(11) NOT NULL auto_increment,
    pid int(11) DEFAULT '0' NOT NULL,
    tstamp int(11) DEFAULT '0' NOT NULL,
    crdate int(11) DEFAULT '0' NOT NULL,
    cruser_id int(11) DEFAULT '0' NOT NULL,
    publicationid int(11) DEFAULT '0' NOT NULL,
    oid int(11) DEFAULT NULL,
    firstname varchar(64) DEFAULT NULL,
    lastname varchar(64) DEFAULT NULL,
    institute varchar(64) DEFAULT '' NOT NULL,
    division varchar(64) DEFAULT '' NOT NULL,
    sortid int(11) DEFAULT NULL,
    pubdbInstitute varchar(64) DEFAULT '' NOT NULL,
    PRIMARY KEY (uid),
    KEY parent (pid)
    KEY idx1 (publicationid,uid)
);    


CREATE TABLE tx_tuwinformations_divisions (
    uid int(11) NOT NULL auto_increment,
    pid int(11) DEFAULT '0' NOT NULL,
    tstamp int(11) DEFAULT '0' NOT NULL,
    crdate int(11) DEFAULT '0' NOT NULL,
    cruser_id int(11) DEFAULT '0' NOT NULL,
    publicationid int(11) DEFAULT '0' NOT NULL,
    division int(11) DEFAULT '0' NOT NULL,
    updated datetime DEFAULT '2000-01-01 00:00:00',
    
    PRIMARY KEY (uid),
    KEY parent (pid)
    UNIQUE KEY idx1 (publicationid,division)
);    

CREATE TABLE tx_tuwinformations_journals (
    uid int(11) NOT NULL auto_increment,
    pid int(11) DEFAULT '0' NOT NULL,
    tstamp int(11) DEFAULT '0' NOT NULL,
    crdate int(11) DEFAULT '0' NOT NULL,
    cruser_id int(11) DEFAULT '0' NOT NULL,
    abbreviation varchar(64) DEFAULT '' NOT NULL,
    title varchar(255) DEFAULT '' NOT NULL,
    issn char(9) DEFAULT '' NOT NULL,
    impact_factor float DEFAULT '0' NOT NULL,
    eigenfactor float DEFAULT '0' NOT NULL,
    normeigenfactor float DEFAULT '0' NOT NULL,

    PRIMARY KEY (uid),
    KEY parent (pid),
    UNIQUE KEY idx1 (issn),
    KEY idx2 (journal)
);


#
# Table data for table 'tx_tuwinformations_journals'
#
DELETE FROM tx_tuwinformations_journals;
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ISO_ABBREV','TITLE','ISSN',0.000000,0.000000,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pineal Res.','JOURNAL OF PINEAL RESEARCH','0742-3098',9.314000,0.007790,0.887520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Autism','Molecular Autism','2040-2392',4.961000,0.004500,0.512400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Cell. Neurosci.','MOLECULAR AND CELLULAR NEUROSCIENCE','1044-7431',3.597000,0.010000,1.139280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neural Comput.','NEURAL COMPUTATION','0899-7667',1.626000,0.007730,0.880570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuroinformatics','NEUROINFORMATICS','1539-2791',2.864000,0.002740,0.312230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dermatol. Clin.','DERMATOLOGIC CLINICS','0733-8635',1.875000,0.003040,0.347060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Cosmetic Sci.','INTERNATIONAL JOURNAL OF COSMETIC SCIENCE','0142-5463',1.542000,0.002130,0.242760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Acad. Dermatol.','JOURNAL OF THE AMERICAN ACADEMY OF DERMATOLOGY','0190-9622',5.621000,0.034140,3.891320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Wound Care','Journal of Wound Care','0969-0700',1.205000,0.002530,0.288590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pigment Cell Melanoma Res.','Pigment Cell & Melanoma Research','1755-1471',4.163000,0.009870,1.125040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Cutan. Med. Surg.','SEMINARS IN CUTANEOUS MEDICINE AND SURGERY','1085-5629',1.600000,0.001910,0.217310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem Erde-Geochem.','CHEMIE DER ERDE-GEOCHEMISTRY','0009-2819',1.622000,0.002120,0.241080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geochim. Cosmochim. Acta','GEOCHIMICA ET COSMOCHIMICA ACTA','0016-7037',4.315000,0.068720,7.832280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geofluids','GEOFLUIDS','1468-8115',1.750000,0.002410,0.274920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pipel. Syst. Eng. Pract.','Journal of Pipeline Systems Engineering and Practice','1949-1190',0.896000,0.000560,0.064200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. S. Afr. Inst. Civ. Eng.','Journal of the South African Institution of Civil Engineering','1021-2019',0.115000,0.000190,0.021800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nav. Eng. J.','NAVAL ENGINEERS JOURNAL','0028-1425',0.157000,0.000220,0.025040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Civil Eng.-Struct. Build.','PROCEEDINGS OF THE INSTITUTION OF CIVIL ENGINEERS-STRUCTURES AND BUILDINGS','0965-0911',0.429000,0.000970,0.110030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Civil Eng.-Transp.','PROCEEDINGS OF THE INSTITUTION OF CIVIL ENGINEERS-TRANSPORT','0965-092X',0.314000,0.000340,0.038550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Road Mater. Pavement Des.','Road Materials and Pavement Design','1468-0629',1.547000,0.002320,0.263920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transp. Res. Pt. B-Methodol.','TRANSPORTATION RESEARCH PART B-METHODOLOGICAL','0191-2615',3.769000,0.012740,1.451940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Int.','WATER INTERNATIONAL','0250-8060',1.040000,0.001040,0.118270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Struct. Biol.','JOURNAL OF STRUCTURAL BIOLOGY','1047-8477',2.570000,0.025540,2.911150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('NMR Biomed.','NMR IN BIOMEDICINE','0952-3480',2.983000,0.014830,1.689890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Biophys. Mol. Biol.','PROGRESS IN BIOPHYSICS & MOLECULAR BIOLOGY','0079-6107',2.581000,0.004970,0.566040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Microbiol.','ANNALS OF MICROBIOLOGY','1590-4261',1.232000,0.003520,0.401500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biocontrol Sci.','BIOCONTROL SCIENCE','1342-4815',0.677000,0.000480,0.055250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biofouling','BIOFOULING','0892-7014',3.000000,0.005670,0.646530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomed Res. Int.','Biomed Research International','2314-6133',2.134000,0.045020,5.130870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biopharm. Int.','BIOPHARM INTERNATIONAL','1542-166X',0.181000,0.000270,0.030900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biotech. Histochem.','BIOTECHNIC & HISTOCHEMISTRY','1052-0295',1.078000,0.001020,0.116690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biotechnol. Bioeng.','BIOTECHNOLOGY AND BIOENGINEERING','0006-3592',4.243000,0.026090,2.973680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Langmuir','LANGMUIR','0743-7463',3.993000,0.164800,18.784090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Divers.','MOLECULAR DIVERSITY','1381-1991',2.080000,0.002260,0.257050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanotechnol. Rev.','Nanotechnology Reviews','2191-9089',2.044000,0.000660,0.075540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('RSC Adv.','RSC Advances','2046-2069',3.289000,0.129930,14.809770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Russ. Chem. Bull.','RUSSIAN CHEMICAL BULLETIN','1066-5285',0.579000,0.003270,0.372840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('SAR QSAR Environ. Res.','SAR AND QSAR IN ENVIRONMENTAL RESEARCH','1062-936X',1.897000,0.001070,0.122460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geostand. Geoanal. Res.','GEOSTANDARDS AND GEOANALYTICAL RESEARCH','1639-4488',2.885000,0.002680,0.304980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lithos','LITHOS','0024-4937',3.723000,0.026150,2.980650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Geod.','MARINE GEODESY','0149-0419',0.979000,0.001380,0.157390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mineral. Petrol.','MINERALOGY AND PETROLOGY','0930-0708',1.180000,0.001810,0.205860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nonlinear Process Geophys.','NONLINEAR PROCESSES IN GEOPHYSICS','1023-5809',1.321000,0.004440,0.506620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Subst. Abus.','Substance Abuse','0889-7077',2.576000,0.002480,0.282230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Effic.','Energy Efficiency','1570-646X',1.183000,0.001510,0.171890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Sustain Dev.','Energy for Sustainable Development','0973-0826',2.379000,0.003800,0.432630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Precis Eng Manuf-Green Technol.','International Journal of Precision Engineering and Manufacturing-Green Technology','2288-6206',2.545000,0.000320,0.036360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clean Prod.','JOURNAL OF CLEANER PRODUCTION','0959-6526',4.959000,0.027880,3.178090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Acoust.','Archives of Acoustics','0137-5075',0.661000,0.000790,0.089630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Ultrason. Ferroelectr. Freq. Control','IEEE TRANSACTIONS ON ULTRASONICS FERROELECTRICS AND FREQUENCY CONTROL','0885-3010',2.287000,0.012270,1.398390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Control','ANNUAL REVIEWS IN CONTROL','1367-5788',2.042000,0.002810,0.320580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Autom. Sci. Eng.','IEEE Transactions on Automation Science and Engineering','1545-5955',2.696000,0.007450,0.848660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Adv. Manuf. Technol.','INTERNATIONAL JOURNAL OF ADVANCED MANUFACTURING TECHNOLOGY','0268-3768',1.568000,0.022370,2.549810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Intell. Autom. Soft Comput.','INTELLIGENT AUTOMATION AND SOFT COMPUTING','1079-8587',0.351000,0.000370,0.041660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Dyn. Control Syst.','JOURNAL OF DYNAMICAL AND CONTROL SYSTEMS','1079-2724',0.422000,0.001080,0.122960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Crit. Rev. Eukaryot. Gene Expr.','CRITICAL REVIEWS IN EUKARYOTIC GENE EXPRESSION','1045-4403',1.660000,0.001270,0.145040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dis. Markers','DISEASE MARKERS','0278-0240',2.137000,0.004460,0.508710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electron. J. Biotechnol.','ELECTRONIC JOURNAL OF BIOTECHNOLOGY','0717-3458',1.403000,0.001390,0.158050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Biotechnol.','FOOD BIOTECHNOLOGY','0890-5436',0.814000,0.000350,0.039370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Appl. Phycol.','JOURNAL OF APPLIED PHYCOLOGY','0921-8971',2.372000,0.008060,0.918440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Biol.','JOURNAL OF COMPUTATIONAL BIOLOGY','1066-5277',1.537000,0.007550,0.860480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microb. Biotechnol.','Microbial Biotechnology','1751-7907',3.991000,0.005450,0.621290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chromatographia','CHROMATOGRAPHIA','0009-5893',1.332000,0.004300,0.490660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Environ. Anal. Chem.','INTERNATIONAL JOURNAL OF ENVIRONMENTAL ANALYTICAL CHEMISTRY','0306-7319',1.411000,0.002060,0.234590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trac-Trends Anal. Chem.','TRAC-TRENDS IN ANALYTICAL CHEMISTRY','0165-9936',7.487000,0.018210,2.075570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Organomet. Chem.','APPLIED ORGANOMETALLIC CHEMISTRY','0268-2605',2.452000,0.003350,0.382250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dalton Trans.','DALTON TRANSACTIONS','1477-9226',4.177000,0.102210,11.649590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inorg. Chem. Commun.','INORGANIC CHEMISTRY COMMUNICATIONS','1387-7003',1.762000,0.009570,1.091130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biol. Inorg. Chem.','JOURNAL OF BIOLOGICAL INORGANIC CHEMISTRY','0949-8257',2.495000,0.006600,0.751960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Fluor. Chem.','JOURNAL OF FLUORINE CHEMISTRY','0022-1139',2.213000,0.007680,0.875520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Renew. Mater.','Journal of Renewable Materials','2164-6325',1.263000,0.000230,0.026570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Renew. Energy','RENEWABLE ENERGY','0960-1481',3.404000,0.037280,4.249080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sust. Cities Soc.','Sustainable Cities and Society','2210-6715',1.044000,0.000630,0.071610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Ecol. Environ. Res.','APPLIED ECOLOGY AND ENVIRONMENTAL RESEARCH','1589-1623',0.500000,0.000440,0.049690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Veg. Sci.','APPLIED VEGETATION SCIENCE','1402-2001',2.308000,0.003150,0.359110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Austral Ecol.','AUSTRAL ECOLOGY','1442-9985',1.598000,0.005190,0.591270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biodivers. Conserv.','BIODIVERSITY AND CONSERVATION','0960-3115',2.258000,0.014650,1.669990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Lett.','Biology Letters','1744-9561',2.823000,0.025350,2.889340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecography','ECOGRAPHY','0906-7590',5.355000,0.019140,2.181570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecohydrology','Ecohydrology','1936-0584',2.138000,0.006090,0.694390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecol. Complex.','Ecological Complexity','1476-945X',1.797000,0.003480,0.396150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecol. Res.','ECOLOGICAL RESEARCH','0912-3814',1.338000,0.004530,0.515960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecology','ECOLOGY','0012-9658',4.733000,0.055190,6.290840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Robot. Auton. Syst.','ROBOTICS AND AUTONOMOUS SYSTEMS','0921-8890',1.618000,0.005630,0.642060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genet. Sel. Evol.','GENETICS SELECTION EVOLUTION','0999-193X',2.895000,0.003690,0.420970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Anim. Sci. Biotechnol.','Journal of Animal Science and Biotechnology','2049-1891',2.037000,0.001330,0.151640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Appl. Anim. Res.','JOURNAL OF APPLIED ANIMAL RESEARCH','0971-2119',0.503000,0.000610,0.069160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mljekarstvo','Mljekarstvo','0026-704X',0.596000,0.000270,0.030480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Worlds Poult. Sci. J.','WORLDS POULTRY SCIENCE JOURNAL','0043-9339',0.974000,0.001650,0.187560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('World Rabbit Sci.','World Rabbit Science','1257-5011',0.833000,0.000420,0.048380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Agric. Econ.','AGRICULTURAL ECONOMICS','0169-5150',1.739000,0.003480,0.396880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanomedicine','Nanomedicine','1743-5889',4.889000,0.013360,1.522680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Biotechnol.','NATURE BIOTECHNOLOGY','1087-0156',43.113000,0.157110,17.907960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stem Cells','STEM CELLS','1066-5099',5.902000,0.040440,4.609490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transgenic Res.','TRANSGENIC RESEARCH','0962-8819',2.054000,0.004020,0.457680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Algae','ALGAE','1226-2617',1.778000,0.000820,0.093340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Bot. Fenn.','ANNALES BOTANICI FENNICI','0003-3847',0.893000,0.001240,0.141580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bot. J. Linnean Soc.','BOTANICAL JOURNAL OF THE LINNEAN SOCIETY','0024-4074',2.523000,0.004940,0.562600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polyhedron','POLYHEDRON','0277-5387',2.108000,0.014050,1.601140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Inorgan. Chem.','PROGRESS IN INORGANIC CHEMISTRY','0079-6379',4.308000,0.000450,0.050930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Bond.','Structure and Bonding','0081-5993',1.753000,0.001550,0.176520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioinorg. Chem. Appl.','BIOINORGANIC CHEMISTRY AND APPLICATIONS','1565-3633',1.488000,0.001100,0.125220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomacromolecules','BIOMACROMOLECULES','1525-7797',5.583000,0.052460,5.979620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioorg. Med. Chem. Lett.','BIOORGANIC & MEDICINAL CHEMISTRY LETTERS','0960-894X',2.486000,0.054320,6.191440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Carbohydr. Polym.','CARBOHYDRATE POLYMERS','0144-8617',4.219000,0.058370,6.653110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Organometallics','ORGANOMETALLICS','0276-7333',4.186000,0.059670,6.800900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Russ. J. Bioorg. Chem.','RUSSIAN JOURNAL OF BIOORGANIC CHEMISTRY','1068-1620',0.660000,0.001060,0.121320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tetrahedron','TETRAHEDRON','0040-4020',2.645000,0.048840,5.567340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Top. Organomet. Chem.','Topics in Organometallic Chemistry','1436-6002',4.543000,0.004450,0.507040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Glob. Change Biol.','GLOBAL CHANGE BIOLOGY','1354-1013',8.444000,0.076790,8.752290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nat. Hist.','JOURNAL OF NATURAL HISTORY','0022-2933',1.010000,0.003800,0.433170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Acad. Nat. Sci. Phila.','PROCEEDINGS OF THE ACADEMY OF NATURAL SCIENCES OF PHILADELPHIA','0097-3157',0.952000,0.000270,0.031270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('POLAR REC.','POLAR RECORD','0032-2474',0.904000,0.000950,0.107860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Restor. Ecol.','RESTORATION ECOLOGY','1061-2971',1.891000,0.006330,0.721040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vie Milieu','VIE ET MILIEU-LIFE AND ENVIRONMENT','0240-8759',0.222000,0.000290,0.033420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Resour. Econ','Annual Review of Resource Economics','1941-1340',1.042000,0.001280,0.146450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Agric. Human Values','AGRICULTURE AND HUMAN VALUES','0889-048X',2.222000,0.002320,0.264370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Agric. Sustain.','International Journal of Agricultural Sustainability','1473-5903',1.538000,0.001360,0.154910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Integr. Agric.','Journal of Integrative Agriculture','2095-3119',0.724000,0.002380,0.271320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev.  Fac. Cienc. Agrar. Univ Nac Cuyo','REVISTA DE LA FACULTAD DE CIENCIAS AGRARIAS','1853-8665',0.663000,0.000150,0.016750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryptogam. Algol.','CRYPTOGAMIE ALGOLOGIE','0181-1568',1.487000,0.000790,0.090360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Folia Geobot.','FOLIA GEOBOTANICA','1211-9520',1.433000,0.001080,0.122850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Exp. Bot.','JOURNAL OF EXPERIMENTAL BOTANY','0022-0957',5.677000,0.056600,6.450820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Integr. Plant Biol.','Journal of Integrative Plant Biology','1672-9072',3.670000,0.006890,0.785810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Plant Pathol.','JOURNAL OF PLANT PATHOLOGY','1125-4653',1.038000,0.002380,0.271040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Plants','Nature Plants','2055-026X',0.000000,0.000000,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adsorpt.-J. Int. Adsorpt. Soc.','ADSORPTION-JOURNAL OF THE INTERNATIONAL ADSORPTION SOCIETY','0929-5607',1.870000,0.003170,0.361730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Catal. B-Environ.','APPLIED CATALYSIS B-ENVIRONMENTAL','0926-3373',8.328000,0.057140,6.512660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Colloid Polym. Sci.','COLLOID AND POLYMER SCIENCE','0303-402X',1.890000,0.006950,0.792010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gold Bull.','GOLD BULLETIN','0017-1557',2.323000,0.001380,0.157460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Quantum Chem.','INTERNATIONAL JOURNAL OF QUANTUM CHEMISTRY','0020-7608',2.184000,0.009900,1.128440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Rev. Phys. Chem.','INTERNATIONAL REVIEWS IN PHYSICAL CHEMISTRY','0144-235X',6.094000,0.002230,0.254550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Energ. Mater.','Journal of Energetic Materials','0737-0652',1.017000,0.000550,0.062350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Energy Chem.','Journal of Energy Chemistry','2095-4956',2.322000,0.001630,0.185350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mater. Chem. A','Journal of Materials Chemistry A','2050-7488',8.262000,0.109000,12.423570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Photochem. Photobiol. C-Photochem. Rev.','JOURNAL OF PHOTOCHEMISTRY AND PHOTOBIOLOGY C-PHOTOCHEMISTRY REVIEWS','1389-5567',12.162000,0.004420,0.503240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochem. Mol. Biol. Educ.','BIOCHEMISTRY AND MOLECULAR BIOLOGY EDUCATION','1470-8175',0.465000,0.000670,0.075810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Eng. Educ','INTERNATIONAL JOURNAL OF ENGINEERING EDUCATION','0949-149X',0.559000,0.000920,0.105150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem. Educ.','JOURNAL OF CHEMICAL EDUCATION','0021-9584',1.225000,0.004070,0.464440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sch. Health','JOURNAL OF SCHOOL HEALTH','0022-4391',1.547000,0.004620,0.527010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nurse Educ. Today','NURSE EDUCATION TODAY','0260-6917',1.591000,0.005210,0.594070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Rev. Spec. Top.-Phys. Educ. R.','Physical Review Special Topics-Physics Education Research','1554-9178',1.316000,0.001330,0.151730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Health Sci. Educ.','ADVANCES IN HEALTH SCIENCES EDUCATION','1382-4996',2.462000,0.004650,0.530270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Disabil. Health J.','Disability and Health Journal','1936-6574',1.345000,0.001590,0.180670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fam. Syst. Health','Families Systems & Health','1091-7527',1.299000,0.001380,0.157460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Health Technol. Assess.','HEALTH TECHNOLOGY ASSESSMENT','1366-5278',4.058000,0.009300,1.060130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Propul. Power','JOURNAL OF PROPULSION AND POWER','0748-4658',1.134000,0.005410,0.617030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microgravity Sci. Technol.','MICROGRAVITY SCIENCE AND TECHNOLOGY','0938-0108',0.725000,0.000950,0.107900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Sci.-Agron.','ACTA SCIENTIARUM-AGRONOMY','1807-8621',1.317000,0.001700,0.193730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Agric. Water Manage.','AGRICULTURAL WATER MANAGEMENT','0378-3774',2.603000,0.013920,1.586220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Agrofor. Syst.','AGROFORESTRY SYSTEMS','0167-4366',0.910000,0.002540,0.289310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Agron. Sustain. Dev.','Agronomy for Sustainable Development','1774-0746',4.141000,0.006370,0.726510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cah. Agric.','CAHIERS AGRICULTURES','1166-7699',0.384000,0.000420,0.047750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cereal Res. Commun.','CEREAL RESEARCH COMMUNICATIONS','0133-3720',0.528000,0.000640,0.072620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Agron.','EUROPEAN JOURNAL OF AGRONOMY','1161-0301',3.186000,0.007070,0.805820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Agrophys.','International Agrophysics','0236-8722',1.067000,0.001000,0.113860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Sugar J.','INTERNATIONAL SUGAR JOURNAL','0020-8841',0.181000,0.000380,0.042990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Amer. Pomolog. Soc.','JOURNAL OF THE AMERICAN POMOLOGICAL SOCIETY','1527-3741',0.151000,0.000130,0.015340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Philipp. J. Crop Sci.','Philippine Journal of Crop Science','0115-463X',0.333000,0.000090,0.010750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Breed.','PLANT BREEDING','0179-9541',1.502000,0.003400,0.388070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Prot. Sci.','PLANT PROTECTION SCIENCE','1212-2580',0.661000,0.000390,0.044330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytochem. Anal.','PHYTOCHEMICAL ANALYSIS','0958-0344',2.497000,0.003320,0.377940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytochem. Lett.','Phytochemistry Letters','1874-3900',1.353000,0.003340,0.380930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytopathology','PHYTOPATHOLOGY','0031-949X',3.011000,0.010050,1.145890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytotaxa','Phytotaxa','1179-3155',1.087000,0.006110,0.696190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Biotechnol. J.','PLANT BIOTECHNOLOGY JOURNAL','1467-7644',6.090000,0.010850,1.236990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Ecol.','PLANT ECOLOGY','1385-0237',1.490000,0.007100,0.809330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Reprod.','Plant Reproduction','2194-7953',2.468000,0.000690,0.078370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Planta','PLANTA','0032-0935',3.239000,0.015610,1.779260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Protoplasma','PROTOPLASMA','0033-183X',2.343000,0.005380,0.612930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Phys. Chem. C','Journal of Physical Chemistry C','1932-7447',4.509000,0.284030,32.373840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Solut. Chem.','JOURNAL OF SOLUTION CHEMISTRY','0095-9782',1.256000,0.003250,0.370550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Water. Chem. Technol.','Journal of Water Chemistry and Technology','1063-455X',0.258000,0.000190,0.021920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Langmuir','LANGMUIR','0743-7463',3.993000,0.164800,18.784090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pet. Chem.','PETROLEUM CHEMISTRY','0965-5441',0.495000,0.000920,0.104540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Surf. Sci.','PROGRESS IN SURFACE SCIENCE','0079-6816',7.579000,0.001760,0.200620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Silicon','Silicon','1876-990X',0.860000,0.000660,0.075390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solid State Nucl. Magn. Reson.','SOLID STATE NUCLEAR MAGNETIC RESONANCE','0926-2040',2.250000,0.001670,0.189890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surf. Innov.','Surface Innovations','2050-6252',1.438000,0.000280,0.032010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Z. Naturfors. Sect. A-J. Phys. Sci.','ZEITSCHRIFT FUR NATURFORSCHUNG SECTION A-A JOURNAL OF PHYSICAL SCIENCES','0932-0784',0.886000,0.001240,0.141440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Math. Artif. Intell.','ANNALS OF MATHEMATICS AND ARTIFICIAL INTELLIGENCE','1012-2443',0.944000,0.001470,0.167400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comp. Eff. Res.','Journal of Comparative Effectiveness Research','2042-6305',1.075000,0.000960,0.108930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Health Polit. Policy Law','JOURNAL OF HEALTH POLITICS POLICY AND LAW','0361-6878',1.436000,0.002770,0.315900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Interprofessional Care','Journal of Interprofessional Care','1356-1820',1.645000,0.002630,0.299830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Care','MEDICAL CARE','0025-7079',3.081000,0.022340,2.545810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Hist.','MEDICAL HISTORY','0025-7273',0.479000,0.000340,0.039100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Popul. Health Manag.','Population Health Management','1942-7891',1.629000,0.002170,0.247500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electrochemistry','ELECTROCHEMISTRY','1344-3542',0.791000,0.001770,0.201900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Electrochem. Sci. Technol.','Journal of Electrochemical Science and Technology','2093-8551',0.462000,0.000150,0.017590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Solid State Electrochem.','JOURNAL OF SOLID STATE ELECTROCHEMISTRY','1432-8488',2.327000,0.011520,1.312860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. J. Linnean Soc.','BIOLOGICAL JOURNAL OF THE LINNEAN SOCIETY','0024-4066',1.984000,0.011600,1.322370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Lett.','Biology Letters','1744-9561',2.823000,0.025350,2.889340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Weed Biol. Manag.','WEED BIOLOGY AND MANAGEMENT','1444-6162',0.500000,0.000470,0.053820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Weed Res.','WEED RESEARCH','0043-1737',1.517000,0.002680,0.305080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Weed Technol.','WEED TECHNOLOGY','0890-037X',1.487000,0.002430,0.277460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Allergol. Int.','ALLERGOLOGY INTERNATIONAL','1323-8930',2.355000,0.002730,0.311170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Allergy Asthma Immunol. Res.','Allergy Asthma & Immunology Research','2092-7355',2.309000,0.002670,0.304820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Invest. Allergol. Clin. Immunol.','JOURNAL OF INVESTIGATIONAL ALLERGOLOGY AND CLINICAL IMMUNOLOGY','1018-9068',2.131000,0.003380,0.385340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Fr. Allergol.','Revue Francaise d Allergologie','1877-0320',0.217000,0.000140,0.016320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anat. Sci. Int.','ANATOMICAL SCIENCE INTERNATIONAL','1447-6959',0.861000,0.000600,0.068840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cells Tissues Organs','CELLS TISSUES ORGANS','1422-6405',1.228000,0.003430,0.391020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Zoomorphology','ZOOMORPHOLOGY','0720-213X',1.242000,0.001010,0.114760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Syst. Biol. Reprod. Med.','Systems Biology in Reproductive Medicine','1939-6368',1.204000,0.001770,0.201420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Anesth.','Canadian Journal of Anesthesia-Journal canadien d anesthesie','0832-610X',2.139000,0.005640,0.643130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Anesthesiol.','Current Opinion in Anesthesiology','0952-7907',1.916000,0.004620,0.526270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Obstet. Anesth.','INTERNATIONAL JOURNAL OF OBSTETRIC ANESTHESIA','0959-289X',2.040000,0.002450,0.278790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Weed Biol. Manag.','WEED BIOLOGY AND MANAGEMENT','1444-6162',0.500000,0.000470,0.053820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Willdenowia','Willdenowia','0511-9618',0.500000,0.000430,0.048560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Z. Arznei- Gewurzpflanzen','Zeitschrift fur Arznei- & Gewurzpflanzen','1431-9292',0.194000,0.000030,0.003580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Breast J.','Breast Journal','1075-122X',1.920000,0.004590,0.523160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Epidemiol. Biomarkers Prev.','CANCER EPIDEMIOLOGY BIOMARKERS & PREVENTION','1055-9965',3.622000,0.038180,4.351480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Genet.','Cancer Genetics','2210-7762',2.333000,0.003310,0.377040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Immunol. Immunother.','CANCER IMMUNOLOGY IMMUNOTHERAPY','0340-7004',4.846000,0.014510,1.654000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Radiother.','Cancer Radiotherapie','1278-3218',1.299000,0.001530,0.173900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Carcinogenesis','CARCINOGENESIS','0143-3334',4.874000,0.033710,3.841890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Cancer','Chinese Journal of Cancer','1000-467X',2.814000,0.003700,0.421780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Lymphoma Myeloma Leuk.','Clinical Lymphoma Myeloma & Leukemia','2152-2650',2.316000,0.005220,0.594690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Auton. Agents Multi-Agent Syst.','AUTONOMOUS AGENTS AND MULTI-AGENT SYSTEMS','1387-2532',1.417000,0.001360,0.155550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cogn. Comput.','Cognitive Computation','1866-9956',1.933000,0.001250,0.142820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cogn. Syst. Res.','Cognitive Systems Research','1389-0417',1.204000,0.001040,0.118240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Vis. Image Underst.','COMPUTER VISION AND IMAGE UNDERSTANDING','1077-3142',2.134000,0.008330,0.949220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Decis. Support Syst.','DECISION SUPPORT SYSTEMS','0167-9236',2.604000,0.011870,1.352590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Expert Syst. Appl.','EXPERT SYSTEMS WITH APPLICATIONS','0957-4174',2.981000,0.054910,6.258680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fuzzy Optim. Decis. Mak.','Fuzzy Optimization and Decision Making','1568-4539',2.569000,0.001250,0.142800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Neural Netw. Learn. Syst.','IEEE Transactions on Neural Networks and Learning Systems','2162-237X',4.854000,0.022450,2.558630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Technol. Control','Information Technology and Control','1392-124X',0.633000,0.000340,0.039240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mach. Learn. Cybern.','International Journal of Machine Learning and Cybernetics','1868-8071',1.110000,0.001440,0.163840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Pattern Recognit. Artif. Intell.','INTERNATIONAL JOURNAL OF PATTERN RECOGNITION AND ARTIFICIAL INTELLIGENCE','0218-0014',0.915000,0.001370,0.156140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Artif. Intell. Res.','JOURNAL OF ARTIFICIAL INTELLIGENCE RESEARCH','1076-9757',1.659000,0.005060,0.576650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Syst. Sci. Int.','JOURNAL OF COMPUTER AND SYSTEMS SCIENCES INTERNATIONAL','1064-2307',0.503000,0.000500,0.057120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Intell. Fuzzy Syst.','JOURNAL OF INTELLIGENT & FUZZY SYSTEMS','1064-1246',1.004000,0.001860,0.211620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Isr. J. Ecol. Evol.','Israel Journal of Ecology & Evolution','1565-9801',0.727000,0.000270,0.031010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Syst. Bot.','SYSTEMATIC BOTANY','0363-6445',1.098000,0.002630,0.299810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Syst. Entomol.','SYSTEMATIC ENTOMOLOGY','0307-6970',3.343000,0.004310,0.491130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Zool. Scr.','ZOOLOGICA SCRIPTA','0300-3256',2.733000,0.003640,0.415070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Cell Dev.Biol.','Annual Review of Cell and Developmental Biology','1081-0706',12.755000,0.020570,2.344480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Top. Dev. Biol.','Current Topics in Developmental Biology','0070-2153',4.677000,0.007810,0.890740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dev. Neurobiol.','Developmental Neurobiology','1932-8451',2.529000,0.008760,0.998430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('EvoDevo','EvoDevo','2041-9139',3.177000,0.003550,0.404760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Reprod. Dev.','MOLECULAR REPRODUCTION AND DEVELOPMENT','1040-452X',2.141000,0.004970,0.566350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neural Dev.','Neural Development','1749-8104',3.038000,0.003390,0.385820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann Endocrinol.','ANNALES D ENDOCRINOLOGIE','0003-4266',0.930000,0.001070,0.121940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pain Pract.','Pain Practice','1530-7085',2.317000,0.003920,0.446440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Landsc. Ecol. Eng.','Landscape and Ecological Engineering','1860-1871',0.597000,0.000540,0.062060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Hist.','NATURAL HISTORY','0028-0712',0.051000,0.000050,0.005790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Linn. Soc. N. S. W.','PROCEEDINGS OF THE LINNEAN SOCIETY OF NEW SOUTH WALES','0370-047X',0.214000,0.000130,0.014880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Geophys.','ANNALES GEOPHYSICAE','0992-7689',1.731000,0.009050,1.032000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Astron. Astrophys.','Annual Review of Astronomy and Astrophysics','0066-4146',37.846000,0.020160,2.297550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Astron. Geophys.','ASTRONOMY & GEOPHYSICS','1366-8781',0.256000,0.000300,0.034320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Astron. Rep.','ASTRONOMY REPORTS','1063-7729',0.805000,0.001750,0.199680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Astrophys. J.','ASTROPHYSICAL JOURNAL','0004-637X',5.909000,0.426030,48.558430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Balt. Astron.','BALTIC ASTRONOMY','1392-0049',0.346000,0.000620,0.071080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Epigenetics','Clinical Epigenetics','1868-7083',4.327000,0.002180,0.248560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Clin. Exp. Pathol.','International Journal of Clinical and Experimental Pathology','1936-2625',1.581000,0.009690,1.103960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Invest. New Drugs','INVESTIGATIONAL NEW DRUGS','0167-6997',3.281000,0.010460,1.192640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Adolesc. Young Adult Oncol.','Journal of Adolescent and Young Adult Oncology','2156-5333',1.111000,0.000640,0.073040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. BUON','Journal of BUON','1107-0625',0.880000,0.001370,0.155890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cancer','Journal of Cancer','1837-9664',3.609000,0.004230,0.481650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Surg. Oncol.','JOURNAL OF SURGICAL ONCOLOGY','0022-4790',3.151000,0.017880,2.037840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Intell. Inf. Syst.','JOURNAL OF INTELLIGENT INFORMATION SYSTEMS','0925-9902',1.000000,0.000990,0.113400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Intell. Robot. Syst.','JOURNAL OF INTELLIGENT & ROBOTIC SYSTEMS','0921-0296',0.932000,0.003920,0.446340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mult.-Valued Log. Soft Comput.','JOURNAL OF MULTIPLE-VALUED LOGIC AND SOFT COMPUTING','1542-3980',0.325000,0.000930,0.105500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Knowl. Inf. Syst.','KNOWLEDGE AND INFORMATION SYSTEMS','0219-1377',1.702000,0.004930,0.562480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Hum.-Comput. Interact.','INTERNATIONAL JOURNAL OF HUMAN-COMPUTER INTERACTION','1044-7318',1.260000,0.001650,0.188590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Interact. Comput.','INTERACTING WITH COMPUTERS','0953-5438',0.889000,0.001670,0.190410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Sex Differ.','Biology of Sex Differences','2042-6410',3.237000,0.001780,0.202590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Endocr. Disord.','BMC Endocrine Disorders','1472-6823',1.739000,0.002100,0.238930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bone','BONE','8756-3282',3.736000,0.034520,3.935060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endocr. Metab. Immune Disord.-Drug Targets','Endocrine Metabolic & Immune Disorders-Drug Targets','1871-5303',1.987000,0.001150,0.131430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endocr.-Relat. Cancer','ENDOCRINE-RELATED CANCER','1351-0088',4.472000,0.011910,1.357350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endocrinology','ENDOCRINOLOGY','0013-7227',4.159000,0.051160,5.831160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Free Radic. Biol. Med.','FREE RADICAL BIOLOGY AND MEDICINE','0891-5849',5.784000,0.047700,5.437150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Neuroendocrinol.','FRONTIERS IN NEUROENDOCRINOLOGY','0091-3022',8.852000,0.007250,0.826410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gen. Comp. Endocrinol.','GENERAL AND COMPARATIVE ENDOCRINOLOGY','0016-6480',2.667000,0.015640,1.782930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Horm. Metab. Res.','HORMONE AND METABOLIC RESEARCH','0018-5043',2.029000,0.006770,0.772180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Endocrinol.','International Journal of Endocrinology','1687-8337',2.376000,0.006370,0.726320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin. Densitom.','JOURNAL OF CLINICAL DENSITOMETRY','1094-6950',2.644000,0.003130,0.356320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oncology','ONCOLOGY','0030-2414',2.152000,0.005710,0.651030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Onkologe','Onkologe','0947-8965',0.090000,0.000080,0.008580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pathol. Oncol. Res.','PATHOLOGY & ONCOLOGY RESEARCH','1219-4956',1.940000,0.003800,0.433100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Tumor Res.','Progress in Tumor Research','0079-6263',1.625000,0.000040,0.005040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiol. Oncol.','Radiology and Oncology','1318-2099',1.736000,0.001230,0.139730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Cancer Biol.','SEMINARS IN CANCER BIOLOGY','1044-579X',9.955000,0.012870,1.466450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('UHOD-Uluslar. Hematol.-Onkol. De.','UHOD-Uluslararasi Hematoloji-Onkoloji Dergisi','1306-133X',0.974000,0.000360,0.040460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Displays','DISPLAYS','0141-9382',1.903000,0.001160,0.131850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE-ACM Trans. Netw.','IEEE-ACM TRANSACTIONS ON NETWORKING','1063-6692',2.186000,0.015410,1.756470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Comput.','IEEE TRANSACTIONS ON COMPUTERS','0018-9340',1.723000,0.011390,1.298420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Very Large Scale Integr. (VLSI) Syst.','IEEE TRANSACTIONS ON VERY LARGE SCALE INTEGRATION (VLSI) SYSTEMS','1063-8210',1.245000,0.011060,1.260390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. High Perform. Comput. Appl.','INTERNATIONAL JOURNAL OF HIGH PERFORMANCE COMPUTING APPLICATIONS','1094-3420',1.081000,0.002160,0.245750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Perform. Eval.','PERFORMANCE EVALUATION','0166-5316',0.944000,0.002840,0.323780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM SIGCOMM Comp. Commun. Rev.','ACM SIGCOMM Computer Communication Review','0146-4833',1.402000,0.011600,1.321980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Knowl. Discov. Data','ACM Transactions on Knowledge Discovery from Data','1556-4681',1.000000,0.001510,0.172570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aslib Proc.','ASLIB PROCEEDINGS','0001-253X',1.147000,0.000420,0.048000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bell Labs Tech. J.','BELL LABS TECHNICAL JOURNAL','1089-7089',1.200000,0.001420,0.161740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Commun.','COMPUTER COMMUNICATIONS','0140-3664',2.099000,0.007990,0.910840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front.. Comput. Sci.','Frontiers of Computer Science','2095-2228',0.660000,0.000860,0.098070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Inform. Technol. Elect. Eng.','Frontiers of Information Technology & Electronic Engineering','2095-9184',0.000000,0.000000,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutr. Metab. Carbiovasc. Dis.','NUTRITION METABOLISM AND CARDIOVASCULAR DISEASES','0939-4753',3.390000,0.011260,1.283080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trace Elem. Electrolytes','TRACE ELEMENTS AND ELECTROLYTES','0946-2104',0.377000,0.000110,0.012870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomass Bioenerg.','BIOMASS & BIOENERGY','0961-9534',3.249000,0.030960,3.528590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('China Pet. Process. Petrochem. T.','China Petroleum Processing & Petrochemical Technology','1008-6234',0.388000,0.000110,0.012840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CT F  Cienc. Tecnol. Futuro','CT&F-Ciencia Tecnologia y Futuro','0122-5383',0.281000,0.000080,0.008630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Explor. Exploit.','ENERGY EXPLORATION & EXPLOITATION','0144-5987',1.094000,0.000690,0.078210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Policy','ENERGY POLICY','0301-4215',3.045000,0.062060,7.073590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Astrophys. Astron.','JOURNAL OF ASTROPHYSICS AND ASTRONOMY','0250-6335',0.329000,0.000480,0.055010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Dark Universe','Physics of the Dark Universe','2212-6864',5.222000,0.002490,0.283760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Mex. Astron. Astrofis.','REVISTA MEXICANA DE ASTRONOMIA Y ASTROFISICA','0185-1101',2.364000,0.002130,0.242640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Space Weather','SPACE WEATHER-THE INTERNATIONAL JOURNAL OF RESEARCH AND APPLICATIONS','1542-7390',2.398000,0.003040,0.346540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Audiol.','American Journal of Audiology','1059-0889',1.125000,0.001090,0.123850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Fluency Disord.','JOURNAL OF FLUENCY DISORDERS','0094-730X',2.022000,0.000980,0.112250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Speech Lang. Hear. Res.','JOURNAL OF SPEECH LANGUAGE AND HEARING RESEARCH','1092-4388',1.526000,0.007540,0.859210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Logop. Phoniatr. Vocology.','Logopedics Phoniatrics Vocology','1401-5439',0.750000,0.000760,0.086330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Noise Health','Noise & Health','1463-1741',1.826000,0.001940,0.221420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Behav. Genet.','BEHAVIOR GENETICS','0001-8244',3.268000,0.005870,0.668800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Physiol.-Heart Circul. Physiol.','AMERICAN JOURNAL OF PHYSIOLOGY-HEART AND CIRCULATORY PHYSIOLOGY','0363-6135',3.324000,0.036800,4.194280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Noninvasive Electrocardiol.','ANNALS OF NONINVASIVE ELECTROCARDIOLOGY','1082-720X',1.569000,0.001760,0.200980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Cardiovasc. Disord.','BMC Cardiovascular Disorders','1471-2261',1.916000,0.005980,0.681410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiol. J.','Cardiology Journal','1897-5593',1.130000,0.002550,0.291000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiovasc. Ultrasound','Cardiovascular Ultrasound','1476-7120',1.463000,0.001780,0.202450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Circ.Res.','CIRCULATION RESEARCH','0009-7330',11.551000,0.085030,9.692140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Prev. Cardiol.','European Journal of Preventive Cardiology','2047-4873',3.361000,0.007490,0.853380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heart Fail. Clin.','Heart Failure Clinics','1551-7136',1.764000,0.002670,0.304880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heart Vessels','HEART AND VESSELS','0910-8327',2.293000,0.002670,0.304420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Cardiovasc. Imaging','INTERNATIONAL JOURNAL OF CARDIOVASCULAR IMAGING','1569-5794',1.880000,0.007400,0.843220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Heart Assoc.','Journal of the American Heart Association','2047-9980',5.117000,0.019890,2.266760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Card. Surg.','JOURNAL OF CARDIAC SURGERY','0886-0440',0.783000,0.003540,0.403760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Syst. J.','IEEE Systems Journal','1932-8184',2.114000,0.004440,0.506170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Manage.','INFORMATION & MANAGEMENT','0378-7206',2.163000,0.003170,0.360970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Process. Manage.','INFORMATION PROCESSING & MANAGEMENT','0306-4573',1.397000,0.002220,0.252920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Syst. Manage.','INFORMATION SYSTEMS MANAGEMENT','1058-0530',1.021000,0.000530,0.060070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Arab J. Inf. Technol.','International Arab Journal of Information Technology','1683-3198',0.519000,0.000260,0.029510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Web. Serv. Res.','International Journal of Web Services Research','1545-7362',0.257000,0.000240,0.027910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ambient Intell. Smart Environ.','Journal of Ambient Intelligence and Smart Environments','1876-1364',0.707000,0.000720,0.082590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Commun. Netw.','JOURNAL OF COMMUNICATIONS AND NETWORKS','1229-2370',0.920000,0.002710,0.308470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Database Manage.','JOURNAL OF DATABASE MANAGEMENT','1063-8016',0.120000,0.000180,0.020530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Inf. Sci.','JOURNAL OF INFORMATION SCIENCE','0165-5515',0.878000,0.001340,0.153250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Inf. Technol.','JOURNAL OF INFORMATION TECHNOLOGY','0268-3962',4.775000,0.002680,0.305280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Opt. Commun. Netw.','Journal of Optical Communications and Networking','1943-0620',2.183000,0.005270,0.600190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Energy Inst.','JOURNAL OF THE ENERGY INSTITUTE','1743-9671',1.000000,0.000590,0.067590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pet. Chem.','PETROLEUM CHEMISTRY','0965-5441',0.495000,0.000920,0.104540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Comput. Method Eng.','ARCHIVES OF COMPUTATIONAL METHODS IN ENGINEERING','1134-3060',4.214000,0.003150,0.358750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CMES-Comp. Model. Eng. Sci.','CMES-COMPUTER MODELING IN ENGINEERING & SCIENCES','1526-1492',0.841000,0.003730,0.425050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Combust. Sci. Technol.','COMBUSTION SCIENCE AND TECHNOLOGY','0010-2202',1.193000,0.003970,0.452810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eksploat. Niezawodn.','Eksploatacja i Niezawodnosc-Maintenance and Reliability','1507-2711',1.248000,0.000690,0.079170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. ECT','JOURNAL OF ECT','1095-0680',1.833000,0.002190,0.249150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Bioinform.','Current Bioinformatics','1574-8936',0.770000,0.000820,0.093870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomol. Screen','JOURNAL OF BIOMOLECULAR SCREENING','1087-0571',2.218000,0.006370,0.726070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Biol.','JOURNAL OF COMPUTATIONAL BIOLOGY','1066-5277',1.537000,0.007550,0.860480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mass Spectrom.','JOURNAL OF MASS SPECTROMETRY','1076-5174',2.541000,0.008650,0.985880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Proteomics','Journal of Proteomics','1874-3919',3.867000,0.027690,3.155990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiovasc. Electrophysiol.','JOURNAL OF CARDIOVASCULAR ELECTROPHYSIOLOGY','1045-3873',3.097000,0.015000,1.709310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiovasc. Pharmacol.','JOURNAL OF CARDIOVASCULAR PHARMACOLOGY','0160-2446',2.462000,0.007300,0.832430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Heart Lung Transplant.','JOURNAL OF HEART AND LUNG TRANSPLANTATION','1053-2498',7.509000,0.025450,2.900510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Heart Valve Dis.','JOURNAL OF HEART VALVE DISEASE','0966-8519',0.715000,0.003320,0.378600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JACC-Cardiovasc. Imag.','JACC-Cardiovascular Imaging','1936-878X',7.815000,0.023520,2.680250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Rev. Cardiol.','Nature Reviews Cardiology','1759-5002',10.533000,0.017600,2.006360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neth. Heart J.','Netherlands Heart Journal','1568-5888',2.062000,0.001830,0.208790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutr. Metab. Carbiovasc. Dis.','NUTRITION METABOLISM AND CARDIOVASCULAR DISEASES','0939-4753',3.390000,0.011260,1.283080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trends Cardiovasc. Med.','TRENDS IN CARDIOVASCULAR MEDICINE','1050-1738',3.075000,0.002880,0.328070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aging-US','Aging-US','1945-4589',3.979000,0.009010,1.027170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Cell','BIOLOGY OF THE CELL','0248-4900',2.552000,0.003400,0.387600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Membr.','BIOLOGICHESKIE MEMBRANY','0233-4755',0.081000,0.000050,0.005930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('KSII Trans. Internet Inf. Syst.','KSII Transactions on Internet and Information Systems','1976-7277',0.365000,0.000960,0.109500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Secur. Commun. Netw.','Security and Communication Networks','1939-0114',0.806000,0.001560,0.177420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wirel. Commun. Mob. Comput.','WIRELESS COMMUNICATIONS & MOBILE COMPUTING','1530-8669',0.922000,0.003320,0.378230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wirel. Netw.','WIRELESS NETWORKS','1022-0038',1.006000,0.003530,0.402750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Comput. Method Eng.','ARCHIVES OF COMPUTATIONAL METHODS IN ENGINEERING','1134-3060',4.214000,0.003150,0.358750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Electr. Eng.','COMPUTERS & ELECTRICAL ENGINEERING','0045-7906',1.084000,0.003190,0.363660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Electron. Agric.','COMPUTERS AND ELECTRONICS IN AGRICULTURE','0168-1699',1.892000,0.007020,0.800180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Linguist.','COMPUTATIONAL LINGUISTICS','0891-2017',2.017000,0.001960,0.223760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Meth. Programs Biomed.','COMPUTER METHODS AND PROGRAMS IN BIOMEDICINE','0169-2607',1.862000,0.007960,0.906820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Phys. Commun.','COMPUTER PHYSICS COMMUNICATIONS','0010-4655',3.635000,0.032170,3.666390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Struct.','COMPUTERS & STRUCTURES','0045-7949',2.425000,0.013270,1.512760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput.-Aided Civil Infrastruct. Eng.','COMPUTER-AIDED CIVIL AND INFRASTRUCTURE ENGINEERING','1093-9687',5.288000,0.003670,0.418390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Digit. Investig.','Digital Investigation','1742-2876',1.211000,0.000640,0.072790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Comput.','ENGINEERING COMPUTATIONS','0264-4401',0.691000,0.001430,0.162940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Stud.','Engineering Studies','1937-8629',0.417000,0.000210,0.023620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Comput. Methods','International Journal of Computational Methods','0219-8762',1.123000,0.001510,0.171660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Pressure Vessels Pip.','INTERNATIONAL JOURNAL OF PRESSURE VESSELS AND PIPING','0308-0161',1.432000,0.003750,0.427960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Audio Eng. Soc.','JOURNAL OF THE AUDIO ENGINEERING SOCIETY','1549-4950',0.856000,0.001240,0.140860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chin. Inst. Eng.','JOURNAL OF THE CHINESE INSTITUTE OF ENGINEERS','0253-3839',0.246000,0.000540,0.061170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Eng. Res.','Journal of Engineering Research','2307-1877',0.177000,0.000040,0.004060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Measurement','MEASUREMENT','0263-2241',1.742000,0.010390,1.184580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Artif. Organs','ARTIFICIAL ORGANS','0160-564X',1.993000,0.004620,0.526630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Australas. Phys. Eng. Sci. Med.','AUSTRALASIAN PHYSICAL & ENGINEERING SCIENCES IN MEDICINE','0158-9938',0.676000,0.000780,0.088640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biofabrication','Biofabrication','1758-5082',4.702000,0.003810,0.433920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioinspired Biomim. Nanobiomat.','Bioinspired Biomimetic and Nanobiomaterials','2045-9858',0.523000,0.000360,0.040610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomech. Model. Mechanobiol.','Biomechanics and Modeling in Mechanobiology','1617-7959',3.032000,0.006520,0.743570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lab Chip','LAB ON A CHIP','1473-0197',5.586000,0.055990,6.381790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Cell. Probes','MOLECULAR AND CELLULAR PROBES','0890-8508',1.565000,0.001840,0.209210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prep. Biochem. Biotechnol.','PREPARATIVE BIOCHEMISTRY & BIOTECHNOLOGY','1082-6068',1.114000,0.000750,0.085160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACS Chem. Biol.','ACS Chemical Biology','1554-8929',5.090000,0.033820,3.854590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Biochim. Pol.','ACTA BIOCHIMICA POLONICA','0001-527X',1.187000,0.002900,0.331020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Respir. Cell Mol. Biol.','AMERICAN JOURNAL OF RESPIRATORY CELL AND MOLECULAR BIOLOGY','1044-1549',4.082000,0.021180,2.414360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Amyloid-J. Protein Fold. Disord.','AMYLOID-JOURNAL OF PROTEIN FOLDING DISORDERS','1350-6129',2.351000,0.003290,0.374770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Insect Biochem. Physiol.','ARCHIVES OF INSECT BIOCHEMISTRY AND PHYSIOLOGY','0739-4462',1.357000,0.001600,0.182910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochim. Biophys. Acta-Bioenerg.','BIOCHIMICA ET BIOPHYSICA ACTA-BIOENERGETICS','0005-2728',4.864000,0.024120,2.749300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochem. J.','BIOCHEMICAL JOURNAL','0264-6021',3.562000,0.049610,5.654550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochem. Soc. Trans.','BIOCHEMICAL SOCIETY TRANSACTIONS','0300-5127',2.679000,0.024070,2.743080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Prolif.','CELL PROLIFERATION','0960-7722',3.084000,0.003220,0.366730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Struct. Funct.','CELL STRUCTURE AND FUNCTION','0386-7196',1.969000,0.000940,0.107310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Tissue Res.','CELL AND TISSUE RESEARCH','0302-766X',2.948000,0.016140,1.839930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Stem Cell Res. Ther.','Current Stem Cell Research & Therapy','1574-888X',2.645000,0.002080,0.237470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cytologia','CYTOLOGIA','0011-4545',0.227000,0.000320,0.036600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Faseb J.','FASEB JOURNAL','0892-6638',5.299000,0.064270,7.325740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Folia Histochem. Cytobiol.','FOLIA HISTOCHEMICA ET CYTOBIOLOGICA','0239-8508',1.060000,0.001320,0.150320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genes Dev.','GENES & DEVELOPMENT','0890-9369',10.042000,0.117120,13.349120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Growth Factors','GROWTH FACTORS','0897-7194',2.043000,0.001850,0.210640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Growth Horm. IGF Res.','GROWTH HORMONE & IGF RESEARCH','1096-6374',1.448000,0.001690,0.192600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('In Vitro Cell. Dev. Biol.-Anim.','IN VITRO CELLULAR & DEVELOPMENTAL BIOLOGY-ANIMAL','1071-2690',0.971000,0.002320,0.264010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Inf. Technol. Decis. Mak.','INTERNATIONAL JOURNAL OF INFORMATION TECHNOLOGY & DECISION MAKING','0219-6220',1.183000,0.001350,0.153960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cheminformatics','Journal of Cheminformatics','1758-2946',3.949000,0.005610,0.639600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Civil. Eng.','JOURNAL OF COMPUTING IN CIVIL ENGINEERING','0887-3801',1.855000,0.003340,0.380690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hydroinform.','JOURNAL OF HYDROINFORMATICS','1464-7141',1.180000,0.002260,0.258100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Appl. Percept.','ACM Transactions on Applied Perception','1544-3558',0.561000,0.000900,0.102820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Web','ACM Transactions on the Web','1559-1131',1.061000,0.001510,0.172550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput.-Aided Des.','COMPUTER-AIDED DESIGN','0010-4485',2.149000,0.007530,0.858580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Image Anal.','MEDICAL IMAGE ANALYSIS','1361-8415',4.565000,0.010690,1.218710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Eng. Geol. Environ.','Bulletin of Engineering Geology and the Environment','1435-9529',1.252000,0.001560,0.178100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Chem. Lett.','Environmental Chemistry Letters','1610-3653',2.918000,0.002670,0.304780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indoor Built Environ.','INDOOR AND BUILT ENVIRONMENT','1420-326X',0.943000,0.001500,0.170470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Iran. J. Environ. Health Sci. Eng.','Iranian Journal of Environmental Health Science & Engineering','1735-1979',2.280000,0.000750,0.085680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Water Resour. Assoc.','JOURNAL OF THE AMERICAN WATER RESOURCES ASSOCIATION','1093-474X',1.659000,0.005100,0.580760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clean Prod.','JOURNAL OF CLEANER PRODUCTION','0959-6526',4.959000,0.027880,3.178090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Biochem. Biophys.','CELL BIOCHEMISTRY AND BIOPHYSICS','1085-9195',1.627000,0.006880,0.784570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Extremophiles','EXTREMOPHILES','1431-0651',2.346000,0.003870,0.441320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Cell','MOLECULAR CELL','1097-2765',13.958000,0.192560,21.948350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Cell. Endocrinol.','MOLECULAR AND CELLULAR ENDOCRINOLOGY','0303-7207',3.859000,0.029700,3.385700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oncogene','ONCOGENE','0950-9232',7.932000,0.094170,10.734000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oncotarget','Oncotarget','1949-2553',5.008000,0.030880,3.519630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pigment Cell Melanoma Res.','Pigment Cell & Melanoma Research','1755-1471',4.163000,0.009870,1.125040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Protoplasma','PROTOPLASMA','0033-183X',2.343000,0.005380,0.612930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Signal.','Science Signaling','1945-0877',7.359000,0.043900,5.004050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stem Cells','STEM CELLS','1066-5099',5.902000,0.040440,4.609490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tissue Antigens','TISSUE ANTIGENS','0001-2815',2.046000,0.004770,0.543270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trends Cell Biol.','TRENDS IN CELL BIOLOGY','0962-8924',11.532000,0.032440,3.697950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trends Mol. Med','TRENDS IN MOLECULAR MEDICINE','1471-4914',9.292000,0.020480,2.334410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wiley Interdiscip. Rev.-RNA','Wiley Interdisciplinary Reviews-RNA','1757-7004',4.519000,0.009510,1.083930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Graph.-UK','COMPUTERS & GRAPHICS-UK','0097-8493',1.120000,0.004310,0.491030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Sci. Inf. Syst.','Computer Science and Information Systems','1820-0214',0.623000,0.000810,0.092210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Stand. Interfaces','COMPUTER STANDARDS & INTERFACES','0920-5489',1.268000,0.001470,0.167520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Form. Asp. Comput.','FORMAL ASPECTS OF COMPUTING','0934-5043',0.521000,0.000800,0.090900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front.. Comput. Sci.','Frontiers of Computer Science','2095-2228',0.660000,0.000860,0.098070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Micro','IEEE MICRO','0272-1732',1.091000,0.004110,0.468420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Vis. Comput. Graph.','IEEE TRANSACTIONS ON VISUALIZATION AND COMPUTER GRAPHICS','1077-2626',1.400000,0.017410,1.984580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IET Softw.','IET Software','1751-8806',0.473000,0.000570,0.065330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Sci. Technol.','JOURNAL OF COMPUTER SCIENCE AND TECHNOLOGY','1000-9000',0.475000,0.001560,0.178340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Math. Imaging Vis.','JOURNAL OF MATHEMATICAL IMAGING AND VISION','0924-9907',1.461000,0.005400,0.615290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Comput. Model.','MATHEMATICAL AND COMPUTER MODELLING','0895-7177',1.366000,0.012970,1.478580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Multimed. Tools Appl.','MULTIMEDIA TOOLS AND APPLICATIONS','1380-7501',1.331000,0.005470,0.623630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Softw.-Pract. Exp.','SOFTWARE-PRACTICE & EXPERIENCE','0038-0644',0.652000,0.001990,0.226750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cold Reg. Eng.','JOURNAL OF COLD REGIONS ENGINEERING','0887-381X',0.720000,0.000210,0.024210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Residuals Sci. Technol.','Journal of Residuals Science & Technology','1544-8053',0.386000,0.000130,0.015120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ozone-Sci. Eng.','OZONE-SCIENCE & ENGINEERING','0191-9512',0.853000,0.001030,0.117810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Res.','WATER RESEARCH','0043-1354',5.991000,0.078040,8.895340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Sci. Technol.-Water Supply','Water Science and Technology-Water Supply','1606-9749',0.532000,0.001300,0.148390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('AATCC Rev.','AATCC REVIEW','1532-8813',0.239000,0.000160,0.018190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Eng. Prog.','CHEMICAL ENGINEERING PROGRESS','0360-7275',0.364000,0.000430,0.048680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Color Res. Appl.','COLOR RESEARCH AND APPLICATION','0361-2317',0.847000,0.001150,0.131490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Combust. Sci. Technol.','COMBUSTION SCIENCE AND TECHNOLOGY','0010-2202',1.193000,0.003970,0.452810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Combust. Theory Model.','COMBUSTION THEORY AND MODELLING','1364-7830',2.230000,0.002610,0.297210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Sources Part A-Recovery Util. Environ. Eff.','Energy Sources Part A-Recovery Utilization and Environmental Effects','1556-7036',0.455000,0.002100,0.239630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Rev. Cell Mol. Biol.','International Review of Cell and Molecular Biology','1937-6448',3.752000,0.005150,0.587550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomol. Struct. Dyn.','JOURNAL OF BIOMOLECULAR STRUCTURE & DYNAMICS','0739-1102',2.300000,0.003360,0.382750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem. Ecol.','JOURNAL OF CHEMICAL ECOLOGY','0098-0331',3.151000,0.009460,1.078340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Crit Care Resusc.','Critical Care and Resuscitation','1441-2772',3.317000,0.003100,0.353470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Intensive Care Med.','JOURNAL OF INTENSIVE CARE MEDICINE','0885-0666',3.262000,0.002400,0.273660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Respir. Crit. Care Med.','SEMINARS IN RESPIRATORY AND CRITICAL CARE MEDICINE','1069-3424',2.274000,0.004120,0.469840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ther. Hypothermia Temp. Manag.','Therapeutic Hypothermia and Temperature Management','2153-7658',1.415000,0.000410,0.047290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Mech. Eng.','Advances in Mechanical Engineering','1687-8140',0.640000,0.003270,0.372330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Build. Simul.','Building Simulation','1996-3599',1.409000,0.000840,0.096050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Heat Fluid Flow','INTERNATIONAL JOURNAL OF HEAT AND FLUID FLOW','0142-727X',1.737000,0.007170,0.817030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Softw. Qual. J.','SOFTWARE QUALITY JOURNAL','0963-9314',0.787000,0.000750,0.085750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Virtual Real.','VIRTUAL REALITY','1359-4338',0.568000,0.000580,0.065690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Artif. Life','ARTIFICIAL LIFE','1064-5462',1.042000,0.000930,0.106550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Computing','COMPUTING','0010-485X',0.872000,0.002180,0.248940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Concurr. Comput.-Pract. Exp.','CONCURRENCY AND COMPUTATION-PRACTICE & EXPERIENCE','1532-0626',0.942000,0.003760,0.428500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryptologia','CRYPTOLOGIA','0161-1194',0.213000,0.000080,0.009540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Futur. Gener. Comp. Syst.','Future Generation Computer Systems-The International Journal of eScience','0167-739X',2.430000,0.008330,0.949010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. High Perform. Comput. Appl.','INTERNATIONAL JOURNAL OF HIGH PERFORMANCE COMPUTING APPLICATIONS','1094-3420',1.081000,0.002160,0.245750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cell. Autom.','Journal of Cellular Automata','1557-5969',0.418000,0.000280,0.032430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Adhes. Adhes.','INTERNATIONAL JOURNAL OF ADHESION AND ADHESIVES','0143-7496',1.956000,0.005080,0.579050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Chem. React. Eng.','International Journal of Chemical Reactor Engineering','2194-5748',0.759000,0.001410,0.161160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Can. Pet. Technol.','JOURNAL OF CANADIAN PETROLEUM TECHNOLOGY','0021-9487',0.787000,0.001830,0.208690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Food Eng.','JOURNAL OF FOOD ENGINEERING','0260-8774',3.199000,0.023440,2.672200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Loss Prev. Process Ind.','JOURNAL OF LOSS PREVENTION IN THE PROCESS INDUSTRIES','0950-4230',1.409000,0.003500,0.398370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Supercrit. Fluids','JOURNAL OF SUPERCRITICAL FLUIDS','0896-8446',2.579000,0.010190,1.161170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Surfactants Deterg.','JOURNAL OF SURFACTANTS AND DETERGENTS','1097-3958',1.853000,0.001910,0.218070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Korean J. Chem. Eng.','KOREAN JOURNAL OF CHEMICAL ENGINEERING','0256-1115',1.408000,0.005340,0.608490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pet. Chem.','PETROLEUM CHEMISTRY','0965-5441',0.495000,0.000920,0.104540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polym. Eng. Sci.','POLYMER ENGINEERING AND SCIENCE','0032-3888',1.719000,0.007300,0.832180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Process Saf. Environ. Protect.','PROCESS SAFETY AND ENVIRONMENTAL PROTECTION','0957-5820',2.078000,0.002690,0.306710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Technol. Energ. Mater.','Science and Technology of Energetic Materials','1347-9466',0.636000,0.000150,0.016700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sep. Sci. Technol.','SEPARATION SCIENCE AND TECHNOLOGY','0149-6395',1.083000,0.006010,0.684940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Ecol.','MOLECULAR ECOLOGY','0962-1083',5.947000,0.064180,7.315670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Ecol. Resour.','Molecular Ecology Resources','1755-098X',5.298000,0.024500,2.792130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Med.','NATURE MEDICINE','1078-8956',30.357000,0.161790,18.440690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurosignals','NEUROSIGNALS','1424-862X',1.593000,0.000920,0.104940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Biol.','PHYSICAL BIOLOGY','1478-3967',1.837000,0.006210,0.708170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Sci.','PLANT SCIENCE','0168-9452',3.362000,0.014340,1.634330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prion','Prion','1933-6896',2.444000,0.002650,0.302400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Process Biochem.','PROCESS BIOCHEMISTRY','1359-5113',2.529000,0.015120,1.723670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Lipid Res.','PROGRESS IN LIPID RESEARCH','0163-7827',11.238000,0.008480,0.966630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prostaglandins Other Lipid Mediat.','PROSTAGLANDINS & OTHER LIPID MEDIATORS','1098-8823',2.905000,0.002490,0.284130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Physiol. Biochem. Pharmacol.','Reviews of Physiology Biochemistry and Pharmacology','0303-4240',5.333000,0.000550,0.062580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Structure','STRUCTURE','0969-2126',5.237000,0.042980,4.898630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Therm. Sci.','Thermal Science','0354-9836',0.939000,0.002270,0.258250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Catal. Today','CATALYSIS TODAY','0920-5861',4.312000,0.033760,3.848220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Oil Chem. Soc.','JOURNAL OF THE AMERICAN OIL CHEMISTS SOCIETY','0003-021X',1.505000,0.006020,0.686710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biobased Mater. Bioenergy','Journal of Biobased Materials and Bioenergy','1556-6560',0.635000,0.000790,0.090590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cosmet. Sci.','JOURNAL OF COSMETIC SCIENCE','1525-7886',0.358000,0.000320,0.036860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Microencapsul.','JOURNAL OF MICROENCAPSULATION','0265-2048',1.631000,0.002220,0.253080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Near Infrared Spectrosc.','JOURNAL OF NEAR INFRARED SPECTROSCOPY','0967-0335',1.117000,0.001470,0.167520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pol. J. Chem. Technol.','Polish Journal of Chemical Technology','1509-8117',0.575000,0.000590,0.066880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Org. Coat.','PROGRESS IN ORGANIC COATINGS','0300-9440',2.632000,0.007870,0.897370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rec. Nat. Prod.','Records of Natural Products','1307-6167',0.765000,0.000960,0.109100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stud. Conserv.','STUDIES IN CONSERVATION','0039-3630',0.323000,0.000490,0.055820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Parallel Distrib. Comput.','JOURNAL OF PARALLEL AND DISTRIBUTED COMPUTING','0743-7315',1.320000,0.005740,0.654380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Malayas. J. Comput. Sci.','Malaysian Journal of Computer Science','0127-9084',0.476000,0.000100,0.011910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Multimed. Tools Appl.','MULTIMEDIA TOOLS AND APPLICATIONS','1380-7501',1.331000,0.005470,0.623630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semant. Web','Semantic Web','1570-0844',1.786000,0.001270,0.144450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Comput.','STATISTICS AND COMPUTING','0960-3174',1.786000,0.009340,1.064390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theor. Comput. Sci.','THEORETICAL COMPUTER SCIENCE','0304-3975',0.643000,0.016940,1.930600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Autom. Constr.','AUTOMATION IN CONSTRUCTION','0926-5805',2.442000,0.007030,0.801600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cem. Concr. Compos.','CEMENT & CONCRETE COMPOSITES','0958-9465',3.399000,0.012970,1.478200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Pavement Eng.','International Journal of Pavement Engineering','1029-8436',0.877000,0.001780,0.203330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Adv. Concr. Technol.','Journal of Advanced Concrete Technology','1346-8014',0.658000,0.001030,0.117300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Civil Eng.-Struct. Build.','PROCEEDINGS OF THE INSTITUTION OF CIVIL ENGINEERS-STRUCTURES AND BUILDINGS','0965-0911',0.429000,0.000970,0.110030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Ergon.','APPLIED ERGONOMICS','0003-6870',1.713000,0.006130,0.698240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CIRP Ann-Manuf. Technol.','CIRP ANNALS-MANUFACTURING TECHNOLOGY','0007-8506',2.492000,0.008350,0.952020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cogn. Technol. Work','Cognition Technology & Work','1435-5558',0.987000,0.000710,0.080940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Ind. Appl. Mag.','IEEE INDUSTRY APPLICATIONS MAGAZINE','1077-2618',0.422000,0.000750,0.085590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Ind. Inform.','IEEE Transactions on Industrial Informatics','1551-3203',4.708000,0.016350,1.863870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Syst. Eng.','Systems Engineering','1098-1241',0.956000,0.000530,0.059930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Concurrent Eng.-Res. Appl.','CONCURRENT ENGINEERING-RESEARCH AND APPLICATIONS','1063-293X',1.020000,0.000350,0.040270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Adv. Manuf. Technol.','INTERNATIONAL JOURNAL OF ADVANCED MANUFACTURING TECHNOLOGY','0268-3768',1.568000,0.022370,2.549810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Prod. Econ.','INTERNATIONAL JOURNAL OF PRODUCTION ECONOMICS','0925-5273',2.782000,0.020630,2.351710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Yeast','YEAST','0749-503X',2.259000,0.002960,0.337520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cytotherapy','CYTOTHERAPY','1465-3249',3.625000,0.008290,0.944680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomater. Tissue Eng.','Journal of Biomaterials and Tissue Engineering','2157-9083',1.287000,0.000570,0.064530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stem Cell Rep.','Stem Cell Reports','2213-6711',7.023000,0.011730,1.336800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stem Cell Rev. Rep.','Stem Cell Reviews and Reports','1550-8943',3.111000,0.005920,0.675120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. Biol. Teach.','AMERICAN BIOLOGY TEACHER','0002-7685',0.229000,0.000260,0.030030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Hum. Biol.','ANNALS OF HUMAN BIOLOGY','0301-4460',1.570000,0.002410,0.274390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Biol. Sci.','Archives of Biological Sciences','0354-4664',0.367000,0.001620,0.184330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Astrobiology','ASTROBIOLOGY','1531-1074',2.628000,0.005760,0.657070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Res.','BIOLOGICAL RESEARCH','0716-9760',1.328000,0.001480,0.168410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioscience','BIOSCIENCE','0006-3568',4.294000,0.014750,1.681550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Braz. J. Biol.','BRAZILIAN JOURNAL OF BIOLOGY','1519-6984',0.559000,0.002720,0.309930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electromagn. Biol. Med.','ELECTROMAGNETIC BIOLOGY AND MEDICINE','1536-8378',1.208000,0.000640,0.072500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Pharm. Res.','ARCHIVES OF PHARMACAL RESEARCH','0253-6269',2.490000,0.007910,0.901300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioorg. Med. Chem. Lett.','BIOORGANIC & MEDICINAL CHEMISTRY LETTERS','0960-894X',2.486000,0.054320,6.191440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Res. Toxicol.','CHEMICAL RESEARCH IN TOXICOLOGY','0893-228X',3.025000,0.015560,1.773900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fitoterapia','FITOTERAPIA','0367-326X',2.408000,0.010030,1.142900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Med. Food','JOURNAL OF MEDICINAL FOOD','1096-620X',1.844000,0.005190,0.591410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Chem.','Medicinal Chemistry','1573-4064',1.458000,0.002050,0.233640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Chem. Res.','MEDICINAL CHEMISTRY RESEARCH','1054-2523',1.436000,0.006970,0.794160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Acid Ther.','Nucleic Acid Therapeutics','2159-3337',2.813000,0.002450,0.279360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACS Nano','ACS Nano','1936-0851',13.334000,0.356820,40.670560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Crystallogr. Sect. A','Acta Crystallographica A-Foundation and Advances','2053-2733',2.333000,0.004020,0.458620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Crystallogr. Sect. B-Struct. Sci.Cryst. Eng. Mat.','Acta Crystallographica Section B-Structural Science Crystal Engineering and Materials','2052-5206',2.892000,0.003940,0.449240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Crystallogr. Sect. C-Struct. Chem.','Acta Crystallographica Section C-Structural Chemistry','2053-2296',0.479000,0.001650,0.187940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Pharm.','ARCHIV DER PHARMAZIE','0365-6233',2.043000,0.002520,0.287080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stahlbau','Stahlbau','0038-9145',0.225000,0.000870,0.099590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Steel Compos. Struct.','STEEL AND COMPOSITE STRUCTURES','1229-9367',1.796000,0.001360,0.155200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Emerg. Med.','AMERICAN JOURNAL OF EMERGENCY MEDICINE','0735-6757',1.504000,0.012640,1.441060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Emerg. Med.','ANNALS OF EMERGENCY MEDICINE','0196-0644',5.008000,0.018560,2.115390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Emergencias','Emergencias','1137-6821',2.917000,0.000770,0.087290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Emerg. Med.','European Journal of Emergency Medicine','0969-9546',2.026000,0.002660,0.303630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Resuscitation','RESUSCITATION','0300-9572',5.414000,0.030010,3.420850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ulus. Travma Acil Cerrahi Derg.','Ulusal Travma ve Acil Cerrahi Dergisi-Turkish Journal of Trauma & Emergency Surgery','1306-696X',0.453000,0.001010,0.115110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phase Transit.','PHASE TRANSITIONS','0141-1594',0.858000,0.001800,0.204900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. Endod. J.','Australian Endodontic Journal','1329-1947',0.885000,0.000500,0.057050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cranio-J. Craniomandib. Pract.','CRANIO-THE JOURNAL OF CRANIOMANDIBULAR PRACTICE','0886-9634',0.738000,0.000700,0.080300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prod. Plan. Control','PRODUCTION PLANNING & CONTROL','0953-7287',1.532000,0.001820,0.207280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Robot. Comput.-Integr. Manuf.','ROBOTICS AND COMPUTER-INTEGRATED MANUFACTURING','0736-5845',2.077000,0.003740,0.426280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mar. Sci. Technol.','JOURNAL OF MARINE SCIENCE AND TECHNOLOGY','0948-4280',0.709000,0.000900,0.102950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Struct.','COMPUTERS & STRUCTURES','0045-7949',2.425000,0.013270,1.512760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Constr. Build. Mater.','CONSTRUCTION AND BUILDING MATERIALS','0950-0618',2.421000,0.041500,4.730020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gradev.','Gradevinar','0350-2465',0.158000,0.000170,0.019890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Pavement Eng.','International Journal of Pavement Engineering','1029-8436',0.877000,0.001780,0.203330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Steel Struct.','International Journal of Steel Structures','1598-2351',0.533000,0.000820,0.093720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biol. Res.','Journal of Biological Research-Thessaloniki','2241-5793',0.574000,0.000470,0.053100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biol. Syst.','JOURNAL OF BIOLOGICAL SYSTEMS','0218-3390',0.479000,0.000600,0.068290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Math. Biol.','JOURNAL OF MATHEMATICAL BIOLOGY','0303-6812',1.716000,0.007100,0.809150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Philos. Trans. R. Soc. B-Biol. Sci.','PHILOSOPHICAL TRANSACTIONS OF THE ROYAL SOCIETY B-BIOLOGICAL SCIENCES','0962-8436',5.847000,0.078760,8.977160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochim. Biophys. Acta-Gen. Subj.','BIOCHIMICA ET BIOPHYSICA ACTA-GENERAL SUBJECTS','0304-4165',5.083000,0.025600,2.918390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochem. Biophys. Res. Commun.','BIOCHEMICAL AND BIOPHYSICAL RESEARCH COMMUNICATIONS','0006-291X',2.371000,0.090050,10.263940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomol. NMR Assign.','Biomolecular NMR Assignments','1874-2718',0.687000,0.001100,0.125210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biophys. Chem.','BIOPHYSICAL CHEMISTRY','0301-4622',2.363000,0.004740,0.540780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biophys. J.','BIOPHYSICAL JOURNAL','0006-3495',3.632000,0.074970,8.545260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biorheology','BIORHEOLOGY','0006-355X',0.981000,0.000760,0.086440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell. Mol. Bioeng.','Cellular and Molecular Bioengineering','1865-5025',1.589000,0.001760,0.200450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomech. Eng.-Trans. ASME','JOURNAL OF BIOMECHANICAL ENGINEERING-TRANSACTIONS OF THE ASME','0148-0731',1.747000,0.007410,0.844940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mech. Med. Biol.','Journal of Mechanics in Medicine and Biology','0219-5194',0.797000,0.001090,0.124650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ChemPlusChem','ChemPlusChem','2192-6506',2.836000,0.004900,0.558760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ChemSusChem','ChemSusChem','1864-5631',7.116000,0.037290,4.250830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Green Process. Synth.','Green Processing and Synthesis','2191-9542',1.291000,0.000550,0.062800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IUCrJ','IUCrJ','2052-2525',5.316000,0.002090,0.238350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem. Soc. Pak.','JOURNAL OF THE CHEMICAL SOCIETY OF PAKISTAN','0253-5106',0.276000,0.000970,0.110110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chil. Chem. Soc.','JOURNAL OF THE CHILEAN CHEMICAL SOCIETY','0717-9707',0.429000,0.000920,0.104580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mex. Chem. Soc.','Journal of the Mexican Chemical Society','1870-249X',0.722000,0.000650,0.074640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Dent. J.','INTERNATIONAL DENTAL JOURNAL','0020-6539',0.967000,0.001820,0.207940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Oral Maxillofac. Implants','INTERNATIONAL JOURNAL OF ORAL & MAXILLOFACIAL IMPLANTS','0882-2786',1.859000,0.010020,1.141900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Oral Sci.','International Journal of Oral Science','1674-2818',2.595000,0.002520,0.287230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Paediatr. Dent.','International Journal of Paediatric Dentistry','0960-7439',1.303000,0.002210,0.251900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Oral Implant.','Journal of Oral Implantology','0160-6972',1.432000,0.002640,0.300520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oral Radiol.','Oral Radiology','0911-6028',0.449000,0.000250,0.027970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Orthod. Craniofac. Res.','Orthodontics & Craniofacial Research','1601-6335',1.640000,0.001410,0.161170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Stomatol. Chir. Maxillo-Facil.','Revue de Stomatologie de Chirurgie Maxillo-faciale et de Chirurgie Orale','2213-6533',0.248000,0.000280,0.032250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Clin. Dermatol.','AMERICAN JOURNAL OF CLINICAL DERMATOLOGY','1175-0561',3.084000,0.003150,0.359470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('An. Brasil. Dermatol.','ANAIS BRASILEIROS DE DERMATOLOGIA','0365-0596',0.880000,0.003440,0.391950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. J. Dermatol.','BRITISH JOURNAL OF DERMATOLOGY','0007-0963',4.317000,0.035530,4.049670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Can. Pet. Technol.','JOURNAL OF CANADIAN PETROLEUM TECHNOLOGY','0021-9487',0.787000,0.001830,0.208690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oil Gas Sci. Technol.','Oil & Gas Science and Technology-Revue d IFP Energies nouvelles','1294-4475',1.087000,0.002230,0.254220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('AEU-Int. J. Electron. Commun.','AEU-INTERNATIONAL JOURNAL OF ELECTRONICS AND COMMUNICATIONS','1434-8411',0.786000,0.002200,0.251150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Comput. Electromagn. Soc. J.','APPLIED COMPUTATIONAL ELECTROMAGNETICS SOCIETY JOURNAL','1054-4887',0.389000,0.000860,0.098560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electr. Power Compon. Syst.','ELECTRIC POWER COMPONENTS AND SYSTEMS','1532-5008',0.747000,0.001400,0.160080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electr. Power Syst. Res.','ELECTRIC POWER SYSTEMS RESEARCH','0378-7796',1.809000,0.010250,1.168450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electron. World','ELECTRONICS WORLD','1365-4675',0.027000,0.000020,0.001970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Elektron. Elektrotech.','Elektronika Ir Elektrotechnika','1392-1215',0.389000,0.000990,0.112330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Sci. Technol.','WATER SCIENCE AND TECHNOLOGY','0273-1223',1.064000,0.015630,1.781630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pharmacokinet. Pharmacodyn.','JOURNAL OF PHARMACOKINETICS AND PHARMACODYNAMICS','1567-567X',1.808000,0.002000,0.228010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pharmacol. Exp. Ther.','JOURNAL OF PHARMACOLOGY AND EXPERIMENTAL THERAPEUTICS','0022-3565',3.760000,0.028920,3.295870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vet. Pharmacol. Ther.','JOURNAL OF VETERINARY PHARMACOLOGY AND THERAPEUTICS','0140-7783',1.279000,0.002350,0.268250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Diagn. Ther.','Molecular Diagnosis & Therapy','1177-1062',2.602000,0.001680,0.191140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Drugs','PEDIATRIC DRUGS','1174-5878',2.077000,0.001930,0.219770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacogenomics','PHARMACOGENOMICS','1462-2416',2.710000,0.008330,0.949200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacol. Biochem. Behav.','PHARMACOLOGY BIOCHEMISTRY AND BEHAVIOR','0091-3057',2.537000,0.012530,1.428280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacol. Rep.','Pharmacological Reports','1734-1140',2.251000,0.006080,0.692760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacology','PHARMACOLOGY','0031-7012',1.533000,0.002600,0.295870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytother. Res.','PHYTOTHERAPY RESEARCH','0951-418X',2.694000,0.010990,1.253210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pulm. Pharmacol. Ther.','PULMONARY PHARMACOLOGY & THERAPEUTICS','1094-5539',2.930000,0.004520,0.515380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Esp. Quim.','Revista Espanola de Quimioterapia','0214-3429',1.014000,0.000490,0.056250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ther. Innov. Regul. Sci.','Therapeutic Innovation & Regulatory Science','2168-4790',0.511000,0.000650,0.073890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Toxicon','TOXICON','0041-0101',2.309000,0.011230,1.279560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Spectrosc. Rev.','APPLIED SPECTROSCOPY REVIEWS','0570-4928',4.617000,0.001830,0.208450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Concepts Magn. Reson. Part B','CONCEPTS IN MAGNETIC RESONANCE PART B-MAGNETIC RESONANCE ENGINEERING','1552-5031',0.593000,0.000360,0.041000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Raman Spectrosc.','JOURNAL OF RAMAN SPECTROSCOPY','0377-0486',2.395000,0.010620,1.210790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Magn. Reson. Chem.','MAGNETIC RESONANCE IN CHEMISTRY','0749-1581',1.226000,0.002850,0.325000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Opt. Spectrosc.','OPTICS AND SPECTROSCOPY','0030-400X',0.644000,0.002630,0.299870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Spectroc. Acta Pt. B-Atom. Spectr.','SPECTROCHIMICA ACTA PART B-ATOMIC SPECTROSCOPY','0584-8547',3.289000,0.007380,0.841100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Spectr. Lett.','SPECTROSCOPY LETTERS','0038-7010',0.885000,0.001020,0.116030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aviat. Space Environ. Med.','AVIATION SPACE AND ENVIRONMENTAL MEDICINE','0095-6562',0.755000,0.002250,0.256190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Biomech.','CLINICAL BIOMECHANICS','0268-0033',1.636000,0.009880,1.126090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Perform Anal. Sport','International Journal of Performance Analysis in Sport','1474-8185',1.014000,0.000600,0.068140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Sports Med.','INTERNATIONAL JOURNAL OF SPORTS MEDICINE','0172-4622',2.528000,0.007820,0.891150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuropsychology','NEUROPSYCHOLOGY','0894-4105',2.879000,0.007870,0.897470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuroreport','NEUROREPORT','0959-4965',1.343000,0.007160,0.816430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurotox. Res.','NEUROTOXICITY RESEARCH','1029-8428',3.140000,0.004100,0.467440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacol. Biochem. Behav.','PHARMACOLOGY BIOCHEMISTRY AND BEHAVIOR','0091-3057',2.537000,0.012530,1.428280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Neurosci.','REVIEWS IN THE NEUROSCIENCES','0334-1763',3.198000,0.003790,0.431560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vision Res.','VISION RESEARCH','0042-6989',1.776000,0.015640,1.782970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. NeuroInterventional Surg.','Journal of NeuroInterventional Surgery','1759-8478',2.959000,0.007470,0.851730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Yakugaku Zasshi-J. Pharm. Soc. Jpn.','YAKUGAKU ZASSHI-JOURNAL OF THE PHARMACEUTICAL SOCIETY OF JAPAN','0031-6903',0.161000,0.000760,0.086690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chalcogenide Lett.','Chalcogenide Letters','1584-8663',0.676000,0.000900,0.102570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Appl. Phys.','CURRENT APPLIED PHYSICS','1567-1739',2.144000,0.014550,1.658010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Photonics J.','IEEE Photonics Journal','1943-0655',2.177000,0.011470,1.307690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Device Mater. Reliab.','IEEE TRANSACTIONS ON DEVICE AND MATERIALS RELIABILITY','1530-4388',1.437000,0.003670,0.417880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Laser Appl.','JOURNAL OF LASER APPLICATIONS','1042-346X',1.078000,0.001000,0.114150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nanoelectron. Optoelectron.','Journal of Nanoelectronics and Optoelectronics','1555-130X',0.675000,0.000660,0.075660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Int. Soc. Sport Nutr.','Journal of the International Society of Sports Nutrition','1550-2783',1.811000,0.001870,0.213650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oper. Tech. Sports Med.','OPERATIVE TECHNIQUES IN SPORTS MEDICINE','1060-1872',0.365000,0.000340,0.038360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('PM&R','PM&R','1934-1482',1.655000,0.007480,0.853040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sportverletz. Sportschaden','SPORTVERLETZUNG-SPORTSCHADEN','0932-0555',0.451000,0.000180,0.020840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Stoch. Models. Bus. Ind.','APPLIED STOCHASTIC MODELS IN BUSINESS AND INDUSTRY','1524-1904',0.574000,0.001510,0.172370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('AStA-Adv. Stat. Anal.','AStA-Advances in Statistical Analysis','1863-8171',1.053000,0.001860,0.212510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biom. J.','BIOMETRICAL JOURNAL','0323-3847',0.683000,0.003460,0.394120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Stat.-Simul. Comput.','COMMUNICATIONS IN STATISTICS-SIMULATION AND COMPUTATION','0361-0918',0.397000,0.002600,0.296390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Stat. Data Anal.','COMPUTATIONAL STATISTICS & DATA ANALYSIS','0167-9473',1.179000,0.020680,2.357630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Sci. Eng.','NUCLEAR SCIENCE AND ENGINEERING','0029-5639',0.844000,0.002320,0.264330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Nucl. Energy','PROGRESS IN NUCLEAR ENERGY','0149-1970',1.184000,0.004610,0.525990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiat. Prot. Dosim.','RADIATION PROTECTION DOSIMETRY','0144-8420',0.894000,0.007970,0.908100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Technol. Nucl. Install.','Science and Technology of Nuclear Installations','1687-6075',0.811000,0.001600,0.181820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asian Nurs. Res.','Asian Nursing Research','1976-1317',0.849000,0.000560,0.064270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. J. Oncol. Nurs.','Clinical Journal of Oncology Nursing','1092-1095',0.755000,0.002040,0.232950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Nurs. Knowl.','International Journal of Nursing Knowledge','2047-3087',0.727000,0.000180,0.020710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin. Nurs.','JOURNAL OF CLINICAL NURSING','0962-1067',1.384000,0.013680,1.559020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Fam. Nurs.','Journal of Family Nursing','1074-8407',1.775000,0.000630,0.072270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nurs. Care Qual.','JOURNAL OF NURSING CARE QUALITY','1057-3631',1.117000,0.001170,0.133120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microelectron. Eng.','MICROELECTRONIC ENGINEERING','0167-9317',1.277000,0.012820,1.461670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microelectron. Reliab.','MICROELECTRONICS RELIABILITY','0026-2714',1.202000,0.010180,1.160640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microsyst. Technol.','MICROSYSTEM TECHNOLOGIES-MICRO-AND NANOSYSTEMS-INFORMATION STORAGE AND PROCESSING SYSTEMS','0946-7076',0.974000,0.004200,0.478240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nano','NANO','1793-2920',0.951000,0.001230,0.140680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanotechnol. Rev.','Nanotechnology Reviews','2191-9089',2.044000,0.000660,0.075540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Mater.','NATURE MATERIALS','1476-1122',38.891000,0.207610,23.663220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Status Solidi A-Appl. Mat.','PHYSICA STATUS SOLIDI A-APPLICATIONS AND MATERIALS SCIENCE','1862-6300',1.648000,0.013590,1.548870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Status Solidi-Rapid Res. Lett.','Physica Status Solidi-Rapid Research Letters','1862-6254',2.578000,0.008390,0.956310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Recent Pat. Nanotechnology','Recent Patents on Nanotechnology','1872-2105',1.576000,0.000390,0.044470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Sci. Instrum.','REVIEW OF SCIENTIFIC INSTRUMENTS','0034-6748',1.336000,0.047830,5.451570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solid-State Electron.','SOLID-STATE ELECTRONICS','0038-1101',1.345000,0.007370,0.839810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Thin Solid Films','THIN SOLID FILMS','0040-6090',1.761000,0.046110,5.255660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Ecol. Stat.','ENVIRONMENTAL AND ECOLOGICAL STATISTICS','1352-8505',0.769000,0.001180,0.135000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Korean Stat. Soc.','Journal of the Korean Statistical Society','1226-3192',0.353000,0.001300,0.148430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Markov Process. Relat. Fields','Markov Processes and Related Fields','1024-2953',0.484000,0.001200,0.136690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Metrika','METRIKA','0026-1335',0.595000,0.002050,0.233440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Spat. Stat.','Spatial Statistics','2211-6753',1.385000,0.001180,0.134520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Appl. Genet. Mol. Biol.','Statistical Applications in Genetics and Molecular Biology','2194-6302',1.265000,0.002930,0.333970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr. Nurs.','Journal of Pediatric Nursing-Nursing Care of Children & Families','0882-5963',1.006000,0.001920,0.218610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. PeriAnesthesia Nurs.','Journal of PeriAnesthesia Nursing','1089-9472',0.662000,0.000620,0.070730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Psychiatr. Ment. Health Nurs.','Journal of Psychiatric and Mental Health Nursing','1351-0126',1.055000,0.002860,0.326310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sch. Nurs.','Journal of School Nursing','1059-8405',0.932000,0.000900,0.102750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Viab.','Journal of Tissue Viability','0965-206X',1.656000,0.000650,0.073620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Trauma Nurs.','Journal of Trauma Nursing','1078-7496',0.556000,0.000460,0.052390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nurs. Crit. Care','Nursing in Critical Care','1362-1017',1.113000,0.000990,0.112810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nurs. Ethics','NURSING ETHICS','0969-7330',1.469000,0.001970,0.224210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nurs. Res.','NURSING RESEARCH','0029-6562',1.856000,0.003100,0.353520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Res. Theory Nurs. Pract.','Research and Theory for Nursing Practice','1541-6577',0.273000,0.000270,0.030340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('West. J. Nurs. Res.','WESTERN JOURNAL OF NURSING RESEARCH','0193-9459',1.090000,0.001960,0.222850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Diet. Pract. Res.','CANADIAN JOURNAL OF DIETETIC PRACTICE AND RESEARCH','1486-3847',0.622000,0.000680,0.076980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecol. Food Nutr.','ECOLOGY OF FOOD AND NUTRITION','0367-0244',0.894000,0.000750,0.085270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE J. Sel. Top. Appl. Earth Observ. Remote Sens.','IEEE Journal of Selected Topics in Applied Earth Observations and Remote Sensing','1939-1404',2.145000,0.010930,1.245380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photogramm. Rec.','PHOTOGRAMMETRIC RECORD','0031-868X',1.622000,0.000830,0.095090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Contrib. Plasma Phys.','CONTRIBUTIONS TO PLASMA PHYSICS','0863-1042',1.255000,0.003060,0.348990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Therm. Fluid Sci.','EXPERIMENTAL THERMAL AND FLUID SCIENCE','0894-1777',2.128000,0.011480,1.308000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fluid Dyn.','Fluid Dynamics','0015-4628',0.396000,0.001040,0.119030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('High Energy Density Phys.','High Energy Density Physics','1574-1818',1.702000,0.003160,0.359910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Plasma Phys.','JOURNAL OF PLASMA PHYSICS','0022-3778',0.981000,0.002100,0.238960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Plasmas','PHYSICS OF PLASMAS','1070-664X',2.207000,0.048170,5.490150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Phys.','CHEMICAL PHYSICS','0301-0104',1.758000,0.011700,1.333540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Chem. Phys.','CHINESE JOURNAL OF CHEMICAL PHYSICS','1674-0068',0.496000,0.001150,0.130650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Phys. J. D','EUROPEAN PHYSICAL JOURNAL D','1434-6060',1.208000,0.010510,1.197620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Liq.','JOURNAL OF MOLECULAR LIQUIDS','0167-7322',2.740000,0.010430,1.189180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Phys. B-At. Mol. Opt. Phys.','JOURNAL OF PHYSICS B-ATOMIC MOLECULAR AND OPTICAL PHYSICS','0953-4075',1.833000,0.020380,2.323140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Phys.','MOLECULAR PHYSICS','0026-8976',1.837000,0.012560,1.431510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Instrum. Methods Phys. Res. Sect. B-Beam Interact. Mater. Atoms','NUCLEAR INSTRUMENTS & METHODS IN PHYSICS RESEARCH SECTION B-BEAM INTERACTIONS WITH MATERIALS AND ATOMS','0168-583X',1.389000,0.022730,2.591270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Cir. Bras.','Acta Cirurgica Brasileira','0102-8650',0.580000,0.001680,0.191430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Surg.','AMERICAN JOURNAL OF SURGERY','0002-9610',2.403000,0.021570,2.458090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Surg. Pathol.','AMERICAN JOURNAL OF SURGICAL PATHOLOGY','0147-5185',4.951000,0.026090,2.973230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Plast. Surg.','ANNALS OF PLASTIC SURGERY','0148-7043',1.535000,0.011390,1.297800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. R. Coll. Surg. Engl.','ANNALS OF THE ROYAL COLLEGE OF SURGEONS OF ENGLAND','0035-8843',1.332000,0.004680,0.533610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Thorac. Surg.','ANNALS OF THORACIC SURGERY','0003-4975',3.021000,0.053490,6.097080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Transpl.','Annals of Transplantation','1425-9524',1.032000,0.001710,0.195000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arthroscopy','ARTHROSCOPY-THE JOURNAL OF ARTHROSCOPIC AND RELATED SURGERY','0749-8063',3.724000,0.020510,2.337860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Surg.','BMC Surgery','1471-2482',1.469000,0.003120,0.356040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Burns','BURNS','0305-4179',1.904000,0.007050,0.803560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Surg.','CANADIAN JOURNAL OF SURGERY','0008-428X',1.546000,0.003360,0.383170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Neurol. Neurosurg.','CLINICAL NEUROLOGY AND NEUROSURGERY','0303-8467',1.198000,0.009800,1.116740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Transplant.','CLINICAL TRANSPLANTATION','0902-0063',1.844000,0.009270,1.056340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dig. Endosc.','Digestive Endoscopy','0915-5635',2.715000,0.004920,0.560990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dig. Surg.','DIGESTIVE SURGERY','0253-4886',1.728000,0.003030,0.345750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endoscopy','ENDOSCOPY','0013-726X',5.634000,0.017980,2.049820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Surg.','European Surgery-Acta Chirurgica Austriaca','1682-8631',0.533000,0.000280,0.031620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Behav. Nutr. Phys. Act.','International Journal of Behavioral Nutrition and Physical Activity','1479-5868',3.993000,0.018630,2.123910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nutr. Biochem.','JOURNAL OF NUTRITIONAL BIOCHEMISTRY','0955-2863',4.668000,0.014730,1.678380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutr. Clin. Metab.','Nutrition Clinique et Metabolisme','0985-0562',0.398000,0.000080,0.008620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutr. Diet.','Nutrition & Dietetics','1446-6368',0.899000,0.000920,0.104370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Nutr.','Revista de Nutricao-Brazilian Journal of Nutrition','1415-5273',0.446000,0.000470,0.053720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Beast Cancer','Breast Cancer','1340-6868',1.182000,0.001910,0.217770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Obstet. Gynecol. Reprod. Biol.','European Journal of Obstetrics & Gynecology and Reproductive Biology','0301-2115',1.662000,0.014980,1.706930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gynecol. Endocrinol.','GYNECOLOGICAL ENDOCRINOLOGY','0951-3590',1.413000,0.006010,0.685480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solid State Nucl. Magn. Reson.','SOLID STATE NUCLEAR MAGNETIC RESONANCE','0926-2040',2.250000,0.001670,0.189890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Theor. Phys.','INTERNATIONAL JOURNAL OF THEORETICAL PHYSICS','0020-7748',1.041000,0.005670,0.646450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Korean Phys. Soc.','JOURNAL OF THE KOREAN PHYSICAL SOCIETY','0374-4884',0.445000,0.007990,0.910210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Results Phys.','Results in Physics','2211-3797',1.337000,0.000520,0.059170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wave Motion','WAVE MOTION','0165-2125',1.449000,0.003170,0.360810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Facial Plast. Surg. Clin. N. Am.','Facial Plastic Surgery Clinics of North America','1064-7406',0.614000,0.000960,0.109260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Card. Surg.','JOURNAL OF CARDIAC SURGERY','0886-0440',0.783000,0.003540,0.403760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cranio-MaxilloFac. Surg.','JOURNAL OF CRANIO-MAXILLOFACIAL SURGERY','1010-5182',1.592000,0.006860,0.782160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Endovascular Ther.','JOURNAL OF ENDOVASCULAR THERAPY','1526-6028',3.128000,0.006840,0.779930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hand Surg.-Eur. Vol.','Journal of Hand Surgery-European Volume','1753-1934',1.868000,0.004180,0.476240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hand Ther.','Journal of Hand Therapy','0894-1130',1.770000,0.001520,0.173150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hepato-Biliary-Pancreat. Sci.','Journal of Hepato-Biliary-Pancreatic Sciences','1868-6974',3.146000,0.006840,0.779950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Laparoendosc. Adv. Surg. Tech.','Journal of Laparoendoscopic & Advanced Surgical Techniques','1092-6429',1.297000,0.005410,0.616880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neurosurg. Anesthesiol.','JOURNAL OF NEUROSURGICAL ANESTHESIOLOGY','0898-4921',2.828000,0.001860,0.211860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr. Surg.','JOURNAL OF PEDIATRIC SURGERY','0022-3468',1.733000,0.017410,1.983840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Obstet. Gynaecol. Res.','JOURNAL OF OBSTETRICS AND GYNAECOLOGY RESEARCH','1341-8076',1.091000,0.006210,0.708000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Perinat. Med.','JOURNAL OF PERINATAL MEDICINE','0300-5577',1.798000,0.004410,0.502080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Obstet. Gynecol.','OBSTETRICS AND GYNECOLOGY','0029-7844',5.656000,0.052410,5.973930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Obstet. Gynecol. Surv.','OBSTETRICAL & GYNECOLOGICAL SURVEY','0029-7828',1.718000,0.002360,0.269190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Paediatr. Perinat. Epidemiol.','PAEDIATRIC AND PERINATAL EPIDEMIOLOGY','0269-5022',2.958000,0.006270,0.714710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. Meteorol. Oceanogr. J.','Australian Meteorological and Oceanographic Journal','1836-716X',1.742000,0.001180,0.134510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mar. Res.','JOURNAL OF MARINE RESEARCH','0022-2402',1.189000,0.001820,0.207150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Condens. Matter Phys.','Advances in Condensed Matter Physics','1687-8108',0.932000,0.001320,0.150310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Vapor Depos.','CHEMICAL VAPOR DEPOSITION','0948-1907',1.789000,0.001460,0.166290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Crit. Rev. Solid State Mat. Sci.','CRITICAL REVIEWS IN SOLID STATE AND MATERIALS SCIENCES','1040-8436',5.556000,0.001490,0.169570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Magn.','Journal of Magnetics','1226-1750',0.421000,0.000490,0.055730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Magn. Magn. Mater.','JOURNAL OF MAGNETISM AND MAGNETIC MATERIALS','0304-8853',2.357000,0.024700,2.814860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mech. Phys. Solids','JOURNAL OF THE MECHANICS AND PHYSICS OF SOLIDS','0022-5096',3.875000,0.020230,2.306190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Rev. B','PHYSICAL REVIEW B','2469-9950',3.718000,0.509510,58.074470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiat. Eff. Defects Solids','Radiation Effects and Defects in Solids','1042-0150',0.472000,0.000950,0.108200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solid State Sci.','SOLID STATE SCIENCES','1293-2558',2.041000,0.008810,1.004560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Thin Solid Films','THIN SOLID FILMS','0040-6090',1.761000,0.046110,5.255660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Physiol.-Gastroint. Liver Physiol.','AMERICAN JOURNAL OF PHYSIOLOGY-GASTROINTESTINAL AND LIVER PHYSIOLOGY','0193-1857',3.297000,0.021590,2.460840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lasers Med. Sci.','LASERS IN MEDICAL SCIENCE','0268-8921',2.461000,0.007020,0.800680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microsurgery','MICROSURGERY','0738-1085',2.054000,0.003960,0.450870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Minerva Chir.','MINERVA CHIRURGICA','0026-4733',0.877000,0.000770,0.088260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Minim. Invasive Ther. Allied Technol.','MINIMALLY INVASIVE THERAPY & ALLIED TECHNOLOGIES','1364-5706',1.279000,0.001450,0.165260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurosurg. Focus','Neurosurgical Focus','1092-0684',2.546000,0.011230,1.280020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oper. Tech. Sports Med.','OPERATIVE TECHNIQUES IN SPORTS MEDICINE','1060-1872',0.365000,0.000340,0.038360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Otolaryngol. Head Neck Surg.','OTOLARYNGOLOGY-HEAD AND NECK SURGERY','0194-5998',2.021000,0.017820,2.030630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Vasc. Surg.','Seminars in Vascular Surgery','0895-7967',0.620000,0.001340,0.152180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stereotact. Funct. Neurosurg.','STEREOTACTIC AND FUNCTIONAL NEUROSURGERY','1011-6125',1.691000,0.002130,0.242800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Comput. Electromagn. Soc. J.','APPLIED COMPUTATIONAL ELECTROMAGNETICS SOCIETY JOURNAL','1054-4887',0.389000,0.000860,0.098560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Commun.','COMPUTER COMMUNICATIONS','0140-3664',2.099000,0.007990,0.910840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electron. World','ELECTRONICS WORLD','1365-4675',0.027000,0.000020,0.001970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Ecol.-Prog. Ser.','MARINE ECOLOGY PROGRESS SERIES','0171-8630',2.361000,0.038920,4.435830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Technol. Soc. J.','MARINE TECHNOLOGY SOCIETY JOURNAL','0025-3324',0.590000,0.001070,0.121670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oceanol. Hydrobiol. Stud.','OCEANOLOGICAL AND HYDROBIOLOGICAL STUDIES','1730-413X',0.519000,0.000660,0.075300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oceanologia','OCEANOLOGIA','0078-3234',0.935000,0.001000,0.113930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Oceanogr.','PROGRESS IN OCEANOGRAPHY','0079-6611',3.512000,0.011690,1.332650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geocarto Int.','Geocarto International','1010-6049',1.380000,0.000980,0.112190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Appl. Earth Obs. Geoinf.','International Journal of Applied Earth Observation and Geoinformation','0303-2434',3.798000,0.009090,1.036200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ISPRS Int. Geo-Inf.','ISPRS International Journal of Geo-Information','2220-9964',0.651000,0.000450,0.051780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Exp. Optom.','Clinical and Experimental Optometry','0816-4622',1.280000,0.002300,0.261890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Ophthalmol.','INTERNATIONAL OPHTHALMOLOGY','0165-5701',0.959000,0.002560,0.291370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Physiol.','CHINESE JOURNAL OF PHYSIOLOGY','0304-4920',0.962000,0.000730,0.083500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Physiol. Funct. Imaging','CLINICAL PHYSIOLOGY AND FUNCTIONAL IMAGING','1475-0961',1.869000,0.002640,0.300740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Psychophysiol.','INTERNATIONAL JOURNAL OF PSYCHOPHYSIOLOGY','0167-8760',2.596000,0.010190,1.160930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comp. Physiol. A -Neuroethol. Sens. Neural Behav. Physiol.','JOURNAL OF COMPARATIVE PHYSIOLOGY A-NEUROETHOLOGY SENSORY NEURAL AND BEHAVIORAL PHYSIOLOGY','0340-7594',1.988000,0.004890,0.556820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vasc. Res.','JOURNAL OF VASCULAR RESEARCH','1018-1172',2.186000,0.002630,0.299280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physiol. Meas.','PHYSIOLOGICAL MEASUREMENT','0967-3334',1.576000,0.005600,0.638770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physiol. Res.','PHYSIOLOGICAL RESEARCH','0862-8408',1.643000,0.004070,0.463840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physiol. Rev.','PHYSIOLOGICAL REVIEWS','0031-9333',30.924000,0.035500,4.046750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Respir. Physiol. Neuro.','RESPIRATORY PHYSIOLOGY & NEUROBIOLOGY','1569-9048',1.773000,0.009550,1.088620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Phys. G-Nucl. Part. Phys.','JOURNAL OF PHYSICS G-NUCLEAR AND PARTICLE PHYSICS','0954-3899',2.448000,0.014370,1.638390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Microw. Mag.','IEEE MICROWAVE MAGAZINE','1527-3342',1.975000,0.004400,0.501610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Syst. J.','IEEE Systems Journal','1932-8184',2.114000,0.004440,0.506170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Electromagn. Compat.','IEEE TRANSACTIONS ON ELECTROMAGNETIC COMPATIBILITY','0018-9375',1.146000,0.005340,0.608350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IETE Tech. Rev.','IETE TECHNICAL REVIEW','0256-4602',1.304000,0.000720,0.082080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mobile Netw. Appl.','MOBILE NETWORKS & APPLICATIONS','1383-469X',1.538000,0.002520,0.287310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Opt. Switch. Netw.','Optical Switching and Networking','1573-4277',1.137000,0.000900,0.103090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radio Sci.','RADIO SCIENCE','0048-6604',1.273000,0.004510,0.514380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Telecommun. Policy','TELECOMMUNICATIONS POLICY','0308-5961',0.982000,0.001880,0.214350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Pharmacol. Toxicol.','Annual Review of Pharmacology and Toxicology','0362-1642',14.769000,0.010870,1.239120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Refractive Surg.','JOURNAL OF REFRACTIVE SURGERY','1081-597X',3.314000,0.009040,1.030190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vision','JOURNAL OF VISION','1534-7362',2.341000,0.021310,2.428990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Jpn. J. Ophthalmol.','JAPANESE JOURNAL OF OPHTHALMOLOGY','0021-5155',1.510000,0.003190,0.363370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ophthalmic Genet.','OPHTHALMIC GENETICS','1381-6810',1.886000,0.001910,0.217540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ophthalmic Res.','OPHTHALMIC RESEARCH','0030-3747',1.344000,0.001930,0.219990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ophthalmology','OPHTHALMOLOGY','0161-6420',6.750000,0.059270,6.755880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Displays','DISPLAYS','0141-9382',1.903000,0.001160,0.131850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Phys. J. D','EUROPEAN PHYSICAL JOURNAL D','1434-6060',1.208000,0.010510,1.197620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Laser Micro Nanoeng.','Journal of Laser Micro Nanoengineering','1880-0688',0.759000,0.000850,0.096490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Opt. Commun. Netw.','Journal of Optical Communications and Networking','1943-0620',2.183000,0.005270,0.600190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Opt. Soc. Am. A-Opt. Image Sci. Vis.','JOURNAL OF THE OPTICAL SOCIETY OF AMERICA A-OPTICS IMAGE SCIENCE AND VISION','1084-7529',1.457000,0.012610,1.436870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plasma  Phys. Control. Fusion','PLASMA PHYSICS AND CONTROLLED FUSION','0741-3335',2.404000,0.015310,1.744610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chaos Solitons Fractals','CHAOS SOLITONS & FRACTALS','0960-0779',1.611000,0.004270,0.486890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Math. Phys.','COMMUNICATIONS IN MATHEMATICAL PHYSICS','0010-3616',2.375000,0.039670,4.521540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Phys.','JOURNAL OF COMPUTATIONAL PHYSICS','0021-9991',2.556000,0.054390,6.199370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hyberbolic Differ. Equ.','Journal of Hyperbolic Differential Equations','0219-8916',0.556000,0.001440,0.163670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Rev. E','PHYSICAL REVIEW E','2470-0045',2.252000,0.152320,17.361220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Quantum Inf. Process.','Quantum Information Processing','1570-0755',1.840000,0.004100,0.467400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Drug Chem. Toxicol.','DRUG AND CHEMICAL TOXICOLOGY','0148-0545',1.653000,0.001400,0.159740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fluoride','FLUORIDE','0015-4725',0.797000,0.000230,0.026210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Toxicol. Env. Health Part A','JOURNAL OF TOXICOLOGY AND ENVIRONMENTAL HEALTH-PART A-CURRENT ISSUES','1528-7394',2.243000,0.004530,0.516710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Environ. Contam. Toxicol.','Reviews of Environmental Contamination and Toxicology','0179-5953',2.446000,0.001950,0.222180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Toxicol. Appl. Pharmacol.','TOXICOLOGY AND APPLIED PHARMACOLOGY','0041-008X',3.847000,0.023870,2.720310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asaio J.','ASAIO JOURNAL','1058-2916',2.291000,0.005130,0.585040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microelectron. Eng.','MICROELECTRONIC ENGINEERING','0167-9317',1.277000,0.012820,1.461670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Opt. Express','OPTICS EXPRESS','1094-4087',3.148000,0.229370,26.144070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Opt. Quantum Electron.','OPTICAL AND QUANTUM ELECTRONICS','0306-8919',1.290000,0.001830,0.208430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Opt. Switch. Netw.','Optical Switching and Networking','1573-4277',1.137000,0.000900,0.103090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Optica','Optica','2334-2536',5.205000,0.003070,0.349780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Optik','OPTIK','0030-4026',0.742000,0.008240,0.939670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Opto-Electron. Rev.','OPTO-ELECTRONICS REVIEW','1230-3402',1.611000,0.001310,0.148770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Rev. A','PHYSICAL REVIEW A','2469-9926',2.765000,0.187090,21.324580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ukr. J. Phys. Opt.','Ukrainian Journal of Physical Optics','1609-1833',0.783000,0.000260,0.029870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Musculoskelet. Disord.','BMC MUSCULOSKELETAL DISORDERS','1471-2474',1.684000,0.019590,2.233050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Connect. Tissue Res.','CONNECTIVE TISSUE RESEARCH','0300-8207',1.411000,0.002280,0.259870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gait Posture','GAIT & POSTURE','0966-6362',2.286000,0.016400,1.869570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Express Polym. Lett.','Express Polymer Letters','1788-618X',2.965000,0.004600,0.524320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Iran. Polym. J.','IRANIAN POLYMER JOURNAL','1026-1265',1.684000,0.002110,0.240620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomater. Sci.-Polym. Ed.','JOURNAL OF BIOMATERIALS SCIENCE-POLYMER EDITION','0920-5063',1.733000,0.003690,0.420880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Kobunshi Ronbunshu','KOBUNSHI RONBUNSHU','0386-2186',0.257000,0.000260,0.029320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nihon Reoroji Gakkaishi','NIHON REOROJI GAKKAISHI','0387-1533',0.282000,0.000200,0.023240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plast. Rubber Compos.','PLASTICS RUBBER AND COMPOSITES','1465-8011',0.570000,0.000580,0.066450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polym. Polym. Compos.','POLYMERS & POLYMER COMPOSITES','0967-3911',0.256000,0.000450,0.051030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polym. Rev.','Polymer Reviews','1558-3724',6.216000,0.002370,0.270080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polymers','Polymers','2073-4360',2.944000,0.006260,0.713030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACS Macro Lett.','ACS Macro Letters','2161-1653',5.766000,0.020260,2.309780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Organ Transpl.','Current Opinion in Organ Transplantation','1087-2418',2.680000,0.006090,0.694610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Liver Transplant.','LIVER TRANSPLANTATION','1527-6465',3.951000,0.016000,1.824160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transplant. Proc.','TRANSPLANTATION PROCEEDINGS','0041-1345',0.867000,0.016660,1.898830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transplant. Rev.','Transplantation Reviews','0955-470X',3.915000,0.002170,0.247220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Automot. Technol.','INTERNATIONAL JOURNAL OF AUTOMOTIVE TECHNOLOGY','1229-9138',0.876000,0.001890,0.215750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Mech. Eng. Part D-J. Automob. Eng.','PROCEEDINGS OF THE INSTITUTION OF MECHANICAL ENGINEERS PART D-JOURNAL OF AUTOMOBILE ENGINEERING','0954-4070',0.802000,0.002270,0.259000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transp. Lett.','Transportation Letters-The International Journal of Transportation Research','1942-7867',0.405000,0.000310,0.035180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Trop. Med. Hyg.','AMERICAN JOURNAL OF TROPICAL MEDICINE AND HYGIENE','0002-9637',2.453000,0.028930,3.297990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asian Pac. J. Trop. Med.','Asian Pacific Journal of Tropical Medicine','1995-7645',0.841000,0.003210,0.366070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Trop. Pediatr.','JOURNAL OF TROPICAL PEDIATRICS','0142-6338',1.059000,0.003030,0.345540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aging Male','Aging Male','1368-5538',1.493000,0.001080,0.123670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aktuelle Urol.','AKTUELLE UROLOGIE','0001-7868',0.215000,0.000150,0.016610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Kidney Dis.','AMERICAN JOURNAL OF KIDNEY DISEASES','0272-6386',6.269000,0.033530,3.821670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Orthop.','INTERNATIONAL ORTHOPAEDICS','0341-2695',2.387000,0.016650,1.898040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Acad. Orthop. Surg.','JOURNAL OF THE AMERICAN ACADEMY OF ORTHOPAEDIC SURGEONS','1067-151X',3.055000,0.008300,0.945950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Orthop. Sports Phys. Ther.','JOURNAL OF ORTHOPAEDIC & SPORTS PHYSICAL THERAPY','0190-6011',2.551000,0.007400,0.842980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Orthop. Trauma','JOURNAL OF ORTHOPAEDIC TRAUMA','0890-5339',1.840000,0.010370,1.181810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Spinal Disord. Tech.','JOURNAL OF SPINAL DISORDERS & TECHNIQUES','1536-0652',2.291000,0.007360,0.838900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Osteoarthritis Cartilage','OSTEOARTHRITIS AND CARTILAGE','1063-4584',4.535000,0.026120,2.977210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Z. Orthop. Unfallchir.','Zeitschrift fur Orthopadie und Unfallchirurgie','1864-6697',0.510000,0.000820,0.093820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Otolaryngol.','CLINICAL OTOLARYNGOLOGY','1749-4478',2.627000,0.002710,0.308920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ear Hear.','EAR AND HEARING','0196-0202',2.517000,0.007740,0.882310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Voice','JOURNAL OF VOICE','0892-1997',1.113000,0.004360,0.496600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Laryngo-Rhino-Otol.','LARYNGO-RHINO-OTOLOGIE','0935-8943',0.572000,0.000530,0.059870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Logop. Phoniatr. Vocology.','Logopedics Phoniatrics Vocology','1401-5439',0.750000,0.000760,0.086330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sen-I Gakkaishi','SEN-I GAKKAISHI','0037-9875',0.176000,0.000130,0.014730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anadolu Psikiyatr. Derg.','Anadolu Psikiyatri Dergisi-Anatolian Journal of Psychiatry','1302-6631',0.234000,0.000200,0.023350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. J. Psychiatry','BRITISH JOURNAL OF PSYCHIATRY','0007-1250',7.060000,0.025040,2.853520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Psychiatr.','CURRENT OPINION IN PSYCHIATRY','0951-7367',3.789000,0.006870,0.783510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Psychiatry Rep.','Current Psychiatry Reports','1523-3812',2.858000,0.007160,0.816450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eat. Weight Disord.-Stud. Anorex.','Eating and Weight Disorders-Studies on Anorexia Bulimia and Obesity','1124-4909',1.254000,0.001330,0.151630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Psychogeriatr.','INTERNATIONAL PSYCHOGERIATRICS','1041-6102',2.220000,0.010100,1.151610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Exp. Nephrol.','Clinical and Experimental Nephrology','1342-1751',1.945000,0.004550,0.518630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CUAJ-Can. Urol. Assoc. J.','CUAJ-Canadian Urological Association Journal','1911-6470',0.866000,0.003390,0.386130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Soc. Nephrol.','JOURNAL OF THE AMERICAN SOCIETY OF NEPHROLOGY','1046-6673',8.491000,0.056530,6.443700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Endourol.','JOURNAL OF ENDOUROLOGY','0892-7790',2.107000,0.011890,1.355490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Minerva Urol. Nefrol.','Minerva Urologica E Nefrologica','0393-2249',0.536000,0.000420,0.047390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nephron Physiol.','NEPHRON PHYSIOLOGY','1660-2137',1.562000,0.000530,0.060170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ren. Fail.','RENAL FAILURE','0886-022X',0.875000,0.004550,0.518180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anim. Health Res. Rev.','ANIMAL HEALTH RESEARCH REVIEWS','1466-2523',1.500000,0.001270,0.145320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anthrozoos','ANTHROZOOS','0892-7936',0.725000,0.000900,0.102070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Facies','FACIES','0172-9179',1.690000,0.001680,0.190990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geodiversitas','GEODIVERSITAS','1280-9659',0.844000,0.001210,0.137860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Paleopathol.','International Journal of Paleopathology','1879-9817',0.788000,0.000500,0.057450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neues. Jahrb. Geol. Palaontol.-Abh.','NEUES JAHRBUCH FUR GEOLOGIE UND PALAONTOLOGIE-ABHANDLUNGEN','0077-7749',0.719000,0.001650,0.188530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Geol. Assoc.','PROCEEDINGS OF THE GEOLOGISTS ASSOCIATION','0016-7878',1.844000,0.001460,0.165960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Paleobiology','PALEOBIOLOGY','0094-8373',2.959000,0.003690,0.420740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Bras. Paleontol.','REVISTA BRASILEIRA DE PALEONTOLOGIA','1519-7530',0.625000,0.000500,0.056940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv.Parasitol.','Advances in Parasitology','0065-308X',4.829000,0.002800,0.319530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Arthropod.-Borne Dis.','Journal of Arthropod-Borne Diseases','2322-1984',0.865000,0.000230,0.026440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Malar. J.','MALARIA JOURNAL','1475-2875',3.079000,0.031030,3.537210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Issues Ment. Health Nurs.','Issues in Mental Health Nursing','0161-2840',0.990000,0.002610,0.297210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Atten. Disord.','Journal of Attention Disorders','1087-0547',3.384000,0.005190,0.591110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Psychopharmacol.','JOURNAL OF PSYCHOPHARMACOLOGY','0269-8811',3.637000,0.012340,1.406290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Psychiatr.','MOLECULAR PSYCHIATRY','1359-4184',13.314000,0.044400,5.060370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nervenarzt','NERVENARZT','0028-2804',0.806000,0.001550,0.176100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Perspect. Psychiatr. Care','PERSPECTIVES IN PSYCHIATRIC CARE','0031-5990',1.000000,0.000710,0.080880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacopsychiatry','PHARMACOPSYCHIATRY','0176-3679',1.474000,0.002010,0.228630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stress Health','STRESS AND HEALTH','1532-3005',1.926000,0.002360,0.268850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('World J. Biol. Psychiatry','WORLD JOURNAL OF BIOLOGICAL PSYCHIATRY','1562-2975',4.159000,0.005680,0.646940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ILAR J.','ILAR JOURNAL','1084-2020',2.077000,0.002680,0.305370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Irish Vet. J.','IRISH VETERINARY JOURNAL','0368-0762',0.824000,0.000570,0.064810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Med. Entomol.','JOURNAL OF MEDICAL ENTOMOLOGY','0022-2585',1.712000,0.007020,0.800530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Swine. Health Prod.','JOURNAL OF SWINE HEALTH AND PRODUCTION','1537-209X',1.277000,0.000540,0.061820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lab. Anim.','LABORATORY ANIMALS','0023-6772',1.553000,0.001700,0.193880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lab Anim.','LAB ANIMAL','0093-7355',0.681000,0.000620,0.071000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Vet. Entomol.','MEDICAL AND VETERINARY ENTOMOLOGY','0269-283X',2.242000,0.003410,0.388620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pesqui. Vet. Bras.','PESQUISA VETERINARIA BRASILEIRA','0100-736X',0.335000,0.001840,0.209260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pathog. Glob. Health','Pathogens and Global Health','2047-7724',1.486000,0.001860,0.211840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Syst. Parasitol.','SYSTEMATIC PARASITOLOGY','0165-5752',1.316000,0.001560,0.177950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiovasc. Pathol.','CARDIOVASCULAR PATHOLOGY','1054-8807',2.190000,0.003190,0.364120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cytom. Part B-Clin. Cytom.','CYTOMETRY PART B-CLINICAL CYTOMETRY','1552-4949',2.822000,0.002400,0.273320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dis. Model. Mech.','Disease Models & Mechanisms','1754-8403',4.316000,0.014490,1.651110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Exp. Pathol.','INTERNATIONAL JOURNAL OF EXPERIMENTAL PATHOLOGY','0959-9673',2.125000,0.002450,0.279170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Gynecol. Pathol.','INTERNATIONAL JOURNAL OF GYNECOLOGICAL PATHOLOGY','0277-1691',1.437000,0.002850,0.325180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Surg. Pathol.','INTERNATIONAL JOURNAL OF SURGICAL PATHOLOGY','1066-8969',0.782000,0.002270,0.258630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Toxicol. Pathol.','Journal of Toxicologic Pathology','0914-9198',0.848000,0.000530,0.060750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dev. Neuropsychol.','DEVELOPMENTAL NEUROPSYCHOLOGY','8756-5641',1.947000,0.003750,0.427340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geriatr. Psychol. Neuropsychiat. Vieil.','Geriatrie et Psychologie Neuropsychiatrie de Vieillissement','2115-8789',0.417000,0.000250,0.029030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sport Exerc. Psychol.','JOURNAL OF SPORT & EXERCISE PSYCHOLOGY','0895-2779',2.379000,0.003240,0.369630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Stud. Alcohol Drugs','Journal of Studies on Alcohol and Drugs','1937-1888',2.197000,0.007950,0.905890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychol. Psychother.-Theory Res. Pract.','PSYCHOLOGY AND PSYCHOTHERAPY-THEORY RESEARCH AND PRACTICE','1476-0835',1.661000,0.001620,0.184560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Argent. Clin. Psicol.','Revista Argentina de Clinica Psicologica','0327-6716',0.280000,0.000090,0.010700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Soc. Cogn. Affect. Neurosci.','Social Cognitive and Affective Neuroscience','1749-5016',5.101000,0.018340,2.090140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trav. Hum.','TRAVAIL HUMAIN','0041-1868',0.300000,0.000130,0.014500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Radiol.','ACTA RADIOLOGICA','0284-1851',2.009000,0.007000,0.797860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Nucl. Med.','ANNALS OF NUCLEAR MEDICINE','0914-7187',1.467000,0.003710,0.422990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomed. Opt. Express','Biomedical Optics Express','2156-7085',3.344000,0.019490,2.221740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brachytherapy','Brachytherapy','1538-4721',2.088000,0.002790,0.317780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trop. Anim. Health Prod.','TROPICAL ANIMAL HEALTH AND PRODUCTION','0049-4747',0.870000,0.005060,0.577150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vet. Dermatol.','VETERINARY DERMATOLOGY','0959-4493',1.568000,0.002200,0.250320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Zoonoses Public Health','Zoonoses and Public Health','1863-1959',2.574000,0.004630,0.527650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Blood Pressure','BLOOD PRESSURE','0803-7051',2.010000,0.001920,0.218420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Hypertens. Rep.','CURRENT HYPERTENSION REPORTS','1522-6417',3.112000,0.005690,0.647990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Nephrol. Hypertens.','CURRENT OPINION IN NEPHROLOGY AND HYPERTENSION','1062-4821',3.232000,0.007510,0.855920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Vasc. Endovasc. Surg.','EUROPEAN JOURNAL OF VASCULAR AND ENDOVASCULAR SURGERY','1078-5884',2.912000,0.015210,1.733180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hypertens. Res.','HYPERTENSION RESEARCH','0916-9636',3.208000,0.008410,0.958510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Stroke','International Journal of Stroke','1747-4930',3.044000,0.011320,1.290720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('An. Pediatr.','ANALES DE PEDIATRIA','1695-4033',0.773000,0.000960,0.109910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Child Adolesc. Ment. Health','Child and Adolescent Mental Health','1475-357X',1.405000,0.001220,0.138930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Pediatr.','CLINICAL PEDIATRICS','0009-9228',0.954000,0.005060,0.576820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dev. Med. Child Neurol.','DEVELOPMENTAL MEDICINE AND CHILD NEUROLOGY','0012-1622',3.615000,0.016260,1.853040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Pediatr.','INDIAN JOURNAL OF PEDIATRICS','0019-5456',0.808000,0.003600,0.410650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Dev. Behav. Pediatr.','JOURNAL OF DEVELOPMENTAL AND BEHAVIORAL PEDIATRICS','0196-206X',2.323000,0.005680,0.647030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hum. Lact.','JOURNAL OF HUMAN LACTATION','0890-3344',2.233000,0.001960,0.223730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr Adolesc. Gynecol.','Journal of Pediatric and Adolescent Gynecology','1083-3188',1.605000,0.002890,0.328980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr. Surg.','JOURNAL OF PEDIATRIC SURGERY','0022-3468',1.733000,0.017410,1.983840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JAMA Pediatr.','JAMA Pediatrics','2168-6203',9.528000,0.015660,1.785070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. J. Radiol.','BRITISH JOURNAL OF RADIOLOGY','0007-1285',1.840000,0.011550,1.316270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. Assoc. Radiol. J.-J. Assoc. Can. Radiol.','CANADIAN ASSOCIATION OF RADIOLOGISTS JOURNAL-JOURNAL DE L ASSOCIATION CANADIENNE DES RADIOLOGISTES','0846-5371',1.082000,0.000870,0.098850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Diagn. Interv. Radiol.','Diagnostic and Interventional Radiology','1305-3825',1.406000,0.002510,0.286380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Digit. Imaging','JOURNAL OF DIGITAL IMAGING','0897-1889',1.406000,0.002460,0.279980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Radiat. Res.','JOURNAL OF RADIATION RESEARCH','0449-3060',1.536000,0.004470,0.509230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JBR-BTR','JBR-BTR','1780-2393',0.354000,0.000490,0.055490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Magn. Reson. Med.','MAGNETIC RESONANCE IN MEDICINE','0740-3194',3.782000,0.038740,4.415230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Thromb. Thrombolysis','JOURNAL OF THROMBOSIS AND THROMBOLYSIS','0929-5305',1.884000,0.005730,0.653160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vasa','Vasa-European Journal of Vascular Medicine','0301-1526',1.122000,0.001300,0.147730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annual Review of Virology','2327-056X','3.345',0.000560,0.063310,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Virol.','ARCHIVES OF VIROLOGY','0304-8608',2.255000,0.014840,1.691680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Intervirology','INTERVIROLOGY','0300-5526',1.822000,0.001990,0.227000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Med. Virol.','REVIEWS IN MEDICAL VIROLOGY','1052-9276',4.308000,0.003300,0.376590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Virology','VIROLOGY','0042-6822',3.200000,0.031860,3.631330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. Malacol. Bull.','AMERICAN MALACOLOGICAL BULLETIN','0740-2783',1.049000,0.000620,0.070550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Paediatr. Child Health','Paediatrics & Child Health','1205-7088',1.509000,0.002070,0.235960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Allergy Immunol.','PEDIATRIC ALLERGY AND IMMUNOLOGY','0905-6157',3.947000,0.007990,0.910690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Blood Cancer','PEDIATRIC BLOOD & CANCER','1545-5009',2.634000,0.026070,2.970900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Dent.','PEDIATRIC DENTISTRY','0164-1263',0.800000,0.002030,0.231380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Exerc. Sci.','PEDIATRIC EXERCISE SCIENCE','0899-8493',1.495000,0.002070,0.236120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Res.','PEDIATRIC RESEARCH','0031-3998',2.761000,0.015680,1.787180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Pediatr. Neurol.','Seminars in Pediatric Neurology','1071-9091',1.303000,0.001470,0.167360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Turk. J. Pediatr.','TURKISH JOURNAL OF PEDIATRICS','0041-4301',0.484000,0.001650,0.187740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Alcohol','ALCOHOL','0741-8329',2.440000,0.003890,0.443490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Cardiovasc. Drugs','American Journal of Cardiovascular Drugs','1175-3277',2.233000,0.001780,0.202840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rep. Med. Chem.','Annual Reports in Medicinal Chemistry','0065-7743',1.000000,0.000660,0.075420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiat. Prot. Dosim.','RADIATION PROTECTION DOSIMETRY','0144-8420',0.894000,0.007970,0.908100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiologe','RADIOLOGE','0033-832X',0.278000,0.000550,0.062750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Musculoskelet. Radiol.','SEMINARS IN MUSCULOSKELETAL RADIOLOGY','1089-7860',1.141000,0.001210,0.138480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Nucl. Med.','SEMINARS IN NUCLEAR MEDICINE','0001-2998',2.850000,0.003100,0.353770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Ultrasound CT MRI','SEMINARS IN ULTRASOUND CT AND MRI','0887-2171',1.319000,0.001980,0.225140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surg. Radiol. Anat.','SURGICAL AND RADIOLOGIC ANATOMY','0930-1038',1.195000,0.003350,0.381340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ultrasonics','ULTRASONICS','0041-624X',1.954000,0.007000,0.797710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. Occup. Ther. J.','Australian Occupational Therapy Journal','0045-0766',1.404000,0.001480,0.169090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Folia Phoniatr. Logop.','FOLIA PHONIATRICA ET LOGOPAEDICA','1021-7762',0.391000,0.001120,0.127120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Head Trauma Rehabil.','JOURNAL OF HEAD TRAUMA REHABILITATION','0885-9701',3.323000,0.004940,0.562830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Musculoskelet. Pain','JOURNAL OF MUSCULOSKELETAL PAIN','1058-2452',0.269000,0.000290,0.032690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aquat. Mamm.','AQUATIC MAMMALS','0167-5427',0.873000,0.000900,0.102910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Behav. Ecol.','BEHAVIORAL ECOLOGY','1045-2249',3.029000,0.014730,1.679380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chelonian Conserv. Biol.','CHELONIAN CONSERVATION AND BIOLOGY','1071-8443',0.600000,0.000710,0.080690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comp. Biochem. Physiol. A-Mol. Integr. Physiol.','COMPARATIVE BIOCHEMISTRY AND PHYSIOLOGY A-MOLECULAR & INTEGRATIVE PHYSIOLOGY','1095-6433',2.039000,0.008780,1.001260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Folia Primatol.','FOLIA PRIMATOLOGICA','0015-5713',0.778000,0.000500,0.057420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Primatol.','INTERNATIONAL JOURNAL OF PRIMATOLOGY','0164-0291',1.649000,0.003400,0.387290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Exp. Psychol.-Anim. Learn. Cogn.','JOURNAL OF EXPERIMENTAL PSYCHOLOGY-ANIMAL LEARNING AND COGNITION','0097-7403',1.779000,0.001890,0.215390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mamm. Evol.','JOURNAL OF MAMMALIAN EVOLUTION','1064-7554',2.244000,0.001630,0.185800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochem. Pharmacol.','BIOCHEMICAL PHARMACOLOGY','0006-2952',5.091000,0.035010,3.991000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Pharm. Bull.','BIOLOGICAL & PHARMACEUTICAL BULLETIN','0918-6158',1.574000,0.009880,1.126230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomed. Pharmacother.','BIOMEDICINE & PHARMACOTHERAPY','0753-3322',2.326000,0.004080,0.464950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Braz. J. Pharm. Sci.','Brazilian Journal of Pharmaceutical Sciences','1984-8250',0.485000,0.000790,0.090590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiovasc. Ther.','Cardiovascular Therapeutics','1755-5914',2.243000,0.003540,0.403450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Pharmacol. Ther.','CLINICAL PHARMACOLOGY & THERAPEUTICS','0009-9236',7.268000,0.028930,3.297980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Psychopharmacol. Neurosci.','Clinical Psychopharmacology and Neuroscience','1738-1088',1.500000,0.000740,0.083900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Pharm. Anal.','Current Pharmaceutical Analysis','1573-4129',0.885000,0.000320,0.036910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Drugs Today','DRUGS OF TODAY','1699-3993',1.186000,0.001290,0.146710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Occup. Ther. Int.','Occupational Therapy International','0966-7903',0.683000,0.000370,0.041980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Phys. Ther.','Pediatric Physical Therapy','0898-5669',1.101000,0.001470,0.167380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Occup. Ther. Pediatr.','PHYSICAL & OCCUPATIONAL THERAPY IN PEDIATRICS','0194-2638',1.255000,0.001080,0.123120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Ther.','PHYSICAL THERAPY','0031-9023',2.799000,0.011720,1.336150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physiother. Theory Pract.','PHYSIOTHERAPY THEORY AND PRACTICE','0959-3985',1.169000,0.001930,0.219590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Scand. J. Occup. Ther.','Scandinavian Journal of Occupational Therapy','1103-8128',0.957000,0.001130,0.128820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Turk. Fiz. Tip Rehabil. Derg.','Turkiye Fiziksel Tip ve Rehabilitasyon Dergisi-Turkish Journal of Physical Medicine and Rehabilitation','1302-0234',0.094000,0.000140,0.015990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Chronic Obstr. Pulm. Dis.','International Journal of Chronic Obstructive Pulmonary Disease','1178-2005',3.046000,0.004670,0.532280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Respiration','RESPIRATION','0025-7931',2.651000,0.006610,0.753620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Pneumol. Clin.','Revue de Pneumologie Clinique','0761-8417',0.256000,0.000230,0.025820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Port. Pneumol.','Revista Portuguesa de Pneumologia','0873-2159',1.357000,0.000690,0.079190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sarcoidosis Vasc. Diffus. Lung Dis.','SARCOIDOSIS VASCULITIS AND DIFFUSE LUNG DISEASES','1124-0490',1.465000,0.001280,0.145750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sleep Breath.','Sleep and Breathing','1520-9512',2.332000,0.005410,0.617170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mamm. Study','MAMMAL STUDY','1343-4152',0.375000,0.000410,0.046980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mammal Rev.','MAMMAL REVIEW','0305-1838',4.116000,0.002270,0.259150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Molluscan Res.','MOLLUSCAN RESEARCH','1323-5818',0.708000,0.000330,0.037740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neotrop. Ichthyol.','Neotropical Ichthyology','1679-6225',0.917000,0.002440,0.278480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('North-West. J. Zool.','North-Western Journal of Zoology','1584-9074',0.539000,0.000870,0.098810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pak. J. Zool.','PAKISTAN JOURNAL OF ZOOLOGY','0030-9923',0.478000,0.001370,0.156150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rec. Aust. Mus.','RECORDS OF THE AUSTRALIAN MUSEUM','0067-1975',0.714000,0.000230,0.026750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wildlife Biol.','WILDLIFE BIOLOGY','0909-6396',0.968000,0.001560,0.178180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Zool. Sci.','ZOOLOGICAL SCIENCE','0289-0003',0.814000,0.002750,0.313560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Zool. Stud.','ZOOLOGICAL STUDIES','1021-5506',0.885000,0.002140,0.244180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Min. Sci.','JOURNAL OF MINING SCIENCE','1062-7391',0.350000,0.000740,0.084420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Expert Opin. Ther. Targets','EXPERT OPINION ON THERAPEUTIC TARGETS','1472-8222',4.798000,0.009830,1.120150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Immunopathol. Pharmacol.','INTERNATIONAL JOURNAL OF IMMUNOPATHOLOGY AND PHARMACOLOGY','0394-6320',1.470000,0.003470,0.395800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Neuropsychopharmacol.','INTERNATIONAL JOURNAL OF NEUROPSYCHOPHARMACOLOGY','1461-1457',4.333000,0.013780,1.571130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Int. Med. Res.','JOURNAL OF INTERNATIONAL MEDICAL RESEARCH','0300-0605',1.431000,0.006310,0.718650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fertil. Steril.','FERTILITY AND STERILITY','0015-0282',4.426000,0.055850,6.365610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Reprod. Dev.','MOLECULAR REPRODUCTION AND DEVELOPMENT','1040-452X',2.141000,0.004970,0.566350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Reprod. Biol. Endocrinol.','Reproductive Biology and Endocrinology','1477-7827',2.147000,0.007140,0.814330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Reprod. Domest. Anim.','REPRODUCTION IN DOMESTIC ANIMALS','0936-6768',1.210000,0.007170,0.817280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Reprod. Fertil. Dev.','REPRODUCTION FERTILITY AND DEVELOPMENT','1031-3613',2.135000,0.005320,0.606310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Reprod. Toxicol.','REPRODUCTIVE TOXICOLOGY','0890-6238',2.850000,0.008890,1.013460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theriogenology','THERIOGENOLOGY','0093-691X',1.838000,0.013540,1.542750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aktuelle Rheumatol.','AKTUELLE RHEUMATOLOGIE','0341-051X',0.069000,0.000030,0.003230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arthritis Rheumatol.','Arthritis & Rheumatology','2326-5191',6.009000,0.009810,1.118510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Turk. J. Rheumatol.','Turkish Journal of Rheumatology','1309-0291',0.150000,0.000150,0.016790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Agron. Soil Sci.','Archives of Agronomy and Soil Science','0365-0340',1.118000,0.001570,0.178570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arid Land Res. Manag.','ARID LAND RESEARCH AND MANAGEMENT','1532-4982',0.746000,0.000460,0.052280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Desalination','DESALINATION','0011-9164',4.412000,0.038440,4.381280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecohydrology','Ecohydrology','1936-0584',2.138000,0.006090,0.694390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ground Water Monit. Remediat.','GROUND WATER MONITORING AND REMEDIATION','1069-3629',0.848000,0.000820,0.093880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hydrol. Earth Syst. Sci.','HYDROLOGY AND EARTH SYSTEM SCIENCES','1027-5606',3.990000,0.032080,3.656870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Contam. Hydrol.','JOURNAL OF CONTAMINANT HYDROLOGY','0169-7722',2.063000,0.006320,0.720180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Irrig. Drainage Eng-ASCE','JOURNAL OF IRRIGATION AND DRAINAGE ENGINEERING','0733-9437',1.364000,0.003070,0.350110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stoch. Environ. Res. Risk Assess.','STOCHASTIC ENVIRONMENTAL RESEARCH AND RISK ASSESSMENT','1436-3240',2.237000,0.005200,0.592530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('WasserWirtschaft','WasserWirtschaft','0043-0978',0.102000,0.000160,0.017940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Int.','WATER INTERNATIONAL','0250-8060',1.040000,0.001040,0.118270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Qual. Res. J. Canada','WATER QUALITY RESEARCH JOURNAL OF CANADA','1201-3080',0.531000,0.000390,0.044900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Appl. Comp. Fluid Mech.','Engineering Applications of Computational Fluid Mechanics','1994-2060',1.033000,0.001030,0.117520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Comput.','ENGINEERING COMPUTATIONS','0264-4401',0.691000,0.001430,0.162940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Fluid Mech.','ENVIRONMENTAL FLUID MECHANICS','1567-7419',1.394000,0.001990,0.226700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geophys. Astrophys. Fluid Dyn.','GEOPHYSICAL AND ASTROPHYSICAL FLUID DYNAMICS','0309-1929',0.712000,0.001390,0.158530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heat Mass Transf.','HEAT AND MASS TRANSFER','0947-7411',1.044000,0.003670,0.417840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heat Transf. Eng.','HEAT TRANSFER ENGINEERING','0145-7632',1.016000,0.002900,0.330750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('High Temp.-High Press.','HIGH TEMPERATURES-HIGH PRESSURES','0018-1544',0.522000,0.000260,0.029870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Comput. Fluid Dyn.','INTERNATIONAL JOURNAL OF COMPUTATIONAL FLUID DYNAMICS','1061-8562',0.772000,0.000750,0.085760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Impact Eng.','INTERNATIONAL JOURNAL OF IMPACT ENGINEERING','0734-743X',2.646000,0.007450,0.849660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Thermophys.','INTERNATIONAL JOURNAL OF THERMOPHYSICS','0195-928X',0.946000,0.004170,0.474880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Fluids Struct.','JOURNAL OF FLUIDS AND STRUCTURES','0889-9746',1.709000,0.007200,0.820420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Micromech. Microeng.','JOURNAL OF MICROMECHANICS AND MICROENGINEERING','0960-1317',1.768000,0.015300,1.743540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Neurobiol.','CURRENT OPINION IN NEUROBIOLOGY','0959-4388',6.373000,0.035490,4.045650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dev. Cogn. Neurosci.','Developmental Cognitive Neuroscience','1878-9293',3.963000,0.005890,0.671110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Enceph.-Rev. Psychiatr. Clin. Biol. Ther.','ENCEPHALE-REVUE DE PSYCHIATRIE CLINIQUE BIOLOGIQUE ET THERAPEUTIQUE','0013-7006',0.675000,0.001200,0.136530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Pain','EUROPEAN JOURNAL OF PAIN','1090-3801',2.900000,0.011700,1.334060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Neurol.','EUROPEAN NEUROLOGY','0014-3022',1.403000,0.003950,0.449700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Neurosci.','Frontiers in Neuroscience','1662-453X',3.398000,0.021260,2.423210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Invertebr. Neurosci.','INVERTEBRATE NEUROSCIENCE','1354-2516',1.241000,0.000360,0.041250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neuroimmune Pharm.','Journal of Neuroimmune Pharmacology','1557-1890',3.896000,0.005040,0.575020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genes Immun.','GENES AND IMMUNITY','1466-4879',2.472000,0.006030,0.687540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genetics','GENETICS','0016-6731',4.644000,0.052920,6.032370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hereditas','HEREDITAS','0018-0661',1.083000,0.000530,0.060010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heredity','HEREDITY','0018-067X',3.801000,0.013010,1.482840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hum. Biol.','HUMAN BIOLOGY','0018-7143',0.857000,0.001250,0.142680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Genomics','International Journal of Genomics','2314-436X',1.830000,0.000540,0.061620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hum. Genet.','JOURNAL OF HUMAN GENETICS','1434-5161',2.487000,0.007420,0.845360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Cytogenet.','Molecular Cytogenetics','1755-8166',1.506000,0.002070,0.236170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Genet. Metab.','MOLECULAR GENETICS AND METABOLISM','1096-7192',3.093000,0.014350,1.635210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('OMICS','OMICS-A JOURNAL OF INTEGRATIVE BIOLOGY','1536-2310',2.896000,0.003490,0.397540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Limnologica','LIMNOLOGICA','0075-9511',1.403000,0.001700,0.193460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Freshw. Res.','MARINE AND FRESHWATER RESEARCH','1323-1650',1.583000,0.006250,0.712800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Oper. Res.','COMPUTERS & OPERATIONS RESEARCH','0305-0548',1.988000,0.016530,1.883990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Optim. Appl.','COMPUTATIONAL OPTIMIZATION AND APPLICATIONS','0926-6003',1.444000,0.007540,0.859030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Optimiz.','ENGINEERING OPTIMIZATION','0305-215X',1.380000,0.003010,0.342740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ind. Manag. Optim.','Journal of Industrial and Management Optimization','1547-5816',0.776000,0.001430,0.162720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Manuf. Syst.','JOURNAL OF MANUFACTURING SYSTEMS','0278-6125',2.240000,0.002000,0.228480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Optim. Theory Appl.','JOURNAL OF OPTIMIZATION THEORY AND APPLICATIONS','0022-3239',1.160000,0.010200,1.162370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Optim. Eng.','OPTIMIZATION AND ENGINEERING','1389-4420',0.900000,0.001430,0.162900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Optimization','OPTIMIZATION','0233-1934',0.822000,0.003460,0.394330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mech. Adv. Mater. Struct.','MECHANICS OF ADVANCED MATERIALS AND STRUCTURES','1537-6494',1.000000,0.001660,0.189200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microgravity Sci. Technol.','MICROGRAVITY SCIENCE AND TECHNOLOGY','0938-0108',0.725000,0.000950,0.107900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Mech Eng Pt K-J Multi-Body Dyn.','PROCEEDINGS OF THE INSTITUTION OF MECHANICAL ENGINEERS PART K-JOURNAL OF MULTI-BODY DYNAMICS','1464-4193',1.000000,0.000500,0.056560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Shock Waves','SHOCK WAVES','0938-1287',1.009000,0.001960,0.223270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wave Motion','WAVE MOTION','0165-2125',1.449000,0.003170,0.360810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochem. Medica.','Biochemia Medica','1330-0962',3.051000,0.001670,0.190340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. J. Biomed. Sci.','BRITISH JOURNAL OF BIOMEDICAL SCIENCE','0967-4845',1.245000,0.000580,0.066270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Lab. Med.','CLINICS IN LABORATORY MEDICINE','0272-2712',1.690000,0.002230,0.254150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Diagn. Cytopathol.','DIAGNOSTIC CYTOPATHOLOGY','8755-1039',0.980000,0.003090,0.352460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cytol.','Journal of Cytology','0970-9371',0.463000,0.000480,0.054520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Intell. Transp. Syst. Mag.','IEEE Intelligent Transportation Systems Magazine','1939-1390',1.547000,0.000780,0.089200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Pervasive Comput.','IEEE PERVASIVE COMPUTING','1536-1268',1.836000,0.002410,0.274990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Power Energy Mag.','IEEE Power & Energy Magazine','1540-7977',1.451000,0.002840,0.323150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Biomed. Circuits Syst.','IEEE Transactions on Biomedical Circuits and Systems','1932-4545',2.018000,0.006200,0.706680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trns. Dielectr. Electr. Insul.','IEEE TRANSACTIONS ON DIELECTRICS AND ELECTRICAL INSULATION','1070-9878',1.306000,0.006400,0.729910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Fuzzy Syst.','IEEE TRANSACTIONS ON FUZZY SYSTEMS','1063-6706',6.701000,0.013520,1.541440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Nucl. Sci.','IEEE TRANSACTIONS ON NUCLEAR SCIENCE','0018-9499',1.198000,0.016010,1.825240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Russ. J. Genet.','RUSSIAN JOURNAL OF GENETICS','1022-7954',0.448000,0.001260,0.144180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theor. Popul. Biol.','THEORETICAL POPULATION BIOLOGY','0040-5809',1.452000,0.003300,0.375650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trends Ecol. Evol.','TRENDS IN ECOLOGY & EVOLUTION','0169-5347',16.735000,0.048680,5.548510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Earth Surf. Process. Landf.','EARTH SURFACE PROCESSES AND LANDFORMS','0197-9337',3.505000,0.013530,1.541930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ERDE','ERDE','0013-9998',0.541000,0.000290,0.033530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geoinformatica','GEOINFORMATICA','1384-6175',1.061000,0.000870,0.098860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geomorphologie','Geomorphologie-Relief Processus Environnement','1266-5304',0.673000,0.000400,0.045400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Glob. Planet. Change','GLOBAL AND PLANETARY CHANGE','0921-8181',3.548000,0.015310,1.745220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Quat. Res.','QUATERNARY RESEARCH','0033-5894',2.198000,0.007700,0.877940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cretac. Res.','CRETACEOUS RESEARCH','0195-6671',2.196000,0.004600,0.523950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geol. Acta','GEOLOGICA ACTA','1695-6133',1.056000,0.001050,0.119910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Adriat.','ACTA ADRIATICA','0001-5113',0.561000,0.000440,0.049660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Afr. J. Mar. Sci.','AFRICAN JOURNAL OF MARINE SCIENCE','1814-232X',1.058000,0.001530,0.174870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Mar. Sci.','Annual Review of Marine Science','1941-1405',13.214000,0.013880,1.581820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aquat. Bot.','AQUATIC BOTANY','0304-3770',1.846000,0.003380,0.385610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Coral Reefs','CORAL REEFS','0722-4028',3.000000,0.009950,1.134140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Estuaries Coasts','Estuaries and Coasts','1559-2723',2.659000,0.007680,0.875780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Freshw. Sci.','Freshwater Science','2161-9549',2.433000,0.004120,0.469840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inland Waters','Inland Waters','2044-2041',1.776000,0.001400,0.159720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mar. Syst.','JOURNAL OF MARINE SYSTEMS','0924-7963',2.174000,0.009370,1.068510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Shellfish Res.','JOURNAL OF SHELLFISH RESEARCH','0730-8000',0.829000,0.002280,0.260180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Med.','AMERICAN JOURNAL OF MEDICINE','0002-9343',5.610000,0.026800,3.055030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Saudi Med.','ANNALS OF SAUDI MEDICINE','0256-4947',0.311000,0.001710,0.195320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Iran. Med.','Archives of Iranian Medicine','1029-2977',0.931000,0.002400,0.273060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. J. Hosp. Med.','BRITISH JOURNAL OF HOSPITAL MEDICINE','1750-8460',0.298000,0.000890,0.101890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. Med. J.','CHINESE MEDICAL JOURNAL','0366-6999',0.957000,0.014650,1.669240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clinics','Clinics','1807-5932',1.328000,0.006970,0.794570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dtsch. Arztebl. Int.','Deutsches Arzteblatt International','1866-0452',3.738000,0.006810,0.776010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Med. Sci.','International Journal of Medical Sciences','1449-1907',2.232000,0.005760,0.656260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Osteopath. Med.','International Journal of Osteopathic Medicine','1746-0689',0.509000,0.000100,0.011230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Invest. Med.','JOURNAL OF INVESTIGATIVE MEDICINE','1081-5589',2.085000,0.002790,0.318090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pak. Med. Assoc.','JOURNAL OF THE PAKISTAN MEDICAL ASSOCIATION','0030-9982',0.488000,0.002710,0.308990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Postgrad. Med.','Journal of Postgraduate Medicine','0022-3859',0.870000,0.001230,0.139890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Terahertz Sci. Technol.','IEEE Transactions on Terahertz Science and Technology','2156-342X',2.298000,0.005390,0.613940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE-ACM Trans. Audio Speech Lang.','IEEE-ACM Transactions on Audio Speech and Language Processing','2329-9290',1.225000,0.000970,0.110810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEJ Trans. Electr. Electron. Eng.','IEEJ Transactions on Electrical and Electronic Engineering','1931-4973',0.261000,0.000890,0.101260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IET Image Process.','IET Image Processing','1751-9659',0.860000,0.001830,0.208020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Appl. Electromagn. Mech.','INTERNATIONAL JOURNAL OF APPLIED ELECTROMAGNETICS AND MECHANICS','1383-5416',0.724000,0.001200,0.136640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Elec. Eng. Educ.','INTERNATIONAL JOURNAL OF ELECTRICAL ENGINEERING EDUCATION','0020-7209',0.302000,0.000150,0.017290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Optomechatronics','International Journal of Optomechatronics','1559-9612',0.627000,0.000300,0.034500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Softw. Eng. Knowl. Eng.','INTERNATIONAL JOURNAL OF SOFTWARE ENGINEERING AND KNOWLEDGE ENGINEERING','0218-1940',0.240000,0.000470,0.053220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Commun. Technol. Electron.','JOURNAL OF COMMUNICATIONS TECHNOLOGY AND ELECTRONICS','1064-2269',0.331000,0.000880,0.100570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Electron.','Journal of Computational Electronics','1569-8025',1.104000,0.001550,0.176240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Electron. Imaging','JOURNAL OF ELECTRONIC IMAGING','1017-9909',0.616000,0.002750,0.313190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Electron. Packag.','JOURNAL OF ELECTRONIC PACKAGING','1043-7398',1.402000,0.001040,0.118420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geol. Surv. Den. Greenl. Bull.','GEOLOGICAL SURVEY OF DENMARK AND GREENLAND BULLETIN','1604-8156',0.698000,0.000480,0.054920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Geol.','JOURNAL OF GEOLOGY','0022-1376',2.580000,0.002820,0.321150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('N. Z. J. Geol. Geophys.','NEW ZEALAND JOURNAL OF GEOLOGY AND GEOPHYSICS','0028-8306',1.164000,0.001060,0.120420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stratigraphy','Stratigraphy','1547-139X',0.828000,0.000600,0.068490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('AAPG Bull.','AAPG BULLETIN','0149-1423',2.344000,0.008240,0.938650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Geol. Sin.-Engl. Ed.','ACTA GEOLOGICA SINICA-ENGLISH EDITION','1000-9515',1.996000,0.003430,0.390520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Geophys.','Advances in Geophysics','0065-2687',4.600000,0.000290,0.032700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Geophys.','ANNALES GEOPHYSICAE','0992-7689',1.731000,0.009050,1.032000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Earth Sci.','CANADIAN JOURNAL OF EARTH SCIENCES','0008-4077',1.190000,0.003710,0.423150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Earth Sci. Hist.','EARTH SCIENCES HISTORY','0736-623X',0.188000,0.000110,0.012490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Biodivers.','Marine Biodiversity','1867-1616',1.915000,0.001770,0.201530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microb. Ecol.','MICROBIAL ECOLOGY','0095-3628',3.232000,0.013560,1.546100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Biol. Mar. Oceanogr.','REVISTA DE BIOLOGIA MARINA Y OCEANOGRAFIA','0717-3326',0.475000,0.001020,0.116210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Thalassas','THALASSAS','0212-5919',0.538000,0.000210,0.023660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Holzforschung','HOLZFORSCHUNG','0018-3830',1.711000,0.003090,0.351680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Appl. Ceram.','Advances in Applied Ceramics','1743-6753',1.162000,0.001490,0.169770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Glass Phys. Chem.','GLASS PHYSICS AND CHEMISTRY','1087-6596',0.591000,0.000850,0.096730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ceram. Process. Res.','JOURNAL OF CERAMIC PROCESSING RESEARCH','1229-9162',0.320000,0.001460,0.166280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Eur. Ceram. Soc.','JOURNAL OF THE EUROPEAN CERAMIC SOCIETY','0955-2219',2.933000,0.022000,2.507760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Non-Cryst. Solids','JOURNAL OF NON-CRYSTALLINE SOLIDS','0022-3093',1.825000,0.017370,1.979770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sol-Gel Sci. Technol.','JOURNAL OF SOL-GEL SCIENCE AND TECHNOLOGY','0928-0707',1.473000,0.006090,0.694610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Chem. Glasses-Eur. J. Glass Sci. Technol. Part B','Physics and Chemistry of Glasses-European Journal of Glass Science and Technology Part B','1753-3562',0.630000,0.000470,0.053250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('2D Mater.','2D Materials','2053-1583',9.611000,0.002800,0.319220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACI Mater. J.','ACI MATERIALS JOURNAL','0889-325X',1.154000,0.003090,0.351740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JAMA Intern. Med.','JAMA Internal Medicine','2168-6106',14.000000,0.039690,4.524280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Panminerva Medica','PANMINERVA MEDICA','0031-0808',1.600000,0.000780,0.089110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('PLos Med.','PLOS MEDICINE','1549-1676',13.585000,0.061900,7.055770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Clin. Esp.','REVISTA CLINICA ESPANOLA','0014-2565',0.760000,0.000460,0.052140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Medica Chile','REVISTA MEDICA DE CHILE','0034-9887',0.440000,0.001480,0.169240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sao Paulo Med. J.','Sao Paulo Medical Journal','1516-3180',0.955000,0.000990,0.112570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ups. J. Med. Sci.','UPSALA JOURNAL OF MEDICAL SCIENCES','0300-9734',1.739000,0.001860,0.211780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Microw. Power Electromagn. Energy','JOURNAL OF MICROWAVE POWER AND ELECTROMAGNETIC ENERGY','0832-7823',0.925000,0.000330,0.038030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sens.','Journal of Sensors','1687-725X',0.712000,0.000940,0.106940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microprocess. Microsyst.','MICROPROCESSORS AND MICROSYSTEMS','0141-9331',0.471000,0.000980,0.111650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Netw.-Comput. Neural Syst.','NETWORK-COMPUTATION IN NEURAL SYSTEMS','0954-898X',0.647000,0.000280,0.031680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trait. Signal','Traitement du Signal','0765-0019',0.000000,0.000020,0.002420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aerosol Sci. Technol.','AEROSOL SCIENCE AND TECHNOLOGY','0278-6826',1.953000,0.008740,0.996380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Combust. Flame','COMBUSTION AND FLAME','0010-2180',4.168000,0.026220,2.988220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Archaeol.','ENVIRONMENTAL ARCHAEOLOGY','1461-4103',0.857000,0.000330,0.037240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Eng. Geosci.','ENVIRONMENTAL & ENGINEERING GEOSCIENCE','1078-7275',0.500000,0.000440,0.050530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geochronometria','Geochronometria','1897-1695',2.038000,0.002300,0.261940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geol. Carpath.','GEOLOGICA CARPATHICA','1335-0552',1.523000,0.000990,0.112300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geosci. J.','GEOSCIENCES JOURNAL','1226-4806',0.922000,0.000780,0.088580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Appl. Geophys.','JOURNAL OF APPLIED GEOPHYSICS','0926-9851',1.355000,0.006470,0.737850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Asian Earth Sci.','JOURNAL OF ASIAN EARTH SCIENCES','1367-9120',2.647000,0.019420,2.213200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Geol. Soc.','JOURNAL OF THE GEOLOGICAL SOCIETY','0016-7649',2.473000,0.006770,0.771900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Geophys. Res.','JOURNAL OF GEOPHYSICAL RESEARCH','0148-0227',3.318000,0.304860,34.747380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Mater.','ACTA MATERIALIA','1359-6454',5.058000,0.091640,10.445150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Eng. Mater.','ADVANCED ENGINEERING MATERIALS','1438-1656',1.817000,0.008040,0.916580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Prod. Eng. Manag.','Advances in Production Engineering & Management','1854-6250',1.125000,0.000230,0.025780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cem. Concr. Res.','CEMENT AND CONCRETE RESEARCH','0008-8846',3.480000,0.017420,1.986080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fatigue Fract. Eng. Mater. Struct.','FATIGUE & FRACTURE OF ENGINEERING MATERIALS & STRUCTURES','8756-758X',1.838000,0.003600,0.410510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mater. Form.','International Journal of Material Forming','1960-6206',1.241000,0.002240,0.255760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Jpn. Inst. Met.','JOURNAL OF THE JAPAN INSTITUTE OF METALS','0021-4876',0.234000,0.000590,0.067650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Sci. Technol.','MATERIALS SCIENCE AND TECHNOLOGY','0267-0836',1.008000,0.005160,0.588220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Met. Sci. Heat Treat.','METAL SCIENCE AND HEAT TREATMENT','0026-0673',0.254000,0.000840,0.096130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Metal.','REVISTA DE METALURGIA','0034-8570',0.203000,0.000280,0.031410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tetsu To Hagane-J. Iron Steel Inst. Jpn.','TETSU TO HAGANE-JOURNAL OF THE IRON AND STEEL INSTITUTE OF JAPAN','0021-1575',0.260000,0.001110,0.126420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Med.','Annual Review of Medicine','0066-4219',10.954000,0.012280,1.400060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Flow Meas. Instrum.','FLOW MEASUREMENT AND INSTRUMENTATION','0955-5986',1.152000,0.002310,0.263040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Iran J. Sci. Technol.-Trans. Mech. Eng.','Iranian Journal of Science and Technology-Transactions of Mechanical Engineering','2228-6187',1.045000,0.000210,0.023710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ind. Lubr. Tribol.','INDUSTRIAL LUBRICATION AND TRIBOLOGY','0036-8792',0.406000,0.000460,0.052140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Impact Eng.','INTERNATIONAL JOURNAL OF IMPACT ENGINEERING','0734-743X',2.646000,0.007450,0.849660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mech. Mater. Des.','International Journal of Mechanics and Materials in Design','1569-1713',1.926000,0.001080,0.123090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Refrig.-Rev. Int. Froid','INTERNATIONAL JOURNAL OF REFRIGERATION-REVUE INTERNATIONALE DU FROID','0140-7007',2.291000,0.008400,0.957360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Veh. Des.','INTERNATIONAL JOURNAL OF VEHICLE DESIGN','0143-3369',0.757000,0.000720,0.082610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Fluids Eng.-Trans. ASME','JOURNAL OF FLUIDS ENGINEERING-TRANSACTIONS OF THE ASME','0098-2202',1.283000,0.005240,0.596920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mech. Des.','JOURNAL OF MECHANICAL DESIGN','1050-0472',1.444000,0.005720,0.651640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vibroeng.','Journal of Vibroengineering','1392-8716',0.384000,0.001020,0.115900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Quat. Sci.','JOURNAL OF QUATERNARY SCIENCE','0267-8179',2.553000,0.007580,0.864540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pol. Polar. Res.','POLISH POLAR RESEARCH','0138-0338',1.182000,0.000670,0.076720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Quat. Geochronol.','Quaternary Geochronology','1871-1014',3.142000,0.008370,0.954360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Soils Found.','SOILS AND FOUNDATIONS','0038-0806',1.238000,0.002600,0.296370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Terr. Atmos. Ocean. Sci.','TERRESTRIAL ATMOSPHERIC AND OCEANIC SCIENCES','1017-0839',0.556000,0.001280,0.146290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Adhes. Adhes.','INTERNATIONAL JOURNAL OF ADHESION AND ADHESIVES','0143-7496',1.956000,0.005080,0.579050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Electron. Mater.','JOURNAL OF ELECTRONIC MATERIALS','0361-5235',1.491000,0.013150,1.498770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Eng. Mater. Technol.-Trans. ASME','JOURNAL OF ENGINEERING MATERIALS AND TECHNOLOGY-TRANSACTIONS OF THE ASME','0094-4289',0.935000,0.001420,0.161670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mater. Eng. Perform.','JOURNAL OF MATERIALS ENGINEERING AND PERFORMANCE','1059-9495',1.094000,0.007570,0.862540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Microw. Power Electromagn. Energy','JOURNAL OF MICROWAVE POWER AND ELECTROMAGNETIC ENERGY','0832-7823',0.925000,0.000330,0.038030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nano Res.','Journal of Nano Research','1662-5250',0.366000,0.000470,0.053290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Soc. Inf. Disp.','Journal of the Society for Information Display','1071-0922',0.619000,0.001690,0.192160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Wuhan Univ. Technol.-Mat. Sci. Edit.','JOURNAL OF WUHAN UNIVERSITY OF TECHNOLOGY-MATERIALS SCIENCE EDITION','1000-2413',0.400000,0.002020,0.229740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('KONA Powder Part. J.','KONA Powder and Particle Journal','0288-4534',1.780000,0.000580,0.065890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bosnian J. Basic Med. Sci.','Bosnian Journal of Basic Medical Sciences','1512-8601',0.652000,0.000530,0.060950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Gene Ther.','CANCER GENE THERAPY','0929-1903',2.532000,0.003830,0.436490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Transplant.','CELL TRANSPLANTATION','0963-6897',3.427000,0.010520,1.198680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('EMBO Mol. Med.','EMBO Molecular Medicine','1757-4676',9.547000,0.023190,2.642950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Innate Immun.','Innate Immunity','1753-4259',2.830000,0.003720,0.424390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Invest. Clin.','INVESTIGACION CLINICA','0535-5133',0.406000,0.000290,0.032660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ophthalmol.','Journal of Ophthalmology','2090-004X',1.463000,0.003300,0.375600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Sci. Monitor','MEDICAL SCIENCE MONITOR','1643-3750',1.405000,0.006140,0.700140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Melanoma Res.','MELANOMA RESEARCH','0960-8931',2.219000,0.003890,0.443050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Med.','MOLECULAR MEDICINE','1076-1551',3.530000,0.010940,1.247140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mach. Sci. Technol.','MACHINING SCIENCE AND TECHNOLOGY','1091-0344',1.172000,0.000700,0.079390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mech. Eng.','MECHANICAL ENGINEERING','0025-6501',0.271000,0.000560,0.063620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mechatronics','MECHATRONICS','0957-4158',1.871000,0.005520,0.628950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Combust. Inst.','PROCEEDINGS OF THE COMBUSTION INSTITUTE','1540-7489',4.120000,0.017070,1.945390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Mech. Eng. Part E-J. Process Mech. Eng.','PROCEEDINGS OF THE INSTITUTION OF MECHANICAL ENGINEERS PART E-JOURNAL OF PROCESS MECHANICAL ENGINEERING','0954-4089',1.107000,0.000530,0.060640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rapid Prototyping J.','RAPID PROTOTYPING JOURNAL','1355-2546',1.352000,0.001840,0.209510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Technol. Built Environ.','Science and Technology for the Built Environment','2374-4731',0.000000,0.000000,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Shock Vib.','SHOCK AND VIBRATION','1070-9622',0.880000,0.001630,0.186040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Strojniski Vestn.-J. Mech. Eng.','STROJNISKI VESTNIK-JOURNAL OF MECHANICAL ENGINEERING','0039-2480',0.677000,0.001080,0.123430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wind Energy','WIND ENERGY','1095-4244',2.891000,0.005560,0.633310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Earthq. Spectra','EARTHQUAKE SPECTRA','8755-2930',2.298000,0.005060,0.577220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geomech. Eng.','Geomechanics and Engineering','2005-307X',1.085000,0.000380,0.042960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geotech. Test. J.','GEOTECHNICAL TESTING JOURNAL','0149-6115',0.663000,0.002170,0.246940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Numer. Anal. Methods Geomech.','INTERNATIONAL JOURNAL FOR NUMERICAL AND ANALYTICAL METHODS IN GEOMECHANICS','0363-9061',1.758000,0.006220,0.708420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Phys. Model. Geotech.','International Journal of Physical Modelling in Geotechnics','1346-213X',1.045000,0.000610,0.069160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Civil Eng.-Geotech. Eng.','PROCEEDINGS OF THE INSTITUTION OF CIVIL ENGINEERS-GEOTECHNICAL ENGINEERING','1353-2618',0.577000,0.000670,0.076250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Soils Found.','SOILS AND FOUNDATIONS','0038-0806',1.238000,0.002600,0.296370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Entomol. Mus. Natl. Pragae','ACTA ENTOMOLOGICA MUSEI NATIONALIS PRAGAE','0374-1036',0.617000,0.000800,0.091360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geriatr. Gerontol. Int.','Geriatrics & Gerontology International','1444-1586',2.229000,0.004930,0.561410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Blood Marrow Transplant.','BIOLOGY OF BLOOD AND MARROW TRANSPLANTATION','1083-8791',3.980000,0.023700,2.700780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Haematol.','EUROPEAN JOURNAL OF HAEMATOLOGY','0902-4441',2.544000,0.008370,0.954520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Expert Rev. Hematol.','Expert Review of Hematology','1747-4086',2.439000,0.003790,0.431910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cereb. Blood Flow Metab.','JOURNAL OF CEREBRAL BLOOD FLOW AND METABOLISM','0271-678X',4.929000,0.030330,3.456580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hematol. Oncol.','Journal of Hematology & Oncology','1756-8722',6.263000,0.006790,0.774140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Leukoc. Biol.','JOURNAL OF LEUKOCYTE BIOLOGY','0741-5400',4.165000,0.024330,2.773460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Leukemia','LEUKEMIA','0887-6924',12.104000,0.063000,7.180270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Langmuir','LANGMUIR','0743-7463',3.993000,0.164800,18.784090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Liq. Cryst. Rev.','Liquid Crystals Reviews','2168-0396',3.933000,0.000370,0.042730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Chem. Phys.','MATERIALS CHEMISTRY AND PHYSICS','0254-0584',2.101000,0.030040,3.424060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Corros.','MATERIALS AND CORROSION-WERKSTOFFE UND KORROSION','0947-5117',1.450000,0.002610,0.297150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Res. Bull.','MATERIALS RESEARCH BULLETIN','0025-5408',2.435000,0.021070,2.401240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Sci.-Medzg.','Materials Science-Medziagotyra','1392-1320',0.428000,0.000900,0.102580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Technol.','MATERIALS TECHNOLOGY','1066-7857',1.442000,0.000950,0.108590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Materialwiss. Werkstofftech.','MATERIALWISSENSCHAFT UND WERKSTOFFTECHNIK','0933-5137',0.393000,0.001200,0.136220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Met. Mater.-Int.','METALS AND MATERIALS INTERNATIONAL','1598-9623',1.815000,0.003680,0.419970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Metall. Mater. Trans. B-Proc. Metall. Mater. Proc. Sci.','METALLURGICAL AND MATERIALS TRANSACTIONS B-PROCESS METALLURGY AND MATERIALS PROCESSING SCIENCE','1073-5615',1.474000,0.005300,0.604270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Model. Simul. Mater. Sci. Eng.','MODELLING AND SIMULATION IN MATERIALS SCIENCE AND ENGINEERING','0965-0393',1.859000,0.008670,0.988630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nano Energy','Nano Energy','2211-2855',11.553000,0.017930,2.044120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nano Today','Nano Today','1748-0132',13.157000,0.015050,1.715280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nano-Micro Lett.','Nano-Micro Letters','2311-6706',3.012000,0.001470,0.167440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanomaterials','Nanomaterials','2079-4991',2.690000,0.001240,0.140920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanoscale Res. Lett.','Nanoscale Research Letters','1556-276X',2.584000,0.027000,3.077020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Nanotechnol.','Nature Nanotechnology','1748-3387',35.267000,0.167380,19.077950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trends Mol. Med','TRENDS IN MOLECULAR MEDICINE','1471-4914',9.292000,0.020480,2.334410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioinspir. Biomim.','Bioinspiration & Biomimetics','1748-3182',2.891000,0.005940,0.676890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomater. Sci.','Biomaterials Science','2047-4830',3.614000,0.003740,0.426580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Polym.','CELLULAR POLYMERS','0262-4893',0.615000,0.000090,0.010160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Cells Mater.','EUROPEAN CELLS & MATERIALS','1473-2262',4.560000,0.006760,0.770170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Polym. Mater. Polym. Biomat.','International Journal of Polymeric Materials and Polymeric Biomaterials','0091-4037',1.667000,0.001460,0.165980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomed. Mater. Res. Part B','JOURNAL OF BIOMEDICAL MATERIALS RESEARCH PART B-APPLIED BIOMATERIALS','1552-4973',2.881000,0.010770,1.227050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Mech.','EXPERIMENTAL MECHANICS','0014-4851',1.764000,0.007530,0.858000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Tech.','EXPERIMENTAL TECHNIQUES','0732-8818',0.716000,0.001000,0.114070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Strain Anal. Eng. Des.','JOURNAL OF STRAIN ANALYSIS FOR ENGINEERING DESIGN','0309-3247',1.250000,0.001660,0.188990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Test.','Materials Testing','0025-5300',0.266000,0.000520,0.059760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Zool.','ANNALES ZOOLOGICI','0003-4541',1.136000,0.001100,0.125920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asian Myrmecol.','Asian Myrmecology','1985-1944',1.100000,0.000310,0.034880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Insectology','BULLETIN OF INSECTOLOGY','1721-8861',1.075000,0.001260,0.144120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. Entomol.','CANADIAN ENTOMOLOGIST','0008-347X',1.000000,0.001320,0.149910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Entomol. Am.','Entomologica Americana','1947-5136',0.231000,0.000150,0.017150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Acarol.','INTERNATIONAL JOURNAL OF ACAROLOGY','0164-7954',0.774000,0.001080,0.123610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Odonatol.','INTERNATIONAL JOURNAL OF ODONATOLOGY','1388-7890',0.596000,0.000270,0.031280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Lepid. Soc.','JOURNAL OF THE LEPIDOPTERISTS SOCIETY','0024-0966',0.380000,0.000290,0.033460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Med. Entomol.','JOURNAL OF MEDICAL ENTOMOLOGY','0022-2585',1.712000,0.007020,0.800530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Vet. Entomol.','MEDICAL AND VETERINARY ENTOMOLOGY','0269-283X',2.242000,0.003410,0.388620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pest. Biochem. Physiol.','PESTICIDE BIOCHEMISTRY AND PHYSIOLOGY','0048-3575',2.388000,0.005170,0.589780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Colomb. Entomol.','REVISTA COLOMBIANA DE ENTOMOLOGIA','0120-0488',0.219000,0.000510,0.057950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Neuroinformatics','Frontiers in Neuroinformatics','1662-5196',3.047000,0.004250,0.484450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE J. Biomed. Health Inform.','IEEE Journal of Biomedical and Health Informatics','2168-2194',2.093000,0.003170,0.360800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Neurosci.','JOURNAL OF COMPUTATIONAL NEUROSCIENCE','0929-5313',1.871000,0.004630,0.528120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Graph.','JOURNAL OF MOLECULAR GRAPHICS & MODELLING','1093-3263',1.674000,0.003930,0.447980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Biosci.','MATHEMATICAL BIOSCIENCES','0025-5564',1.256000,0.004410,0.502770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Biosci. Eng.','Mathematical Biosciences and Engineering','1547-1063',1.006000,0.002190,0.249630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Med. Biol.','MATHEMATICAL MEDICINE AND BIOLOGY-A JOURNAL OF THE IMA','1477-8599',1.162000,0.000880,0.100430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wiley Interdiscip. Rev.-Comput. Mol. Sci.','Wiley Interdisciplinary Reviews-Computational Molecular Science','1759-0876',10.234000,0.011720,1.335590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. J. Gen. Pract.','BRITISH JOURNAL OF GENERAL PRACTICE','0960-1643',2.741000,0.009320,1.062760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fam. Med.','FAMILY MEDICINE','0742-3225',0.981000,0.002530,0.288150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Status Solidi A-Appl. Mat.','PHYSICA STATUS SOLIDI A-APPLICATIONS AND MATERIALS SCIENCE','1862-6300',1.648000,0.013590,1.548870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Mater. Sci.','PROGRESS IN MATERIALS SCIENCE','0079-6425',31.083000,0.016770,1.911540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Nat. Sci.','Progress in Natural Science-Materials International','1002-0071',1.753000,0.002710,0.309340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Photovoltaics','PROGRESS IN PHOTOVOLTAICS','1062-7995',7.365000,0.017020,1.940380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Adv. Mater.','Science of Advanced Materials','1947-2935',1.812000,0.004290,0.488830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta. Math. Sin.-English Ser.','ACTA MATHEMATICA SINICA-ENGLISH SERIES','1439-8516',0.386000,0.004260,0.485020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anal. Math. Phys.','Analysis and Mathematical Physics','1664-2368',0.583000,0.001050,0.119800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanoscale Microscale Thermophys. Eng.','Nanoscale and Microscale Thermophysical Engineering','1556-7265',2.390000,0.000860,0.097940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polym. Polym. Compos.','POLYMERS & POLYMER COMPOSITES','0967-3911',0.256000,0.000450,0.051030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Vapor Depos.','CHEMICAL VAPOR DEPOSITION','0948-1907',1.789000,0.001460,0.166290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Corros. Rev.','CORROSION REVIEWS','0334-6005',1.450000,0.000350,0.040040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vac. Sci. Technol. A','JOURNAL OF VACUUM SCIENCE & TECHNOLOGY A','0734-2101',1.724000,0.007570,0.862400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Thin Solid Films','THIN SOLID FILMS','0040-6090',1.761000,0.046110,5.255660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sandw. Struct. Mater.','JOURNAL OF SANDWICH STRUCTURES & MATERIALS','1099-6362',2.852000,0.001110,0.126420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Autex Res. J.','Autex Research Journal','1470-9589',0.460000,0.000200,0.023210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cellulose','CELLULOSE','0969-0239',3.195000,0.011940,1.360370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Cloth. Sci. Technol.','International Journal of Clothing Science and Technology','0955-6222',0.418000,0.000210,0.024050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ind. Text.','Journal of Industrial Textiles','1528-0837',1.120000,0.000770,0.087420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Algebr. Log.','Algebra and Logic','0002-5232',0.524000,0.001420,0.162030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Board Fam. Med.','Journal of the American Board of Family Medicine','1557-2625',1.989000,0.006250,0.712020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ambix','Ambix','0002-6980',0.438000,0.000190,0.021580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Early Sci. Med.','Early Science and Medicine','1383-7427',0.225000,0.000170,0.019750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endeavour','ENDEAVOUR','0160-9327',0.255000,0.000400,0.045890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Found. Sci.','Foundations of Science','1233-1821',0.912000,0.000450,0.050860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Her. Russ. Acad. Sci.','HERALD OF THE RUSSIAN ACADEMY OF SCIENCES','1019-3316',0.327000,0.000320,0.036530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hist. Philos. Life Sci.','HISTORY AND PHILOSOPHY OF THE LIFE SCIENCES','0391-9714',0.349000,0.000230,0.026430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('HYLE','HYLE','1433-5158',0.500000,0.000100,0.010950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stud. Hist. Philos. Mod. Phys.','STUDIES IN HISTORY AND PHILOSOPHY OF MODERN PHYSICS','1355-2198',0.626000,0.001060,0.120360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. J. Grape Wine Res.','AUSTRALIAN JOURNAL OF GRAPE AND WINE RESEARCH','1322-7130',2.126000,0.002330,0.265490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hortic. Bras.','Horticultura Brasileira','0102-0536',0.276000,0.001040,0.118790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Horticult. J.','Horticulture Journal','2189-0102',0.000000,0.000120,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Comput. Math.','Applied and Computational Mathematics','1683-3511',0.717000,0.000410,0.047210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asian J. Math.','Asian Journal of Mathematics','1093-6106',0.722000,0.002830,0.322300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Banach J. Math. Anal.','Banach Journal of Mathematical Analysis','1735-8787',0.800000,0.001230,0.139750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Carpathian J. Math.','Carpathian Journal of Mathematics','1584-2851',0.610000,0.000620,0.070600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Appl. Math. Comput. Sci.','Communications in Applied Mathematics and Computational Science','1559-3940',0.917000,0.001480,0.169180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Contemp. Math.','COMMUNICATIONS IN CONTEMPORARY MATHEMATICS','0219-1997',1.167000,0.003460,0.394210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Pure Appl. Math.','COMMUNICATIONS ON PURE AND APPLIED MATHEMATICS','0010-3640',3.617000,0.014990,1.708140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Compel-Int. J. Comp. Math. Electr. Electron. Eng.','COMPEL-THE INTERNATIONAL JOURNAL FOR COMPUTATION AND MATHEMATICS IN ELECTRICAL AND ELECTRONIC ENGINEERING','0332-1649',0.430000,0.001280,0.145660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Methods Appl. Math.','Computational Methods in Applied Mathematics','1609-4840',0.673000,0.001210,0.138220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Optim. Appl.','COMPUTATIONAL OPTIMIZATION AND APPLICATIONS','0926-6003',1.444000,0.007540,0.859030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Discret. Contin. Dyn. Syst.','DISCRETE AND CONTINUOUS DYNAMICAL SYSTEMS','1078-0947',1.127000,0.018090,2.062050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Discret. Optim.','Discrete Optimization','1572-5286',0.889000,0.002080,0.236820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ESAIM-Math. Model. Numer. Anal.-Model. Math. Anal. Numer.','ESAIM-MATHEMATICAL MODELLING AND NUMERICAL ANALYSIS-MODELISATION MATHEMATIQUE ET ANALYSE NUMERIQUE','0764-583X',1.486000,0.005770,0.657280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Agric. For. Meteorol.','AGRICULTURAL AND FOREST METEOROLOGY','0168-1923',4.461000,0.021180,2.414500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Atmosphere','Atmosphere','2073-4433',1.221000,0.001250,0.142140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clim. Res.','CLIMATE RESEARCH','0936-577X',1.690000,0.006840,0.780010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Earth Future','Earths Future','2328-4277',5.620000,0.002780,0.316640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Glob. Biogeochem. Cycle','GLOBAL BIOGEOCHEMICAL CYCLES','0886-6236',4.495000,0.017000,1.937910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Climatol.','INTERNATIONAL JOURNAL OF CLIMATOLOGY','0899-8418',3.609000,0.023760,2.708450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Turk. Entomol. Derg.-Turk. J. Entomol.','TURKIYE ENTOMOLOJI DERGISI-TURKISH JOURNAL OF ENTOMOLOGY','1010-6960',0.375000,0.000420,0.047890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ambio','AMBIO','0044-7447',2.555000,0.007750,0.882790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomed. Environ. Sci.','BIOMEDICAL AND ENVIRONMENTAL SCIENCES','0895-3988',1.906000,0.002890,0.329830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Environ. Sustain.','Current Opinion in Environmental Sustainability','1877-3435',4.658000,0.009800,1.117260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecosyst. Serv.','Ecosystem Services','2212-0416',4.307000,0.003140,0.357660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Policy','ENERGY POLICY','0301-4215',3.045000,0.062060,7.073590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Exp. Bot.','ENVIRONMENTAL AND EXPERIMENTAL BOTANY','0098-8472',3.712000,0.010300,1.173780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Antimicrob. Resist. Infect. Control','Antimicrobial Resistance and Infection Control','2047-2994',2.716000,0.001320,0.150100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arh. Hig. Rada. Toksikol.','Arhiv za Higijenu Rada i Toksikologiju-Archives of Industrial Hygiene and Toxicology','0004-1254',0.971000,0.000920,0.104460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. J. Prim. Health.','Australian Journal of Primary Health','1448-7527',1.152000,0.001740,0.198240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. J. Rural Health','Australian Journal of Rural Health','1038-5282',0.764000,0.001400,0.160020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. World Health Organ.','BULLETIN OF THE WORLD HEALTH ORGANIZATION','0042-9686',5.296000,0.020200,2.302560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Causes Control','CANCER CAUSES & CONTROL','0957-5243',2.680000,0.016600,1.892400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chronic Dis. Inj. Can.','Chronic Diseases and Injuries in Canada','1925-6523',1.558000,0.000890,0.101210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Health Perspect.','ENVIRONMENTAL HEALTH PERSPECTIVES','0091-6765',8.443000,0.053550,6.103990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Health Prev.','Environmental Health and Preventive Medicine','1342-078X',1.214000,0.001620,0.184520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Epidemiol. Prev.','Epidemiologia & Prevenzione','1120-9763',0.924000,0.000780,0.089420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Epidemiology','EPIDEMIOLOGY','1044-3983',6.075000,0.024310,2.770900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ethn. Dis.','ETHNICITY & DISEASE','1049-510X',1.014000,0.002780,0.316330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Comput. Math.','INTERNATIONAL JOURNAL OF COMPUTER MATHEMATICS','0020-7160',0.577000,0.004530,0.515900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inverse Probl.','INVERSE PROBLEMS','0266-5611',1.651000,0.014800,1.687460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inverse Probl. Imaging','Inverse Problems and Imaging','1930-8337',0.951000,0.003270,0.372760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Appl. Log.','Journal of Applied Logic','1570-8683',0.524000,0.000940,0.107100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Eur. Math. Soc.','JOURNAL OF THE EUROPEAN MATHEMATICAL SOCIETY','1435-9855',1.950000,0.013420,1.529880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Glob. Optim.','JOURNAL OF GLOBAL OPTIMIZATION','0925-5001',1.219000,0.007460,0.849950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Inverse Ill-Posed Probl.','Journal of Inverse and Ill-Posed Problems','0928-0219',0.987000,0.001480,0.169120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nonlinear Sci.','JOURNAL OF NONLINEAR SCIENCE','0938-8974',2.068000,0.003520,0.401570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Optim. Theory Appl.','JOURNAL OF OPTIMIZATION THEORY AND APPLICATIONS','0022-3239',1.160000,0.010200,1.162370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Kinet. Relat. Mod.','Kinetic and Related Models','1937-5093',1.372000,0.003190,0.364100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Comput.','MATHEMATICS OF COMPUTATION','0025-5718',1.464000,0.011250,1.281830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Comput. Model.','MATHEMATICAL AND COMPUTER MODELLING','0895-7177',1.366000,0.012970,1.478580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Microbiol. Immunol. Hung.','ACTA MICROBIOLOGICA ET IMMUNOLOGICA HUNGARICA','1217-8950',0.568000,0.000370,0.042290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Clin. Microbiol. Antimicrob.','Annals of Clinical Microbiology and Antimicrobials','1476-0711',2.083000,0.001670,0.190260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('APMIS','APMIS','0903-4641',1.933000,0.005260,0.599370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Environ. Microbiol.','APPLIED AND ENVIRONMENTAL MICROBIOLOGY','0099-2240',3.823000,0.096340,10.980430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aquat. Microb. Ecol.','AQUATIC MICROBIAL ECOLOGY','0948-3055',2.109000,0.004230,0.482170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Microbiol.','CELLULAR MICROBIOLOGY','1462-5814',4.460000,0.018020,2.053900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Emerg. Microbes Infect.','Emerging Microbes & Infections','2222-1751',4.012000,0.002080,0.237420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('FEMS Microbiol. Ecol.','FEMS MICROBIOLOGY ECOLOGY','0168-6496',3.530000,0.020220,2.305160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fems Microbiol. Rev.','FEMS MICROBIOLOGY REVIEWS','0168-6445',13.687000,0.018330,2.088810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Microbiol.','Frontiers in Microbiology','1664-302X',4.165000,0.036110,4.115330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Helicobacter','HELICOBACTER','1083-4389',3.920000,0.004070,0.463450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Microbiol.','INDIAN JOURNAL OF MICROBIOLOGY','0046-8991',1.143000,0.001620,0.184730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Res.','ENVIRONMENTAL RESEARCH','0013-9351',3.088000,0.014000,1.596200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Res. Lett.','Environmental Research Letters','1748-9326',4.134000,0.034470,3.929320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environment','ENVIRONMENT','0013-9157',1.781000,0.000800,0.091410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Ecol. Environ.','FRONTIERS IN ECOLOGY AND THE ENVIRONMENT','1540-9295',8.504000,0.018760,2.138720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Health Phys.','HEALTH PHYSICS','0017-9078',1.193000,0.005150,0.586560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ind. Health','INDUSTRIAL HEALTH','0019-8366',1.057000,0.002120,0.242050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Environ. Health Res.','INTERNATIONAL JOURNAL OF ENVIRONMENTAL HEALTH RESEARCH','0960-3123',1.582000,0.001630,0.185380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Environ. Res.','International Journal of Environmental Research','1735-6865',0.992000,0.001850,0.210450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Appl. Remote Sens.','Journal of Applied Remote Sensing','1931-3195',0.937000,0.002730,0.310790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Coast. Res.','JOURNAL OF COASTAL RESEARCH','0749-0208',0.852000,0.007780,0.887090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gac. Sanit.','Gaceta Sanitaria','0213-9111',1.509000,0.002230,0.254480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Health Phys.','HEALTH PHYSICS','0017-9078',1.193000,0.005150,0.586560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Dev. Orig. Health Dis.','Journal of Developmental Origins of Health and Disease','2040-1744',1.733000,0.001860,0.211720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Environ. Sci. Health Part B-Pestic. Contam. Agric. Wastes','JOURNAL OF ENVIRONMENTAL SCIENCE AND HEALTH PART B-PESTICIDES FOOD CONTAMINANTS AND AGRICULTURAL WASTES','0360-1234',1.247000,0.002610,0.297530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Epidemiol.','JOURNAL OF EPIDEMIOLOGY','0917-5040',2.546000,0.004870,0.554930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Med. Screen.','JOURNAL OF MEDICAL SCREENING','0969-1413',1.750000,0.003680,0.419900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Public Health Policy','JOURNAL OF PUBLIC HEALTH POLICY','0197-5897',1.652000,0.002030,0.231490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Toxicol. Env. Health-Pt b-Crit. Rev.','JOURNAL OF TOXICOLOGY AND ENVIRONMENTAL HEALTH-PART B-CRITICAL REVIEWS','1093-7404',5.552000,0.002540,0.288990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Womens Health','JOURNAL OF WOMENS HEALTH','1540-9996',2.032000,0.011650,1.327940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Lav.','Medicina del Lavoro','0025-7818',0.493000,0.000290,0.033460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nonlinear Anal.-Model Control','Nonlinear Analysis-Modelling and Control','1392-5113',1.075000,0.000940,0.107670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nonlinear Anal.-Theory Methods Appl.','NONLINEAR ANALYSIS-THEORY METHODS & APPLICATIONS','0362-546X',1.125000,0.027550,3.139590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Numer. Meth. Part Differ. Equ.','NUMERICAL METHODS FOR PARTIAL DIFFERENTIAL EQUATIONS','0749-159X',0.964000,0.004710,0.537150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Period. Math. Hung.','Periodica Mathematica Hungarica','0031-5303',0.286000,0.000920,0.105340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physica D','PHYSICA D-NONLINEAR PHENOMENA','0167-2789',1.579000,0.012290,1.401020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Qual. Theor. Dyn. Syst.','Qualitative Theory of Dynamical Systems','1575-5460',0.717000,0.000580,0.065920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Mat. Complut.','Revista Matematica Complutense','1139-1138',0.631000,0.001220,0.138680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Union Mat. Argent.','Revista de la Union Matematica Argentina','0041-6932',0.344000,0.000640,0.072430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('SIAM J. Sci. Comput.','SIAM JOURNAL ON SCIENTIFIC COMPUTING','1064-8275',1.792000,0.024050,2.741160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theory Appl. Categ.','Theory and Applications of Categories','1201-561X',0.641000,0.001610,0.183470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Topology Appl.','TOPOLOGY AND ITS APPLICATIONS','0166-8641',0.493000,0.006020,0.685990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Univ. Politeh. Buchar. Sci. Bull.-Ser. A-Appl. Math. Phys.','University Politehnica of Bucharest Scientific Bulletin-Series A-Applied Mathematics and Physics','1223-7027',0.365000,0.000410,0.046730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Basic Microbiol.','JOURNAL OF BASIC MICROBIOLOGY','0233-111X',1.585000,0.003060,0.348600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Eukaryot. Microbiol.','JOURNAL OF EUKARYOTIC MICROBIOLOGY','1066-5234',2.738000,0.004100,0.467480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Microbiol.','MOLECULAR MICROBIOLOGY','0950-382X',3.761000,0.053230,6.066610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('PLoS Pathog.','PLoS Pathogens','1553-7366',7.003000,0.142700,16.265150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tuberculosis','TUBERCULOSIS','1472-9792',2.952000,0.007010,0.798980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Microsc.','Acta Microscopica','0798-4545',0.113000,0.000050,0.005260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Environ. Sci. Manage.','Journal of Environmental Science and Management','0119-1144',0.146000,0.000070,0.008150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Gt. Lakes Res.','JOURNAL OF GREAT LAKES RESEARCH','0380-1330',1.910000,0.005640,0.642520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ind. Ecol.','JOURNAL OF INDUSTRIAL ECOLOGY','1088-1980',3.265000,0.006480,0.739090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Toxicol. Env. Health Part A','JOURNAL OF TOXICOLOGY AND ENVIRONMENTAL HEALTH-PART A-CURRENT ISSUES','1528-7394',2.243000,0.004530,0.516710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Water Health','JOURNAL OF WATER AND HEALTH','1477-8920',1.025000,0.002170,0.247670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mires Peat','Mires and Peat','1819-754X',1.095000,0.000880,0.100070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radioprotection','RADIOPROTECTION','0033-8451',0.508000,0.000320,0.036250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Environ. Sci. Bio-Technol.','REVIEWS IN ENVIRONMENTAL SCIENCE AND BIO-TECHNOLOGY','1569-1705',4.352000,0.002080,0.237480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Total Environ.','SCIENCE OF THE TOTAL ENVIRONMENT','0048-9697',3.976000,0.083440,9.510510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stoch. Environ. Res. Risk Assess.','STOCHASTIC ENVIRONMENTAL RESEARCH AND RISK ASSESSMENT','1436-3240',2.237000,0.005200,0.592530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Waste Manage.','WASTE MANAGEMENT','0956-053X',3.829000,0.019050,2.171390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Waste Manage. Res.','WASTE MANAGEMENT & RESEARCH','0734-242X',1.338000,0.003550,0.405190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychol. Health Med.','Psychology Health & Medicine','1354-8506',1.347000,0.002850,0.324400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Public Health','PUBLIC HEALTH','0033-3506',1.566000,0.006610,0.752990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rural Remote Health','Rural and Remote Health','1445-6354',0.783000,0.003110,0.354400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Southeast Asian J. Trop. Med. Public Health','SOUTHEAST ASIAN JOURNAL OF TROPICAL MEDICINE AND PUBLIC HEALTH','0125-1562',0.773000,0.002660,0.303050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trans. Roy. Soc. Trop. Med. Hyg.','TRANSACTIONS OF THE ROYAL SOCIETY OF TROPICAL MEDICINE AND HYGIENE','0035-9203',1.631000,0.006140,0.699480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tob. Induc. Dis.','Tobacco Induced Diseases','1617-9625',1.938000,0.001090,0.123880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Traffic Inj. Prev.','Traffic Injury Prevention','1538-9588',1.148000,0.004750,0.540920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transl. Behav. Med.','Translational Behavioral Medicine','1869-6716',2.189000,0.002800,0.319220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Microbiol. Immunol. Hung.','ACTA MICROBIOLOGICA ET IMMUNOLOGICA HUNGARICA','1217-8950',0.568000,0.000370,0.042290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv.Immunol.','Advances in Immunology','0065-2776',7.064000,0.005460,0.622600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Allergy','ALLERGY','0105-4538',6.335000,0.024050,2.740820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Reprod. Immunol.','AMERICAN JOURNAL OF REPRODUCTIVE IMMUNOLOGY','1046-7408',2.916000,0.009190,1.046930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Central Eur. J. Immunol.','Central European Journal of Immunology','1426-3912',0.309000,0.000310,0.035590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Ration. Mech. Anal.','ARCHIVE FOR RATIONAL MECHANICS AND ANALYSIS','0003-9527',2.321000,0.023040,2.625610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CMC-Comput. Mat. Contin.','CMC-Computers Materials & Continua','1546-2218',0.475000,0.001210,0.137390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Econom. J.','Econometrics Journal','1368-4221',1.116000,0.003480,0.396340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Comput. Methods','International Journal of Computational Methods','0219-8762',1.123000,0.001510,0.171660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Frankl. Inst.-Eng. Appl. Math.','JOURNAL OF THE FRANKLIN INSTITUTE-ENGINEERING AND APPLIED MATHEMATICS','0016-0032',2.327000,0.009560,1.089510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ind. Manag. Optim.','Journal of Industrial and Management Optimization','1547-5816',0.776000,0.001430,0.162720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clay Clay Min.','CLAYS AND CLAY MINERALS','0009-8604',1.222000,0.001560,0.178190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Miner. Process.','INTERNATIONAL JOURNAL OF MINERAL PROCESSING','0301-7516',1.617000,0.003730,0.424890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('An. Acad. Bras. Cienc.','ANAIS DA ACADEMIA BRASILEIRA DE CIENCIAS','0001-3765',0.717000,0.002380,0.270950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Model. Nat. Phenom.','Mathematical Modelling of Natural Phenomena','0973-5348',0.820000,0.002890,0.329610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('New Sci.','NEW SCIENTIST','0262-4079',0.285000,0.001330,0.152020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wetlands','WETLANDS','0277-5212',1.504000,0.004670,0.532580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aquac. Res.','AQUACULTURE RESEARCH','1355-557X',1.606000,0.008080,0.920730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aquac. Int.','AQUACULTURE INTERNATIONAL','0967-6120',0.960000,0.002600,0.296630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fish Pathol.','FISH PATHOLOGY','0388-788X',0.600000,0.000430,0.049330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Resour. Econ.','Marine Resource Economics','0738-1360',1.405000,0.000710,0.081130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Aquac.','Reviews in Aquaculture','1753-5123',4.769000,0.001470,0.167760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. Food J.','British Food Journal','0007-070X',0.973000,0.001450,0.165350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Senses','CHEMICAL SENSES','0379-864X',2.500000,0.004620,0.526080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Immunol. Allerg. Clin. North Am.','IMMUNOLOGY AND ALLERGY CLINICS OF NORTH AMERICA','0889-8561',2.352000,0.002930,0.334100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Immunotherapy','Immunotherapy','1750-743X',2.083000,0.004160,0.474350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inflammation','INFLAMMATION','0360-3997',2.618000,0.006650,0.758060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Immunopathol. Pharmacol.','INTERNATIONAL JOURNAL OF IMMUNOPATHOLOGY AND PHARMACOLOGY','0394-6320',1.470000,0.003470,0.395800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin. Immunol.','JOURNAL OF CLINICAL IMMUNOLOGY','0271-9142',3.094000,0.010070,1.147580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J Immunol. Res.','Journal of Immunology Research','2314-8861',2.812000,0.002470,0.282090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Leukoc. Biol.','JOURNAL OF LEUKOCYTE BIOLOGY','0741-5400',4.165000,0.024330,2.773460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Microbiol. Immunol. Infect.','JOURNAL OF MICROBIOLOGY IMMUNOLOGY AND INFECTION','1684-1182',2.955000,0.003570,0.407210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Quant. Financ.','QUANTITATIVE FINANCE','1469-7688',0.794000,0.006060,0.691060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Int. Metod. Numer. Calc. Dise.','Revista Internacional de Metodos Numericos para Calculo y Diseno en Ingenieria','0213-1315',0.207000,0.000130,0.014640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Risk Anal.','RISK ANALYSIS','0272-4332',2.225000,0.010320,1.176500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Arith.','ACTA ARITHMETICA','0065-1036',0.564000,0.005270,0.600140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anal. PDE','Analysis & PDE','1948-206X',1.304000,0.005360,0.610710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Funct. Anal.','Annals of Functional Analysis','2008-8752',0.492000,0.000740,0.084630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ark. Mat.','ARKIV FOR MATEMATIK','0004-2080',0.744000,0.001570,0.178620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asterisque','ASTERISQUE','0303-1179',0.627000,0.004850,0.552590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Braz. Math. Soc.','BULLETIN OF THE BRAZILIAN MATHEMATICAL SOCIETY','1678-7544',0.300000,0.001800,0.205130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Natl. Acad. Sci. U. S. A.','PROCEEDINGS OF THE NATIONAL ACADEMY OF SCIENCES OF THE UNITED STATES OF AMERICA','0027-8424',9.423000,1.321970,150.678310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('R D Mag.','R&D MAGAZINE','0746-9179',0.042000,0.000190,0.021380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('S. Afr. J. Sci.','SOUTH AFRICAN JOURNAL OF SCIENCE','0038-2353',0.902000,0.001810,0.206530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Nat.','Science of Nature','0028-1042',0.000000,0.000000,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mycologia','MYCOLOGIA','0027-5514',2.638000,0.006750,0.769540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mycopathologia','MYCOPATHOLOGIA','0301-486X',1.671000,0.003730,0.425620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Alzheimer Dis. Assoc. Dis.','ALZHEIMER DISEASE & ASSOCIATED DISORDERS','0893-0341',2.530000,0.004520,0.514650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Indian Acad. Neurol.','Annals of Indian Academy of Neurology','0972-2327',0.687000,0.001390,0.158670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Neuropsychol.-Adult','Applied Neuropsychology-Adult','2327-9095',0.694000,0.000420,0.048160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brain Topogr.','BRAIN TOPOGRAPHY','0896-0267',3.727000,0.004430,0.504860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Emir. J. Food Agric.','Emirates Journal of Food and Agriculture','2079-052X',0.623000,0.000990,0.112630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Agric. Immunol.','FOOD AND AGRICULTURAL IMMUNOLOGY','0954-0105',1.548000,0.000520,0.059400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Drug Law J.','FOOD AND DRUG LAW JOURNAL','1064-590X',0.578000,0.000270,0.030880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Nutr. Bull.','FOOD AND NUTRITION BULLETIN','0379-5721',1.543000,0.003140,0.357700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Sci. Technol. Int.','FOOD SCIENCE AND TECHNOLOGY INTERNATIONAL','1082-0132',0.991000,0.001370,0.156290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Technol.','FOOD TECHNOLOGY','0015-6639',0.239000,0.000260,0.029910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Glob. Food Secur.-Agric.Policy','Global Food Security-Agriculture Policy Economics and Environment','2211-9124',3.745000,0.001340,0.152640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Food Eng.','International Journal of Food Engineering','2194-5764',0.712000,0.000740,0.084280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Dairy Res.','JOURNAL OF DAIRY RESEARCH','0022-0299',1.500000,0.002160,0.246050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Food Meas. Charact.','Journal of Food Measurement and Characterization','1932-7587',0.521000,0.000100,0.011600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JAIDS','JAIDS-JOURNAL OF ACQUIRED IMMUNE DEFICIENCY SYNDROMES','1525-4135',3.806000,0.036050,4.109100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Allergy Immunol.','PEDIATRIC ALLERGY AND IMMUNOLOGY','0905-6157',3.947000,0.007990,0.910690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transpl. Immunol.','TRANSPLANT IMMUNOLOGY','0966-3274',1.317000,0.002090,0.238250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transplant. Proc.','TRANSPLANTATION PROCEEDINGS','0041-1345',0.867000,0.016660,1.898830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACS Infect. Dis.','ACS Infectious Diseases','2373-8227',0.000000,0.000790,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Antivir. Ther.','ANTIVIRAL THERAPY','1359-6535',2.916000,0.009820,1.118790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bol. Malar. Salud. Ambient.','Boletin de Malariologia y Salud Ambiental','1690-4648',0.250000,0.000160,0.018610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. HIV Res.','CURRENT HIV RESEARCH','1570-162X',1.562000,0.003030,0.345570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. HIV AIDS','Current Opinion in HIV and AIDS','1746-630X',4.378000,0.008920,1.016150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('HIV Med.','HIV MEDICINE','1464-2662',3.341000,0.007520,0.857120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Infect. Control Hosp. Epidemiol.','INFECTION CONTROL AND HOSPITAL EPIDEMIOLOGY','0899-823X',3.669000,0.022690,2.586020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Infect. Dis.','Infectious Diseases','2374-4235',0.000000,0.000010,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Soc. Math. Fr.','BULLETIN DE LA SOCIETE MATHEMATIQUE DE FRANCE','0037-9484',0.872000,0.001970,0.224320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Symb. Log.','BULLETIN OF SYMBOLIC LOGIC','1079-8986',0.593000,0.001410,0.160640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. Ann. Math. Ser. B','CHINESE ANNALS OF MATHEMATICS SERIES B','0252-9599',0.452000,0.001960,0.223750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Geom.-Theory Appl.','COMPUTATIONAL GEOMETRY-THEORY AND APPLICATIONS','0925-7721',0.589000,0.002720,0.309840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Czech. Math. J.','CZECHOSLOVAK MATHEMATICAL JOURNAL','0011-4642',0.284000,0.001720,0.195520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dyn. Syst. Appl.','DYNAMIC SYSTEMS AND APPLICATIONS','1056-2176',0.213000,0.000570,0.064840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Found. Comput. Math.','FOUNDATIONS OF COMPUTATIONAL MATHEMATICS','1615-3375',1.986000,0.005810,0.662180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Math. China','Frontiers of Mathematics in China','1673-3452',0.444000,0.001960,0.223610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Auton. Res.','CLINICAL AUTONOMIC RESEARCH','0959-9851',1.257000,0.001810,0.206170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Epileptic Disord.','EPILEPTIC DISORDERS','1294-9361',0.942000,0.001450,0.165460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neurol. Neurosurg. Psychiatry','JOURNAL OF NEUROLOGY NEUROSURGERY AND PSYCHIATRY','0022-3050',6.431000,0.032840,3.742740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neurol. Surg. Part A','Journal of Neurological Surgery Part A-Central European Neurosurgery','2193-6315',0.723000,0.000770,0.087770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neuroradiol.','JOURNAL OF NEURORADIOLOGY','0150-9861',2.759000,0.001340,0.153290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sci. Food Agric.','JOURNAL OF THE SCIENCE OF FOOD AND AGRICULTURE','0022-5142',2.076000,0.017070,1.945530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Food Hum. Nutr.','PLANT FOODS FOR HUMAN NUTRITION','0921-9668',2.276000,0.002380,0.271780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Starch-Starke','STARCH-STARKE','0038-9056',1.523000,0.003060,0.348250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Croat. J. For. Eng.','Croatian Journal of Forest Engineering','1845-5719',0.980000,0.000590,0.067360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. For. Res.','JOURNAL OF FORESTRY RESEARCH','1007-662X',0.658000,0.001260,0.144080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Trop. For. Sci.','JOURNAL OF TROPICAL FOREST SCIENCE','0128-1283',0.612000,0.000770,0.087660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Areas J.','NATURAL AREAS JOURNAL','0885-8608',0.626000,0.000770,0.088160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Ecol.','PLANT ECOLOGY','1385-0237',1.490000,0.007100,0.809330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Arv.','REVISTA ARVORE','0100-6762',0.296000,0.001350,0.154420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Chapingo Ser. Cienc. For. Am.','Revista Chapingo Serie Ciencias Forestales y del Ambiente','0186-3231',0.243000,0.000140,0.015790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Infect. Dev. Ctries.','Journal of Infection in Developing Countries','1972-2680',1.139000,0.004470,0.509360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vector Borne Dis.','JOURNAL OF VECTOR BORNE DISEASES','0972-9062',0.872000,0.001020,0.115810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JAIDS','JAIDS-JOURNAL OF ACQUIRED IMMUNE DEFICIENCY SYNDROMES','1525-4135',3.806000,0.036050,4.109100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Infect. Dis. J.','PEDIATRIC INFECTIOUS DISEASE JOURNAL','0891-3668',2.587000,0.023750,2.706880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Scand. J. Infect. Dis.','SCANDINAVIAN JOURNAL OF INFECTIOUS DISEASES','0036-5548',1.366000,0.005420,0.618060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sex. Transm. Infect.','SEXUALLY TRANSMITTED INFECTIONS','1368-4973',3.015000,0.014320,1.632580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Electron. Mater.','Advanced Electronic Materials','2199-160X',0.000000,0.000000,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ.-Sci. Nano','Environmental Science-Nano','2051-8153',5.896000,0.001000,0.113790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Nanobiosci.','IEEE TRANSACTIONS ON NANOBIOSCIENCE','1536-1241',1.969000,0.001690,0.192220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Georgian Math. J.','Georgian Mathematical Journal','1072-947X',0.417000,0.000770,0.087710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Homol. Homotopy Appl.','Homology Homotopy and Applications','1532-0073',0.486000,0.001970,0.224040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Houst. J. Math.','HOUSTON JOURNAL OF MATHEMATICS','0362-1588',0.273000,0.002160,0.246160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Integr. Equ. Oper. Theory','INTEGRAL EQUATIONS AND OPERATOR THEORY','0378-620X',0.956000,0.005200,0.592890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Interface Free Bound.','INTERFACES AND FREE BOUNDARIES','1463-9963',0.868000,0.001440,0.163780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Izv. Math.','IZVESTIYA MATHEMATICS','1064-5632',0.505000,0.001960,0.223350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Differ. Geom.','JOURNAL OF DIFFERENTIAL GEOMETRY','0022-040X',1.240000,0.009000,1.025750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Group Theory','JOURNAL OF GROUP THEORY','1433-5883',0.505000,0.002370,0.270150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Korean. Math. Soc.','JOURNAL OF THE KOREAN MATHEMATICAL SOCIETY','0304-9914',0.356000,0.001660,0.189370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Math. Inequal.','Journal of Mathematical Inequalities','1846-579X',0.636000,0.001000,0.114200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Numer. Math.','Journal of Numerical Mathematics','1570-2820',0.552000,0.001680,0.191880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neurosurg. Anesthesiol.','JOURNAL OF NEUROSURGICAL ANESTHESIOLOGY','0898-4921',2.828000,0.001860,0.211860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Klin. Neurophysiol.','KLINISCHE NEUROPHYSIOLOGIE','1434-0275',0.148000,0.000060,0.006460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mov. Disord.','MOVEMENT DISORDERS','0885-3185',6.010000,0.040140,4.574770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mult. Scler. J.','Multiple Sclerosis Journal','1352-4585',4.671000,0.021480,2.448170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuroepidemiology','NEUROEPIDEMIOLOGY','0251-5350',2.784000,0.005170,0.589250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurol. Med.-Chir.','NEUROLOGIA MEDICO-CHIRURGICA','0470-8105',0.612000,0.002740,0.312220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuromodulation','NEUROMODULATION','1094-7159',2.409000,0.002840,0.323980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurophysiol. Clin.-Clin. Neurophysiol.','NEUROPHYSIOLOGIE CLINIQUE-CLINICAL NEUROPHYSIOLOGY','0987-7053',1.479000,0.001340,0.152740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurorehabilitation','NEUROREHABILITATION','1053-8135',1.453000,0.004660,0.531700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurosurg. Clin. N. Am.','NEUROSURGERY CLINICS OF NORTH AMERICA','1042-3680',1.624000,0.002470,0.281710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychiatry Res. Neuroimaging','PSYCHIATRY RESEARCH-NEUROIMAGING','0925-4927',2.477000,0.010820,1.233820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tree-Ring Res.','Tree-Ring Research','1536-1098',2.565000,0.000690,0.079030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Urban For. Urban Green.','URBAN FORESTRY & URBAN GREENING','1618-8667',2.006000,0.002760,0.314160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Transl. Gastroenterol.','Clinical and Translational Gastroenterology','2155-384X',3.472000,0.000950,0.107930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endoscopy','ENDOSCOPY','0013-726X',5.634000,0.017980,2.049820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Esophagus','Esophagus','1612-9059',0.386000,0.000290,0.033400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Gastroenterol. Hepatol.','EUROPEAN JOURNAL OF GASTROENTEROLOGY & HEPATOLOGY','0954-691X',2.093000,0.009650,1.100150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gastric Cancer','Gastric Cancer','1436-3291',4.404000,0.007110,0.810140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gastroenterol. Res. Pract.','Gastroenterology Research and Practice','1687-6121',1.742000,0.004470,0.509530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gut','GUT','0017-5749',14.921000,0.064970,7.405340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Gastrointest. Liver Dis.','Journal of Gastrointestinal and Liver Diseases','1841-8724',1.891000,0.002660,0.303000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pancreatology','PANCREATOLOGY','1424-3903',2.406000,0.005130,0.585170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Saudi J. Gastroenterol.','Saudi Journal of Gastroenterology','1319-3767',1.312000,0.001360,0.155570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microfluid. Nanofluid.','Microfluidics and Nanofluidics','1613-4982',2.537000,0.010940,1.246630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanotoxicology','Nanotoxicology','1743-5390',7.913000,0.009500,1.083240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Adv. Mater.','Science of Advanced Materials','1947-2935',1.812000,0.004290,0.488830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Soc. Inf. Sci. Technol.','JOURNAL OF THE AMERICAN SOCIETY FOR INFORMATION SCIENCE AND TECHNOLOGY','1532-2882',2.452000,0.009370,1.067840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Spectrosc.','APPLIED SPECTROSCOPY','0003-7028',1.798000,0.007670,0.874100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Flow Meas. Instrum.','FLOW MEASUREMENT AND INSTRUMENTATION','0955-5986',1.152000,0.002310,0.263040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Instrum. Meas.','IEEE TRANSACTIONS ON INSTRUMENTATION AND MEASUREMENT','0018-9456',1.808000,0.015320,1.746710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chemometr.','JOURNAL OF CHEMOMETRICS','0886-9383',1.873000,0.002890,0.329470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Instrum.','Journal of Instrumentation','1748-0221',1.310000,0.016630,1.895470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Micromech. Microeng.','JOURNAL OF MICROMECHANICS AND MICROENGINEERING','0960-1317',1.768000,0.015300,1.743540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('MAPAN-J. Metrol. Soc. India','MAPAN-Journal of Metrology Society of India','0970-3950',0.634000,0.000230,0.025840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Meas. Sci. Rev.','Measurement Science Review','1335-8871',0.969000,0.000640,0.072890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Instrum. Methods Phys. Res. Sect. A-Accel. Spectrom. Dect. Assoc. Equip.','NUCLEAR INSTRUMENTS & METHODS IN PHYSICS RESEARCH SECTION A-ACCELERATORS SPECTROMETERS DETECTORS AND ASSOCIATED EQUIPMENT','0168-9002',1.200000,0.038190,4.352460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Operat. Theor.','JOURNAL OF OPERATOR THEORY','0379-4024',0.464000,0.002740,0.312300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Jap. J. Math.','Japanese Journal of Mathematics','0289-2316',1.778000,0.000710,0.080780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Law Probab. Risk','LAW PROBABILITY & RISK','1470-8396',0.594000,0.000300,0.034260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lith. Math. J.','Lithuanian Mathematical Journal','0363-1672',0.314000,0.000750,0.085430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Z.','MATHEMATISCHE ZEITSCHRIFT','0025-5874',0.674000,0.014580,1.662260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('N. Y. J. Math.','New York Journal of Mathematics','1076-9803',0.422000,0.002230,0.254050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ther. Adv. Neurol. Disord.','Therapeutic Advances in Neurological Disorders','1756-2856',2.642000,0.001770,0.201480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brain Behav. Immun.','BRAIN BEHAVIOR AND IMMUNITY','0889-1591',5.874000,0.023970,2.732020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brain Res. Bull.','BRAIN RESEARCH BULLETIN','0361-9230',2.572000,0.009060,1.033080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brain Topogr.','BRAIN TOPOGRAPHY','0896-0267',3.727000,0.004430,0.504860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CNS Neurol. Disord.-Drug Targets','CNS & Neurological Disorders-Drug Targets','1871-5273',2.188000,0.005130,0.585280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CNS Neurosci.  Ther.','CNS Neuroscience & Therapeutics','1755-5930',4.019000,0.007660,0.872550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cogn. Affect. Behav. Neurosci.','COGNITIVE AFFECTIVE & BEHAVIORAL NEUROSCIENCE','1530-7026',2.886000,0.006810,0.776650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cogn. Comput.','Cognitive Computation','1866-9956',1.933000,0.001250,0.142820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('United European Gastroenterol. J.','United European Gastroenterology Journal','2050-6406',2.933000,0.001580,0.180010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Hum. Genet.','AMERICAN JOURNAL OF HUMAN GENETICS','0002-9297',10.794000,0.080020,9.121100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anim. Genet.','ANIMAL GENETICS','0268-9146',1.779000,0.005200,0.593000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Balk. J. Med. Gen.','Balkan Journal of Medical Genetics','1311-0160',0.404000,0.000120,0.013440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Genet.','BMC GENETICS','1471-2156',2.152000,0.007990,0.910610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Genomics','BMC GENOMICS','1471-2164',3.867000,0.093930,10.705610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Caryologia','CARYOLOGIA','0008-7114',0.494000,0.000490,0.056240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Circ.-Cardiovasc. Genet.','Circulation-Cardiovascular Genetics','1942-325X',3.808000,0.011140,1.269960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Dysmorphol.','CLINICAL DYSMORPHOLOGY','0962-8827',0.518000,0.000590,0.066890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Genet.','CLINICAL GENETICS','0009-9163',3.892000,0.015400,1.754750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('DNA Repair','DNA REPAIR','1568-7864',3.929000,0.015790,1.799250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gene Expr. Patterns','GENE EXPRESSION PATTERNS','1567-133X',1.485000,0.002250,0.256620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sens. Rev.','Sensor Review','0260-2288',0.898000,0.000640,0.073030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Smart. Struct. Syst.','Smart Structures and Systems','1738-1584',1.138000,0.001910,0.217940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Control. Health Monit.','Structural Control & Health Monitoring','1545-2255',2.082000,0.003150,0.358480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('tm-Tech. Mess.','tm-Technisches Messen','0171-8096',0.179000,0.000120,0.013640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Altern. Ther. Health Med.','ALTERNATIVE THERAPIES IN HEALTH AND MEDICINE','1078-6791',1.329000,0.001170,0.133150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Complement. Ther. Clin. Pract.','Complementary Therapies in Clinical Practice','1744-3881',1.158000,0.001120,0.127350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Forsch. Komplement.med.','FORSCHENDE KOMPLEMENTARMEDIZIN','1021-7096',0.551000,0.000660,0.075050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ginseng Res.','Journal of Ginseng Research','1226-8453',3.898000,0.002320,0.264010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Tradit. Chin. Med.','Journal of Traditional Chinese Medicine','0255-2922',1.023000,0.001560,0.178210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dev. World Bioeth.','Developing World Bioethics','1471-8731',1.769000,0.000660,0.075140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Forensic Sci. Med. Pathol.','Forensic Science Medicine and Pathology','1547-769X',1.896000,0.002210,0.251660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Regul. Toxicol. Pharmacol.','REGULATORY TOXICOLOGY AND PHARMACOLOGY','0273-2300',2.227000,0.006350,0.723520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aquat. Ecol.','AQUATIC ECOLOGY','1386-2588',1.797000,0.002130,0.242990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Limnetica','LIMNETICA','0213-8409',0.569000,0.000730,0.082680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Random Struct. Algorithms','RANDOM STRUCTURES & ALGORITHMS','1042-9832',1.011000,0.004940,0.562520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Represent. Theory','Representation Theory','1088-4165',0.639000,0.002180,0.248430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rocky Mt. J. Math.','ROCKY MOUNTAIN JOURNAL OF MATHEMATICS','0035-7596',0.367000,0.002850,0.324340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ukr. Math. J.','Ukrainian Mathematical Journal','0041-5995',0.189000,0.000810,0.092720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Mech. Rev.','Applied Mechanics Reviews','0003-6900',4.784000,0.002190,0.249350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neuropsychiatr. Clin. Neurosci.','JOURNAL OF NEUROPSYCHIATRY AND CLINICAL NEUROSCIENCES','0895-0172',2.433000,0.003890,0.443050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Peripher. Nerv. Syst.','JOURNAL OF THE PERIPHERAL NERVOUS SYSTEM','1085-9489',2.258000,0.003920,0.447250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Physiol.-London','JOURNAL OF PHYSIOLOGY-LONDON','0022-3751',4.731000,0.053030,6.044270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Stroke Cerebrovasc. Dis.','Journal of Stroke & Cerebrovascular Diseases','1052-3057',1.599000,0.010500,1.196260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Brain','Molecular Brain','1756-6606',3.745000,0.006050,0.690020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Psychiatr.','MOLECULAR PSYCHIATRY','1359-4184',13.314000,0.044400,5.060370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mult. Scler. J.','Multiple Sclerosis Journal','1352-4585',4.671000,0.021480,2.448170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Neurosci.','NATURE NEUROSCIENCE','1097-6256',16.724000,0.154680,17.630940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurol. Clin.','NEUROLOGIC CLINICS','0733-8619',1.973000,0.002040,0.232600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurol. Sci.','NEUROLOGICAL SCIENCES','1590-1874',1.783000,0.008380,0.954730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuron','NEURON','0896-6273',13.974000,0.222230,25.329610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dermatol. Sin.','Dermatologica Sinica','1027-8117',0.494000,0.000460,0.052100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('G. Ital. Dermatol. Venereol.','GIORNALE ITALIANO DI DERMATOLOGIA E VENEREOLOGIA','0392-0488',1.014000,0.001140,0.130460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Low. Extrem. Wounds','International Journal of Lower Extremity Wounds','1534-7346',1.366000,0.000860,0.097710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cosmet. Dermatol.','Journal of Cosmetic Dermatology','1473-2130',1.126000,0.001280,0.146180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cutan. Pathol.','JOURNAL OF CUTANEOUS PATHOLOGY','0303-6987',1.409000,0.005520,0.628650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Dermatol. Treat.','JOURNAL OF DERMATOLOGICAL TREATMENT','0954-6634',1.857000,0.003210,0.365570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Invest. Dermatol.','JOURNAL OF INVESTIGATIVE DERMATOLOGY','0022-202X',6.915000,0.043110,4.913360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Skin Pharmacol. Physiol.','SKIN PHARMACOLOGY AND PHYSIOLOGY','1660-5527',2.488000,0.001760,0.200240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wounds-Compend. Clin. Res. Pract.','WOUNDS-A COMPENDIUM OF CLINICAL RESEARCH AND PRACTICE','1044-7946',0.450000,0.000580,0.066060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Geod. Geophys.','Acta Geodaetica et Geophysica','2213-5812',0.528000,0.000360,0.040880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Geophys.','ANNALS OF GEOPHYSICS','1593-5213',0.679000,0.002860,0.326150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Earth Planet. Sci. Lett.','EARTH AND PLANETARY SCIENCE LETTERS','0012-821X',4.326000,0.099400,11.329640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geofizika','Geofizika','0352-3659',0.944000,0.000200,0.022730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geophysics','GEOPHYSICS','0016-8033',2.017000,0.017960,2.046890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hydraul. Res.','JOURNAL OF HYDRAULIC RESEARCH','0022-1686',1.471000,0.004710,0.536570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hydrol. Eng.','JOURNAL OF HYDROLOGIC ENGINEERING','1084-0699',1.530000,0.005780,0.658740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ship Res.','JOURNAL OF SHIP RESEARCH','0022-4502',0.606000,0.000470,0.053940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Water Resour. Plan. Manage.-ASCE','JOURNAL OF WATER RESOURCES PLANNING AND MANAGEMENT','0733-9496',2.521000,0.004340,0.494400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('KSCE J. Civ. Eng.','KSCE Journal of Civil Engineering','1226-7988',0.600000,0.002680,0.305350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Steel Compos. Struct.','STEEL AND COMPOSITE STRUCTURES','1229-9367',1.796000,0.001360,0.155200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Eng. Int.','Structural Engineering International','1016-8664',0.299000,0.000750,0.085870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Saf.','STRUCTURAL SAFETY','0167-4730',2.086000,0.003810,0.434190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transportation','TRANSPORTATION','0049-4488',1.545000,0.003910,0.445570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Model.','JOURNAL OF MOLECULAR MODELING','1610-2940',1.438000,0.010230,1.165960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Photochem. Photobiol. B-Biol.','JOURNAL OF PHOTOCHEMISTRY AND PHOTOBIOLOGY B-BIOLOGY','1011-1344',3.035000,0.008620,0.983030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photochem. Photobiol. Sci.','PHOTOCHEMICAL & PHOTOBIOLOGICAL SCIENCES','1474-905X',2.235000,0.010400,1.184970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochem. Eng. J.','BIOCHEMICAL ENGINEERING JOURNAL','1369-703X',2.463000,0.009730,1.109030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomarkers','BIOMARKERS','1354-750X',2.016000,0.003900,0.444660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioresour. Technol.','BIORESOURCE TECHNOLOGY','0960-8524',4.917000,0.133500,15.216190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Bioinformatics','BMC BIOINFORMATICS','1471-2105',2.435000,0.067930,7.742880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Biochem. Eng. Q.','CHEMICAL AND BIOCHEMICAL ENGINEERING QUARTERLY','0352-9568',0.675000,0.000930,0.105730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sulfur Chem.','Journal of Sulfur Chemistry','1741-5993',0.945000,0.000700,0.079940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mon. Chem.','MONATSHEFTE FUR CHEMIE','0026-9247',1.131000,0.003010,0.342640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanoscale','Nanoscale','2040-3364',7.760000,0.145980,16.639220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Przem. Chem.','PRZEMYSL CHEMICZNY','0033-2496',0.367000,0.000770,0.088310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solid Fuel Chem.','Solid Fuel Chemistry','0361-5219',0.258000,0.000160,0.018490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Turk. J. Chem.','TURKISH JOURNAL OF CHEMISTRY','1300-0527',1.098000,0.001310,0.149590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wiley Interdiscip. Rev.-Comput. Mol. Sci.','Wiley Interdisciplinary Reviews-Computational Molecular Science','1759-0876',10.234000,0.011720,1.335590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Accredit. Qual. Assur.','ACCREDITATION AND QUALITY ASSURANCE','0949-1775',1.010000,0.000890,0.101090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anal. Bioanal. Chem.','ANALYTICAL AND BIOANALYTICAL CHEMISTRY','1618-2642',3.125000,0.054630,6.226550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anal. Lett.','ANALYTICAL LETTERS','0003-2719',1.088000,0.003240,0.369510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Analyst','ANALYST','0003-2654',4.033000,0.047700,5.436390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biosens. Bioelectron.','BIOSENSORS & BIOELECTRONICS','0956-5663',7.476000,0.061210,6.976940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Geodesy','JOURNAL OF GEODESY','0949-7714',2.486000,0.005840,0.665150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Mineral. Geochem.','Reviews in Mineralogy & Geochemistry','1529-6466',6.120000,0.005720,0.652110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adicciones','Adicciones','0214-4840',1.780000,0.000610,0.070010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tob. Induc. Dis.','Tobacco Induced Diseases','1617-9625',1.938000,0.001090,0.123880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Green Chem.','GREEN CHEMISTRY','1463-9262',8.506000,0.053310,6.075730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acoust. Aust.','Acoustics Australia','1839-2571',0.625000,0.000390,0.044610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Acust. United Acust.','ACTA ACUSTICA UNITED WITH ACUSTICA','1610-1928',0.897000,0.002850,0.325010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('EURASIP J. Audio Speech Music Process.','EURASIP Journal on Audio Speech and Music Processing','1687-4722',0.797000,0.000540,0.061620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Audio Speech Lang. Process.','IEEE Transactions on Audio Speech and Language Processing','1558-7916',1.877000,0.011030,1.256820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Aeroacoust.','International Journal of Aeroacoustics','1475-472X',0.414000,0.000940,0.106650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Acoust. Soc. Am.','JOURNAL OF THE ACOUSTICAL SOCIETY OF AMERICA','0001-4966',1.572000,0.033760,3.847620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vib. Acoust.-Trans. ASME','JOURNAL OF VIBRATION AND ACOUSTICS-TRANSACTIONS OF THE ASME','1048-9002',1.169000,0.003880,0.442680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sound Vib.','SOUND AND VIBRATION','1541-0161',0.045000,0.000170,0.019440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chemometrics Intell. Lab. Syst.','CHEMOMETRICS AND INTELLIGENT LABORATORY SYSTEMS','0169-7439',2.217000,0.007080,0.807430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Control Syst. Mag.','IEEE CONTROL SYSTEMS MAGAZINE','1066-033X',2.193000,0.003020,0.343660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IET Contr. Theory Appl.','IET Control Theory and Applications','1751-8644',1.957000,0.013510,1.539880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Technol. Control','Information Technology and Control','1392-124X',0.633000,0.000340,0.039240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mach. Learn. Res.','JOURNAL OF MACHINE LEARNING RESEARCH','1532-4435',2.450000,0.032400,3.692960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Control Signal Syst.','MATHEMATICS OF CONTROL SIGNALS AND SYSTEMS','0932-4194',0.927000,0.000930,0.106550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cytotherapy','CYTOTHERAPY','1465-3249',3.625000,0.008290,0.944680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Diagn. Mol. Pathol.','DIAGNOSTIC MOLECULAR PATHOLOGY','1052-9551',1.474000,0.001060,0.120560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Life Sci.','ENGINEERING IN LIFE SCIENCES','1618-0240',2.168000,0.002610,0.297570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Technol. Biotechnol.','FOOD TECHNOLOGY AND BIOTECHNOLOGY','1330-9862',1.179000,0.001690,0.193070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Bioact. Compat. Polym.','JOURNAL OF BIOACTIVE AND COMPATIBLE POLYMERS','0883-9115',1.568000,0.001010,0.115680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Food Prot.','JOURNAL OF FOOD PROTECTION','0362-028X',1.609000,0.011390,1.297670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Gen. Virol.','JOURNAL OF GENERAL VIROLOGY','0022-1317',3.192000,0.023830,2.715980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Ther.','MOLECULAR THERAPY','1525-0016',6.938000,0.035710,4.070640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mutat. Res.-Fundam. Mol. Mech. Mutagen.','MUTATION RESEARCH-FUNDAMENTAL AND MOLECULAR MECHANISMS OF MUTAGENESIS','0027-5107',2.581000,0.009120,1.039280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chirality','CHIRALITY','0899-0042',2.025000,0.004240,0.483030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electroanalysis','ELECTROANALYSIS','1040-0397',2.471000,0.011210,1.278160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Instrum. Sci. Technol.','INSTRUMENTATION SCIENCE & TECHNOLOGY','1073-9149',0.525000,0.000420,0.047330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Anal. Toxicol.','JOURNAL OF ANALYTICAL TOXICOLOGY','0146-4760',2.322000,0.003870,0.440900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chromatogr. B','JOURNAL OF CHROMATOGRAPHY B-ANALYTICAL TECHNOLOGIES IN THE BIOMEDICAL AND LIFE SCIENCES','1570-0232',2.687000,0.023950,2.729670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sens. Actuator B-Chem.','SENSORS AND ACTUATORS B-CHEMICAL','0925-4005',4.758000,0.064830,7.388760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Inorg. Biochem.','JOURNAL OF INORGANIC BIOCHEMISTRY','0162-0134',3.205000,0.010980,1.251260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Radioanal. Nucl. Chem.','JOURNAL OF RADIOANALYTICAL AND NUCLEAR CHEMISTRY','0236-5731',0.983000,0.008610,0.980950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Ecol. Evol. Syst.','Annual Review of Ecology Evolution and Systematics','1543-592X',9.352000,0.012580,1.433780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Behav. Ecol.','BEHAVIORAL ECOLOGY','1045-2249',3.029000,0.014730,1.679380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Community Ecol.','COMMUNITY ECOLOGY','1585-8553',1.019000,0.000950,0.108560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Conserv. Biol.','CONSERVATION BIOLOGY','0888-8892',4.267000,0.021630,2.465070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecol. Model.','ECOLOGICAL MODELLING','0304-3800',2.275000,0.018730,2.134710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Evol. Ecol. Res.','EVOLUTIONARY ECOLOGY RESEARCH','1522-0613',0.585000,0.001570,0.178480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Evolution','EVOLUTION','0014-3820',4.007000,0.041060,4.680350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fire Ecol.','Fire Ecology','1933-9747',1.098000,0.001110,0.126260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Iberoam. Autom. Inform. Ind.','Revista Iberoamericana de Automatica e Informatica Industrial','1697-7912',0.475000,0.000200,0.022560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anim. Feed Sci. Technol.','ANIMAL FEED SCIENCE AND TECHNOLOGY','0377-8401',1.713000,0.010160,1.158510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anim. Reprod. Sci.','ANIMAL REPRODUCTION SCIENCE','0378-4320',1.377000,0.008010,0.912450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anim. Sci. J.','ANIMAL SCIENCE JOURNAL','1344-3941',1.045000,0.002510,0.286570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Domest. Anim. Endocrinol.','DOMESTIC ANIMAL ENDOCRINOLOGY','0739-7240',1.613000,0.002600,0.295800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Anim. Breed. Genet.','JOURNAL OF ANIMAL BREEDING AND GENETICS','0931-2668',1.745000,0.001960,0.223580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Livest. Sci.','Livestock Science','1871-1413',1.293000,0.011390,1.297780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Small Ruminant Res.','SMALL RUMINANT RESEARCH','0921-4488',1.083000,0.005770,0.657900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('New Genet. Soc.','NEW GENETICS AND SOCIETY','1463-6778',0.929000,0.000650,0.074260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Bot. Gall.','ACTA BOTANICA GALLICA','1253-8078',0.776000,0.000410,0.046660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Alp. Bot.','Alpine Botany','1664-2201',1.645000,0.000430,0.049040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. Syst. Bot.','AUSTRALIAN SYSTEMATIC BOTANY','1030-1887',0.648000,0.000620,0.070260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Austral. Plant Pathol.','AUSTRALASIAN PLANT PATHOLOGY','0815-3191',1.026000,0.001820,0.207860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bot. Marina','BOTANICA MARINA','0006-8055',1.250000,0.001390,0.158550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Caldasia','CALDASIA','0366-5232',0.250000,0.000360,0.040570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Synth. React. Inorg. Met.-Org. Nano-Metal Chem.','Synthesis and Reactivity in Inorganic Metal-Organic and Nano-Metal Chemistry','1553-3174',0.493000,0.001330,0.151450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Carbohydr .Chem. Biochem.','Advances in Carbohydrate Chemistry and Biochemistry','0065-2318',3.667000,0.000590,0.067360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Synth. Catal.','ADVANCED SYNTHESIS & CATALYSIS','1615-4150',6.453000,0.042290,4.820440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Beilstein J. Org. Chem.','Beilstein Journal of Organic Chemistry','1860-5397',2.697000,0.012970,1.477790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Org. Chem.','EUROPEAN JOURNAL OF ORGANIC CHEMISTRY','1434-193X',3.068000,0.041580,4.739030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Carbohydr. Chem.','JOURNAL OF CARBOHYDRATE CHEMISTRY','0732-8303',0.738000,0.000680,0.077610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Organomet. Chem.','JOURNAL OF ORGANOMETALLIC CHEMISTRY','0022-328X',2.336000,0.014510,1.654170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Phys. Org. Chem.','JOURNAL OF PHYSICAL ORGANIC CHEMISTRY','0894-3230',1.515000,0.003670,0.418430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tetrahedron Lett.','TETRAHEDRON LETTERS','0040-4039',2.347000,0.053160,6.059260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adsorpt. Sci. Technol.','ADSORPTION SCIENCE & TECHNOLOGY','0263-6174',0.633000,0.000600,0.068920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Fish Wildl. Manag.','Journal of Fish and Wildlife Management','1944-687X',0.795000,0.000790,0.089930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Plant Ecol.','Journal of Plant Ecology','1752-9921',1.769000,0.002750,0.313390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Landsc. Urban Plan.','LANDSCAPE AND URBAN PLANNING','0169-2046',3.654000,0.012570,1.432850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Ecol.-Prog. Ser.','MARINE ECOLOGY PROGRESS SERIES','0171-8630',2.361000,0.038920,4.435830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Methods Ecol. Evol.','Methods in Ecology and Evolution','2041-210X',6.344000,0.026000,2.963190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Ecol.','MOLECULAR ECOLOGY','0962-1083',5.947000,0.064180,7.315670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Hist.','NATURAL HISTORY','0028-0712',0.051000,0.000050,0.005790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oryx','ORYX','0030-6053',2.052000,0.003920,0.446530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Linn. Soc. N. S. W.','PROCEEDINGS OF THE LINNEAN SOCIETY OF NEW SOUTH WALES','0370-047X',0.214000,0.000130,0.014880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. R. Soc. B-Biol. Sci.','PROCEEDINGS OF THE ROYAL SOCIETY B-BIOLOGICAL SCIENCES','0962-8452',4.823000,0.093280,10.632370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rangel. Ecol. Manag.','Rangeland Ecology & Management','1550-7424',1.349000,0.002880,0.328100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rangeland J.','RANGELAND JOURNAL','1036-9872',1.194000,0.001090,0.123870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Agric. Econ.-Rev. Can. Agroecon.','CANADIAN JOURNAL OF AGRICULTURAL ECONOMICS-REVUE CANADIENNE D AGROECONOMIE','0008-3976',1.291000,0.001050,0.119510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ger. J. Agric. Econ.','German Journal of Agricultural Economics','0002-1121',0.489000,0.000340,0.038200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Agric. Econ.','JOURNAL OF AGRICULTURAL ECONOMICS','0021-857X',1.545000,0.001970,0.224580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Agr. Food Sci.','AGRICULTURAL AND FOOD SCIENCE','1459-6067',1.588000,0.000830,0.095060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biosyst. Eng.','BIOSYSTEMS ENGINEERING','1537-5110',1.997000,0.005990,0.682540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bragantia','BRAGANTIA','1678-4499',0.486000,0.001460,0.166210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chil. J. Agric. Res.','Chilean Journal of Agricultural Research','0718-5839',0.637000,0.001410,0.161010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pak. J. Agric. Sci.','PAKISTAN JOURNAL OF AGRICULTURAL SCIENCES','0552-9034',0.597000,0.000930,0.106110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin.-Cienc. Agrar.','Semina-Ciencias Agrarias','1676-546X',0.229000,0.001730,0.197730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Span. J. Agric. Res.','SPANISH JOURNAL OF AGRICULTURAL RESEARCH','1695-971X',0.760000,0.002480,0.283120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Astronaut.','ACTA ASTRONAUTICA','0094-5765',1.095000,0.008560,0.976030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('AIAA J.','AIAA JOURNAL','0001-1452',1.326000,0.012820,1.461540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Aerosp. Eng.','International Journal of Aerospace Engineering','1687-5966',0.889000,0.000420,0.047520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Flora','FLORA','0367-2530',1.590000,0.003580,0.408480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Asian Nat. Prod. Res.','JOURNAL OF ASIAN NATURAL PRODUCTS RESEARCH','1028-6020',1.009000,0.002870,0.327520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ethnopharmacol.','JOURNAL OF ETHNOPHARMACOLOGY','0378-8741',3.055000,0.028870,3.290540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Plant Regist.','Journal of Plant Registrations','1936-5209',0.474000,0.000700,0.079670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Plant-Microbe Interact.','MOLECULAR PLANT-MICROBE INTERACTIONS','0894-0282',4.145000,0.013260,1.510880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('New Phytol.','NEW PHYTOLOGIST','0028-646X',7.210000,0.069800,7.955510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Catal. Commun.','CATALYSIS COMMUNICATIONS','1566-7367',3.389000,0.017480,1.991830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Catal. Rev.-Sci. Eng.','CATALYSIS REVIEWS-SCIENCE AND ENGINEERING','0161-4940',7.526000,0.001560,0.177600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Catal. Surv. Asia','CATALYSIS SURVEYS FROM ASIA','1571-1013',2.038000,0.000750,0.085630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Catalysts','Catalysts','2073-4344',2.964000,0.001470,0.167920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ChemPhysChem','CHEMPHYSCHEM','1439-4235',3.138000,0.033040,3.766170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clay Min.','CLAY MINERALS','0009-8558',0.874000,0.001180,0.134140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Colloid Surf. A-Physicochem. Eng. Asp.','COLLOIDS AND SURFACES A-PHYSICOCHEMICAL AND ENGINEERING ASPECTS','0927-7757',2.760000,0.029500,3.362820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dokl. Phys. Chem.','DOKLADY PHYSICAL CHEMISTRY','0012-5016',0.642000,0.000660,0.075000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electrocatalysis','Electrocatalysis','1868-2529',2.347000,0.001550,0.176790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Hydrog. Energy','INTERNATIONAL JOURNAL OF HYDROGEN ENERGY','0360-3199',3.205000,0.089830,10.239160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Photoenergy','INTERNATIONAL JOURNAL OF PHOTOENERGY','1110-662X',1.226000,0.004420,0.503910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Intermetallics','INTERMETALLICS','0966-9795',2.541000,0.015830,1.804650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ionics','IONICS','0947-7047',2.119000,0.003890,0.442980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Soc. Mass Spectrom.','JOURNAL OF THE AMERICAN SOCIETY FOR MASS SPECTROMETRY','1044-0305',3.031000,0.015120,1.723240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Catal.','JOURNAL OF CATALYSIS','0021-9517',7.354000,0.034380,3.918400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Dispersion Sci. Technol.','JOURNAL OF DISPERSION SCIENCE AND TECHNOLOGY','0193-2691',1.112000,0.002780,0.317050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Liq.','JOURNAL OF MOLECULAR LIQUIDS','0167-7322',2.740000,0.010430,1.189180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Phys. Chem. A','JOURNAL OF PHYSICAL CHEMISTRY A','1089-5639',2.883000,0.080560,9.182420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Med. Educ.','BMC Medical Education','1472-6920',1.312000,0.006470,0.737300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Educ. Res. Pract.','Chemistry Education Research and Practice','1109-4028',1.802000,0.001640,0.187150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Dent. Educ.','European Journal of Dental Education','1396-5883',0.784000,0.001060,0.121370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biol. Educ.','JOURNAL OF BIOLOGICAL EDUCATION','0021-9266',0.507000,0.000430,0.048710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Teach.','MEDICAL TEACHER','0142-159X',2.355000,0.014070,1.603270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMJ Qual. Saf.','BMJ Quality & Safety','2044-5415',4.996000,0.013900,1.584750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Health Econ.','HEALTH ECONOMICS','1057-9230',2.151000,0.010440,1.189430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Health Serv. Res.','HEALTH SERVICES RESEARCH','0017-9124',2.865000,0.014710,1.676990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Acad. Nurse Pract.','Journal of the American Academy of Nurse Practitioners','1041-2972',1.346000,0.001590,0.181610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Aircr.','JOURNAL OF AIRCRAFT','0021-8669',0.701000,0.005140,0.585930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Helicopter Soc.','JOURNAL OF THE AMERICAN HELICOPTER SOCIETY','0002-8711',0.852000,0.001050,0.119940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Astronaut. Sci.','JOURNAL OF THE ASTRONAUTICAL SCIENCES','0021-9142',0.469000,0.000640,0.072470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Navigation','Navigation-Journal of the Institute of Navigation','0028-1522',0.979000,0.000660,0.075090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Potato Res.','AMERICAN JOURNAL OF POTATO RESEARCH','1099-209X',1.159000,0.001220,0.138770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Agric. Hortic.','BIOLOGICAL AGRICULTURE & HORTICULTURE','0144-8765',0.765000,0.000230,0.026740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biosci. J.','Bioscience Journal','1981-3163',0.218000,0.001270,0.145180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Crop Prot.','CROP PROTECTION','0261-2194',1.652000,0.008220,0.937070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Emir. J. Food Agric.','Emirates Journal of Food and Agriculture','2079-052X',0.623000,0.000990,0.112630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Plant Regist.','Journal of Plant Registrations','1936-5209',0.474000,0.000700,0.079670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pest Manag. Sci.','PEST MANAGEMENT SCIENCE','1526-498X',2.811000,0.013080,1.491040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Postharvest Biol. Technol.','POSTHARVEST BIOLOGY AND TECHNOLOGY','0925-5214',2.618000,0.008370,0.953460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photosynthetica','PHOTOSYNTHETICA','0300-3604',1.558000,0.002020,0.230430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physiol. Mol. Biol. Plants','PHYSIOLOGY AND MOLECULAR BIOLOGY OF PLANTS','0971-5894',1.351000,0.000980,0.111720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physiol. Plant.','PHYSIOLOGIA PLANTARUM','0031-9317',3.520000,0.009710,1.106840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytochem. Rev.','PHYTOCHEMISTRY REVIEWS','1568-7767',2.686000,0.003040,0.346130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Ecol. Evol.','Plant Ecology and Evolution','2032-3913',1.162000,0.000990,0.112980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Methods','Plant Methods','1746-4811',3.449000,0.003500,0.398590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Mol.Biol.','PLANT MOLECULAR BIOLOGY','0167-4412',3.905000,0.010970,1.250330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Soil','PLANT AND SOIL','0032-079X',2.969000,0.031810,3.625240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theor. Appl. Genet.','THEORETICAL AND APPLIED GENETICS','0040-5752',3.900000,0.017630,2.009600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trends Plant Sci.','TRENDS IN PLANT SCIENCE','1360-1385',10.899000,0.029730,3.389050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Mater.','NATURE MATERIALS','1476-1122',38.891000,0.207610,23.663220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Part. Part. Syst. Charact.','PARTICLE & PARTICLE SYSTEMS CHARACTERIZATION','0934-0866',4.367000,0.004100,0.466990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Chem. Chem. Phys.','PHYSICAL CHEMISTRY CHEMICAL PHYSICS','1463-9076',4.449000,0.192220,21.909510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiat. Phys. Chem.','RADIATION PHYSICS AND CHEMISTRY','0969-806X',1.207000,0.007760,0.884790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Technol. Energ. Mater.','Science and Technology of Energetic Materials','1347-9466',0.636000,0.000150,0.016700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surf. Interface Anal.','SURFACE AND INTERFACE ANALYSIS','0142-2421',1.018000,0.007200,0.821130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surf. Rev. Lett.','SURFACE REVIEW AND LETTERS','0218-625X',0.435000,0.000390,0.044680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theor. Chem. Acc.','THEORETICAL CHEMISTRY ACCOUNTS','1432-881X',1.806000,0.008150,0.929270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Top. Catal.','TOPICS IN CATALYSIS','1022-5528',2.355000,0.009130,1.040760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Z. Phys. Chemie-Int. J. Res. Phys. Chem. Chem. Phys.','ZEITSCHRIFT FUR PHYSIKALISCHE CHEMIE-INTERNATIONAL JOURNAL OF RESEARCH IN PHYSICAL CHEMISTRY & CHEMICAL PHYSICS','0942-9352',1.183000,0.002390,0.271890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Auton. Adapt. Syst.','ACM Transactions on Autonomous and Adaptive Systems','1556-4665',1.118000,0.000780,0.088640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Artif. Intell.','APPLIED ARTIFICIAL INTELLIGENCE','0883-9514',0.540000,0.000470,0.053810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Intell.','APPLIED INTELLIGENCE','0924-669X',1.215000,0.002120,0.241250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Rural Health','JOURNAL OF RURAL HEALTH','0890-765X',1.279000,0.002450,0.279300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Educ.','MEDICAL EDUCATION','0308-0110',3.369000,0.013520,1.540620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Methods Med. Res.','STATISTICAL METHODS IN MEDICAL RESEARCH','0962-2802',4.634000,0.007400,0.842960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Technol. Health Care','TECHNOLOGY AND HEALTH CARE','0928-7329',0.678000,0.000890,0.101020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electroanalysis','ELECTROANALYSIS','1040-0397',2.471000,0.011210,1.278160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. New Mat.Electrochem. Syst.','JOURNAL OF NEW MATERIALS FOR ELECTROCHEMICAL SYSTEMS','1480-2422',0.433000,0.000350,0.040260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sensors','SENSORS','1424-8220',2.033000,0.037230,4.243090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Turk. J. Agric. For.','Turkish Journal of Agriculture and Forestry','1300-011X',1.311000,0.001710,0.194470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Exp. Allergy','CLINICAL AND EXPERIMENTAL ALLERGY','0954-7894',5.587000,0.015870,1.808990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Asthma','JOURNAL OF ASTHMA','0277-0903',1.854000,0.005880,0.670110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Morphol.','INTERNATIONAL JOURNAL OF MORPHOLOGY','0717-9502',0.299000,0.000990,0.113370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Anat.','JOURNAL OF ANATOMY','0021-8782',2.154000,0.007730,0.881390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asian J. Androl.','ASIAN JOURNAL OF ANDROLOGY','1008-682X',2.644000,0.006110,0.696650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anaesth. Intensive Care','ANAESTHESIA AND INTENSIVE CARE','0310-057X',1.283000,0.003730,0.424630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anesthesiology','ANESTHESIOLOGY','0003-3022',5.555000,0.033720,3.843130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Fr. Anest. Reanim.','ANNALES FRANCAISES D ANESTHESIE ET DE REANIMATION','0750-7658',0.917000,0.001970,0.224720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Anaesth.','EUROPEAN JOURNAL OF ANAESTHESIOLOGY','0265-0215',3.634000,0.005750,0.654900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Turk. J. Bot.','TURKISH JOURNAL OF BOTANY','1300-008X',1.178000,0.001640,0.186820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Cancer Res.','American Journal of Cancer Research','2156-6976',3.425000,0.003680,0.419800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Transl. Res.','American Journal of Translational Research','1943-8141',3.146000,0.003600,0.410810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Birth Defects Res. Part B-Dev. Reprod. Toxicol.','BIRTH DEFECTS RESEARCH PART B-DEVELOPMENTAL AND REPRODUCTIVE TOXICOLOGY','1542-9733',0.965000,0.001180,0.133930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brain Tumor Pathol.','Brain Tumor Pathology','1433-7398',1.202000,0.001200,0.137220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Chemother. Pharmacol.','CANCER CHEMOTHERAPY AND PHARMACOLOGY','0344-5704',2.824000,0.016720,1.905500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Lett.','CANCER LETTERS','0304-3835',5.992000,0.037570,4.282010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Med.','Cancer Medicine','2045-7634',2.915000,0.004040,0.460220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Res.','CANCER RESEARCH','0008-5472',8.556000,0.180760,20.603230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Treat. Rev.','CANCER TREATMENT REVIEWS','0305-7372',7.983000,0.014690,1.674890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer','CANCER','0008-543X',5.649000,0.088180,10.050580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell. Oncol.','CELLULAR ONCOLOGY','2211-3428',3.562000,0.002090,0.237750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Cancer Res.','Chinese Journal of Cancer Research','1000-9604',2.201000,0.001840,0.209620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Artif. Intell.','ARTIFICIAL INTELLIGENCE','0004-3702',3.333000,0.009000,1.025710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chemometrics Intell. Lab. Syst.','CHEMOMETRICS AND INTELLIGENT LABORATORY SYSTEMS','0169-7439',2.217000,0.007080,0.807430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Linguist.','COMPUTATIONAL LINGUISTICS','0891-2017',2.017000,0.001960,0.223760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Connect. Sci.','CONNECTION SCIENCE','0954-0091',1.125000,0.000220,0.025470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Appl. Artif. Intell.','ENGINEERING APPLICATIONS OF ARTIFICIAL INTELLIGENCE','0952-1976',2.368000,0.008700,0.992050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Intell. Syst.','IEEE INTELLIGENT SYSTEMS','1541-1672',3.532000,0.003500,0.398510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Comput. Intell. Syst.','International Journal of Computational Intelligence Systems','1875-6891',0.391000,0.001120,0.127260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Doc. Anal. Recognit.','International Journal on Document Analysis and Recognition','1433-2833',0.885000,0.000630,0.071300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Uncertainty Fuzziness Knowl.-Based Syst.','INTERNATIONAL JOURNAL OF UNCERTAINTY FUZZINESS AND KNOWLEDGE-BASED SYSTEMS','0218-4885',1.000000,0.001210,0.138070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Evol. Appl.','Evolutionary Applications','1752-4571',4.572000,0.010580,1.205830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Evol. Ecol.','EVOLUTIONARY ECOLOGY','0269-7653',1.875000,0.006140,0.699670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Evol. Ecol. Res.','EVOLUTIONARY ECOLOGY RESEARCH','1522-0613',0.585000,0.001570,0.178480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Syst. Palaeontol.','JOURNAL OF SYSTEMATIC PALAEONTOLOGY','1477-2019',3.143000,0.003100,0.353130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wiley Interdiscip. Rev.-Dev. Biol.','Wiley Interdisciplinary Reviews-Developmental Biology','1759-7684',4.711000,0.003150,0.359380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Zygote','ZYGOTE','0967-1994',1.370000,0.001370,0.156590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Antioxid. Redox Signal.','ANTIOXIDANTS & REDOX SIGNALING','1523-0864',7.093000,0.045430,5.178420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiothorac. Vasc. Anesth.','JOURNAL OF CARDIOTHORACIC AND VASCULAR ANESTHESIA','1053-0770',1.519000,0.006860,0.782150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Minerva Anestesiol.','Minerva Anestesiologica','0375-9393',2.036000,0.005410,0.616070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pain','PAIN','0304-3959',5.557000,0.046470,5.296320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Peabody Mus. Natl. Hist.','Bulletin of the Peabody Museum of Natural History','0079-032X',1.217000,0.000500,0.057410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Conserv. Genet.','CONSERVATION GENETICS','1566-0621',2.040000,0.007510,0.855640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Divers. Distrib.','DIVERSITY AND DISTRIBUTIONS','1366-9516',4.566000,0.017200,1.960790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nat. Conserv.','JOURNAL FOR NATURE CONSERVATION','1617-1381',2.220000,0.002690,0.306110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nat. Hist.','JOURNAL OF NATURAL HISTORY','0022-2933',1.010000,0.003800,0.433170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Koedoe','KOEDOE','0075-6458',1.412000,0.000600,0.067940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Conserv.','Natureza & Conservacao','1679-0073',1.000000,0.001020,0.116620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pachyderm','PACHYDERM','1026-2881',0.405000,0.000180,0.019990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Chil. Hist. Nat.','REVISTA CHILENA DE HISTORIA NATURAL','0716-078X',0.738000,0.000790,0.090340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Syst. Biodivers.','SYSTEMATICS AND BIODIVERSITY','1477-2000',1.985000,0.002120,0.241130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Astron. J.','ASTRONOMICAL JOURNAL','0004-6256',4.617000,0.062910,7.170640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Astrophysics','ASTROPHYSICS','0571-7256',0.735000,0.000540,0.062010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Cancer Drug Targets','CURRENT CANCER DRUG TARGETS','1568-0096',3.707000,0.005250,0.598830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('EJSO','EJSO','0748-7983',2.940000,0.013050,1.487240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Cell Res.','EXPERIMENTAL CELL RESEARCH','0014-4827',3.378000,0.025120,2.862670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Future Oncol.','Future Oncology','1479-6694',2.129000,0.008650,0.985960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hematol. Oncol.','HEMATOLOGICAL ONCOLOGY','0278-0232',3.494000,0.002380,0.271010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Breast Canc.','Journal of Breast Cancer','1738-6756',1.854000,0.002040,0.232720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neuro-Oncol.','JOURNAL OF NEURO-ONCOLOGY','0167-594X',2.754000,0.019470,2.218940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mach. Learn. Res.','JOURNAL OF MACHINE LEARNING RESEARCH','1532-4435',2.450000,0.032400,3.692960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Minds Mach.','MINDS AND MACHINES','0924-6495',0.769000,0.000400,0.046090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Netw.-Comput. Neural Syst.','NETWORK-COMPUTATION IN NEURAL SYSTEMS','0954-898X',0.647000,0.000280,0.031680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Hum.-Comput. Stud.','INTERNATIONAL JOURNAL OF HUMAN-COMPUTER STUDIES','1071-5819',1.476000,0.002870,0.326570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. J.','COMPUTER JOURNAL','0010-4620',1.000000,0.004040,0.460580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arq. Bras. Endocrinol. Metabol.','Arquivos Brasileiros de Endocrinologia e Metabologia','0004-2730',1.028000,0.002100,0.239510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comp. Biochem. Physiol. C-Toxicol. Pharmacol.','COMPARATIVE BIOCHEMISTRY AND PHYSIOLOGY C-TOXICOLOGY & PHARMACOLOGY','1532-0456',2.546000,0.004790,0.546190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Clin. Nutr. Metab. Care','CURRENT OPINION IN CLINICAL NUTRITION AND METABOLIC CARE','1363-1950',4.033000,0.008880,1.011750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Diabetes Metab.','DIABETES & METABOLISM','1262-3636',4.693000,0.005890,0.670890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Diabetes Res. Clin. Pract.','DIABETES RESEARCH AND CLINICAL PRACTICE','0168-8227',3.045000,0.021500,2.451030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Diabetes-Metab. Res. Rev.','DIABETES-METABOLISM RESEARCH AND REVIEWS','1520-7560',3.064000,0.008300,0.945770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Domest. Anim. Endocrinol.','DOMESTIC ANIMAL ENDOCRINOLOGY','0739-7240',1.613000,0.002600,0.295800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endocr. J.','ENDOCRINE JOURNAL','0918-8959',1.895000,0.005560,0.633320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Islets','Islets','1938-2014',2.408000,0.002580,0.293790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oncogenesis','Oncogenesis','2157-9024',5.021000,0.002930,0.333490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oncologist','ONCOLOGIST','1083-7159',4.789000,0.023240,2.649020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oncology-NY','ONCOLOGY-NEW YORK','0890-9091',2.967000,0.003290,0.375420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('OncoTargets Ther.','OncoTargets and Therapy','1178-6930',2.272000,0.004120,0.470000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiat. Oncol.','Radiation Oncology','1748-717X',2.466000,0.014060,1.603040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Radiat. Oncol.','SEMINARS IN RADIATION ONCOLOGY','1053-4296',3.556000,0.003900,0.444720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Cardiol. Sin.','Acta Cardiologica Sinica','1011-6842',0.201000,0.000210,0.023820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Cardiovasc. Drugs','American Journal of Cardiovascular Drugs','1175-3277',2.233000,0.001780,0.202840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IBM J. Res. Dev.','IBM JOURNAL OF RESEARCH AND DEVELOPMENT','0018-8646',0.626000,0.001840,0.209260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Reliab.','IEEE TRANSACTIONS ON RELIABILITY','0018-9529',2.287000,0.006190,0.705180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEICE Trans. Fundam. Electron. Commun. Comput. Sci.','IEICE TRANSACTIONS ON FUNDAMENTALS OF ELECTRONICS COMMUNICATIONS AND COMPUTER SCIENCES','1745-1337',0.236000,0.002520,0.287350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Circuits Syst. Comput.','JOURNAL OF CIRCUITS SYSTEMS AND COMPUTERS','0218-1266',0.308000,0.000540,0.061240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Sci. Technol.','JOURNAL OF COMPUTER SCIENCE AND TECHNOLOGY','1000-9000',0.475000,0.001560,0.178340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sust. Comput.','Sustainable Computing-Informatics & Systems','2210-5379',0.569000,0.000540,0.061780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Sens. Netw.','ACM Transactions on Sensor Networks','1550-4859',1.448000,0.003360,0.383220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ad Hoc Sens. Wirl. Netw.','Ad Hoc & Sensor Wireless Networks','1551-9899',0.587000,0.000430,0.049290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bus. Inf. Syst. Eng.','Business & Information Systems Engineering','1867-0202',2.059000,0.000760,0.087060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. J.','COMPUTER JOURNAL','0010-4620',1.000000,0.004040,0.460580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Secur.','COMPUTERS & SECURITY','0167-4048',1.640000,0.002490,0.283430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Digit. Investig.','Digital Investigation','1742-2876',1.211000,0.000640,0.072790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Diabetes Investig.','Journal of Diabetes Investigation','2040-1116',2.294000,0.003400,0.388090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Endocrinol.','JOURNAL OF ENDOCRINOLOGY','0022-0795',4.498000,0.013250,1.510680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Endocrinol.','JOURNAL OF MOLECULAR ENDOCRINOLOGY','0952-5041',2.947000,0.005830,0.664840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lancet Diabetes Endocrinol.','Lancet Diabetes & Endocrinology','2213-8587',16.320000,0.011290,1.286320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Metab. Brain Dis.','METABOLIC BRAIN DISEASE','0885-7490',2.603000,0.003840,0.437820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Metab.-Clin. Exp.','METABOLISM-CLINICAL AND EXPERIMENTAL','0026-0495',4.375000,0.016120,1.837520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Genet. Metab.','MOLECULAR GENETICS AND METABOLISM','1096-7192',3.093000,0.014350,1.635210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuroendocrinology','NEUROENDOCRINOLOGY','0028-3835',2.583000,0.005640,0.642550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Obesity','Obesity','1930-7381',3.614000,0.041400,4.718620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Endocr. Metab. Disord.','REVIEWS IN ENDOCRINE & METABOLIC DISORDERS','1389-9155',5.088000,0.003560,0.406060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vitam. Horm.','Vitamins and Hormones','0083-6729',2.161000,0.002490,0.283490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biofuels Bioprod. Biorefining','Biofuels Bioproducts & Biorefining-Biofpr','1932-104X',4.416000,0.005410,0.616950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Conv. Manag.','ENERGY CONVERSION AND MANAGEMENT','0196-8904',4.801000,0.033620,3.832110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Sources Part B','Energy Sources Part B-Economics Planning and Policy','1556-7249',0.579000,0.000540,0.061170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energies','Energies','1996-1073',2.077000,0.010840,1.235210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cosmic Res.','COSMIC RESEARCH','0010-9525',0.610000,0.000840,0.095830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('C. R. Phys.','COMPTES RENDUS PHYSIQUE','1631-0705',2.081000,0.005280,0.601450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Earth Moon Planets','EARTH MOON AND PLANETS','0167-9295',0.659000,0.000450,0.051310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Korean Astron. Soc.','Journal of the Korean Astronomical Society','1225-4614',0.655000,0.000660,0.074810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mon. Not. Roy. Astron. Soc.','MONTHLY NOTICES OF THE ROYAL ASTRONOMICAL SOCIETY','0035-8711',4.952000,0.302830,34.516230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Publ. Astron. Soc. Aust.','PUBLICATIONS OF THE ASTRONOMICAL SOCIETY OF AUSTRALIA','1323-3580',3.245000,0.004490,0.511730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Publ. Astron. Soc. Jpn.','PUBLICATIONS OF THE ASTRONOMICAL SOCIETY OF JAPAN','0004-6264',1.961000,0.010180,1.160190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Serb. Astron. J.','Serbian Astronomical Journal','1450-698X',0.429000,0.000070,0.008370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solar Syst. Res.','SOLAR SYSTEM RESEARCH','0038-0946',0.638000,0.000970,0.110000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Augment. Altern. Commun.','Augmentative and Alternative Communication','0743-4618',2.960000,0.000720,0.082300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brain Lang.','BRAIN AND LANGUAGE','0093-934X',3.038000,0.009240,1.053070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trends Amplif.','Trends in Amplification','1084-7138',2.500000,0.000790,0.089540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Advan. Study Behav.','Advances in the Study of Behavior','0065-3454',1.933000,0.000790,0.089480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiovasc. Interv. Radiol.','CARDIOVASCULAR AND INTERVENTIONAL RADIOLOGY','0174-1551',2.144000,0.009040,1.030780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiovasc. Toxicol.','Cardiovascular Toxicology','1530-7905',2.063000,0.001680,0.191020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Circ.-Cardiovasc. Imaging','Circulation-Cardiovascular Imaging','1941-9651',5.771000,0.018570,2.116710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Circ.-Cardiovasc. Qual. Outcomes','Circulation-Cardiovascular Quality and Outcomes','1941-7705',4.282000,0.020250,2.308350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Circ.-Heart Fail.','Circulation-Heart Failure','1941-3289',6.833000,0.023050,2.627700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Cardiol. Rep.','Current Cardiology Reports','1523-3782',1.830000,0.003880,0.441850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Heart J.','EUROPEAN HEART JOURNAL','0195-668X',15.064000,0.129610,14.773300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Heart Fail.','EUROPEAN JOURNAL OF HEART FAILURE','1388-9842',5.135000,0.022760,2.594060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heart Fail. Rev.','HEART FAILURE REVIEWS','1382-4147',3.611000,0.005180,0.590180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heart Lung Circ.','Heart Lung and Circulation','1443-9506',1.575000,0.004290,0.489260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Cardiol.','INTERNATIONAL JOURNAL OF CARDIOLOGY','0167-5273',4.638000,0.057180,6.517540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Coll. Cardiol.','JOURNAL OF THE AMERICAN COLLEGE OF CARDIOLOGY','0735-1097',17.759000,0.214600,24.460240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiol.','Journal of Cardiology','0914-5087',2.405000,0.004950,0.564490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Syst. Front.','INFORMATION SYSTEMS FRONTIERS','1387-3326',1.450000,0.001540,0.176010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Internet Technol.','Journal of Internet Technology','1607-9264',0.533000,0.000360,0.040750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Organ. Comp. Electron. Commer.','JOURNAL OF ORGANIZATIONAL COMPUTING AND ELECTRONIC COMMERCE','1091-9392',0.944000,0.000310,0.035000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Zhejiang Univ.-SCI. C.','Journal of Zhejiang University-SCIENCE C-Computers & Electronics','1869-1951',0.392000,0.000910,0.103520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Knowl. Inf. Syst.','KNOWLEDGE AND INFORMATION SYSTEMS','0219-1377',1.702000,0.004930,0.562480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fuel Process. Technol.','FUEL PROCESSING TECHNOLOGY','0378-3820',3.847000,0.021290,2.426180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Green Energy','International Journal of Green Energy','1543-5075',1.601000,0.001160,0.132040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Hydrog. Energy','INTERNATIONAL JOURNAL OF HYDROGEN ENERGY','0360-3199',3.205000,0.089830,10.239160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Photoenergy','INTERNATIONAL JOURNAL OF PHOTOENERGY','1110-662X',1.226000,0.004420,0.503910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Energy Chem.','Journal of Energy Chemistry','2095-4956',2.322000,0.001630,0.185350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Jpn. Pet. Inst','JOURNAL OF THE JAPAN PETROLEUM INSTITUTE','1346-8804',0.605000,0.000480,0.054650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mater. Chem. A','Journal of Materials Chemistry A','2050-7488',8.262000,0.109000,12.423570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pet. Sci. Eng.','JOURNAL OF PETROLEUM SCIENCE AND ENGINEERING','0920-4105',1.655000,0.008750,0.997550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Power Sources','JOURNAL OF POWER SOURCES','0378-7753',6.333000,0.132720,15.126910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oil Gas J.','OIL & GAS JOURNAL','0030-1388',0.066000,0.000920,0.105390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Combust. Inst.','PROCEEDINGS OF THE COMBUSTION INSTITUTE','1540-7489',4.120000,0.017070,1.945390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Civ. Eng.-Energy','Proceedings of the Institution of Civil Engineers-Energy','1751-4223',0.744000,0.000370,0.042650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Renew. Energy','RENEWABLE ENERGY','0960-1481',3.404000,0.037280,4.249080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wind Energy','WIND ENERGY','1095-4244',2.891000,0.005560,0.633310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Polytech. Hung.','Acta Polytechnica Hungarica','1785-8860',0.544000,0.000680,0.077240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CMC-Comput. Mat. Contin.','CMC-Computers Materials & Continua','1546-2218',0.475000,0.001210,0.137390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Meth. Appl. Mech. Eng.','COMPUTER METHODS IN APPLIED MECHANICS AND ENGINEERING','0045-7825',3.467000,0.033530,3.821590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Design Stud.','DESIGN STUDIES','0142-694X',2.070000,0.001330,0.151320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Anal. Bound. Elem.','ENGINEERING ANALYSIS WITH BOUNDARY ELEMENTS','0955-7997',1.862000,0.006230,0.709550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brain Behav. Evol.','BRAIN BEHAVIOR AND EVOLUTION','0006-8977',2.103000,0.002480,0.282790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Senses','CHEMICAL SENSES','0379-864X',2.500000,0.004620,0.526080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cogn. Affect. Behav. Neurosci.','COGNITIVE AFFECTIVE & BEHAVIORAL NEUROSCIENCE','1530-7026',2.886000,0.006810,0.776650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cogn. Behav. Neurol.','Cognitive and Behavioral Neurology','1543-3633',1.185000,0.000900,0.102980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Behav. Neurosci.','Frontiers in Behavioral Neuroscience','1662-5153',3.392000,0.015280,1.742100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Exp. Anal. Behav.','JOURNAL OF THE EXPERIMENTAL ANALYSIS OF BEHAVIOR','0022-5002',2.171000,0.002560,0.292020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurobiol. Learn. Mem.','NEUROBIOLOGY OF LEARNING AND MEMORY','1074-7427',3.439000,0.012000,1.368230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurosci. Biobehav. Rev.','NEUROSCIENCE AND BIOBEHAVIORAL REVIEWS','0149-7634',8.580000,0.045210,5.152760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stress','STRESS-THE INTERNATIONAL JOURNAL ON THE BIOLOGY OF STRESS','1025-3890',2.383000,0.004240,0.483470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Crystallogr. Sect. D-Struct. Biol.','Acta Crystallographica Section D-Structural Biology','2059-7983',2.512000,0.077270,8.806800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomed. Opt. Express','Biomedical Optics Express','2156-7085',3.344000,0.019490,2.221740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Bioinformatics','BMC BIOINFORMATICS','1471-2105',2.435000,0.067930,7.742880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Breath Res.','Journal of Breath Research','1752-7155',4.177000,0.002360,0.269130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chromatogr. A','JOURNAL OF CHROMATOGRAPHY A','0021-9673',3.926000,0.067070,7.644790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Graph.','JOURNAL OF MOLECULAR GRAPHICS & MODELLING','1093-3263',1.674000,0.003930,0.447980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiovasc. Nurs.','Journal of Cardiovascular Nursing','0889-4655',2.172000,0.003150,0.359410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiovasc. Surg.','JOURNAL OF CARDIOVASCULAR SURGERY','0021-9509',1.632000,0.003780,0.430720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Electrocardiol.','JOURNAL OF ELECTROCARDIOLOGY','0022-0736',1.290000,0.002970,0.338760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Invasive Cardiol.','JOURNAL OF INVASIVE CARDIOLOGY','1042-3931',1.112000,0.004380,0.498840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Cardiovasc. Dis.','PROGRESS IN CARDIOVASCULAR DISEASES','0033-0620',4.635000,0.006430,0.733040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Bras. Cir. Cardiovasc.','Revista Brasileira de Cirurgia Cardiovascular','0102-7638',0.526000,0.001020,0.116360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Histochem. Cytochem.','ACTA HISTOCHEMICA ET CYTOCHEMICA','0044-5991',0.912000,0.000700,0.080180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anim. Cells Syst.','Animal Cells and Systems','1976-8354',0.481000,0.000380,0.043050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochim. Biophys. Acta Mol. Cell Biol. Lipids','BIOCHIMICA ET BIOPHYSICA ACTA-MOLECULAR AND CELL BIOLOGY OF LIPIDS','1388-1981',4.779000,0.018360,2.093200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochim. Biophys. Acta-Mol. Cell Res.','BIOCHIMICA ET BIOPHYSICA ACTA-MOLECULAR CELL RESEARCH','0167-4889',5.128000,0.033630,3.833540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biopreserv. Biobank.','Biopreservation and Biobanking','1947-5535',1.804000,0.001020,0.115940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell','CELL','0092-8674',28.710000,0.555090,63.268790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Biochem. Biophys.','CELL BIOCHEMISTRY AND BIOPHYSICS','1085-9195',1.627000,0.006880,0.784570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Multimedia Syst.','MULTIMEDIA SYSTEMS','0942-4962',1.410000,0.001210,0.138290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pervasive Mob. Comput.','Pervasive and Mobile Computing','1574-1192',1.719000,0.003290,0.374690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Eng. Softw.','ADVANCES IN ENGINEERING SOFTWARE','0965-9978',1.673000,0.005400,0.615270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CIN-Comput. Inform. Nurs.','CIN-COMPUTERS INFORMATICS NURSING','1538-2931',0.868000,0.001430,0.162970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Ind. Eng.','COMPUTERS & INDUSTRIAL ENGINEERING','0360-8352',2.086000,0.013190,1.502870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Methods Biomech. Biomed. Eng.','COMPUTER METHODS IN BIOMECHANICS AND BIOMEDICAL ENGINEERING','1025-5842',1.850000,0.005270,0.600740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Oper. Res.','COMPUTERS & OPERATIONS RESEARCH','0305-0548',1.988000,0.016530,1.883990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Geosci.','COMPUTATIONAL GEOSCIENCES','1420-0597',1.992000,0.004620,0.526700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE-ACM Trans. Comput. Biol. Bioinform.','IEEE-ACM Transactions on Computational Biology and Bioinformatics','1545-5963',1.609000,0.005810,0.662280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Ind. Inform.','IEEE Transactions on Industrial Informatics','1551-3203',4.708000,0.016350,1.863870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Learn. Technol.','IEEE Transactions on Learning Technologies','1939-1382',1.129000,0.001100,0.125020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Med. Imaging','IEEE TRANSACTIONS ON MEDICAL IMAGING','0278-0062',3.756000,0.024430,2.784400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fire Technol.','FIRE TECHNOLOGY','0015-2684',1.016000,0.001510,0.171550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Ind. Appl.','IEEE TRANSACTIONS ON INDUSTRY APPLICATIONS','0093-9994',1.901000,0.017360,1.978350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ing. Invest.','Ingenieria e Investigacion','0120-5609',0.278000,0.000120,0.013870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Instrum. Exp. Tech.','INSTRUMENTS AND EXPERIMENTAL TECHNIQUES','0020-4412',0.353000,0.001160,0.131780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Fire Sci.','JOURNAL OF FIRE SCIENCES','0734-9041',0.758000,0.000870,0.099110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ind. Manag. Optim.','Journal of Industrial and Management Optimization','1547-5816',0.776000,0.001430,0.162720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Health Monit.','STRUCTURAL HEALTH MONITORING-AN INTERNATIONAL JOURNAL','1475-9217',3.193000,0.003620,0.412420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Bioeng. Biomech.','Acta of Bioengineering and Biomechanics','1509-409X',0.767000,0.000710,0.081140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Biomed. Eng.','ANNALS OF BIOMEDICAL ENGINEERING','0090-6964',2.887000,0.017640,2.011020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Artif. Intell. Med.','ARTIFICIAL INTELLIGENCE IN MEDICINE','0933-3657',2.142000,0.002640,0.301470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomed. Eng.-Biomed. Tech.','Biomedical Engineering-Biomedizinische Technik','0013-5585',1.650000,0.001720,0.196470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('PLoS Comput. Biol.','PLoS Computational Biology','1553-734X',4.587000,0.085170,9.707730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proteome Sci.','Proteome Science','1477-5956',1.746000,0.002990,0.340400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proteomics','PROTEOMICS','1615-9853',4.079000,0.027450,3.128620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transgenic Res.','TRANSGENIC RESEARCH','0962-8819',2.054000,0.004020,0.457680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Carbohydr .Chem. Biochem.','Advances in Carbohydrate Chemistry and Biochemistry','0065-2318',3.667000,0.000590,0.067360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Antioxid. Redox Signal.','ANTIOXIDANTS & REDOX SIGNALING','1523-0864',7.093000,0.045430,5.178420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochim. Biophys. Acta-Biomembr.','BIOCHIMICA ET BIOPHYSICA ACTA-BIOMEMBRANES','0005-2736',3.687000,0.027230,3.103650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochem. Mol. Biol. Educ.','BIOCHEMISTRY AND MOLECULAR BIOLOGY EDUCATION','1470-8175',0.465000,0.000670,0.075810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochemistry','BIOCHEMISTRY','0006-2960',2.876000,0.083130,9.475210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biofactors','BIOFACTORS','0951-6433',4.504000,0.004060,0.462830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomacromolecules','BIOMACROMOLECULES','1525-7797',5.583000,0.052460,5.979620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioorganic Chem.','BIOORGANIC CHEMISTRY','0045-2068',2.252000,0.001910,0.217560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Commun. Signal.','Cell Communication and Signaling','1478-811X',3.661000,0.005620,0.640290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Death Dis.','Cell Death & Disease','2041-4889',5.378000,0.035690,4.067750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell. Oncol.','CELLULAR ONCOLOGY','2211-3428',3.562000,0.002090,0.237750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell. Physiol. Biochem.','CELLULAR PHYSIOLOGY AND BIOCHEMISTRY','1015-8987',4.652000,0.012220,1.392810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Connect. Tissue Res.','CONNECTIVE TISSUE RESEARCH','0300-8207',1.411000,0.002280,0.259870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Biol.','CURRENT BIOLOGY','0960-9822',8.983000,0.141790,16.161020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cytoskeleton','Cytoskeleton','1949-3584',2.316000,0.006260,0.712980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('FEBS Lett.','FEBS LETTERS','0014-5793',3.519000,0.059610,6.794060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Biosci.','Frontiers in Bioscience-Landmark','1093-9946',2.484000,0.008880,1.012030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genes Cells','GENES TO CELLS','1356-9597',2.481000,0.006930,0.790050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IET Syst. Biol.','IET Systems Biology','1751-8849',0.764000,0.000890,0.101940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomed. Inform.','JOURNAL OF BIOMEDICAL INFORMATICS','1532-0464',2.447000,0.008090,0.922320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput.-Aided Mol. Des.','JOURNAL OF COMPUTER-AIDED MOLECULAR DESIGN','0920-654X',3.199000,0.006010,0.684470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Netw. Comput. Appl.','JOURNAL OF NETWORK AND COMPUTER APPLICATIONS','1084-8045',2.331000,0.007870,0.896960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Inf.','Molecular Informatics','1868-1743',1.570000,0.002660,0.303200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Soc. Sci. Comput. Rev.','SOCIAL SCIENCE COMPUTER REVIEW','0894-4393',1.525000,0.002110,0.240770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Anal. Data Min.','Statistical Analysis and Data Mining','1932-1864',0.574000,0.001910,0.217560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Virtual Real.','VIRTUAL REALITY','1359-4338',0.568000,0.000580,0.065690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Math. Softw.','ACM TRANSACTIONS ON MATHEMATICAL SOFTWARE','0098-3500',1.879000,0.004670,0.532040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Comput.','Advances in Computers','0065-2458',0.256000,0.000450,0.051560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Eng. Softw.','ADVANCES IN ENGINEERING SOFTWARE','0965-9978',1.673000,0.005400,0.615270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Automat. Softw. Eng.','Automated Software Engineering','0928-8910',1.312000,0.000930,0.106080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Tissue Banking','CELL AND TISSUE BANKING','1389-9333',1.248000,0.001390,0.158860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Meth. Programs Biomed.','COMPUTER METHODS AND PROGRAMS IN BIOMEDICINE','0169-2607',1.862000,0.007960,0.906820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Expert Rev. Med. Devices','Expert Review of Medical Devices','1743-4440',1.762000,0.002810,0.320280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Biomed. Circuits Syst.','IEEE Transactions on Biomedical Circuits and Systems','1932-4545',2.018000,0.006200,0.706680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomech. Eng.-Trans. ASME','JOURNAL OF BIOMECHANICAL ENGINEERING-TRANSACTIONS OF THE ASME','0148-0731',1.747000,0.007410,0.844940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Eng. Phys.','MEDICAL ENGINEERING & PHYSICS','1350-4533',1.619000,0.008460,0.963890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Organogenesis','Organogenesis','1547-6278',2.910000,0.002440,0.278070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physiol. Meas.','PHYSIOLOGICAL MEASUREMENT','0967-3334',1.576000,0.005600,0.638770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ultrason. Imaging','ULTRASONIC IMAGING','0161-7346',2.111000,0.000750,0.085080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ambio','AMBIO','0044-7447',2.555000,0.007750,0.882790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Eng. Sci.','ENVIRONMENTAL ENGINEERING SCIENCE','1092-8758',1.481000,0.002360,0.268870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem. Technol. Biotechnol.','JOURNAL OF CHEMICAL TECHNOLOGY AND BIOTECHNOLOGY','0268-2575',2.738000,0.010510,1.198040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biotechnol. Appl. Biochem.','BIOTECHNOLOGY AND APPLIED BIOCHEMISTRY','0885-4513',1.429000,0.001740,0.198160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem.-Biol. Interact.','CHEMICO-BIOLOGICAL INTERACTIONS','0009-2797',2.618000,0.011450,1.305540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ChemBioChem','CHEMBIOCHEM','1439-4227',2.850000,0.023780,2.710810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chemoecology','CHEMOECOLOGY','0937-7409',1.863000,0.001250,0.142390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comp. Biochem. Physiol. C-Toxicol. Pharmacol.','COMPARATIVE BIOCHEMISTRY AND PHYSIOLOGY C-TOXICOLOGY & PHARMACOLOGY','1532-0456',2.546000,0.004790,0.546190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Top. Membr.','Current Topics in Membranes','1063-5823',3.881000,0.001990,0.227310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Diagn. Mol. Pathol.','DIAGNOSTIC MOLECULAR PATHOLOGY','1052-9551',1.474000,0.001060,0.120560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dokl. Biochem. Biophys.','Doklady Biochemistry and Biophysics','1607-6729',0.394000,0.000480,0.054500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Embo J.','EMBO JOURNAL','0261-4189',9.643000,0.106940,12.189350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Expert Opin. Drug Metab. Toxicol.','Expert Opinion on Drug Metabolism & Toxicology','1742-5255',2.598000,0.006180,0.704420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Faseb J.','FASEB JOURNAL','0892-6638',5.299000,0.064270,7.325740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cell Sci.','JOURNAL OF CELL SCIENCE','0021-9533',4.706000,0.083310,9.495750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Recept. Signal Transduct.','JOURNAL OF RECEPTORS AND SIGNAL TRANSDUCTION','1079-9893',1.782000,0.001480,0.168690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Tissue Eng. Regen. Med.','Journal of Tissue Engineering and Regenerative Medicine','1932-6254',4.710000,0.007260,0.827990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Cancer Res.','MOLECULAR CANCER RESEARCH','1541-7786',4.510000,0.017020,1.940170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Reprod. Dev.','MOLECULAR REPRODUCTION AND DEVELOPMENT','1040-452X',2.141000,0.004970,0.566350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Struct. Mol. Biol.','NATURE STRUCTURAL & MOLECULAR BIOLOGY','1545-9993',13.338000,0.103970,11.850120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Cell','PLANT CELL','1040-4651',8.538000,0.075120,8.562470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stem Cell Res. Ther.','Stem Cell Research & Therapy','1757-6512',4.504000,0.006790,0.774060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Structure','STRUCTURE','0969-2126',5.237000,0.042980,4.898630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Lang. Syst. Struct.','COMPUTER LANGUAGES SYSTEMS & STRUCTURES','1477-8424',0.556000,0.000160,0.018030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Graph. Models','GRAPHICAL MODELS','1524-0703',0.821000,0.001160,0.132070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Inf. Secur.','International Journal of Information Security','1615-5262',1.279000,0.000980,0.112100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Program. Comput. Softw.','PROGRAMMING AND COMPUTER SOFTWARE','0361-7688',0.390000,0.000340,0.039280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Polym. Environ.','JOURNAL OF POLYMERS AND THE ENVIRONMENT','1566-2543',1.969000,0.003450,0.393140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Terramech.','JOURNAL OF TERRAMECHANICS','0022-4898',1.306000,0.000890,0.101890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Waste Manage. Res.','WASTE MANAGEMENT & RESEARCH','0734-242X',1.338000,0.003550,0.405190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Environ. Res.','WATER ENVIRONMENT RESEARCH','1061-4303',0.659000,0.002210,0.252140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Sci. Technol.','WATER SCIENCE AND TECHNOLOGY','0273-1223',1.064000,0.015630,1.781630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Atom. Sprays','ATOMIZATION AND SPRAYS','1044-5110',1.235000,0.001490,0.170210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Chem. Eng.','CANADIAN JOURNAL OF CHEMICAL ENGINEERING','0008-4034',1.066000,0.003930,0.447460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Environ. Sci.','Energy & Environmental Science','1754-5692',25.427000,0.164740,18.777170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fuel','FUEL','0016-2361',3.611000,0.055350,6.308330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Insect Biochem. Mol. Biol.','INSECT BIOCHEMISTRY AND MOLECULAR BIOLOGY','0965-1748',3.767000,0.009090,1.036500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Genet. Genomics','Journal of Genetics and Genomics','1673-8527',3.981000,0.004520,0.515400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Integr. Plant Biol.','Journal of Integrative Plant Biology','1672-9072',3.670000,0.006890,0.785810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Biol.','JOURNAL OF MOLECULAR BIOLOGY','0022-2836',4.517000,0.065990,7.521530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Recognit.','JOURNAL OF MOLECULAR RECOGNITION','0952-3499',2.091000,0.003710,0.422560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Intensive Care Med.','INTENSIVE CARE MEDICINE','0342-4642',10.125000,0.033980,3.872660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Trauma Acute Care Surg.','Journal of Trauma and Acute Care Surgery','2163-0755',2.802000,0.020260,2.309700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Therm. Eng.','APPLIED THERMAL ENGINEERING','1359-4311',3.043000,0.032090,3.657370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryogenics','CRYOGENICS','0011-2275',1.026000,0.002000,0.228360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy','ENERGY','0360-5442',4.292000,0.062480,7.121090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Therm. Fluid Sci.','EXPERIMENTAL THERMAL AND FLUID SCIENCE','0894-1777',2.128000,0.011480,1.308000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Commun. Heat Mass Transf.','INTERNATIONAL COMMUNICATIONS IN HEAT AND MASS TRANSFER','0735-1933',2.559000,0.012190,1.389470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Green Energy','International Journal of Green Energy','1543-5075',1.601000,0.001160,0.132040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Heat Mass Transf.','INTERNATIONAL JOURNAL OF HEAT AND MASS TRANSFER','0017-9310',2.857000,0.046880,5.343680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Enhanc. Heat Transf.','JOURNAL OF ENHANCED HEAT TRANSFER','1065-5131',0.562000,0.000430,0.049560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Therm. Sci.','Journal of Thermal Science','1003-2169',0.543000,0.001150,0.130670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microgravity Sci. Technol.','MICROGRAVITY SCIENCE AND TECHNOLOGY','0938-0108',0.725000,0.000950,0.107900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Algorithms','ACM Transactions on Algorithms','1549-6325',0.776000,0.003560,0.406100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Math. Commun.','Advances in Mathematics of Communications','1930-5346',0.631000,0.001570,0.179160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryptogr. Commun.','Cryptography and Communications-Discrete-Structures Boolean Functions and Sequences','1936-2447',0.742000,0.000760,0.086570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front.. Comput. Sci.','Frontiers of Computer Science','2095-2228',0.660000,0.000860,0.098070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Bio-Inspired Comput..','International Journal of Bio-Inspired Computation','1758-0366',1.390000,0.000800,0.090870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Found. Comput. Sci.','INTERNATIONAL JOURNAL OF FOUNDATIONS OF COMPUTER SCIENCE','0129-0541',0.467000,0.001700,0.194200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Unconv. Comput.','International Journal of Unconventional Computing','1548-7199',0.739000,0.000350,0.040380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Anal. Appl.','JOURNAL OF COMPUTATIONAL ANALYSIS AND APPLICATIONS','1521-1398',0.799000,0.000930,0.106470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cryptology','JOURNAL OF CRYPTOLOGY','0933-2790',1.617000,0.001740,0.198320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Chem. Technol.','INDIAN JOURNAL OF CHEMICAL TECHNOLOGY','0971-457X',0.491000,0.000660,0.075090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Energy Chem.','Journal of Energy Chemistry','2095-4956',2.322000,0.001630,0.185350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('KGK-Kautsch. Gummi Kunstst.','KGK-Kautschuk Gummi Kunststoffe','0948-3276',0.359000,0.000240,0.027020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Maced. J. Chem. Chem. Eng.','Macedonian Journal of Chemistry and Chemical engineering','1857-5552',0.400000,0.000240,0.027830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oil Gas Sci. Technol.','Oil & Gas Science and Technology-Revue d IFP Energies nouvelles','1294-4475',1.087000,0.002230,0.254220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pet. Sci. Technol.','PETROLEUM SCIENCE AND TECHNOLOGY','1091-6466',0.418000,0.001950,0.222740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plasma Chem. Plasma Process.','PLASMA CHEMISTRY AND PLASMA PROCESSING','0272-4324',1.811000,0.002500,0.285250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Energy Combust. Sci.','PROGRESS IN ENERGY AND COMBUSTION SCIENCE','0360-1285',16.784000,0.012430,1.416930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Membr. Biol.','MOLECULAR MEMBRANE BIOLOGY','0968-7688',1.983000,0.001530,0.174760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Psychiatr.','MOLECULAR PSYCHIATRY','1359-4184',13.314000,0.044400,5.060370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Chem. Biol.','Nature Chemical Biology','1552-4450',12.709000,0.060840,6.934150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Open Biol','Open Biology','2046-2441',4.822000,0.007480,0.852010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Organogenesis','Organogenesis','1547-6278',2.910000,0.002440,0.278070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pest. Biochem. Physiol.','PESTICIDE BIOCHEMISTRY AND PHYSIOLOGY','0048-3575',2.388000,0.005170,0.589780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytochem. Lett.','Phytochemistry Letters','1874-3900',1.353000,0.003340,0.380930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytochemistry','PHYTOCHEMISTRY','0031-9422',2.779000,0.016100,1.835440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Molec. Biol. Transl. Sci.','Progress in Molecular Biology and Translational Science','1877-1173',3.364000,0.007190,0.819760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Protein Sci.','PROTEIN SCIENCE','0961-8368',3.039000,0.017740,2.022170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Appl. Genet. Mol. Biol.','Statistical Applications in Genetics and Molecular Biology','2194-6302',1.265000,0.002930,0.333970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Numer Heat Tranf. B-Fundam.','NUMERICAL HEAT TRANSFER PART B-FUNDAMENTALS','1040-7790',1.330000,0.001580,0.179920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Combust. Inst.','PROCEEDINGS OF THE COMBUSTION INSTITUTE','1540-7489',4.120000,0.017070,1.945390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Flavour Frag. J.','FLAVOUR AND FRAGRANCE JOURNAL','0882-5734',1.693000,0.001780,0.202870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Energy Chem.','Journal of Energy Chemistry','2095-4956',2.322000,0.001630,0.185350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Surfactants Deterg.','JOURNAL OF SURFACTANTS AND DETERGENTS','1097-3958',1.853000,0.001910,0.218070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Prod. Res.','NATURAL PRODUCT RESEARCH','1478-6419',1.057000,0.005880,0.669740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tenside Surfactants Deterg.','TENSIDE SURFACTANTS DETERGENTS','0932-3414',0.678000,0.000400,0.045990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Heuristics','JOURNAL OF HEURISTICS','1381-1231',1.344000,0.002130,0.243280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Parallel Comput.','PARALLEL COMPUTING','0167-8191',1.000000,0.002900,0.330760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACI Struct. J.','ACI STRUCTURAL JOURNAL','0889-3241',1.227000,0.004070,0.464110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Beton- Stahlbetonbau','Beton- und Stahlbetonbau','0005-9900',0.431000,0.001480,0.168310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput.-Aided Civil Infrastruct. Eng.','COMPUTER-AIDED CIVIL AND INFRASTRUCTURE ENGINEERING','1093-9687',5.288000,0.003670,0.418390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Constr.','Informes de la Construccion','0020-0883',0.227000,0.000300,0.033740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Steel Struct.','International Journal of Steel Structures','1598-2351',0.533000,0.000820,0.093720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Leukos','Leukos','1550-2724',2.167000,0.000430,0.048920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('PCI J.','PCI JOURNAL','0887-9672',0.526000,0.000510,0.058250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Oper. Res.','COMPUTERS & OPERATIONS RESEARCH','0305-0548',1.988000,0.016530,1.883990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hum. Factors','HUMAN FACTORS','0018-7208',1.370000,0.003400,0.387380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Mech. Eng. Part O-J. Risk Reliab.','Proceedings of the Institution of Mechanical Engineers Part O-Journal of Risk and Reliability','1748-006X',1.073000,0.001460,0.166090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Qual. Eng.','Quality Engineering','0898-2112',0.883000,0.000880,0.100440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Technovation','TECHNOVATION','0166-4972',2.243000,0.003600,0.410730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('AI EDAM-Artif. Intell. Eng. Des. Anal. Manuf.','AI EDAM-ARTIFICIAL INTELLIGENCE FOR ENGINEERING DESIGN ANALYSIS AND MANUFACTURING','0890-0604',0.877000,0.000440,0.050230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mach. Sci. Technol.','MACHINING SCIENCE AND TECHNOLOGY','1091-0344',1.172000,0.000700,0.079390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Packag. Technol. Sci.','PACKAGING TECHNOLOGY AND SCIENCE','0894-3214',1.292000,0.000850,0.096580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trace Elem. Electrolytes','TRACE ELEMENTS AND ELECTROLYTES','0946-2104',0.377000,0.000110,0.012870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trends Mol. Med','TRENDS IN MOLECULAR MEDICINE','1471-4914',9.292000,0.020480,2.334410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vitam. Horm.','Vitamins and Hormones','0083-6729',2.161000,0.002490,0.283490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell. Reprogramm.','Cellular Reprogramming','2152-4971',1.462000,0.001920,0.218560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biocell','BIOCELL','0327-9545',0.423000,0.000320,0.036790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioelectromagnetics','BIOELECTROMAGNETICS','0197-8462',1.583000,0.002500,0.284800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Rev.','BIOLOGICAL REVIEWS','1464-7931',10.725000,0.018520,2.110690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biometrika','BIOMETRIKA','0006-3444',1.130000,0.016300,1.857850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryobiology','CRYOBIOLOGY','0011-2240',1.920000,0.003690,0.421150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACS Infect. Dis.','ACS Infectious Diseases','2373-8227',0.000000,0.000790,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioorg. Med. Chem.','BIOORGANIC & MEDICINAL CHEMISTRY','0968-0896',2.923000,0.037720,4.299600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Drugs','Marine Drugs','1660-3397',3.345000,0.013870,1.581060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacogn. Mag.','Pharmacognosy Magazine','0973-1296',0.831000,0.001330,0.151630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rec. Nat. Prod.','Records of Natural Products','1307-6167',0.765000,0.000960,0.109100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACS Sustain. Chem. Eng.','ACS Sustainable Chemistry & Engineering','2168-0485',5.267000,0.008540,0.973540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Road Mater. Pavement Des.','Road Materials and Pavement Design','1468-0629',1.547000,0.002320,0.263920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wind Struct.','WIND AND STRUCTURES','1226-6116',0.746000,0.000660,0.075300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Emerg. Care','PEDIATRIC EMERGENCY CARE','0749-5161',0.923000,0.006340,0.722430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Scand. J. Trauma Resusc. Emerg. Med.','Scandinavian Journal of Trauma Resuscitation & Emergency Medicine','1757-7241',2.310000,0.004540,0.517950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Crystallogr. Sect. A','Acta Crystallographica A-Foundation and Advances','2053-2733',2.333000,0.004020,0.458620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Struct. Chem.','CHINESE JOURNAL OF STRUCTURAL CHEMISTRY','0254-5861',0.538000,0.000880,0.100410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryst. Growth Des.','CRYSTAL GROWTH & DESIGN','1528-7483',4.425000,0.048640,5.544400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Cryst. Liquid Cryst.','MOLECULAR CRYSTALS AND LIQUID CRYSTALS','1542-1406',0.532000,0.002760,0.314440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polyhedron','POLYHEDRON','0277-5387',2.108000,0.014050,1.601140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Oral Biol.','ARCHIVES OF ORAL BIOLOGY','0003-9969',1.733000,0.007240,0.825230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Oral Implant. Res.','CLINICAL ORAL IMPLANTS RESEARCH','0905-7161',3.464000,0.016950,1.932470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brodogradnja','Brodogradnja','0007-215X',0.312000,0.000150,0.017250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ship Res.','JOURNAL OF SHIP RESEARCH','0022-4502',0.606000,0.000470,0.053940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Beton- Stahlbetonbau','Beton- und Stahlbetonbau','0005-9900',0.431000,0.001480,0.168310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput.-Aided Civil Infrastruct. Eng.','COMPUTER-AIDED CIVIL AND INFRASTRUCTURE ENGINEERING','1093-9687',5.288000,0.003670,0.418390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ing. Sismica','Ingegneria Sismica','0393-1420',0.676000,0.000140,0.015870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Adv. Concr. Technol.','Journal of Advanced Concrete Technology','1346-8014',0.658000,0.001030,0.117300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cold Reg. Eng.','JOURNAL OF COLD REGIONS ENGINEERING','0887-381X',0.720000,0.000210,0.024210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Therm. Biol.','JOURNAL OF THERMAL BIOLOGY','0306-4565',1.621000,0.002950,0.335810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('PLoS. Biol.','PLOS BIOLOGY','1545-7885',8.668000,0.079360,9.045820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiat. Environ. Biophys.','RADIATION AND ENVIRONMENTAL BIOPHYSICS','0301-634X',1.923000,0.002680,0.305030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theory Biosci.','THEORY IN BIOSCIENCES','1431-7613',1.000000,0.001130,0.128590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Biochim. Biophys. Sin.','ACTA BIOCHIMICA ET BIOPHYSICA SINICA','1672-9145',2.124000,0.004660,0.530930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioelectrochemistry','BIOELECTROCHEMISTRY','1567-5394',3.556000,0.004450,0.507370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Struct. Biol.','BMC STRUCTURAL BIOLOGY','1472-6807',1.926000,0.002490,0.284310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Phys. Lipids','CHEMISTRY AND PHYSICS OF LIPIDS','0009-3084',2.901000,0.004890,0.557700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Top. Membr.','Current Topics in Membranes','1063-5823',3.881000,0.001990,0.227310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Carbon Lett.','Carbon Letters','1976-4251',1.588000,0.000570,0.064560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Biodivers.','CHEMISTRY & BIODIVERSITY','1612-1872',1.444000,0.006150,0.701050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Rev.','CHEMICAL REVIEWS','0009-2665',37.369000,0.245030,27.928710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Sci.','Chemical Science','2041-6520',9.144000,0.088930,10.136750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ChemistryOpen','ChemistryOpen','2191-1363',3.585000,0.001140,0.129390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Croat. Chem. Acta','CROATICA CHEMICA ACTA','0011-1643',0.732000,0.000910,0.104220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Crystengcomm','CRYSTENGCOMM','1466-8033',3.849000,0.055130,6.283230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Environ. Sci.','Energy & Environmental Science','1754-5692',25.427000,0.164740,18.777170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem.','Journal of Chemistry','2090-9063',0.996000,0.002940,0.335460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cheminformatics','Journal of Cheminformatics','1758-2946',3.949000,0.005610,0.639600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dent. Mater. J.','DENTAL MATERIALS JOURNAL','0287-4547',1.087000,0.002980,0.339150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Endod. J.','INTERNATIONAL ENDODONTIC JOURNAL','0143-2885',2.842000,0.008710,0.992290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Evid.-Based Dent. Pract.','Journal of Evidence-Based Dental Practice','1532-3382',1.474000,0.001110,0.126890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Dent.','PEDIATRIC DENTISTRY','0164-1263',0.800000,0.002030,0.231380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Periodontol. 2000','PERIODONTOLOGY 2000','0906-6713',4.949000,0.004410,0.502720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Orthod.','Seminars in Orthodontics','1073-8746',0.346000,0.000430,0.049580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Derm.-Venereol.','ACTA DERMATO-VENEREOLOGICA','0001-5555',3.638000,0.007650,0.872150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Burns','BURNS','0305-4179',1.904000,0.007050,0.803560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Dermatol.','CLINICS IN DERMATOLOGY','0738-081X',2.367000,0.004610,0.525750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Oil Gas Coal Technol.','International Journal of Oil Gas and Coal Technology','1753-3309',0.464000,0.000270,0.030470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Petroleum Explor. Dev.','Petroleum Exploration and Development','1000-0747',1.377000,0.002140,0.244030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('SPE J.','SPE JOURNAL','1086-055X',1.442000,0.004830,0.550410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM J. Emerg. Technol. Comput. Syst.','ACM Journal on Emerging Technologies in Computing Systems','1550-4832',0.705000,0.000820,0.093480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Electr. Comput. Eng.','Advances in Electrical and Computer Engineering','1582-7445',0.459000,0.000390,0.044060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Control Eng. Practice','CONTROL ENGINEERING PRACTICE','0967-0661',1.830000,0.008800,1.003160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electron. Lett.','ELECTRONICS LETTERS','0013-5194',0.854000,0.024900,2.838310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Appl. Artif. Intell.','ENGINEERING APPLICATIONS OF ARTIFICIAL INTELLIGENCE','0952-1976',2.368000,0.008700,0.992050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('EURASIP J. Audio Speech Music Process.','EURASIP Journal on Audio Speech and Music Processing','1687-4722',0.797000,0.000540,0.061620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nat. Prod.','JOURNAL OF NATURAL PRODUCTS','0163-3864',3.662000,0.023920,2.726000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurotoxicology','NEUROTOXICOLOGY','0161-813X',2.738000,0.007630,0.869380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pak. J. Pharm. Sci.','Pakistan Journal of Pharmaceutical Sciences','1011-601X',0.581000,0.001710,0.194960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacol. Res.','PHARMACOLOGICAL RESEARCH','1043-6618',4.816000,0.011000,1.254300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacol. Rev.','PHARMACOLOGICAL REVIEWS','0031-6997',18.393000,0.017810,2.030250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacol. Ther.','PHARMACOLOGY & THERAPEUTICS','0163-7258',11.000000,0.020610,2.349170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Neuro-Psychopharmacol. Biol. Psychiatry','PROGRESS IN NEURO-PSYCHOPHARMACOLOGY & BIOLOGICAL PSYCHIATRY','0278-5846',4.361000,0.017980,2.049270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Soil Biol. Biochem.','SOIL BIOLOGY & BIOCHEMISTRY','0038-0717',4.152000,0.035100,4.000600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Soil Tillage Res.','SOIL & TILLAGE RESEARCH','0167-1987',2.709000,0.008480,0.966620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Soil Use Manage.','SOIL USE AND MANAGEMENT','0266-0032',1.823000,0.003660,0.416710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Atom. Spectrosc.','ATOMIC SPECTROSCOPY','0195-5373',1.600000,0.000390,0.044280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Concepts Magn. Reson. Part A','CONCEPTS IN MAGNETIC RESONANCE PART A','1546-6086',0.526000,0.000680,0.078000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cult. Herit.','JOURNAL OF CULTURAL HERITAGE','1296-2074',1.533000,0.002860,0.325830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Near Infrared Spectrosc.','JOURNAL OF NEAR INFRARED SPECTROSCOPY','0967-0335',1.117000,0.001470,0.167520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Quant. Spectrosc. Radiat. Transf.','JOURNAL OF QUANTITATIVE SPECTROSCOPY & RADIATIVE TRANSFER','0022-4073',2.859000,0.015530,1.770020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mass Spectrom. Rev.','MASS SPECTROMETRY REVIEWS','0277-7037',9.346000,0.005510,0.627570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solid State Nucl. Magn. Reson.','SOLID STATE NUCLEAR MAGNETIC RESONANCE','0926-2040',2.250000,0.001670,0.189890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Spectroc. Acta Pt. A-Molec. Biomolec. Spectr.','SPECTROCHIMICA ACTA PART A-MOLECULAR AND BIOMOLECULAR SPECTROSCOPY','1386-1425',2.653000,0.027550,3.140080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('X-Ray Spectrom.','X-RAY SPECTROMETRY','0049-8246',1.173000,0.001450,0.165330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Sports Med.','AMERICAN JOURNAL OF SPORTS MEDICINE','0363-5465',4.517000,0.041400,4.718580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. J. Sports Med.','BRITISH JOURNAL OF SPORTS MEDICINE','0306-3674',6.724000,0.027170,3.097230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. J. Sport Med.','CLINICAL JOURNAL OF SPORT MEDICINE','1050-642X',2.308000,0.004740,0.540460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hum. Mov. Sci.','HUMAN MOVEMENT SCIENCE','0167-9457',1.606000,0.005130,0.585190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Isokinetics Exerc. Sci.','ISOKINETICS AND EXERCISE SCIENCE','0959-3020',0.357000,0.000590,0.066930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurosci. Biobehav. Rev.','NEUROSCIENCE AND BIOBEHAVIORAL REVIEWS','0149-7634',8.580000,0.045210,5.152760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurosignals','NEUROSIGNALS','1424-862X',1.593000,0.000920,0.104940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychophysiology','PSYCHOPHYSIOLOGY','0048-5772',3.074000,0.013590,1.548530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stress','STRESS-THE INTERNATIONAL JOURNAL ON THE BIOLOGY OF STRESS','1025-3890',2.383000,0.004240,0.483470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neuroimaging','JOURNAL OF NEUROIMAGING','1051-2284',1.625000,0.003690,0.420200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Radiat. Isot.','APPLIED RADIATION AND ISOTOPES','0969-8043',1.136000,0.010560,1.203930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fusion Eng. Des.','FUSION ENGINEERING AND DESIGN','0920-3796',1.301000,0.010860,1.237540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fusion Sci. Technol.','FUSION SCIENCE AND TECHNOLOGY','1536-1055',0.799000,0.003910,0.446110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Eng. Int.','NUCLEAR ENGINEERING INTERNATIONAL','0029-5507',0.070000,0.000200,0.023010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACS Photonics','ACS Photonics','2330-4022',5.404000,0.006070,0.692420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Surf. Sci.','APPLIED SURFACE SCIENCE','0169-4332',3.150000,0.082460,9.399160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryogenics','CRYOGENICS','0011-2275',1.026000,0.002000,0.228360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trns. Dielectr. Electr. Insul.','IEEE TRANSACTIONS ON DIELECTRICS AND ELECTRICAL INSULATION','1070-9878',1.306000,0.006400,0.729910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Nanotechnol.','IEEE TRANSACTIONS ON NANOTECHNOLOGY','1536-125X',1.702000,0.006600,0.751710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Semicond. Manuf.','IEEE TRANSACTIONS ON SEMICONDUCTOR MANUFACTURING','0894-6507',1.045000,0.001420,0.161330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Integr. Ferroelectr.','INTEGRATED FERROELECTRICS','1058-4587',0.375000,0.001100,0.125300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Appl. Mech. Tech. Phys.','Journal of Applied Mechanics and Technical Physics','0021-8944',0.274000,0.001150,0.131240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Theor. Nanosci.','Journal of Computational and Theoretical Nanoscience','1546-1955',1.666000,0.003420,0.390330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Disp. Technol.','Journal of Display Technology','1551-319X',1.925000,0.004930,0.562020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Orthop. Sports Phys. Ther.','JOURNAL OF ORTHOPAEDIC & SPORTS PHYSICAL THERAPY','0190-6011',2.551000,0.007400,0.842980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sport Rehabil.','JOURNAL OF SPORT REHABILITATION','1056-6716',1.612000,0.001550,0.177210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physician Sportsmed.','PHYSICIAN AND SPORTSMEDICINE','0091-3847',1.144000,0.001890,0.215740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Quest','QUEST','0033-6297',0.809000,0.000680,0.077630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Astin Bull.','Astin Bulletin','0515-0361',0.732000,0.001370,0.156430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bayesian Anal.','Bayesian Analysis','1931-6690',1.087000,0.005880,0.669740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biostatistics','BIOSTATISTICS','1465-4644',2.109000,0.008420,0.959730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. J. Math. Stat. Psychol.','BRITISH JOURNAL OF MATHEMATICAL & STATISTICAL PSYCHOLOGY','0007-1102',3.698000,0.004330,0.493140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comb. Probab. Comput.','COMBINATORICS PROBABILITY & COMPUTING','0963-5483',0.627000,0.004760,0.542400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Stat.','COMPUTATIONAL STATISTICS','0943-4062',0.520000,0.002210,0.251380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Instrum. Methods Phys. Res. Sect. B-Beam Interact. Mater. Atoms','NUCLEAR INSTRUMENTS & METHODS IN PHYSICS RESEARCH SECTION B-BEAM INTERACTIONS WITH MATERIALS AND ATOMS','0168-583X',1.389000,0.022730,2.591270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Technol. Radiat. Prot.','Nuclear Technology & Radiation Protection','1451-3994',0.372000,0.000450,0.051130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiat. Meas.','RADIATION MEASUREMENTS','1350-4487',1.071000,0.008530,0.972280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Assist. Inferm. Ric.','Assistenza Infermieristica e Ricerca','1592-5986',0.075000,0.000100,0.011090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. J. Adv. Nurs.','Australian Journal of Advanced Nursing','0813-0531',0.302000,0.000410,0.046750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. J. Rural Health','Australian Journal of Rural Health','1038-5282',0.764000,0.001400,0.160020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Nurs.','CANCER NURSING','0162-220X',2.017000,0.004270,0.486890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geriatr. Nurs.','GERIATRIC NURSING','0197-4572',1.009000,0.001080,0.123290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Assoc. Nurses Aids Care','JANAC-JOURNAL OF THE ASSOCIATION OF NURSES IN AIDS CARE','1055-3290',1.398000,0.002040,0.232180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Child Health Care','Journal of Child Health Care','1367-4935',1.242000,0.001040,0.118460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Community Health Nurs.','Journal of Community Health Nursing','0737-0016',0.538000,0.000420,0.047390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('MAPAN-J. Metrol. Soc. India','MAPAN-Journal of Metrology Society of India','0970-3950',0.634000,0.000230,0.025840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Lett.','MATERIALS LETTERS','0167-577X',2.437000,0.047810,5.449500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nano Lett.','NANO LETTERS','1530-6984',13.779000,0.367140,41.846160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nano Res.','Nano Research','1998-0124',8.893000,0.019870,2.264400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanoscale Res. Lett.','Nanoscale Research Letters','1556-276X',2.584000,0.027000,3.077020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photonics Nanostruct.','Photonics and Nanostructures-Fundamentals and Applications','1569-4410',1.505000,0.001960,0.223690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Quant. Infrared Thermogr. J.','Quantitative InfraRed Thermography Journal','1768-6733',1.200000,0.000560,0.063850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rom. J. Inform. Sci. Technol.','Romanian Journal of Information Science and Technology','1453-8245',0.269000,0.000240,0.027490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Adv. Mater.','Science of Advanced Materials','1947-2935',1.812000,0.004290,0.488830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electron. J. Stat.','Electronic Journal of Statistics','1935-7524',0.736000,0.011840,1.349200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environmetrics','ENVIRONMETRICS','1180-4009',1.160000,0.004430,0.504430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fuzzy Sets Syst.','FUZZY SETS AND SYSTEMS','0165-0114',2.098000,0.007710,0.879030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Infin. Dimens. Anal. Quantum Probab. Relat. Top.','INFINITE DIMENSIONAL ANALYSIS QUANTUM PROBABILITY AND RELATED TOPICS','0219-0257',0.682000,0.001120,0.127230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Biostat.','International Journal of Biostatistics','2194-573X',0.667000,0.002600,0.296380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Game Theory','INTERNATIONAL JOURNAL OF GAME THEORY','0020-7276',0.577000,0.002880,0.328590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Stat. Rev.','INTERNATIONAL STATISTICAL REVIEW','0306-7734',1.789000,0.002920,0.332310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. R. Stat. Soc. Ser. A-Stat. Soc.','JOURNAL OF THE ROYAL STATISTICAL SOCIETY SERIES A-STATISTICS IN SOCIETY','0964-1998',1.702000,0.004570,0.520720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. R. Stat. Soc. Ser. B-Stat. Methodol.','JOURNAL OF THE ROYAL STATISTICAL SOCIETY SERIES B-STATISTICAL METHODOLOGY','1369-7412',4.222000,0.019160,2.184280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Multivariate Behav. Res.','MULTIVARIATE BEHAVIORAL RESEARCH','0027-3171',1.551000,0.008430,0.960800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Methodol.','Statistical Methodology','1572-3127',0.604000,0.002320,0.265000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Model.','STATISTICAL MODELLING','1471-082X',0.932000,0.001480,0.168770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nurs. Manag.','Journal of Nursing Management','0966-0429',1.721000,0.004320,0.492920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nephrol. Nurs. J.','Nephrology Nursing Journal','1526-744X',0.734000,0.000690,0.078110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nurs. Philos.','Nursing Philosophy','1466-7681',0.981000,0.000560,0.063280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nurs. Sci. Q.','NURSING SCIENCE QUARTERLY','0894-3184',0.579000,0.000340,0.038680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rehabil. Nurs.','Rehabilitation Nursing','0278-4807',1.156000,0.000980,0.111280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Workplace Health Saf.','Workplace Health & Safety','2165-0799',0.545000,0.000360,0.041040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Worldviews Evid.-Based Nurs.','Worldviews on Evidence-Based Nursing','1545-102X',1.762000,0.001260,0.143680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Nutr. Metab.','ANNALS OF NUTRITION AND METABOLISM','0250-6807',2.461000,0.004390,0.500790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Nutr.','Annual Review of Nutrition','0199-9885',6.784000,0.004570,0.520510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endocrinol. Nutr.','Endocrinologia y Nutricion','1575-0922',1.314000,0.001030,0.116890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Chem.','FOOD CHEMISTRY','0308-8146',4.052000,0.093140,10.615710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Numer. Methods Fluids','INTERNATIONAL JOURNAL FOR NUMERICAL METHODS IN FLUIDS','0271-2091',1.447000,0.011670,1.329780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Turbul.','JOURNAL OF TURBULENCE','1468-5248',1.472000,0.002840,0.323610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Fusion','NUCLEAR FUSION','0029-5515',4.040000,0.021820,2.486740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theor. Comput. Fluid Dyn.','THEORETICAL AND COMPUTATIONAL FLUID DYNAMICS','0935-4964',1.321000,0.001960,0.223320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Atom. Mol. Opt. Phys.','Advances In Atomic Molecular and Optical Physics','1049-250X',5.417000,0.001400,0.159960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Chem. Phys.','Advances in Chemical Physics','0065-2385',2.304000,0.001560,0.178210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Atom. Data Nucl. Data Tables','ATOMIC DATA AND NUCLEAR DATA TABLES','0092-640X',2.576000,0.001480,0.168220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mass Spectrom.','INTERNATIONAL JOURNAL OF MASS SPECTROMETRY','1387-3806',2.183000,0.010330,1.177690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Quantum Chem.','INTERNATIONAL JOURNAL OF QUANTUM CHEMISTRY','0020-7608',2.184000,0.009900,1.128440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stoch. Models','STOCHASTIC MODELS','1532-6349',0.360000,0.001250,0.142080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theory Probab. Appl.','THEORY OF PROBABILITY AND ITS APPLICATIONS','0040-585X',0.408000,0.001610,0.183330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Surg. Treat. Res.','Annals of Surgical Treatment and Research','2288-6575',0.730000,0.000330,0.038110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Thorac. Cardiovasc. Surg.','Annals of Thoracic and Cardiovascular Surgery','1341-1098',0.658000,0.002070,0.235530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cir. Cir.','Cirugia y Cirujanos','0009-7411',0.137000,0.000570,0.064640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Colon Rectal Surg.','Clinics in Colon and Rectal Surgery','1531-0043',0.714000,0.001130,0.128720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Orthop. Rel. Res.','CLINICAL ORTHOPAEDICS AND RELATED RESEARCH','0009-921X',3.127000,0.040840,4.655490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Plast. Surg.','CLINICS IN PLASTIC SURGERY','0094-1298',1.065000,0.002250,0.256880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dis. Colon Rectum','DISEASES OF THE COLON & RECTUM','0012-3706',3.739000,0.018190,2.073220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endoskopie Heute','Endoskopie Heute','0933-811X',0.188000,0.000080,0.008880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Sport Nutr. Exerc. Metab.','INTERNATIONAL JOURNAL OF SPORT NUTRITION AND EXERCISE METABOLISM','1526-484X',2.105000,0.002710,0.308840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nutr. Educ. Behav.','JOURNAL OF NUTRITION EDUCATION AND BEHAVIOR','1499-4046',2.253000,0.003920,0.446540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutr. Clin. Pract.','NUTRITION IN CLINICAL PRACTICE','0884-5336',2.155000,0.003890,0.443770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutr. Neurosci.','NUTRITIONAL NEUROSCIENCE','1028-415X',2.616000,0.001600,0.182500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutrients','Nutrients','2072-6643',3.759000,0.014540,1.657450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutrition','NUTRITION','0899-9007',2.839000,0.011010,1.254670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Perinatol.','AMERICAN JOURNAL OF PERINATOLOGY','0735-1631',1.677000,0.005600,0.638030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Gynecol. Obstet.','ARCHIVES OF GYNECOLOGY AND OBSTETRICS','0932-0067',1.680000,0.012090,1.378430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. N. Z. J. Obstet. Gynaecol.','AUSTRALIAN & NEW ZEALAND JOURNAL OF OBSTETRICS & GYNAECOLOGY','0004-8666',1.738000,0.004470,0.509580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Pregnancy Childbirth','BMC Pregnancy and Childbirth','1471-2393',2.180000,0.013430,1.530210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Contraception','CONTRACEPTION','0010-7824',2.788000,0.014490,1.651530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Contracept. Reprod. Health Care','EUROPEAN JOURNAL OF CONTRACEPTION AND REPRODUCTIVE HEALTH CARE','1362-5187',1.236000,0.001780,0.203290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fertil. Steril.','FERTILITY AND STERILITY','0015-0282',4.426000,0.055850,6.365610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ginekol. Pol.','Ginekologia Polska','0017-0011',0.609000,0.001100,0.125030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Braz. J. Phys.','BRAZILIAN JOURNAL OF PHYSICS','0103-9733',1.042000,0.001310,0.149780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Phys.','CHINESE JOURNAL OF PHYSICS','0577-9073',0.464000,0.001030,0.117740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Theor. Phys.','COMMUNICATIONS IN THEORETICAL PHYSICS','0253-6102',0.948000,0.004860,0.553650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Phys.','EUROPEAN JOURNAL OF PHYSICS','0143-0807',0.608000,0.002290,0.260600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Pure Appl. Phys.','INDIAN JOURNAL OF PURE & APPLIED PHYSICS','0019-5596',0.739000,0.001370,0.156270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Phys. Soc. Jpn.','JOURNAL OF THE PHYSICAL SOCIETY OF JAPAN','0031-9015',1.559000,0.024240,2.763200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Rep.-Rev. Sec. Phys. Lett.','PHYSICS REPORTS-REVIEW SECTION OF PHYSICS LETTERS','0370-1573',16.240000,0.030420,3.467000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Rev. Lett.','PHYSICAL REVIEW LETTERS','0031-9007',7.645000,0.818870,93.335170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Quantum Inf. Process.','Quantum Information Processing','1570-0755',1.840000,0.004100,0.467400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rom. Rep. Phys.','Romanian Reports in Physics','1221-1451',1.367000,0.001580,0.180030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Comput. Assist. Radiol. Surg.','International Journal of Computer Assisted Radiology and Surgery','1861-6410',1.827000,0.003160,0.360150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Acad. Orthop. Surg.','JOURNAL OF THE AMERICAN ACADEMY OF ORTHOPAEDIC SURGEONS','1067-151X',3.055000,0.008300,0.945950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hand Surg.-Am. Vol.','JOURNAL OF HAND SURGERY-AMERICAN VOLUME','0363-5023',1.640000,0.012620,1.438810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Shoulder Elbow Surg.','JOURNAL OF SHOULDER AND ELBOW SURGERY','1058-2746',2.412000,0.018160,2.069860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Surg. Educ.','Journal of Surgical Education','1931-7204',1.950000,0.005450,0.621300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Thorac. Cardiovasc. Surg.','JOURNAL OF THORACIC AND CARDIOVASCULAR SURGERY','0022-5223',3.494000,0.051980,5.924590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hypertens. Pregnancy','HYPERTENSION IN PREGNANCY','1064-1955',1.211000,0.001240,0.141850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JOGNN','JOGNN-JOURNAL OF OBSTETRIC GYNECOLOGIC AND NEONATAL NURSING','0884-2175',1.094000,0.002510,0.285570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Obstet. Gynecol. Clin. N. Am.','OBSTETRICS AND GYNECOLOGY CLINICS OF NORTH AMERICA','0889-8545',1.400000,0.001910,0.217730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pregnancy Hypertens.','Pregnancy Hypertension-An International Journal of Womens Cardiovascular Health','2210-7789',1.308000,0.001040,0.118420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prenat. Diagn.','PRENATAL DIAGNOSIS','0197-3851',3.043000,0.013400,1.527730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Reprod. Sci.','Reproductive Sciences','1933-7191',2.429000,0.007030,0.801490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Twin Res. Hum. Genet.','Twin Research and Human Genetics','1832-4274',2.339000,0.004930,0.562470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Women Birth','Women and Birth','1871-5192',1.525000,0.001880,0.214080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Adriat.','ACTA ADRIATICA','0001-5113',0.561000,0.000440,0.049660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Oceanol. Sin.','ACTA OCEANOLOGICA SINICA','0253-505X',0.631000,0.001970,0.224870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Braz. J. Oceanogr.','BRAZILIAN JOURNAL OF OCEANOGRAPHY','1679-8759',0.621000,0.000890,0.101330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Oceanol. Limnol.','CHINESE JOURNAL OF OCEANOLOGY AND LIMNOLOGY','0254-4059',0.547000,0.002270,0.258810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ICES J. Mar. Sci.','ICES JOURNAL OF MARINE SCIENCE','1054-3139',2.626000,0.013350,1.522150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Geo-Mar. Sci.','Indian Journal of Geo-Marine Sciences','0379-5136',0.316000,0.000680,0.077710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. OCEAN UNIV.','Journal of Ocean University of China','1672-5182',0.509000,0.000960,0.108950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Oper. Oceanogr.','Journal of Operational Oceanography','1755-876X',1.263000,0.000410,0.046340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Solid State Mat. Sci.','CURRENT OPINION IN SOLID STATE & MATERIALS SCIENCE','1359-0286',5.111000,0.005870,0.668890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Phys. J. B','EUROPEAN PHYSICAL JOURNAL B','1434-6028',1.223000,0.013740,1.565660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Low Temp. Phys.','JOURNAL OF LOW TEMPERATURE PHYSICS','0022-2291',0.787000,0.005850,0.667150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Philos. Mag.','PHILOSOPHICAL MAGAZINE','1478-6435',1.632000,0.014970,1.706310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Status Solidi B-Basic Solid State Phys.','PHYSICA STATUS SOLIDI B-BASIC SOLID STATE PHYSICS','0370-1972',1.522000,0.014320,1.631940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plasma Process. Polym.','Plasma Processes and Polymers','1612-8850',2.713000,0.005730,0.653470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Physiol.-Cell Physiol.','AMERICAN JOURNAL OF PHYSIOLOGY-CELL PHYSIOLOGY','0363-6143',3.395000,0.023620,2.692000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Physiol.-Regul. Integr. Comp. Physiol.','AMERICAN JOURNAL OF PHYSIOLOGY-REGULATORY INTEGRATIVE AND COMPARATIVE PHYSIOLOGY','0363-6119',3.168000,0.024810,2.827620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Physiol. Pharmacol.','CANADIAN JOURNAL OF PHYSIOLOGY AND PHARMACOLOGY','0008-4212',1.704000,0.004310,0.491260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lasers Surg. Med.','LASERS IN SURGERY AND MEDICINE','0196-8092',2.135000,0.005800,0.661310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurol. Med.-Chir.','NEUROLOGIA MEDICO-CHIRURGICA','0470-8105',0.612000,0.002740,0.312220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ophthalmic Surg. Lasers Imag. Retin.','Ophthalmic Surgery Lasers & Imaging Retina','2325-8160',1.212000,0.004220,0.481350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('South Afr. J. Surg.','SOUTH AFRICAN JOURNAL OF SURGERY','0038-2361',0.462000,0.000350,0.040270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Cutan. Med. Surg.','SEMINARS IN CUTANEOUS MEDICINE AND SURGERY','1085-5629',1.600000,0.001910,0.217310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Plast. Surg.','Seminars in Plastic Surgery','1535-2188',0.483000,0.000900,0.102800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surg. Clin.-North Am.','SURGICAL CLINICS OF NORTH AMERICA','0039-6109',2.068000,0.004290,0.488800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surg. Oncol. Clin. N. Am.','Surgical Oncology Clinics of North America','1055-3207',1.958000,0.001910,0.217140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surg. Radiol. Anat.','SURGICAL AND RADIOLOGIC ANATOMY','0930-1038',1.195000,0.003350,0.381340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surg. Today','SURGERY TODAY','0941-1291',1.329000,0.006430,0.733070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Unfallchirurg','UNFALLCHIRURG','0177-5537',0.581000,0.001370,0.155810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ad Hoc Netw.','Ad Hoc Networks','1570-8705',1.660000,0.006990,0.796580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('China Commun.','China Communications','1673-5447',0.424000,0.000900,0.102340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Netw.','Computer Networks','1389-1286',1.446000,0.013420,1.529580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Geod.','MARINE GEODESY','0149-0419',0.979000,0.001380,0.157390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ocean Eng.','OCEAN ENGINEERING','0029-8018',1.488000,0.009720,1.107980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oceanogr. Mar. Biol.','Oceanography and Marine Biology','0078-3218',4.545000,0.001130,0.128450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Thalassas','THALASSAS','0212-5919',0.538000,0.000210,0.023660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Geosci. Remote Sens. Lett.','IEEE Geoscience and Remote Sensing Letters','1545-598X',2.228000,0.016050,1.829710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Geosci. Remote Sensing','IEEE TRANSACTIONS ON GEOSCIENCE AND REMOTE SENSING','0196-2892',3.360000,0.037590,4.284650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Digit. Earth','International Journal of Digital Earth','1753-8947',2.762000,0.002140,0.244060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Geod.','MARINE GEODESY','0149-0419',0.979000,0.001380,0.157390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Ophthalmol.','ACTA OPHTHALMOLOGICA','1755-375X',3.032000,0.012180,1.388360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arq. Bras. Oftalmol.','ARQUIVOS BRASILEIROS DE OFTALMOLOGIA','0004-2749',0.494000,0.001220,0.139240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Opthalmol.-J. Can. Opthalmol.','CANADIAN JOURNAL OF OPHTHALMOLOGY-JOURNAL CANADIEN D OPHTALMOLOGIE','0008-4182',1.460000,0.002740,0.312240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cornea','CORNEA','0277-3740',1.833000,0.012930,1.473710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eye Contact Lens-Sci. Clin. Pra.','Eye & Contact Lens-Science and Clinical Practice','1542-2321',1.252000,0.002010,0.229250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CryoLetters','CRYOLETTERS','0143-2044',0.748000,0.000880,0.100710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Appl. Physiol.','EUROPEAN JOURNAL OF APPLIED PHYSIOLOGY','1439-6319',2.328000,0.019590,2.232830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fish Physiol. Biochem.','FISH PHYSIOLOGY AND BIOCHEMISTRY','0920-1742',1.442000,0.004680,0.533470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Sport Physiol. Perform.','International Journal of Sports Physiology and Performance','1555-0265',3.042000,0.005110,0.582980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Physiol. Biochem.','JOURNAL OF PHYSIOLOGY AND BIOCHEMISTRY','1138-7548',2.054000,0.002560,0.292340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pineal Res.','JOURNAL OF PINEAL RESEARCH','0742-3098',9.314000,0.007790,0.887520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lymphat. Res. Biol.','Lymphatic Research and Biology','1539-6851',1.758000,0.001110,0.126900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pest. Biochem. Physiol.','PESTICIDE BIOCHEMISTRY AND PHYSIOLOGY','0048-3575',2.388000,0.005170,0.589780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pflugers Arch.','PFLUGERS ARCHIV-EUROPEAN JOURNAL OF PHYSIOLOGY','0031-6768',3.654000,0.014190,1.617200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physiol. Genomics','PHYSIOLOGICAL GENOMICS','1094-8341',2.615000,0.008250,0.940620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mod. Phys. Lett. A','MODERN PHYSICS LETTERS A','0217-7323',1.116000,0.006830,0.779000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Antennas Propag.','IEEE TRANSACTIONS ON ANTENNAS AND PROPAGATION','0018-926X',2.053000,0.043120,4.914930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE. Trans. Mob. Comput.','IEEE TRANSACTIONS ON MOBILE COMPUTING','1536-1233',2.456000,0.017090,1.947920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Veh. Technol.','IEEE TRANSACTIONS ON VEHICULAR TECHNOLOGY','0018-9545',2.243000,0.035180,4.010030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Ad Hoc Ubiquitous Comput.','International Journal of Ad Hoc and Ubiquitous Computing','1743-8225',0.489000,0.000550,0.062190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Satell. Commun. Netw.','INTERNATIONAL JOURNAL OF SATELLITE COMMUNICATIONS AND NETWORKING','1542-0973',0.700000,0.000460,0.052820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ambient Intell. Smart Environ.','Journal of Ambient Intelligence and Smart Environments','1876-1364',0.707000,0.000720,0.082590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Netw. Syst. Manag.','Journal of Network and Systems Management','1064-7570',1.078000,0.000540,0.062030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Opt. Commun. Netw.','Journal of Optical Communications and Networking','1943-0620',2.183000,0.005270,0.600190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Navigation','Navigation-Journal of the Institute of Navigation','0028-1522',0.979000,0.000660,0.075090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pervasive Mob. Comput.','Pervasive and Mobile Computing','1574-1192',1.719000,0.003290,0.374690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Electromagn. Res.','Progress in Electromagnetics Research-PIER','1559-8985',1.315000,0.011030,1.256680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Alcohol','ALCOHOL','0741-8329',2.440000,0.003890,0.443490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Environ. Contam. Toxicol.','BULLETIN OF ENVIRONMENTAL CONTAMINATION AND TOXICOLOGY','0007-4861',1.191000,0.006690,0.763000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JAMA Ophthalmol.','JAMA Ophthalmology','2168-6165',4.340000,0.009650,1.100110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ophthalmologica','OPHTHALMOLOGICA','0030-3755',1.515000,0.002740,0.312460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Optom. Vis. Sci.','OPTOMETRY AND VISION SCIENCE','1040-5488',1.442000,0.007640,0.870780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Opt. Photonics','Advances in Optics and Photonics','1943-8206',12.368000,0.003650,0.416100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fiber Integrated Opt.','FIBER AND INTEGRATED OPTICS','0146-8030',0.373000,0.000230,0.025940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Photonics Technol. Lett.','IEEE PHOTONICS TECHNOLOGY LETTERS','1041-1135',1.945000,0.027620,3.148180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomed. Opt.','JOURNAL OF BIOMEDICAL OPTICS','1083-3668',2.556000,0.025750,2.934970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Disp. Technol.','Journal of Display Technology','1551-319X',1.925000,0.004930,0.562020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Infrared Millim. Terahertz Waves','Journal of Infrared Millimeter and Terahertz Waves','1866-6892',1.851000,0.004020,0.458540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Opt. Soc. Am. B-Opt. Phys.','JOURNAL OF THE OPTICAL SOCIETY OF AMERICA B-OPTICAL PHYSICS','0740-3224',1.731000,0.020170,2.298750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Russ. Laser Res.','JOURNAL OF RUSSIAN LASER RESEARCH','1071-2836',0.800000,0.000760,0.086340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Part. Nucl. Phys.','PROGRESS IN PARTICLE AND NUCLEAR PHYSICS','0146-6410',9.472000,0.006320,0.720420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Lett. B','PHYSICS LETTERS B','0370-2693',4.787000,0.095490,10.884190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Theor. Math. Phys.','Advances in Theoretical and Mathematical Physics','1095-0761',2.385000,0.003160,0.359760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Nonlinear Sci. Numer. Simul.','Communications in Nonlinear Science and Numerical Simulation','1007-5704',2.834000,0.022080,2.517050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Phys. Commun.','COMPUTER PHYSICS COMMUNICATIONS','0010-4655',3.635000,0.032170,3.666390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Infin. Dimens. Anal. Quantum Probab. Relat. Top.','INFINITE DIMENSIONAL ANALYSIS QUANTUM PROBABILITY AND RELATED TOPICS','0219-0257',0.682000,0.001120,0.127230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Quantum Inf.','INTERNATIONAL JOURNAL OF QUANTUM INFORMATION','0219-7499',0.701000,0.002150,0.245520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inverse Probl. Imaging','Inverse Problems and Imaging','1930-8337',0.951000,0.003270,0.372760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nonlinear Sci.','JOURNAL OF NONLINEAR SCIENCE','0938-8974',2.068000,0.003520,0.401570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Multiscale Model. Simul.','MULTISCALE MODELING & SIMULATION','1540-3459',1.585000,0.005440,0.619630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('SIAM J. Appl. Dyn. Syst.','SIAM JOURNAL ON APPLIED DYNAMICAL SYSTEMS','1536-0040',1.819000,0.004680,0.533420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Drug Saf.','DRUG SAFETY','0114-5916',3.206000,0.006320,0.720110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Food Saf. Food Qual.','Journal of Food Safety and Food Quality-Archiv fur Lebensmittelhygiene','0003-925X',0.083000,0.000210,0.024150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pharmacol. Toxicol. Methods','JOURNAL OF PHARMACOLOGICAL AND TOXICOLOGICAL METHODS','1056-8719',2.147000,0.002790,0.318090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Artif. Organs','ARTIFICIAL ORGANS','0160-564X',1.993000,0.004620,0.526630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Leukos','Leukos','1550-2724',2.167000,0.000430,0.048920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Opt. Commun.','OPTICS COMMUNICATIONS','0030-4018',1.480000,0.026660,3.038320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photonic Netw. Commun.','PHOTONIC NETWORK COMMUNICATIONS','1387-974X',0.557000,0.000740,0.084030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ardeola','ARDEOLA','0570-7358',0.696000,0.000470,0.053610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bird Stud.','BIRD STUDY','0006-3657',0.888000,0.001470,0.167710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Forktail','FORKTAIL','0950-1746',0.123000,0.000090,0.010380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ibis','IBIS','0019-1019',1.804000,0.004450,0.507540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ornithol.','JOURNAL OF ORNITHOLOGY','0021-8375',1.419000,0.005440,0.620530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Bras. Ornitol.','Revista Brasileira de Ornitologia','0103-5657',0.356000,0.000340,0.039210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wilson J. Ornithol.','Wilson Journal of Ornithology','1559-4491',0.553000,0.001570,0.179390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Orthop. Trauma Surg.','ARCHIVES OF ORTHOPAEDIC AND TRAUMA SURGERY','0936-8051',1.496000,0.010210,1.163350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Foot Ankle Int.','FOOT & ANKLE INTERNATIONAL','1071-1007',1.896000,0.008160,0.929930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hip Int.','Hip International','1120-7000',0.889000,0.002790,0.317480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Phys. J. E','EUROPEAN PHYSICAL JOURNAL E','1292-8941',1.625000,0.007220,0.822830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fiber. Polym.','FIBERS AND POLYMERS','1229-9197',1.022000,0.003720,0.424570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Polym. Sci.','International Journal of Polymer Science','1687-9422',1.000000,0.001350,0.153450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Polym. Eng.','JOURNAL OF POLYMER ENGINEERING','0334-6447',0.631000,0.000620,0.070560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Macromol. Biosci.','MACROMOLECULAR BIOSCIENCE','1616-5187',3.680000,0.010700,1.219730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Macromol. React. Eng.','Macromolecular Reaction Engineering','1862-832X',1.256000,0.001220,0.138550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Macromol. Res.','MACROMOLECULAR RESEARCH','1598-5032',1.357000,0.003550,0.405140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polym. Adv. Technol.','POLYMERS FOR ADVANCED TECHNOLOGIES','1042-7147',1.823000,0.006820,0.777000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polym.-Plast. Technol. Eng.','POLYMER-PLASTICS TECHNOLOGY AND ENGINEERING','0360-2559',1.511000,0.003270,0.372780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Rubber Plast. Recycl. Technol.','Progress in Rubber Plastics and Recycling Technology','1477-7606',0.212000,0.000070,0.008200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theor. Math. Phys.','THEORETICAL AND MATHEMATICAL PHYSICS','0040-5779',0.831000,0.003510,0.400290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Heart Lung Transplant.','JOURNAL OF HEART AND LUNG TRANSPLANTATION','1053-2498',7.509000,0.025450,2.900510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transplantation','TRANSPLANTATION','0041-1337',3.690000,0.033920,3.866440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Intell. Transp. Syst. Mag.','IEEE Intelligent Transportation Systems Magazine','1939-1390',1.547000,0.000780,0.089200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Promet','Promet-Traffic & Transportation','0353-5320',0.509000,0.000320,0.036950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transportation','TRANSPORTATION','0049-4488',1.545000,0.003910,0.445570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Trop.','ACTA TROPICA','0001-706X',2.380000,0.011100,1.264920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Shoulder Surg.','International Journal of Shoulder Surgery','0973-6042',0.519000,0.000550,0.063040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Back Musculoskelet. Rehabil.','JOURNAL OF BACK AND MUSCULOSKELETAL REHABILITATION','1053-8127',0.956000,0.001040,0.118680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hand Surg.-Am. Vol.','JOURNAL OF HAND SURGERY-AMERICAN VOLUME','0363-5023',1.640000,0.012620,1.438810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hand Ther.','Journal of Hand Therapy','0894-1130',1.770000,0.001520,0.173150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Shoulder Elbow Surg.','JOURNAL OF SHOULDER AND ELBOW SURGERY','1058-2746',2.412000,0.018160,2.069860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Orthop. Traumatol.-Surg. Res.','Orthopaedics & Traumatology-Surgery & Research','1877-0568',1.393000,0.006850,0.780270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physician Sportsmed.','PHYSICIAN AND SPORTSMEDICINE','0091-3847',1.144000,0.001890,0.215740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Otorhinolaryngol. Ital.','Acta Otorhinolaryngologica Italica','0392-100X',1.531000,0.001660,0.188740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Exp. Otorhinolaryngol.','Clinical and Experimental Otorhinolaryngology','1976-8710',0.855000,0.001250,0.143020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Otolaryngol. Head Neck Surg.','Current Opinion in Otolaryngology & Head and Neck Surgery','1068-9508',1.586000,0.003920,0.446910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Int. Adv. Otol.','Journal of International Advanced Otology','1308-7649',0.123000,0.000170,0.019050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JAMA Otolaryngol-Head Neck Surg.','JAMA Otolaryngology-Head & Neck Surgery','2168-6181',2.705000,0.004650,0.529500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ORL-J. Oto-Rhino-Laryngol. Head Neck Surg.','ORL-Journal for Oto-Rhino-Laryngology Head and Neck Surgery','0301-1569',1.000000,0.001440,0.164160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Psychiatr. Nurs.','ARCHIVES OF PSYCHIATRIC NURSING','0883-9417',1.217000,0.001380,0.157240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Psychiatry','BIOLOGICAL PSYCHIATRY','0006-3223',11.212000,0.074060,8.440840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dement. Geriatr. Cogn. Disord.','DEMENTIA AND GERIATRIC COGNITIVE DISORDERS','1420-8008',3.408000,0.007190,0.819800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Forschritte Neurol. Psychiatr.','FORTSCHRITTE DER NEUROLOGIE PSYCHIATRIE','0720-4299',0.803000,0.000620,0.070500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gen. Hosp. Psych.','GENERAL HOSPITAL PSYCHIATRY','0163-8343',2.381000,0.007640,0.870980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Eating Disord.','INTERNATIONAL JOURNAL OF EATING DISORDERS','0276-3478',4.068000,0.009830,1.120940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mental Health Addict.','International Journal of Mental Health and Addiction','1557-1874',1.018000,0.001410,0.160380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Urol.','CURRENT OPINION IN UROLOGY','0963-0643',2.006000,0.003620,0.412810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Iran. J. Kidney Dis.','Iranian Journal of Kidney Diseases','1735-8582',1.140000,0.001130,0.129000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nephrol.','JOURNAL OF NEPHROLOGY','1121-8428',1.352000,0.004400,0.501750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Rev. Nephrol.','Nature Reviews Nephrology','1759-5061',9.463000,0.014830,1.690650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nephrology','NEPHROLOGY','1320-5358',1.796000,0.006020,0.686540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurourol. Urodyn.','NEUROUROLOGY AND URODYNAMICS','0733-2467',3.128000,0.008770,0.999040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Perit. Dial. Int.','PERITONEAL DIALYSIS INTERNATIONAL','0896-8608',1.298000,0.003120,0.355050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Urol.Int.','UROLOGIA INTERNATIONALIS','0042-1138',1.313000,0.003530,0.401850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annual Review of Animal Biosciences','2165-8102','4.348',0.001020,0.116340,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Otol. Neurotol.','OTOLOGY & NEUROTOLOGY','1531-7129',1.953000,0.012500,1.424910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cretac. Res.','CRETACEOUS RESEARCH','0195-6671',2.196000,0.004600,0.523950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Palaeontogr. Abt. B-Palaophytol.','PALAEONTOGRAPHICA ABTEILUNG B-PALAOPHYTOLOGIE','0375-0299',1.556000,0.000140,0.015420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stratigraphy','Stratigraphy','1547-139X',0.828000,0.000600,0.068490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Parasitolog.','ACTA PARASITOLOGICA','1230-2821',1.293000,0.001700,0.193770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Host Microbe','Cell Host & Microbe','1931-3128',12.552000,0.052150,5.943630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Child Adolesc. Psychopharmacol.','JOURNAL OF CHILD AND ADOLESCENT PSYCHOPHARMACOLOGY','1044-5463',2.149000,0.004240,0.483570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. ECT','JOURNAL OF ECT','1095-0680',1.833000,0.002190,0.249150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nerv. Ment. Dis.','JOURNAL OF NERVOUS AND MENTAL DISEASE','0022-3018',1.836000,0.007890,0.899530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Psychiatr. Ment. Health Nurs.','Journal of Psychiatric and Mental Health Nursing','1351-0126',1.055000,0.002860,0.326310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JAMA Psychiatry','JAMA Psychiatry','2168-622X',14.417000,0.021580,2.460190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lancet Psychiatry','Lancet Psychiatry','2215-0374',5.756000,0.001510,0.172070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurocase','NEUROCASE','1355-4794',1.225000,0.001630,0.185390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychiatry Investig.','Psychiatry Investigation','1738-3684',1.500000,0.002080,0.237240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychoneuroendocrinology','PSYCHONEUROENDOCRINOLOGY','0306-4530',4.704000,0.027600,3.145960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychother. Psychosom.','PSYCHOTHERAPY AND PSYCHOSOMATICS','0033-3190',7.632000,0.004630,0.527810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transl. Psychiatr.','Translational Psychiatry','2158-3188',5.538000,0.013750,1.567180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. Vet. J.-Rev. Vet. Can.','CANADIAN VETERINARY JOURNAL-REVUE VETERINAIRE CANADIENNE','0008-5286',0.639000,0.002920,0.332620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Anim. Hosp. Assoc.','JOURNAL OF THE AMERICAN ANIMAL HOSPITAL ASSOCIATION','0587-2871',0.793000,0.001680,0.191200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Camel Pract. Res.','JOURNAL OF CAMEL PRACTICE AND RESEARCH','0971-6777',0.027000,0.000130,0.014840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Med. Primatol.','JOURNAL OF MEDICAL PRIMATOLOGY','0047-2565',0.930000,0.001100,0.124830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vet. Behav.-Clin. Appl. Res.','Journal of Veterinary Behavior-Clinical Applications and Research','1558-7878',1.366000,0.001420,0.162200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Wildl. Dis.','JOURNAL OF WILDLIFE DISEASES','0090-3558',1.189000,0.004560,0.519540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Kafkas Univ. Vet. Fak. Derg.','Kafkas Universitesi Veteriner Fakultesi Dergisi','1300-6045',0.418000,0.001270,0.144910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Onderstepoort J. Vet. Res.','ONDERSTEPOORT JOURNAL OF VETERINARY RESEARCH','0030-2465',0.603000,0.000550,0.063180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Reprod. Domest. Anim.','REPRODUCTION IN DOMESTIC ANIMALS','0936-6768',1.210000,0.007170,0.817280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vet. Parasitol.','VETERINARY PARASITOLOGY','0304-4017',2.242000,0.020760,2.366030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Alzheimer Dis. Assoc. Dis.','ALZHEIMER DISEASE & ASSOCIATED DISORDERS','0893-0341',2.530000,0.004520,0.514650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anal. Cell. Pathol.','Analytical Cellular Pathology','2210-7177',0.459000,0.000640,0.073010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Pathol. Lab. Med.','ARCHIVES OF PATHOLOGY & LABORATORY MEDICINE','0003-9985',2.631000,0.012210,1.391950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Diagn. Pathol.','Diagnostic Pathology','1746-1596',1.895000,0.005990,0.683080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fetal Pediatr. Pathol.','Fetal and Pediatric Pathology','1551-3815',0.514000,0.000720,0.081580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Paleopathol.','International Journal of Paleopathology','1879-9817',0.788000,0.000500,0.057450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuropathol. Appl. Neurobiol.','NEUROPATHOLOGY AND APPLIED NEUROBIOLOGY','0305-1846',4.483000,0.006070,0.692090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pol. J. Pathol.','POLISH JOURNAL OF PATHOLOGY','1233-9687',1.240000,0.000700,0.079360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Clin. Neuropsychol.','ARCHIVES OF CLINICAL NEUROPSYCHOLOGY','0887-6177',2.014000,0.003640,0.414650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Depress. Anxiety','DEPRESSION AND ANXIETY','1091-4269',5.004000,0.017530,1.997510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ergonomics','ERGONOMICS','0014-0139',1.449000,0.005100,0.580730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin. Exp. Neuropsychol.','JOURNAL OF CLINICAL AND EXPERIMENTAL NEUROPSYCHOLOGY','1380-3395',1.693000,0.005920,0.674820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Exp. Psychol.-Learn. Mem. Cogn.','JOURNAL OF EXPERIMENTAL PSYCHOLOGY-LEARNING MEMORY AND COGNITION','0278-7393',2.776000,0.014930,1.701420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Int. Neuropsychol. Soc.','JOURNAL OF THE INTERNATIONAL NEUROPSYCHOLOGICAL SOCIETY','1355-6177',2.633000,0.009530,1.085890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prat. Psychol.','Pratiques Psychologiques','1269-1763',0.162000,0.000170,0.019630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychophysiology','PSYCHOPHYSIOLOGY','0048-5772',3.074000,0.013590,1.548530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sport Psychol.','SPORT PSYCHOLOGIST','0888-4781',1.104000,0.000990,0.113410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Z. Neuropsychol.','Zeitschrift fur Neuropsychologie','1016-264X',0.371000,0.000080,0.009540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Radiat. Isot.','APPLIED RADIATION AND ISOTOPES','0969-8043',1.136000,0.010560,1.203930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Scand. J. Lab. Anim. Sci.','SCANDINAVIAN JOURNAL OF LABORATORY ANIMAL SCIENCE','0901-3393',0.000000,0.000060,0.007070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Turk. J. Vet. Anim. Sci.','TURKISH JOURNAL OF VETERINARY & ANIMAL SCIENCES','1300-0128',0.352000,0.000790,0.090610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vet. Res.','VETERINARY RESEARCH','0928-4249',2.928000,0.008170,0.931740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Atheroscler. Suppl.','ATHEROSCLEROSIS SUPPLEMENTS','1567-5688',3.356000,0.001090,0.124560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Blood Press. Monit.','BLOOD PRESSURE MONITORING','1359-5237',1.115000,0.001730,0.197630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Atheroscler. Thromb.','Journal of Atherosclerosis and Thrombosis','1340-3478',2.411000,0.005910,0.673260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiovasc. Surg.','JOURNAL OF CARDIOVASCULAR SURGERY','0021-9509',1.632000,0.003780,0.430720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Endovascular Ther.','JOURNAL OF ENDOVASCULAR THERAPY','1526-6028',3.128000,0.006840,0.779930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ultrastruct. Pathol.','ULTRASTRUCTURAL PATHOLOGY','0191-3123',0.828000,0.000890,0.101730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Virchows Arch.','VIRCHOWS ARCHIV','0945-6317',2.627000,0.008520,0.970780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Breastfeed. Med.','Breastfeeding Medicine','1556-8253',1.438000,0.002380,0.271090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Childs Nerv. Syst.','CHILDS NERVOUS SYSTEM','0256-7040',1.080000,0.007910,0.902010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Child Adolesc. Psych.','EUROPEAN CHILD & ADOLESCENT PSYCHIATRY','1018-8827',3.339000,0.006760,0.770210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ital. J. Pediatr.','Italian Journal of Pediatrics','1720-8424',1.614000,0.002340,0.266370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin Res. Pediatr. Endocrinol.','Journal of Clinical Research in Pediatric Endocrinology','1308-5727',1.568000,0.001640,0.187380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr. Hematol. Oncol.','JOURNAL OF PEDIATRIC HEMATOLOGY ONCOLOGY','1077-4114',1.146000,0.005540,0.631990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr. Endocrinol. Metab.','JOURNAL OF PEDIATRIC ENDOCRINOLOGY & METABOLISM','0334-018X',0.912000,0.003640,0.414650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr. Health Care','Journal of Pediatric Health Care','0891-5245',1.615000,0.001850,0.210840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Perinat. Neonatal Nurs.','JOURNAL OF PERINATAL & NEONATAL NURSING','0893-2190',0.857000,0.000980,0.112210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Spec. Pediatr. Nurs.','Journal for Specialists in Pediatric Nursing','1539-0136',0.919000,0.000920,0.104560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Nucl. Med.','CLINICAL NUCLEAR MEDICINE','0363-9762',4.278000,0.006270,0.714330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Concepts Magn. Reson. Part A','CONCEPTS IN MAGNETIC RESONANCE PART A','1546-6086',0.526000,0.000680,0.078000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Invest. Radiol.','INVESTIGATIVE RADIOLOGY','0020-9996',4.887000,0.011910,1.356980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nucl. Cardiol.','JOURNAL OF NUCLEAR CARDIOLOGY','1071-3581',2.929000,0.005100,0.581450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Korean J. Radiol.','KOREAN JOURNAL OF RADIOLOGY','1229-6929',1.592000,0.003550,0.405100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Imaging','Molecular Imaging','1535-3508',2.216000,0.002630,0.300230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuroimage','NEUROIMAGE','1053-8119',5.463000,0.179770,20.490040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Renin-Angiotensin-Aldosterone Syst.','JOURNAL OF THE RENIN-ANGIOTENSIN-ALDOSTERONE SYSTEM','1470-3203',2.350000,0.002180,0.248620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vasc. Res.','JOURNAL OF VASCULAR RESEARCH','1018-1172',2.186000,0.002630,0.299280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vasc. Surg.-Venous Lymphat. Dis.','Journal of Vascular Surgery-Venous and Lymphatic Disorders','2213-333X',0.882000,0.000440,0.050330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vasc. Med.','VASCULAR MEDICINE','1358-863X',1.438000,0.002230,0.253640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vascular','Vascular','1708-5381',0.612000,0.001270,0.144740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aids','AIDS','0269-9370',4.407000,0.046080,5.252340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Gen. Virol.','JOURNAL OF GENERAL VIROLOGY','0022-1317',3.192000,0.023830,2.715980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Viral Hepatitis','JOURNAL OF VIRAL HEPATITIS','1352-0504',4.179000,0.012510,1.426160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Virol. Methods','JOURNAL OF VIROLOGICAL METHODS','0166-0934',1.508000,0.012110,1.380750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Ethol.','ACTA ETHOLOGICA','0873-9749',1.204000,0.000600,0.068190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Primatol.','AMERICAN JOURNAL OF PRIMATOLOGY','0275-2565',2.103000,0.006160,0.702680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Klinische Padiatr.','KLINISCHE PADIATRIE','0300-8630',0.980000,0.002030,0.231700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neonatology','Neonatology','1661-7800',2.754000,0.006270,0.714310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Paediatr. Perinat. Epidemiol.','PAEDIATRIC AND PERINATAL EPIDEMIOLOGY','0269-5022',2.958000,0.006270,0.714710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Allergy Immunol. Pulmonol.','Pediatric Allergy Immunology and Pulmonology','2151-321X',0.941000,0.000630,0.071580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Int.','PEDIATRICS INTERNATIONAL','1328-8067',0.868000,0.004950,0.564510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Nephrol.','PEDIATRIC NEPHROLOGY','0931-041X',2.338000,0.013880,1.581990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Rheumatol.','Pediatric Rheumatology','1546-0096',2.144000,0.001650,0.188150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Fetal Neonatal Med.','Seminars in Fetal & Neonatal Medicine','1744-165X',2.800000,0.005250,0.598860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Perinatol.','SEMINARS IN PERINATOLOGY','0146-0005',2.131000,0.005090,0.580460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Pharmacol. Toxicol.','Annual Review of Pharmacology and Toxicology','0362-1642',14.769000,0.010870,1.239120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anti-Cancer Drugs','ANTI-CANCER DRUGS','0959-4973',2.268000,0.004600,0.524570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Radiol.','PEDIATRIC RADIOLOGY','0301-0449',1.525000,0.008130,0.927080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiol. Oncol.','Radiology and Oncology','1318-2099',1.736000,0.001230,0.139730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiother. Oncol.','RADIOTHERAPY AND ONCOLOGY','0167-8140',4.817000,0.032880,3.748040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rofo-Fortschr. Gebiet Rontgenstrahlen Bildgeb. Verfahr.','ROFO-FORTSCHRITTE AUF DEM GEBIET DER RONTGENSTRAHLEN UND DER BILDGEBENDEN VERFAHREN','1438-9029',1.672000,0.002320,0.264230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Bras. Fisioter.','Brazilian Journal of Physical Therapy','1413-3555',0.898000,0.001840,0.209280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Orthop. Sports Phys. Ther.','JOURNAL OF ORTHOPAEDIC & SPORTS PHYSICAL THERAPY','0190-6011',2.551000,0.007400,0.842980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Behav. Ecol. Sociobiol.','BEHAVIORAL ECOLOGY AND SOCIOBIOLOGY','0340-5443',2.382000,0.014160,1.614110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brain Behav. Evol.','BRAIN BEHAVIOR AND EVOLUTION','0006-8977',2.103000,0.002480,0.282790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Herpetol. Monogr.','HERPETOLOGICAL MONOGRAPHS','0733-1347',1.900000,0.000160,0.018350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comp. Neurol.','JOURNAL OF COMPARATIVE NEUROLOGY','0021-9967',3.331000,0.021560,2.457780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comp. Physiol. B-Biochem. Syst. Environ. Physiol.','JOURNAL OF COMPARATIVE PHYSIOLOGY B-BIOCHEMICAL SYSTEMIC AND ENVIRONMENTAL PHYSIOLOGY','0174-1578',1.884000,0.004750,0.541570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comp. Psychol.','JOURNAL OF COMPARATIVE PSYCHOLOGY','0735-7036',2.494000,0.002600,0.296110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Invertebr. Pathol.','JOURNAL OF INVERTEBRATE PATHOLOGY','0022-2011',2.198000,0.007860,0.895930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Pharmacol.','CURRENT OPINION IN PHARMACOLOGY','1471-4892',4.769000,0.012650,1.441790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Pharm. Design','CURRENT PHARMACEUTICAL DESIGN','1381-6128',3.052000,0.030690,3.497980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dissolut. Technol.','DISSOLUTION TECHNOLOGIES','1521-298X',0.375000,0.000460,0.052890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Drug Chem. Toxicol.','DRUG AND CHEMICAL TOXICOLOGY','0148-0545',1.653000,0.001400,0.159740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Bronconeumol.','ARCHIVOS DE BRONCONEUMOLOGIA','0300-2896',1.771000,0.002470,0.281850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('COPD-J. Chronic Obstr. Pulm. Dis.','COPD-Journal of Chronic Obstructive Pulmonary Disease','1541-2555',2.160000,0.004120,0.469860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Thorac. Cardiovasc. Surg.','JOURNAL OF THORACIC AND CARDIOVASCULAR SURGERY','0022-5223',3.494000,0.051980,5.924590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('npj Prim. Care Respir. Med.','npj Primary Care Respiratory Medicine','2055-1010',1.447000,0.000210,0.023770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Allergy Immunol. Pulmonol.','Pediatric Allergy Immunology and Pulmonology','2151-321X',0.941000,0.000630,0.071580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Respirology','RESPIROLOGY','1323-7799',3.078000,0.009350,1.065620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tuberculosis','TUBERCULOSIS','1472-9792',2.952000,0.007010,0.798980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lab. Anim.','LABORATORY ANIMALS','0023-6772',1.553000,0.001700,0.193880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('N. Z. J. Zool.','NEW ZEALAND JOURNAL OF ZOOLOGY','0301-4223',0.758000,0.000570,0.065430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pac. Sci.','PACIFIC SCIENCE','0030-8870',1.163000,0.001030,0.117530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Primates','PRIMATES','0032-8332',1.142000,0.001590,0.180870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Zoosystema','ZOOSYSTEMA','1280-9551',0.549000,0.000590,0.067190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Minerals','Minerals','2075-163X',1.500000,0.000640,0.072900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Expert Rev. Clin. Pharmacol.','Expert Review of Clinical Pharmacology','1751-2433',2.488000,0.002830,0.322100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fitoterapia','FITOTERAPIA','0367-326X',2.408000,0.010030,1.142900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Pharmacol.','INDIAN JOURNAL OF PHARMACOLOGY','0253-7613',0.599000,0.001590,0.180740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Immunopharmacol.','INTERNATIONAL IMMUNOPHARMACOLOGY','1567-5769',2.551000,0.013950,1.590310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Clin. Phar,.','International Journal of Clinical Pharmacy','2210-7703',1.339000,0.002710,0.308480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Parasitol.-Drugs Drug Resist.','International Journal for Parasitology-Drugs and Drug Resistance','2211-3207',3.746000,0.001980,0.225860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Invest. New Drugs','INVESTIGATIONAL NEW DRUGS','0167-6997',3.281000,0.010460,1.192640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiovasc. Pharmacol. Ther.','JOURNAL OF CARDIOVASCULAR PHARMACOLOGY AND THERAPEUTICS','1074-2484',2.538000,0.002930,0.333790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chemother.','JOURNAL OF CHEMOTHERAPY','1120-009X',1.333000,0.001700,0.193700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Drug Target.','JOURNAL OF DRUG TARGETING','1061-186X',2.821000,0.003710,0.423280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ethnopharmacol.','JOURNAL OF ETHNOPHARMACOLOGY','0378-8741',3.055000,0.028870,3.290540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Food Drug Anal.','JOURNAL OF FOOD AND DRUG ANALYSIS','1021-9498',1.980000,0.001230,0.140020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Reproduction','REPRODUCTION','1470-1626',3.184000,0.013500,1.538260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Best Pract. Res. Clin. Rheumatol.','BEST PRACTICE & RESEARCH IN CLINICAL RHEUMATOLOGY','1521-6942',3.267000,0.006210,0.707590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Musculoskelet. Disord.','BMC MUSCULOSKELETAL DISORDERS','1471-2474',1.684000,0.019590,2.233050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Rheumatol. Rep.','Current Rheumatology Reports','1523-3774',2.976000,0.005490,0.625400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Soil Sci. Plant Anal.','COMMUNICATIONS IN SOIL SCIENCE AND PLANT ANALYSIS','0010-3624',0.529000,0.002840,0.323540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Soil Sci.','EUROPEAN JOURNAL OF SOIL SCIENCE','1351-0754',3.425000,0.006930,0.790080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geoderma','GEODERMA','0016-7061',2.855000,0.020440,2.330300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutr. Cycl. Agroecosyst.','NUTRIENT CYCLING IN AGROECOSYSTEMS','1385-1314',1.490000,0.003610,0.411180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Bras. Cienc. Solo','REVISTA BRASILEIRA DE CIENCIA DO SOLO','0100-0683',0.611000,0.003550,0.405160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Groundwater','Groundwater','0017-467X',1.947000,0.005580,0.635550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Water Resour. Assoc.','JOURNAL OF THE AMERICAN WATER RESOURCES ASSOCIATION','1093-474X',1.659000,0.005100,0.580760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Water Work Assoc.','JOURNAL AMERICAN WATER WORKS ASSOCIATION','2164-4535',0.505000,0.001450,0.164740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hydro-environ. Res.','Journal of Hydro-environment Research','1570-6443',1.971000,0.001870,0.213420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pipel. Syst. Eng. Pract.','Journal of Pipeline Systems Engineering and Practice','1949-1190',0.896000,0.000560,0.064200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('River Res. Appl.','RIVER RESEARCH AND APPLICATIONS','1535-1459',1.980000,0.005830,0.664660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tecnol. Cienc. Agua','Tecnologia y Ciencias del Agua','0187-8336',0.108000,0.000090,0.010080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Vadose Zone J.','VADOSE ZONE JOURNAL','1539-1663',1.737000,0.007550,0.860310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Air Soil Pollut.','WATER AIR AND SOIL POLLUTION','0049-6979',1.551000,0.013010,1.482730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Conv. Manag.','ENERGY CONVERSION AND MANAGEMENT','0196-8904',4.801000,0.033620,3.832110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fluid Dyn. Res.','FLUID DYNAMICS RESEARCH','0169-5983',0.846000,0.001930,0.219430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Fract.','INTERNATIONAL JOURNAL OF FRACTURE','0376-9429',1.642000,0.006680,0.760920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Elast.','JOURNAL OF ELASTICITY','0374-3535',1.656000,0.002380,0.271790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hydrodyn.','Journal of Hydrodynamics','1001-6058',0.776000,0.002320,0.264170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Math. Fluid Mech.','Journal of Mathematical Fluid Mechanics','1422-6928',1.023000,0.003200,0.364200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nonlinear Sci.','JOURNAL OF NONLINEAR SCIENCE','0938-8974',2.068000,0.003520,0.401570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Therm. Stresses','JOURNAL OF THERMAL STRESSES','0149-5739',1.211000,0.001790,0.204470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Comput. Neurosci.','Frontiers in Computational Neuroscience','1662-5188',2.653000,0.007510,0.855590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Neuroinformatics','Frontiers in Neuroinformatics','1662-5196',3.047000,0.004250,0.484450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Neurorobotics','Frontiers in Neurorobotics','1662-5218',1.723000,0.000780,0.089290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genes Brain Behav.','GENES BRAIN AND BEHAVIOR','1601-1848',3.275000,0.008100,0.923620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Dev. Neurosci.','INTERNATIONAL JOURNAL OF DEVELOPMENTAL NEUROSCIENCE','0736-5748',2.380000,0.005390,0.613860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Neuropsychopharmacol.','INTERNATIONAL JOURNAL OF NEUROPSYCHOPHARMACOLOGY','1461-1457',4.333000,0.013780,1.571130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin. Neurosci.','JOURNAL OF CLINICAL NEUROSCIENCE','0967-5868',1.387000,0.014140,1.611250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comp. Physiol. A -Neuroethol. Sens. Neural Behav. Physiol.','JOURNAL OF COMPARATIVE PHYSIOLOGY A-NEUROETHOLOGY SENSORY NEURAL AND BEHAVIORAL PHYSIOLOGY','0340-7594',1.988000,0.004890,0.556820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Electromyogr. Kinesiol.','JOURNAL OF ELECTROMYOGRAPHY AND KINESIOLOGY','1050-6411',1.530000,0.006640,0.756940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hist. Neurosci.','Journal of the History of the Neurosciences','0964-704X',0.529000,0.000330,0.038020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neurol. Sci.','JOURNAL OF THE NEUROLOGICAL SCIENCES','0022-510X',2.126000,0.021850,2.490210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genes Nutr.','Genes and Nutrition','1555-8932',2.398000,0.002750,0.312900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genetika-Belgrade','Genetika-Belgrade','0534-0012',0.308000,0.000360,0.041030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hum. Genet.','HUMAN GENETICS','0340-6717',5.138000,0.017720,2.019530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Genet. Couns.','Journal of Genetic Counseling','1059-7700',2.030000,0.003950,0.450290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nutrigenet. Nutrigenomics','Journal of Nutrigenetics and Nutrigenomics','1661-6499',1.488000,0.000740,0.084840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Diagn. Ther.','Molecular Diagnosis & Therapy','1177-1062',2.602000,0.001680,0.191140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Qual. Technol.','JOURNAL OF QUALITY TECHNOLOGY','0022-4065',1.578000,0.002340,0.266570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('M&SOM-Manuf. Serv. Oper. Manag.','M&SOM-Manufacturing & Service Operations Management','1523-4614',1.966000,0.005940,0.676520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nav. Res. Logist.','NAVAL RESEARCH LOGISTICS','0894-069X',0.787000,0.002660,0.302820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Omega-Int. J. Manage. Sci.','OMEGA-INTERNATIONAL JOURNAL OF MANAGEMENT SCIENCE','0305-0483',3.962000,0.007370,0.839650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oper. Res.','OPERATIONS RESEARCH','0030-364X',1.777000,0.016180,1.844090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Probab. Eng. Inform. Sci.','PROBABILITY IN THE ENGINEERING AND INFORMATIONAL SCIENCES','0269-9648',0.390000,0.000930,0.105800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Qual. Reliab. Eng. Int.','QUALITY AND RELIABILITY ENGINEERING INTERNATIONAL','0748-8017',1.457000,0.003180,0.362290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('SORT-Stat. Oper. Res. Trans.','SORT-Statistics and Operations Research Transactions','1696-2281',0.414000,0.000450,0.051190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Meccanica','MECCANICA','0025-6455',1.828000,0.004740,0.539790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mech. Res. Commun.','MECHANICS RESEARCH COMMUNICATIONS','0093-6413',1.400000,0.004570,0.521410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mechanika','Mechanika','1392-1207',0.277000,0.000590,0.066760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Multibody Syst. Dyn.','MULTIBODY SYSTEM DYNAMICS','1384-5640',1.389000,0.001780,0.202860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ZAMM-Z. Angew. Math. Mech.','ZAMM-Zeitschrift fur Angewandte Mathematik und Mechanik','0044-2267',1.293000,0.003150,0.359140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Chem. Lab. Med.','CLINICAL CHEMISTRY AND LABORATORY MEDICINE','1434-6621',3.017000,0.012090,1.378290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Crit. Rev. Clin. Lab. Sci.','CRITICAL REVIEWS IN CLINICAL LABORATORY SCIENCES','1040-8363',4.167000,0.001620,0.184190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Immuno-anal. Biol. spec.','Immuno-analyse & Biologie specialisee','0923-2532',0.074000,0.000040,0.004460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Chin. Med.','AMERICAN JOURNAL OF CHINESE MEDICINE','0192-415X',2.959000,0.002730,0.311560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Intell. Syst.','IEEE INTELLIGENT SYSTEMS','1541-1672',3.532000,0.003500,0.398510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE J. Emerg. Sel. Top. Power Electron.','IEEE Journal of Emerging and Selected Topics in Power Electronics','2168-6777',3.129000,0.003040,0.346720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Latin Am. Trans.','IEEE Latin America Transactions','1548-0992',0.436000,0.000530,0.060780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Microw. Wirel. Compon. Lett.','IEEE MICROWAVE AND WIRELESS COMPONENTS LETTERS','1531-1309',1.599000,0.014440,1.645870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Signal Process. Mag.','IEEE SIGNAL PROCESSING MAGAZINE','1053-5888',6.671000,0.018620,2.122020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Circuits Syst. Video Technol.','IEEE TRANSACTIONS ON CIRCUITS AND SYSTEMS FOR VIDEO TECHNOLOGY','1051-8215',2.254000,0.013250,1.510570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Circuits Syst. I-Regul. Pap.','IEEE TRANSACTIONS ON CIRCUITS AND SYSTEMS I-REGULAR PAPERS','1549-8328',2.393000,0.027540,3.138540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Ind. Appl.','IEEE TRANSACTIONS ON INDUSTRY APPLICATIONS','0093-9994',1.901000,0.017360,1.978350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Pattern Anal. Mach. Intell.','IEEE TRANSACTIONS ON PATTERN ANALYSIS AND MACHINE INTELLIGENCE','0162-8828',6.077000,0.061200,6.975040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Power Deliv.','IEEE TRANSACTIONS ON POWER DELIVERY','0885-8977',2.032000,0.020810,2.371670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Power Syst.','IEEE TRANSACTIONS ON POWER SYSTEMS','0885-8950',3.342000,0.035630,4.061350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plasmid','PLASMID','0147-619X',1.732000,0.001820,0.207040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Geogr. Slov.','Acta Geographica Slovenica-Geografski Zbornik','1581-6613',0.267000,0.000090,0.010370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aeolian Res.','Aeolian Research','1875-9637',2.275000,0.002830,0.322270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arct. Antarct. Alp. Res.','ARCTIC ANTARCTIC AND ALPINE RESEARCH','1523-0430',1.455000,0.002730,0.310960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Geogr. Sci.','Journal of Geographical Sciences','1009-637X',1.923000,0.002760,0.315150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Permafrost Periglacial Process.','PERMAFROST AND PERIGLACIAL PROCESSES','1045-6740',2.000000,0.002410,0.274170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bol. Soc. Geol. Mex.','Boletin de la Sociedad Geologica Mexicana','1405-3322',0.679000,0.000530,0.060330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Carbonates Evaporites','CARBONATES AND EVAPORITES','0891-2556',0.440000,0.000500,0.056610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Facies','FACIES','0172-9179',1.690000,0.001680,0.190990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geofluids','GEOFLUIDS','1468-8115',1.750000,0.002410,0.274920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biofouling','BIOFOULING','0892-7014',3.000000,0.005670,0.646530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Crustaceana','CRUSTACEANA','0011-216X',0.664000,0.001700,0.194240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Biol. Fishes','ENVIRONMENTAL BIOLOGY OF FISHES','0378-1909',1.404000,0.005180,0.590240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fish Shellfish Immunol.','FISH & SHELLFISH IMMUNOLOGY','1050-4648',3.025000,0.014970,1.706830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ICES J. Mar. Sci.','ICES JOURNAL OF MARINE SCIENCE','1054-3139',2.626000,0.013350,1.522150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ichthyol. Explor. Freshw.','ICHTHYOLOGICAL EXPLORATION OF FRESHWATERS','0936-9902',0.594000,0.000540,0.061930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Aquat. Plant Manage.','JOURNAL OF AQUATIC PLANT MANAGEMENT','0146-6623',0.257000,0.000230,0.026200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Crustac. Biol.','JOURNAL OF CRUSTACEAN BIOLOGY','0278-0372',0.922000,0.001770,0.201250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Fish Dis.','JOURNAL OF FISH DISEASES','0140-7775',2.053000,0.004160,0.474260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Molluscan Stud.','JOURNAL OF MOLLUSCAN STUDIES','0260-1230',1.185000,0.001670,0.189980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Limnetica','LIMNETICA','0213-8409',0.569000,0.000730,0.082680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Med.','CLINICAL MEDICINE','1470-2118',1.632000,0.003240,0.369520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Med. Res. Opin.','CURRENT MEDICAL RESEARCH AND OPINION','0300-7995',2.643000,0.011960,1.363320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Intern. Med.','European Journal of Internal Medicine','0953-6205',2.591000,0.007730,0.881210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fam. Med.','FAMILY MEDICINE','0742-3225',0.981000,0.002530,0.288150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Med. Res.','INDIAN JOURNAL OF MEDICAL RESEARCH','0971-5916',1.446000,0.007410,0.844990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Intern. Med. J.','INTERNAL MEDICINE JOURNAL','1444-0903',1.526000,0.006430,0.732600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Irish J. Med. Sci.','IRISH JOURNAL OF MEDICAL SCIENCE','0021-1265',1.158000,0.002290,0.261440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Intern. Med.','JOURNAL OF INTERNAL MEDICINE','0954-6820',7.803000,0.017520,1.996880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Technol. Soc. Mag.','IEEE TECHNOLOGY AND SOCIETY MAGAZINE','0278-0097',0.635000,0.000310,0.035830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEICE Trans. Commun.','IEICE TRANSACTIONS ON COMMUNICATIONS','0916-8516',0.300000,0.002420,0.275880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IET Circ. Devices Syst.','IET Circuits Devices & Systems','1751-858X',0.590000,0.001090,0.124060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IET Commun.','IET Communications','1751-8628',0.624000,0.006180,0.704440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IET Comput. Vis.','IET Computer Vision','1751-9632',0.573000,0.000960,0.109430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IETE Tech. Rev.','IETE TECHNICAL REVIEW','0256-4602',1.304000,0.000720,0.082080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Electr. Power Energy Syst.','INTERNATIONAL JOURNAL OF ELECTRICAL POWER & ENERGY SYSTEMS','0142-0615',2.587000,0.015030,1.713190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Electron.','INTERNATIONAL JOURNAL OF ELECTRONICS','0020-7217',0.414000,0.000830,0.094320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Robust Nonlinear Control','INTERNATIONAL JOURNAL OF ROBUST AND NONLINEAR CONTROL','1049-8923',2.527000,0.010520,1.198630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Circuits Syst. Comput.','JOURNAL OF CIRCUITS SYSTEMS AND COMPUTERS','0218-1266',0.308000,0.000540,0.061240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Disp. Technol.','Journal of Display Technology','1551-319X',1.925000,0.004930,0.562020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Electron. Mater.','JOURNAL OF ELECTRONIC MATERIALS','0361-5235',1.491000,0.013150,1.498770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geology','GEOLOGY','0091-7613',4.548000,0.047760,5.443280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('GFF','GFF','1103-5897',1.179000,0.001140,0.130350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Himal. Geol.','HIMALAYAN GEOLOGY','0971-8966',0.350000,0.000150,0.016730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Iber. Geol.','JOURNAL OF IBERIAN GEOLOGY','1698-6180',1.827000,0.001200,0.136400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Earth Planet. Sci.','Annual Review of Earth and Planetary Sciences','0084-6597',7.810000,0.011550,1.316970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Archaeol. Prospect.','Archaeological Prospection','1075-2196',1.327000,0.000840,0.095530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ArcheoSciences-Rev. Archeom.','ArcheoSciences-Revue d Archeometrie','1960-1360',0.111000,0.000100,0.011940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Astrobiology','ASTROBIOLOGY','1531-1074',2.628000,0.005760,0.657070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biogeosciences','Biogeosciences','1726-4170',3.700000,0.048120,5.484850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Boreas','BOREAS','0300-9483',2.386000,0.004210,0.479790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Geosci.','COMPUTERS & GEOSCIENCES','0098-3004',2.474000,0.014800,1.686700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Earth Interact.','Earth Interactions','1087-3562',1.319000,0.001620,0.184780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('N. Z. J. Mar. Freshw. Res.','NEW ZEALAND JOURNAL OF MARINE AND FRESHWATER RESEARCH','0028-8330',0.864000,0.000900,0.102280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phycologia','PHYCOLOGIA','0031-8884',1.628000,0.002100,0.239390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Fish. Biol. Fish.','REVIEWS IN FISH BIOLOGY AND FISHERIES','0960-3166',3.222000,0.003670,0.418800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Chem. Technol.','CELLULOSE CHEMISTRY AND TECHNOLOGY','0576-9787',0.562000,0.001390,0.158000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('For. Prod. J.','FOREST PRODUCTS JOURNAL','0015-7473',0.481000,0.001060,0.120610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Wood Chem. Technol.','JOURNAL OF WOOD CHEMISTRY AND TECHNOLOGY','0277-3813',1.830000,0.000860,0.098260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ceram.-Silik.','CERAMICS-SILIKATY','0862-5468',0.485000,0.000550,0.063050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Adv. Ceram.','Journal of Advanced Ceramics','2226-4108',0.957000,0.000490,0.055970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Powder Metall. Met. Ceram.','POWDER METALLURGY AND METAL CERAMICS','1068-1302',0.235000,0.000430,0.048550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Korean J. Intern. Med.','KOREAN JOURNAL OF INTERNAL MEDICINE','1226-3303',1.679000,0.002120,0.241800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Libyan J. Med.','Libyan Journal of Medicine','1993-2820',1.429000,0.000400,0.045190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Clin. N. Am.','MEDICAL CLINICS OF NORTH AMERICA','0025-7125',2.333000,0.003380,0.385340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Medicine (Baltimore)','MEDICINE','0025-7974',2.133000,0.007630,0.869580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neth. J. Med.','NETHERLANDS JOURNAL OF MEDICINE','0300-2977',1.489000,0.003050,0.347950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Palliat. Med.','PALLIATIVE MEDICINE','0269-2163',3.685000,0.006890,0.785480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Patient Prefer. Adherence','Patient Preference and Adherence','1177-889X',1.718000,0.003870,0.441520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pol. Arch. Med. Wewn.','Polskie Archiwum Medycyny Wewnetrznej-Polish Archives of Internal Medicine','0032-3772',2.054000,0.001670,0.190470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Assoc. Med. Bras.','Revista da Associacao Medica Brasileira','0104-4230',0.664000,0.001760,0.201080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sex. Med.','Sexual Medicine','2050-1161',1.188000,0.000180,0.020550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anti-Corros. Methods Mater.','ANTI-CORROSION METHODS AND MATERIALS','0003-5599',0.424000,0.000430,0.049510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. Metall. Q.','CANADIAN METALLURGICAL QUARTERLY','0008-4433',0.479000,0.000790,0.089620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('China Foundry','China Foundry','1672-6421',0.354000,0.000310,0.035100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mod. Power Syst. Clean Energy','Journal of Modern Power Systems and Clean Energy','2196-5625',0.975000,0.000310,0.035670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Real-Time Image Process.','Journal of Real-Time Image Processing','1861-8200',1.564000,0.000860,0.097660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Signal Process. Syst. Signal Image Video Technol.','Journal of Signal Processing Systems for Signal Image and Video Technology','1939-8018',0.508000,0.001890,0.214850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Syst. Eng. Electron.','Journal of Systems Engineering and Electronics','1004-4132',0.468000,0.001280,0.145780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mach. Vis. Appl.','MACHINE VISION AND APPLICATIONS','0932-8092',1.272000,0.003610,0.411650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microsyst. Technol.','MICROSYSTEM TECHNOLOGIES-MICRO-AND NANOSYSTEMS-INFORMATION STORAGE AND PROCESSING SYSTEMS','0946-7076',0.974000,0.004200,0.478240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Quantum Electron.','PROGRESS IN QUANTUM ELECTRONICS','0079-6727',6.923000,0.001410,0.161040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Quantum Electron.','QUANTUM ELECTRONICS','1063-7818',0.978000,0.003370,0.383610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semicond. Sci. Technol.','SEMICONDUCTOR SCIENCE AND TECHNOLOGY','0268-1242',2.098000,0.012870,1.467370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Turk. J. Electr. Eng. Comput. Sci.','Turkish Journal of Electrical Engineering and Computer Sciences','1300-0632',0.518000,0.001010,0.114790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ASHRAE J.','ASHRAE JOURNAL','0001-2491',0.223000,0.000410,0.046800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Comput.','ENGINEERING WITH COMPUTERS','0177-0667',1.460000,0.001520,0.173220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Earth-Sci. Rev.','EARTH-SCIENCE REVIEWS','0012-8252',6.991000,0.021550,2.456820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Est. J. Earth Sci.','Estonian Journal of Earth Sciences','1736-4728',0.732000,0.000610,0.069460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geodin. Acta','GEODINAMICA ACTA','0985-3111',1.714000,0.000290,0.032810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geomorphologie','Geomorphologie-Relief Processus Environnement','1266-5304',0.673000,0.000400,0.045400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geosci. Data J.','Geoscience Data Journal','2049-6060',1.562000,0.000240,0.027640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geotech. Test. J.','GEOTECHNICAL TESTING JOURNAL','0149-6115',0.663000,0.002170,0.246940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Speleol.','INTERNATIONAL JOURNAL OF SPELEOLOGY','0392-6672',1.559000,0.000990,0.113160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Mech. Solida Sin.','ACTA MECHANICA SOLIDA SINICA','0894-9166',0.692000,0.001750,0.199160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Electron. Mater.','Advanced Electronic Materials','2199-160X',0.000000,0.000000,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Beilstein J. Nanotechnol.','Beilstein Journal of Nanotechnology','2190-4286',2.778000,0.006670,0.760430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Solid State Mat. Sci.','CURRENT OPINION IN SOLID STATE & MATERIALS SCIENCE','1359-0286',5.111000,0.005870,0.668890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electron. Mater. Lett.','Electronic Materials Letters','1738-8090',2.057000,0.003260,0.371250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Image Anal. Stereol.','Image Analysis & Stereology','1580-3139',0.500000,0.000620,0.071200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Midem-J. Microelectron. Electron. Compon. Mater.','INFORMACIJE MIDEM-JOURNAL OF MICROELECTRONICS ELECTRONIC COMPONENTS AND MATERIALS','0352-9045',0.433000,0.000290,0.032600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hydrometallurgy','HYDROMETALLURGY','0304-386X',2.290000,0.009060,1.032800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mater. Res.','International Journal of Materials Research','1862-5282',0.687000,0.002860,0.326250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Met.','International Journal of Metalcasting','1939-5981',0.196000,0.000130,0.015200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. S. Afr. Inst. Min. Metall.','Journal of the Southern African Institute of Mining and Metallurgy','2225-6253',0.237000,0.000830,0.094050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Korean J. Met. Mater.','Korean Journal of Metals and Materials','1738-8228',1.360000,0.001470,0.167320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Philos. Mag.','PHILOSOPHICAL MAGAZINE','1478-6435',1.632000,0.014970,1.706310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Powder Metall. Met. Ceram.','POWDER METALLURGY AND METAL CERAMICS','1068-1302',0.235000,0.000430,0.048550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rare Metals','RARE METALS','1001-0521',0.957000,0.001660,0.189150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Metall.-Cah. Inf. Techn.','REVUE DE METALLURGIE-CAHIERS D INFORMATIONS TECHNIQUES','0035-1563',0.432000,0.000130,0.014940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Weld. World','Welding in the World','0043-2288',0.861000,0.001340,0.153280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Med. Okayama','ACTA MEDICA OKAYAMA','0386-300X',0.596000,0.000830,0.094750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Ther.','ADVANCES IN THERAPY','0741-238X',2.503000,0.004080,0.464540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Crashworthiness','INTERNATIONAL JOURNAL OF CRASHWORTHINESS','1358-8265',0.680000,0.000910,0.103410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Plast.','INTERNATIONAL JOURNAL OF PLASTICITY','0749-6419',5.623000,0.017490,1.993430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Braz. Soc. Mech. Sci. Eng.','Journal of the Brazilian Society of Mechanical Sciences and Engineering','1678-5878',0.963000,0.000880,0.100600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chin. Soc. Mech. Eng.','Journal of the Chinese Society of Mechanical Engineers','0257-9731',0.130000,0.000180,0.020920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Enhanc. Heat Transf.','JOURNAL OF ENHANCED HEAT TRANSFER','1065-5131',0.562000,0.000430,0.049560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mech. Sci. Technol.','Journal of Mechanical Science and Technology','1738-494X',0.761000,0.006850,0.780680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Therm. Sci.','Journal of Thermal Science','1003-2169',0.543000,0.001150,0.130670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Jokull','Jokull','0449-0576',0.833000,0.000330,0.037600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Paleogeogr. Paleoclimatol. Paleoecol.','PALAEOGEOGRAPHY PALAEOCLIMATOLOGY PALAEOECOLOGY','0031-0182',2.525000,0.028460,3.244100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photogramm. Eng. Remote Sens.','PHOTOGRAMMETRIC ENGINEERING AND REMOTE SENSING','0099-1112',1.288000,0.003220,0.367230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Geogr.','PHYSICAL GEOGRAPHY','0272-3646',0.875000,0.000740,0.084080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Q. J. Eng. Geol. Hydrogeol.','QUARTERLY JOURNAL OF ENGINEERING GEOLOGY AND HYDROGEOLOGY','1470-9236',1.058000,0.000740,0.084280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Swiss J. Geosci.','Swiss Journal of Geosciences','1661-8726',1.660000,0.001250,0.142910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Age','AGE','0161-9152',2.500000,0.007710,0.878410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Age Ageing','AGE AND AGEING','0002-0729',4.201000,0.015010,1.711260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Numer. Anal. Methods Geomech.','INTERNATIONAL JOURNAL FOR NUMERICAL AND ANALYTICAL METHODS IN GEOMECHANICS','0363-9061',1.758000,0.006220,0.708420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Intermetallics','INTERMETALLICS','0966-9795',2.541000,0.015830,1.804650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Adhes.','JOURNAL OF ADHESION','0021-8464',1.409000,0.001560,0.177640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Elast.','JOURNAL OF ELASTICITY','0374-3535',1.656000,0.002380,0.271790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Elastomer Plast.','JOURNAL OF ELASTOMERS AND PLASTICS','0095-2443',0.671000,0.000540,0.061120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Exp. Nanosci.','Journal of Experimental Nanoscience','1745-8080',0.832000,0.000990,0.112680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Laser Appl.','JOURNAL OF LASER APPLICATIONS','1042-346X',1.078000,0.001000,0.114150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mater. Res.','JOURNAL OF MATERIALS RESEARCH','0884-2914',1.579000,0.015420,1.757660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mater. Sci.-Mater. Electron.','JOURNAL OF MATERIALS SCIENCE-MATERIALS IN ELECTRONICS','0957-4522',1.798000,0.008580,0.977670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nanosci. Nanotechnol.','JOURNAL OF NANOSCIENCE AND NANOTECHNOLOGY','1533-4880',1.338000,0.020130,2.294820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Phys. Chem. Lett.','Journal of Physical Chemistry Letters','1948-7185',8.539000,0.118650,13.523400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Porous Mat.','JOURNAL OF POROUS MATERIALS','1380-2224',1.385000,0.002540,0.289500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomed. Res.','BIOMEDICAL RESEARCH-TOKYO','0388-6107',0.953000,0.001010,0.114910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Biother. Radiopharm.','CANCER BIOTHERAPY AND RADIOPHARMACEUTICALS','1084-9785',1.715000,0.002500,0.284610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dis. Markers','DISEASE MARKERS','0278-0240',2.137000,0.004460,0.508710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Clin. Invest.','EUROPEAN JOURNAL OF CLINICAL INVESTIGATION','0014-2972',2.687000,0.009540,1.087740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Ther. Med.','Experimental and Therapeutic Medicine','1792-0981',1.280000,0.008680,0.988900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Med. Res.','INDIAN JOURNAL OF MEDICAL RESEARCH','0971-5916',1.446000,0.007410,0.844990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biol. Regul. Homeost. Agents','JOURNAL OF BIOLOGICAL REGULATORS AND HOMEOSTATIC AGENTS','0393-974X',1.546000,0.002270,0.259130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomed. Sci.','JOURNAL OF BIOMEDICAL SCIENCE','1021-7770',2.935000,0.006370,0.726280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Gene. Med.','JOURNAL OF GENE MEDICINE','1099-498X',3.246000,0.002560,0.292200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Int. Med. Res.','JOURNAL OF INTERNATIONAL MEDICAL RESEARCH','0300-0605',1.431000,0.006310,0.718650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Genet. Metab.','MOLECULAR GENETICS AND METABOLISM','1096-7192',3.093000,0.014350,1.635210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mech. Sci.','Mechanical Sciences','2191-9151',1.200000,0.000620,0.070160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Eng. Mech.','STRUCTURAL ENGINEERING AND MECHANICS','1225-4568',1.021000,0.002530,0.288940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trans. FAMENA','Transactions of FAMENA','1333-1124',0.317000,0.000150,0.016720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wear','WEAR','0043-1648',2.323000,0.017920,2.042280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Geotech.','Acta Geotechnica','1861-1125',2.426000,0.002450,0.279800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Earthq. Eng.','Bulletin of Earthquake Engineering','1570-761X',2.036000,0.004920,0.561080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geotechnique','GEOTECHNIQUE','0016-8505',2.000000,0.007750,0.883490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geotext. Geomembr.','GEOTEXTILES AND GEOMEMBRANES','0266-1144',2.366000,0.003420,0.390250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Geomech.','International Journal of Geomechanics','1532-3641',1.387000,0.002410,0.274770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Environ. Eng. Geophys.','JOURNAL OF ENVIRONMENTAL AND ENGINEERING GEOPHYSICS','1083-1363',0.619000,0.000300,0.034280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Insect Physiol.','Advances in Insect Physiology','0065-2806',3.417000,0.000800,0.091180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Psychogeriatr.','INTERNATIONAL PSYCHOGERIATRICS','1041-6102',2.220000,0.010100,1.151610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Geriatr. Soc.','JOURNAL OF THE AMERICAN GERIATRICS SOCIETY','0002-8614',3.842000,0.038510,4.389820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Gerontol. Ser. A-Biol. Sci. Med. Sci.','JOURNALS OF GERONTOLOGY SERIES A-BIOLOGICAL SCIENCES AND MEDICAL SCIENCES','1079-5006',5.476000,0.021550,2.456790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Gerontol. Nurs.','Journal of Gerontological Nursing','0098-9134',0.940000,0.001350,0.153500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rejuv. Res.','REJUVENATION RESEARCH','1549-1684',3.664000,0.002830,0.322140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Blood Rev.','BLOOD REVIEWS','0268-960X',6.627000,0.004980,0.567200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Hemorheol. Microcirc.','CLINICAL HEMORHEOLOGY AND MICROCIRCULATION','1386-0291',1.815000,0.002920,0.332750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Hematol.','EXPERIMENTAL HEMATOLOGY','0301-472X',2.303000,0.007250,0.826850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hematol. Oncol. Clin. North Am.','HEMATOLOGY-ONCOLOGY CLINICS OF NORTH AMERICA','0889-8588',2.806000,0.004650,0.529820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lancet Haematol.','Lancet Haematology','2352-3026',4.889000,0.000320,0.036170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Horizons','Materials Horizons','2051-6347',9.095000,0.003060,0.348430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Lett.','MATERIALS LETTERS','0167-577X',2.437000,0.047810,5.449500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Struct.','MATERIALS AND STRUCTURES','1359-5997',2.453000,0.008130,0.926780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Materia','Materia-Rio de Janeiro','1517-7076',0.145000,0.000030,0.003420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mech. Mater.','MECHANICS OF MATERIALS','0167-6636',2.636000,0.008580,0.978350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Micro Nano Lett.','Micro & Nano Letters','1750-0443',0.723000,0.002700,0.308290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microsyst. Technol.','MICROSYSTEM TECHNOLOGIES-MICRO-AND NANOSYSTEMS-INFORMATION STORAGE AND PROCESSING SYSTEMS','0946-7076',0.974000,0.004200,0.478240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('MRS Commun.','MRS Communications','2159-6859',1.797000,0.001110,0.126020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanotechnology','NANOTECHNOLOGY','0957-4484',3.573000,0.072640,8.279710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Org. Electron.','ORGANIC ELECTRONICS','1566-1199',3.471000,0.025200,2.871830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuromodulation','NEUROMODULATION','1094-7159',2.409000,0.002840,0.323980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Xenotransplantation','XENOTRANSPLANTATION','0908-665X',3.789000,0.001990,0.227040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Biomater.','Acta Biomaterialia','1742-7061',6.008000,0.053810,6.133070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomaterials','BIOMATERIALS','0142-9612',8.387000,0.148530,16.929310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomater. Appl.','JOURNAL OF BIOMATERIALS APPLICATIONS','0885-3282',1.988000,0.002760,0.314870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mat. Chem. B','Journal of Materials Chemistry B','2050-750X',4.872000,0.023020,2.624290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Pavement Eng.','International Journal of Pavement Engineering','1029-8436',0.877000,0.001780,0.203330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Soc. Entomol. Fr.','ANNALES DE LA SOCIETE ENTOMOLOGIQUE DE FRANCE','0037-9271',0.575000,0.000840,0.095530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Insect Biochem. Physiol.','ARCHIVES OF INSECT BIOCHEMISTRY AND PHYSIOLOGY','0739-4462',1.357000,0.001600,0.182910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Austral Entomol.','Austral Entomology','2052-1758',1.114000,0.000240,0.026950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Entomol. Res.','BULLETIN OF ENTOMOLOGICAL RESEARCH','0007-4853',1.761000,0.003270,0.372470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecol. Entomol.','ECOLOGICAL ENTOMOLOGY','0307-6946',1.687000,0.004650,0.529520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Entomol. Sci.','ENTOMOLOGICAL SCIENCE','1343-8786',1.144000,0.001320,0.150620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Entomol.','ENVIRONMENTAL ENTOMOLOGY','0046-225X',1.315000,0.006780,0.772530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Insect. Conserv. Divers.','Insect Conservation and Diversity','1752-458X',2.367000,0.003100,0.353860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Insect Sci.','Insect Science','1672-9609',2.551000,0.003190,0.363570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Pest Manage.','INTERNATIONAL JOURNAL OF PEST MANAGEMENT','0967-0874',0.373000,0.000920,0.105160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Mosq. Control Assoc.','JOURNAL OF THE AMERICAN MOSQUITO CONTROL ASSOCIATION','8756-971X',0.824000,0.001120,0.127640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Arachnol.','JOURNAL OF ARACHNOLOGY','0161-8202',0.691000,0.001300,0.148600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Orient. Insects','ORIENTAL INSECTS','0030-5316',0.360000,0.000210,0.023420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physiol. Entomol.','PHYSIOLOGICAL ENTOMOLOGY','0307-6962',1.530000,0.001750,0.199700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Platelets','PLATELETS','0953-7104',3.213000,0.004690,0.534190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Algorithms. Mol. Biol.','Algorithms for Molecular Biology','1748-7188',1.439000,0.002930,0.334130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Math. Biol.','BULLETIN OF MATHEMATICAL BIOLOGY','0092-8240',1.326000,0.005730,0.652750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BioData Min.','BioData Mining','1756-0381',1.640000,0.001040,0.118750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biom. J.','BIOMETRICAL JOURNAL','0323-3847',0.683000,0.003460,0.394120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Intell. Neurosci.','Computational Intelligence and Neuroscience','1687-5265',0.430000,0.004490,0.511240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Biomath.','International Journal of Biomathematics','1793-5245',0.938000,0.000810,0.092630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Biol.','JOURNAL OF COMPUTATIONAL BIOLOGY','1066-5277',1.537000,0.007550,0.860480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Status Solidi-Rapid Res. Lett.','Physica Status Solidi-Rapid Research Letters','1862-6254',2.578000,0.008390,0.956310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rapid Prototyping J.','RAPID PROTOTYPING JOURNAL','1355-2546',1.352000,0.001840,0.209510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Rom. Mat.','Revista Romana de Materiale-Romanian Journal of Materials','1583-3186',0.612000,0.000180,0.020920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Road Mater. Pavement Des.','Road Materials and Pavement Design','1468-0629',1.547000,0.002320,0.263920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Technol. Adv. Mater.','SCIENCE AND TECHNOLOGY OF ADVANCED MATERIALS','1468-6996',3.433000,0.006940,0.790710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Scr. Mater.','SCRIPTA MATERIALIA','1359-6462',3.305000,0.044060,5.021900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sens. Mater.','SENSORS AND MATERIALS','0914-4935',0.489000,0.000350,0.039510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Appl. Math.','ADVANCES IN APPLIED MATHEMATICS','0196-8858',0.833000,0.004520,0.514790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Funct. Anal.','Annals of Functional Analysis','2008-8752',0.492000,0.000740,0.084630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Cryst. Growth Charact. Mater.','PROGRESS IN CRYSTAL GROWTH AND CHARACTERIZATION OF MATERIALS','0960-8974',4.750000,0.000420,0.048000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Quant. Infrared Thermogr. J.','Quantitative InfraRed Thermography Journal','1768-6733',1.200000,0.000560,0.063850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Strength Mater-Engl. Tr.','STRENGTH OF MATERIALS','0039-2316',0.462000,0.000510,0.057650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Surf. Sci.','APPLIED SURFACE SCIENCE','0169-4332',3.150000,0.082460,9.399160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Plast. Film Sheeting','JOURNAL OF PLASTIC FILM & SHEETING','8756-0879',0.850000,0.000220,0.024910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pigm. Resin. Technol.','Pigment & Resin Technology','0369-9420',0.697000,0.000390,0.044840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surf. Coat. Int.','SURFACE COATINGS INTERNATIONAL','1754-0925',0.061000,0.000010,0.000940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Compos. Interfaces','COMPOSITE INTERFACES','0927-6440',1.046000,0.000690,0.079190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plast. Rubber Compos.','PLASTICS RUBBER AND COMPOSITES','1465-8011',0.570000,0.000580,0.066450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polym. Compos.','POLYMER COMPOSITES','0272-8397',2.004000,0.006920,0.788790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Rubber Plast. Recycl. Technol.','Progress in Rubber Plastics and Recycling Technology','1477-7606',0.212000,0.000070,0.008200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('AATCC J. Res.','AATCC Journal of Research','2330-5517',0.167000,0.000020,0.001790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fibre Chem.','FIBRE CHEMISTRY','0015-0541',0.214000,0.000140,0.016280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Eng. Fiber Fabr.','Journal of Engineered Fibers and Fabrics','1558-9250',0.538000,0.001030,0.117690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tekst. Konfeksiyon','Tekstil ve Konfeksiyon','1300-3356',0.287000,0.000290,0.032820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prim. Care Diabetes','Primary Care Diabetes','1751-9918',1.570000,0.001650,0.188630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryptologia','CRYPTOLOGIA','0161-1194',0.213000,0.000080,0.009540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Phys. J. H','European Physical Journal H','2102-6459',0.918000,0.000890,0.101950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Hist. Math.','Revue d Histoire des Mathematiques','1262-022X',0.364000,0.000330,0.037910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Erwerbs-Obstbau','Erwerbs-Obstbau','0014-0309',0.481000,0.000100,0.010980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asymptotic Anal.','ASYMPTOTIC ANALYSIS','0921-7134',0.414000,0.002220,0.253200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Math. Sci.','Communications in Mathematical Sciences','1539-6746',1.198000,0.004280,0.488010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryptologia','CRYPTOLOGIA','0161-1194',0.213000,0.000080,0.009540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Differ. Integral Equ.','Differential and Integral Equations','0893-4983',0.851000,0.003900,0.444420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dyn. Partial Differ. Equ.','Dynamics of Partial Differential Equations','1548-159X',0.686000,0.000920,0.104660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electron. J. Qual. Theory Differ.','Electronic Journal of Qualitative Theory of Differential Equations','1417-3875',0.732000,0.001670,0.190030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Evol. Equ. Control Theory','Evolution Equations and Control Theory','2163-2480',0.557000,0.000600,0.068520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fixed Point Theory','Fixed Point Theory','1583-5022',0.581000,0.000630,0.072310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Forum Math.','FORUM MATHEMATICUM','0933-7741',0.823000,0.003590,0.409070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Notre Dame J. Form. Log.','Notre Dame Journal of Formal Logic','0029-4527',0.538000,0.001360,0.154690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Symb. Log.','Review of Symbolic Logic','1755-0203',0.588000,0.001020,0.116000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geomat. Nat. Hazards Risk','Geomatics Natural Hazards & Risk','1947-5705',2.140000,0.000550,0.063220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Disaster Risk Reduct.','International Journal of Disaster Risk Reduction','2212-4209',1.242000,0.000620,0.071020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Agrometeorol.','Journal of Agrometeorology','0972-1665',0.361000,0.000220,0.025570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Air Waste Manage. Assoc.','JOURNAL OF THE AIR & WASTE MANAGEMENT ASSOCIATION','1096-2247',1.613000,0.005370,0.612380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Atmos. Chem.','JOURNAL OF ATMOSPHERIC CHEMISTRY','0167-7764',1.550000,0.000940,0.106930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Hazards Rev.','Natural Hazards Review','1527-6988',1.293000,0.001160,0.132390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Agr. Env. Med.','ANNALS OF AGRICULTURAL AND ENVIRONMENTAL MEDICINE','1232-1966',0.895000,0.002560,0.292340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aquat. Ecosyst. Health Manag.','AQUATIC ECOSYSTEM HEALTH & MANAGEMENT','1463-4988',0.455000,0.001170,0.132850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BioEnergy Res.','BioEnergy Research','1939-1234',3.309000,0.006040,0.687940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biogeochemistry','BIOGEOCHEMISTRY','0168-2563',3.407000,0.014350,1.636060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Environ.-Proc. R. Irish Acad.','BIOLOGY AND ENVIRONMENT-PROCEEDINGS OF THE ROYAL IRISH ACADEMY','0791-7945',0.326000,0.000230,0.025780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecol. Appl.','ECOLOGICAL APPLICATIONS','1051-0761',4.252000,0.027330,3.115440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Horticult. Sci. Biotechnol.','JOURNAL OF HORTICULTURAL SCIENCE & BIOTECHNOLOGY','1462-0316',0.458000,0.000960,0.109830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Mal. Prof. Environ.','Archives des Maladies Professionnelles et de l Environnement','1775-8785',0.184000,0.000070,0.007960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Public Health','BMC PUBLIC HEALTH','1471-2458',2.209000,0.080380,9.161270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cent. Eur. J. Public Health','Central European Journal of Public Health','1210-7778',0.525000,0.000680,0.077510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Epidemiol. Infect.','EPIDEMIOLOGY AND INFECTION','0950-2688',2.515000,0.018520,2.111370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fluoride','FLUORIDE','0015-4725',0.797000,0.000230,0.026210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fuzzy Sets Syst.','FUZZY SETS AND SYSTEMS','0165-0114',2.098000,0.007710,0.879030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IMA J. Appl. Math.','IMA JOURNAL OF APPLIED MATHEMATICS','0272-4960',1.034000,0.002250,0.256680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Dyn. Control Syst.','JOURNAL OF DYNAMICAL AND CONTROL SYSTEMS','1079-2724',0.422000,0.001080,0.122960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Funct. space','Journal of Function Spaces','2314-8896',0.426000,0.000320,0.036150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Geom. Phys.','JOURNAL OF GEOMETRY AND PHYSICS','0393-0440',0.752000,0.007570,0.862290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Math. Imaging Vis.','JOURNAL OF MATHEMATICAL IMAGING AND VISION','0924-9907',1.461000,0.005400,0.615290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theor. Appl. Climatol.','THEORETICAL AND APPLIED CLIMATOLOGY','0177-798X',2.433000,0.011280,1.285290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Antonie Van Leeuwenhoek','ANTONIE VAN LEEUWENHOEK INTERNATIONAL JOURNAL OF GENERAL AND MOLECULAR MICROBIOLOGY','0003-6072',1.944000,0.007560,0.861630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Microbiol.','ARCHIVES OF MICROBIOLOGY','0302-8933',1.760000,0.004000,0.456170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Archaea','ARCHAEA-AN INTERNATIONAL MICROBIOLOGICAL JOURNAL','1472-3646',3.234000,0.001600,0.182560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Microbiol.','BMC MICROBIOLOGY','1471-2180',2.581000,0.022790,2.597490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Crit. Rev. Microbiol.','CRITICAL REVIEWS IN MICROBIOLOGY','1040-841X',8.192000,0.003720,0.423520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Microbiol.','CURRENT OPINION IN MICROBIOLOGY','1369-5274',6.234000,0.020860,2.377410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Enferm. Infec. Microbiol. Clin.','ENFERMEDADES INFECCIOSAS Y MICROBIOLOGIA CLINICA','0213-005X',1.530000,0.002640,0.300830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Microbiol. Rep.','Environmental Microbiology Reports','1758-2229',3.500000,0.008020,0.914070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gut Pathogens','Gut Pathogens','1757-4749',2.816000,0.001860,0.212010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Syst. Evol. Microbiol.','INTERNATIONAL JOURNAL OF SYSTEMATIC AND EVOLUTIONARY MICROBIOLOGY','1466-5026',2.439000,0.018540,2.113010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Health Perspect.','ENVIRONMENTAL HEALTH PERSPECTIVES','0091-6765',8.443000,0.053550,6.103990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Rev.','ENVIRONMENTAL REVIEWS','1208-6053',4.630000,0.002960,0.337200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Technol.','ENVIRONMENTAL TECHNOLOGY','0959-3330',1.760000,0.006640,0.756850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environmetrics','ENVIRONMETRICS','1180-4009',1.160000,0.004430,0.504430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Grundwasser','Grundwasser','1430-483X',0.436000,0.000230,0.025950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Coast. Conserv.','JOURNAL OF COASTAL CONSERVATION','1400-0350',1.096000,0.001360,0.155380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Elem.','Journal of Elementology','1644-2296',0.719000,0.000490,0.056090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geospatial Health','Geospatial Health','1827-1987',1.093000,0.001410,0.160720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Health Expect.','HEALTH EXPECTATIONS','1369-6513',3.207000,0.004110,0.468400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Circumpolar Health','International Journal of Circumpolar Health','1239-9736',0.707000,0.001830,0.208340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Occup. Med. Environ. Health','International Journal of Occupational Medicine and Environmental Health','1232-1087',0.780000,0.001450,0.165800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Behav. Health Serv. Res.','JOURNAL OF BEHAVIORAL HEALTH SERVICES & RESEARCH','1094-3412',1.617000,0.001750,0.199070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cancer Educ.','JOURNAL OF CANCER EDUCATION','0885-8195',1.368000,0.003410,0.389190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Environ. Health','JOURNAL OF ENVIRONMENTAL HEALTH','0022-0892',0.887000,0.001110,0.126950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Occup. Environ. Hyg.','JOURNAL OF OCCUPATIONAL AND ENVIRONMENTAL HYGIENE','1545-9624',1.155000,0.002750,0.312960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Public Health','JOURNAL OF PUBLIC HEALTH','1741-3842',2.019000,0.005700,0.649580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Toxicol. Env. Health Part A','JOURNAL OF TOXICOLOGY AND ENVIRONMENTAL HEALTH-PART A-CURRENT ISSUES','1528-7394',2.243000,0.004530,0.516710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('MMWR-Morb. Mortal. Wkly. Rep.','MMWR-MORBIDITY AND MORTALITY WEEKLY REPORT','0149-2195',10.588000,0.081560,9.295820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Occup. Environ. Med.','OCCUPATIONAL AND ENVIRONMENTAL MEDICINE','1351-0711',3.745000,0.011400,1.299170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Meth. Appl. Sci.','MATHEMATICAL METHODS IN THE APPLIED SCIENCES','0170-4214',1.002000,0.007660,0.873640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Method Oper. Res.','MATHEMATICAL METHODS OF OPERATIONS RESEARCH','1432-2994',0.526000,0.001920,0.218570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Oper. Res.','MATHEMATICS OF OPERATIONS RESEARCH','0364-765X',1.406000,0.006790,0.774040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rend. Semin. Mat. Univ. Padova','RENDICONTI DEL SEMINARIO MATEMATICO DELLA UNIVERSITA DI PADOVA','0041-8994',0.382000,0.001210,0.137800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. China-Math.','Science China-Mathematics','1674-7283',0.761000,0.008640,0.985120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sel. Math.-New Ser.','Selecta Mathematica-New Series','1022-1824',1.148000,0.003610,0.410990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('SIAM J. Math. Anal.','SIAM JOURNAL ON MATHEMATICAL ANALYSIS','0036-1410',1.486000,0.016520,1.883120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('SIAM J. Optim.','SIAM JOURNAL ON OPTIMIZATION','1052-6234',2.659000,0.017270,1.968140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stoch. Anal. Appl.','STOCHASTIC ANALYSIS AND APPLICATIONS','0736-2994',0.630000,0.002320,0.264070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Antibiot.','JOURNAL OF ANTIBIOTICS','0021-8820',2.173000,0.005490,0.625180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Microbiol. Biotechnol.','JOURNAL OF MICROBIOLOGY AND BIOTECHNOLOGY','1017-7825',1.685000,0.006710,0.764500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Microbiol. Immunol. Infect.','JOURNAL OF MICROBIOLOGY IMMUNOLOGY AND INFECTION','1684-1182',2.955000,0.003570,0.407210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Microbiol. Biotechnol.','JOURNAL OF MOLECULAR MICROBIOLOGY AND BIOTECHNOLOGY','1464-1801',1.701000,0.001750,0.199320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Oral Microbiology','Journal of Oral Microbiology','2000-2297',3.421000,0.001200,0.136600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('mBio','mBio','2150-7511',6.975000,0.039550,4.507850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microb. Ecol.','MICROBIAL ECOLOGY','0095-3628',3.232000,0.013560,1.546100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microbiol. Immunol.','MICROBIOLOGY AND IMMUNOLOGY','0385-5600',1.428000,0.003200,0.365090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microbiol. Res.','MICROBIOLOGICAL RESEARCH','0944-5013',2.723000,0.004090,0.466250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('MicrobiologyOpen','MicrobiologyOpen','2045-8827',2.148000,0.002160,0.246010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pol. J. Microbiol.','Polish Journal of Microbiology','1733-1331',0.750000,0.000920,0.105360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Protist','PROTIST','1434-4610',2.898000,0.004120,0.469370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Syst. Appl. Microbiol.','SYSTEMATIC AND APPLIED MICROBIOLOGY','0723-2020',3.691000,0.005630,0.641240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Microsc..','JOURNAL OF MICROSCOPY','0022-2720',2.136000,0.007040,0.802680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microsc. microanal.','MICROSCOPY AND MICROANALYSIS','1431-9276',1.730000,0.010570,1.204450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microsc. Res. Tech.','MICROSCOPY RESEARCH AND TECHNIQUE','1059-910X',1.130000,0.004600,0.524810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ultrastruct. Pathol.','ULTRASTRUCTURAL PATHOLOGY','0191-3123',0.828000,0.000890,0.101730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Robot.','ADVANCED ROBOTICS','0169-1864',0.516000,0.002310,0.262750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Environ. Eng. Landsc. Manag.','Journal of Environmental Engineering and Landscape Management','1648-6897',0.591000,0.000350,0.040150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Environ. Inform.','Journal of Environmental Informatics','1726-2135',3.857000,0.001130,0.128580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Environ. Sci. Health Part A-Toxic/Hazard. Subst. Environ. Eng.','JOURNAL OF ENVIRONMENTAL SCIENCE AND HEALTH PART A-TOXIC/HAZARDOUS SUBSTANCES & ENVIRONMENTAL ENGINEERING','1093-4529',1.276000,0.004770,0.543280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Environ. Sci. Health Part B-Pestic. Contam. Agric. Wastes','JOURNAL OF ENVIRONMENTAL SCIENCE AND HEALTH PART B-PESTICIDES FOOD CONTAMINANTS AND AGRICULTURAL WASTES','0360-1234',1.247000,0.002610,0.297530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Paleolimn.','JOURNAL OF PALEOLIMNOLOGY','0921-2728',2.237000,0.005320,0.605920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Clim. Chang.','Nature Climate Change','1758-678X',17.184000,0.067510,7.694320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ozone-Sci. Eng.','OZONE-SCIENCE & ENGINEERING','0191-9512',0.853000,0.001030,0.117810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiat. Environ. Biophys.','RADIATION AND ENVIRONMENTAL BIOPHYSICS','0301-634X',1.923000,0.002680,0.305030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Remote Sens. Environ.','REMOTE SENSING OF ENVIRONMENT','0034-4257',5.881000,0.044920,5.119760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Int. Contam. Ambient.','Revista Internacional de Contaminacion Ambiental','0188-4999',0.343000,0.000260,0.029740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Patient Educ. Couns.','PATIENT EDUCATION AND COUNSELING','0738-3991',2.232000,0.017780,2.026830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Public Health Ethics','Public Health Ethics','1754-9973',1.283000,0.000920,0.105360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pub. Health Genomics','Public Health Genomics','1662-4246',1.535000,0.002460,0.280900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sex Health','Sexual Health','1448-5028',1.225000,0.004360,0.496640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wildern. Environ. Med.','WILDERNESS & ENVIRONMENTAL MEDICINE','1080-6032',1.163000,0.001150,0.130570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('APMIS','APMIS','0903-4641',1.933000,0.005260,0.599370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Immunol. Ther. Exp.','ARCHIVUM IMMUNOLOGIAE ET THERAPIAE EXPERIMENTALIS','0004-069X',2.464000,0.002610,0.297830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Immunol. Immunother.','CANCER IMMUNOLOGY IMMUNOTHERAPY','0340-7004',4.846000,0.014510,1.654000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comp. Immunol. Microbiol. Infect. Dis.','COMPARATIVE IMMUNOLOGY MICROBIOLOGY AND INFECTIOUS DISEASES','0147-9571',1.943000,0.002680,0.305520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Complex Syst.','ADVANCES IN COMPLEX SYSTEMS','0219-5259',0.461000,0.000910,0.103390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annual Review of Statistics and Its Application','2326-8298','3.045',0.000730,0.082960,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Comput.','ENGINEERING COMPUTATIONS','0264-4401',0.691000,0.001430,0.162940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fract. Calc. Appl. Anal.','Fractional Calculus and Applied Analysis','1311-0454',2.246000,0.002470,0.281940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cell. Autom.','Journal of Cellular Automata','1557-5969',0.418000,0.000280,0.032430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Math. Music','Journal of Mathematics and Music','1745-9737',0.320000,0.000140,0.016520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Robot. Res.','INTERNATIONAL JOURNAL OF ROBOTICS RESEARCH','0278-3649',2.489000,0.011930,1.360250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Bionic Eng.','Journal of Bionic Engineering','1672-6529',1.466000,0.001510,0.171780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gospod. Surowcami. Miner.','Gospodarka Surowcami Mineralnymi-Mineral Resources Management','0860-0953',0.567000,0.000310,0.035520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mineral. Petrol. Sci.','Journal of Mineralogical and Petrological Sciences','1345-6296',0.648000,0.000650,0.073980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Mineral. Geochem.','Reviews in Mineralogy & Geochemistry','1529-6466',6.120000,0.005720,0.652110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Complexity','COMPLEXITY','1076-2787',3.514000,0.001210,0.137390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fractals-Complex Geom. Patterns Scaling Nat. Soc.','FRACTALS-COMPLEX GEOMETRY PATTERNS AND SCALING IN NATURE AND SOCIETY','0218-348X',1.412000,0.000620,0.071040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Life Sci.','Frontiers in Life Science','2155-3769',0.864000,0.000130,0.015300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Her. Russ. Acad. Sci.','HERALD OF THE RUSSIAN ACADEMY OF SCIENCES','1019-3316',0.327000,0.000320,0.036530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Issues Sci. Technol.','ISSUES IN SCIENCE AND TECHNOLOGY','0748-5492',0.467000,0.000620,0.070970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Naturwissenschaften','NATURWISSENSCHAFTEN','0028-1042',1.773000,0.006460,0.735750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Resour. Res.','WATER RESOURCES RESEARCH','0043-1397',3.792000,0.056420,6.430720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Water Sci. Technol.','WATER SCIENCE AND TECHNOLOGY','0273-1223',1.064000,0.015630,1.781630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wetl. Ecol. Manag.','WETLANDS ECOLOGY AND MANAGEMENT','0923-4861',1.407000,0.001660,0.189470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Fish. Aquat. Sci.','CANADIAN JOURNAL OF FISHERIES AND AQUATIC SCIENCES','0706-652X',2.437000,0.011240,1.280800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecol. Freshw. Fish','ECOLOGY OF FRESHWATER FISH','0906-6691',2.052000,0.003030,0.345490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fish Res.','FISHERIES RESEARCH','0165-7836',2.230000,0.009760,1.112730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Fish.','INDIAN JOURNAL OF FISHERIES','0970-6011',0.160000,0.000340,0.038780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Aquat. Anim. Health','JOURNAL OF AQUATIC ANIMAL HEALTH','0899-7659',0.859000,0.000850,0.096450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Knowl. Manag. Aquat. Ecosyst.','Knowledge and Management of Aquatic Ecosystems','1961-9502',0.978000,0.000770,0.087860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Freshw. Res.','MARINE AND FRESHWATER RESEARCH','1323-1650',1.583000,0.006250,0.712800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('North Am. J. Fish Manage.','NORTH AMERICAN JOURNAL OF FISHERIES MANAGEMENT','0275-5947',1.013000,0.003410,0.388880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Fish. Sci. Aquac..','Reviews in Fisheries Science & Aquaculture','2330-8249',1.143000,0.000110,0.012500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cereal Foods World','CEREAL FOODS WORLD','0146-6283',0.889000,0.000300,0.034730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Inflamm.','European Journal of Inflammation','1721-727X',0.532000,0.000320,0.036440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Human Vaccines Immunother.','Human Vaccines & Immunotherapeutics','2164-5515',2.146000,0.010590,1.207050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Med. Res.','INDIAN JOURNAL OF MEDICAL RESEARCH','0971-5916',1.446000,0.007410,0.844990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inflamm. Res.','INFLAMMATION RESEARCH','1023-3830',2.557000,0.005420,0.617270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inflammopharmacology','INFLAMMOPHARMACOLOGY','0925-4692',2.304000,0.001450,0.164850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Autoimmun.','JOURNAL OF AUTOIMMUNITY','0896-8411',7.760000,0.013440,1.531480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Match-Commun. Math. Comput. Chem.','MATCH-COMMUNICATIONS IN MATHEMATICAL AND IN COMPUTER CHEMISTRY','0340-6253',3.858000,0.007500,0.854360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Financ. Econ.','Mathematics and Financial Economics','1862-9679',0.727000,0.001480,0.169060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Resour. Model.','NATURAL RESOURCE MODELING','0890-8575',0.370000,0.000550,0.062710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Differ. Equat.','Advances in Differential Equations','1079-9389',0.917000,0.002750,0.313390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Nonlinear Stud.','ADVANCED NONLINEAR STUDIES','1536-1365',1.135000,0.002820,0.321570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Algebr. Log.','Algebra and Logic','0002-5232',0.524000,0.001420,0.162030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. Math. Mon.','AMERICAN MATHEMATICAL MONTHLY','0002-9890',0.349000,0.002100,0.239290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anal. Math. Phys.','Analysis and Mathematical Physics','1664-2368',0.583000,0.001050,0.119800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Acad. Sci. Fenn. Ser. A1-Math.','ANNALES ACADEMIAE SCIENTIARUM FENNICAE-MATHEMATICA','1239-629X',0.830000,0.002830,0.322000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Mat. Pura Appl.','ANNALI DI MATEMATICA PURA ED APPLICATA','0373-3114',0.861000,0.003300,0.375710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Pure Appl. Log.','ANNALS OF PURE AND APPLIED LOGIC','0168-0072',0.582000,0.004260,0.485100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Anal. Discret. Math.','Applicable Analysis and Discrete Mathematics','1452-8630',0.787000,0.001250,0.142460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. R. Soc.  A-Math. Phys. Eng. Sci.','PROCEEDINGS OF THE ROYAL SOCIETY A-MATHEMATICAL PHYSICAL AND ENGINEERING SCIENCES','1364-5021',1.935000,0.018540,2.112900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eukaryot. Cell','EUKARYOTIC CELL','1535-9778',2.946000,0.014100,1.607590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('FEMS Yeast Res.','FEMS YEAST RESEARCH','1567-1356',2.479000,0.005160,0.587860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Med. Mushrooms','INTERNATIONAL JOURNAL OF MEDICINAL MUSHROOMS','1521-9437',1.357000,0.000680,0.077010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mycol. Med.','JOURNAL DE MYCOLOGIE MEDICALE','1156-5233',0.756000,0.000530,0.060400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('MycoKeys','MycoKeys','1314-4057',1.846000,0.000340,0.038890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mycotaxon','MYCOTAXON','0093-4666',0.610000,0.002440,0.278270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Iberoam. Micol.','REVISTA IBEROAMERICANA DE MICOLOGIA','1130-1406',1.444000,0.000960,0.109720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stud. Mycol.','STUDIES IN MYCOLOGY','0166-0616',13.889000,0.003560,0.405650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Neurol.','ANNALS OF NEUROLOGY','0364-5134',9.638000,0.059440,6.774730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Behav. Sleep Med.','Behavioral Sleep Medicine','1540-2002',2.485000,0.001790,0.204170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Neurol.','BMC Neurology','1471-2377',1.961000,0.010780,1.229260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brain Stimul.','Brain Stimulation','1935-861X',4.793000,0.009070,1.033670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brain Tumor Pathol.','Brain Tumor Pathology','1433-7398',1.202000,0.001200,0.137220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Control','FOOD CONTROL','0956-7135',3.388000,0.023920,2.726840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Nutr. Res.','Food & Nutrition Research','1654-6628',3.226000,0.002110,0.240970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Foodborne Pathog. Dis.','Foodborne Pathogens and Disease','1535-3141',2.270000,0.008450,0.962640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Food Biochem.','JOURNAL OF FOOD BIOCHEMISTRY','0145-8884',0.832000,0.001440,0.163570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Food Saf. Food Qual.','Journal of Food Safety and Food Quality-Archiv fur Lebensmittelhygiene','0003-925X',0.083000,0.000210,0.024150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lancet HIV','Lancet HIV','2352-3018',8.364000,0.000750,0.085830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microb. Pathog.','MICROBIAL PATHOGENESIS','0882-4010',1.888000,0.003750,0.427800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mucosal Immunol.','Mucosal Immunology','1933-0219',6.103000,0.016650,1.897780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('OncoImmunology','OncoImmunology','2162-402X',7.644000,0.011680,1.331450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Parasite Immunol.','PARASITE IMMUNOLOGY','0141-9838',1.917000,0.003090,0.352150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Scand. J. Immunol.','SCANDINAVIAN JOURNAL OF IMMUNOLOGY','0300-9475',2.270000,0.005170,0.588750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tuberculosis','TUBERCULOSIS','1472-9792',2.952000,0.007010,0.798980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Virulence','Virulence','2150-5594',5.418000,0.008200,0.935070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Infect. Dis.','BMC INFECTIOUS DISEASES','1471-2334',2.690000,0.036220,4.128080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Infect. Dis. Med. Microbiol.','Canadian Journal of Infectious Diseases & Medical Microbiology','1712-9532',0.991000,0.001290,0.147050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Vaccine Immunol.','Clinical and Vaccine Immunology','1556-6811',2.277000,0.016830,1.918640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Math. Sci.','Bulletin of Mathematical Sciences','1664-3607',1.194000,0.001090,0.124640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Banach J. Math. Anal.','Banach Journal of Mathematical Analysis','1735-8787',0.800000,0.001230,0.139750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. Math. Bul.-Bul. Can. Math.','CANADIAN MATHEMATICAL BULLETIN-BULLETIN CANADIEN DE MATHEMATIQUES','0008-4395',0.384000,0.002170,0.246820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Complex Var. Elliptic Equ.','Complex Variables and Elliptic Equations','1747-6933',0.466000,0.003140,0.358210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Differ. Integral Equ.','Differential and Integral Equations','0893-4983',0.851000,0.003900,0.444420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Discret. Comput. Geom.','DISCRETE & COMPUTATIONAL GEOMETRY','0179-5376',0.816000,0.008360,0.952920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Discuss. Math. Graph Theory','Discussiones Mathematicae Graph Theory','1234-3099',0.349000,0.001450,0.165260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electron. J. Differ. Equ.','Electronic Journal of Differential Equations','1072-6691',0.769000,0.005260,0.599650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Finite Fields their Appl.','FINITE FIELDS AND THEIR APPLICATIONS','1071-5797',1.292000,0.004730,0.538880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Forum Math.','FORUM MATHEMATICUM','0933-7741',0.823000,0.003590,0.409070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geom. Topol.','GEOMETRY & TOPOLOGY','1465-3060',1.294000,0.011110,1.266140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cerebrovasc. Dis.','CEREBROVASCULAR DISEASES','1015-9770',3.359000,0.012300,1.402350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Neurophysiol.','CLINICAL NEUROPHYSIOLOGY','1388-2457',3.426000,0.021690,2.471870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Neurol.','EUROPEAN JOURNAL OF NEUROLOGY','1351-5101',3.956000,0.021220,2.418120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hum. Psychopharmacol.-Clin. Exp.','HUMAN PSYCHOPHARMACOLOGY-CLINICAL AND EXPERIMENTAL','0885-6222',2.440000,0.003330,0.379710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Affect. Disord.','JOURNAL OF AFFECTIVE DISORDERS','0165-0327',3.570000,0.046800,5.334140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin. Neurosci.','JOURNAL OF CLINICAL NEUROSCIENCE','0967-5868',1.387000,0.014140,1.611250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin. Sleep Med.','Journal of Clinical Sleep Medicine','1550-9389',2.710000,0.009190,1.047920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neurosurg.','JOURNAL OF NEUROSURGERY','0022-3085',3.443000,0.030640,3.492690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Oleo Sci.','Journal of Oleo Science','1345-8957',1.108000,0.002010,0.229010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sens. Stud.','JOURNAL OF SENSORY STUDIES','0887-8250',2.213000,0.002120,0.241630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Postharvest Biol. Technol.','POSTHARVEST BIOLOGY AND TECHNOLOGY','0925-5214',2.618000,0.008370,0.953460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Riv. Ital. Sostanze Grasse','Rivista Italiana delle Sostanze Grasse','0035-6808',0.159000,0.000100,0.011470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Veg. Sci.','APPLIED VEGETATION SCIENCE','1402-2001',2.308000,0.003150,0.359110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cerne','Cerne','0104-7760',0.238000,0.000840,0.095640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fire Ecol.','Fire Ecology','1933-9747',1.098000,0.001110,0.126260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Forest Pathol.','FOREST PATHOLOGY','1437-4781',1.437000,0.001720,0.196380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('For. Sci.','FOREST SCIENCE','0015-749X',1.702000,0.003000,0.342160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Holzforschung','HOLZFORSCHUNG','0018-3830',1.711000,0.003090,0.351680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. For. Econ.','Journal of Forest Economics','1104-6899',1.185000,0.001030,0.116970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. STD AIDS','INTERNATIONAL JOURNAL OF STD & AIDS','0956-4624',1.300000,0.007580,0.863400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Infect. Dis.','JOURNAL OF INFECTIOUS DISEASES','0022-1899',6.344000,0.094820,10.808080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sex. Transm. Dis.','SEXUALLY TRANSMITTED DISEASES','0148-5717',2.968000,0.017610,2.006970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transpl. Infect. Dis.','Transplant Infectious Disease','1398-2273',1.459000,0.004790,0.546300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM J. Emerg. Technol. Comput. Syst.','ACM Journal on Emerging Technologies in Computing Systems','1550-4832',0.705000,0.000820,0.093480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACS Appl. Mater. Interfaces','ACS Applied Materials & Interfaces','1944-8244',7.145000,0.147660,16.830280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Funct. Mater.','ADVANCED FUNCTIONAL MATERIALS','1616-301X',11.382000,0.141640,16.143650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomed. Nanotechnol.','Journal of Biomedical Nanotechnology','1550-7033',3.929000,0.007450,0.849390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Micro-Nanolithogr. MEMS MOEMS','Journal of Micro-Nanolithography MEMS and MOEMS','1932-5150',1.335000,0.001620,0.184910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Phys. Chem. C','Journal of Physical Chemistry C','1932-7447',4.509000,0.284030,32.373840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Number Theory','International Journal of Number Theory','1793-0421',0.463000,0.004280,0.487940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Math. Res. Notices','INTERNATIONAL MATHEMATICS RESEARCH NOTICES','1073-7928',1.031000,0.020920,2.384670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Iran. J. Fuzzy. Syst.','Iranian Journal of Fuzzy Systems','1735-0654',0.381000,0.000370,0.041770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Approx. Theory','JOURNAL OF APPROXIMATION THEORY','0021-9045',0.921000,0.004780,0.545250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Funct. Space Appl.','Journal of Function Spaces and Applications','2090-8997',0.469000,0.001130,0.129180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Graph Theory','JOURNAL OF GRAPH THEORY','0364-9024',0.796000,0.005310,0.605560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Inverse Ill-Posed Probl.','Journal of Inverse and Ill-Posed Problems','0928-0219',0.987000,0.001480,0.169120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Psychopharmacol.','JOURNAL OF PSYCHOPHARMACOLOGY','0269-8811',3.637000,0.012340,1.406290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Spinal Cord. Med.','JOURNAL OF SPINAL CORD MEDICINE','1079-0268',1.578000,0.004020,0.457840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Spinal Disord. Tech.','JOURNAL OF SPINAL DISORDERS & TECHNIQUES','1536-0652',2.291000,0.007360,0.838900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nervenarzt','NERVENARZT','0028-2804',0.806000,0.001550,0.176100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurocrit. Care','Neurocritical Care','1541-6933',2.488000,0.008900,1.014150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuroscientist','NEUROSCIENTIST','1073-8584',7.295000,0.010080,1.149270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pain Res. Manag.','Pain Research & Management','1203-6765',1.685000,0.002070,0.235490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Neurosurg.','PEDIATRIC NEUROSURGERY','1016-2291',0.245000,0.000940,0.106800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('South. J. Appl. For.','SOUTHERN JOURNAL OF APPLIED FORESTRY','0148-4419',0.517000,0.000350,0.040010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aliment. Pharmacol. Ther.','ALIMENTARY PHARMACOLOGY & THERAPEUTICS','0269-2813',6.320000,0.033920,3.866680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Gastroenterol.','CURRENT OPINION IN GASTROENTEROLOGY','0267-1379',3.618000,0.006810,0.775840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dig. Dis. Sci.','DIGESTIVE DISEASES AND SCIENCES','0163-2116',2.516000,0.023730,2.704570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dig. Liver Dis.','DIGESTIVE AND LIVER DISEASE','1590-8658',2.719000,0.010330,1.177120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Helicobacter','HELICOBACTER','1083-4389',3.920000,0.004070,0.463450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microporous Mesoporous Mat.','MICROPOROUS AND MESOPOROUS MATERIALS','1387-1811',3.349000,0.026940,3.070180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microsyst. Technol.','MICROSYSTEM TECHNOLOGIES-MICRO-AND NANOSYSTEMS-INFORMATION STORAGE AND PROCESSING SYSTEMS','0946-7076',0.974000,0.004200,0.478240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanoscale Microscale Thermophys. Eng.','Nanoscale and Microscale Thermophysical Engineering','1556-7265',2.390000,0.000860,0.097940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanosci. Nanotechnol. Lett.','Nanoscience and Nanotechnology Letters','1941-4900',1.007000,0.002040,0.232110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Physica E','PHYSICA E-LOW-DIMENSIONAL SYSTEMS & NANOSTRUCTURES','1386-9477',1.904000,0.011920,1.359130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Adv. Mater. Sci.','REVIEWS ON ADVANCED MATERIALS SCIENCE','1606-5131',1.245000,0.002000,0.227420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Small','Small','1613-6810',8.315000,0.077240,8.804330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Synth. React. Inorg. Met.-Org. Nano-Metal Chem.','Synthesis and Reactivity in Inorganic Metal-Organic and Nano-Metal Chemistry','1553-3174',0.493000,0.001330,0.151450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aslib Proc.','ASLIB PROCEEDINGS','0001-253X',1.147000,0.000420,0.048000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Ind. Electron.','IEEE TRANSACTIONS ON INDUSTRIAL ELECTRONICS','0278-0046',6.383000,0.071060,8.099080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Synchrot. Radiat.','JOURNAL OF SYNCHROTRON RADIATION','1600-5775',1.877000,0.009960,1.135710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Meas. Control','MEASUREMENT & CONTROL','0020-2940',0.431000,0.000110,0.012610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Meas. Sci. Technol.','MEASUREMENT SCIENCE and TECHNOLOGY','0957-0233',1.492000,0.017250,1.966100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Kinet. Relat. Mod.','Kinetic and Related Models','1937-5093',1.372000,0.003190,0.364100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Kyoto J. Math.','Kyoto Journal of Mathematics','2156-2261',0.656000,0.002150,0.245110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Nachr.','MATHEMATISCHE NACHRICHTEN','0025-584X',0.688000,0.007000,0.798030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Milan J. Math.','Milan Journal of Mathematics','1424-9286',0.853000,0.001890,0.215790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Miskolc Math. Notes','Miskolc Mathematical Notes','1787-2405',0.335000,0.000560,0.063740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mosc. Math. J.','Moscow Mathematical Journal','1609-3321',0.648000,0.002500,0.285080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Open Math.','Open Mathematics','2391-5455',0.000000,0.000000,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Steklov Inst. Math.','Proceedings of the Steklov Institute of Mathematics','0081-5438',0.464000,0.003540,0.403630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stroke','STROKE','0039-2499',5.787000,0.097720,11.137920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACS Chem. Neurosci.','ACS Chemical Neuroscience','1948-7193',4.348000,0.011060,1.260140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Neuropathol.','ACTA NEUROPATHOLOGICA','0001-6322',11.360000,0.036920,4.208170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acupunct. Electro-Ther. Res.','ACUPUNCTURE & ELECTRO-THERAPEUTICS RESEARCH','0360-1293',0.778000,0.000090,0.010140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Inspired Cogn. Archit.','Biologically Inspired Cognitive Architectures','2212-683X',0.838000,0.000180,0.021010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell. Mol. Neurobiol.','CELLULAR AND MOLECULAR NEUROBIOLOGY','0272-4340',2.328000,0.005680,0.647000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ther. Adv. Gastroenterol.','Therapeutic Advances in Gastroenterology','1756-283X',3.883000,0.002410,0.274210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochem. Genet.','BIOCHEMICAL GENETICS','0006-2928',0.952000,0.001330,0.151610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Gene Ther.','CANCER GENE THERAPY','0929-1903',2.532000,0.003830,0.436490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Conserv. Genet. Resour.','Conservation Genetics Resources','1877-7252',0.446000,0.004820,0.549790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Epigenetics Chromatin','Epigenetics & Chromatin','1756-8935',4.873000,0.004490,0.512150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Hum. Genet.','EUROPEAN JOURNAL OF HUMAN GENETICS','1018-4813',4.580000,0.026950,3.071730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gene Ther.','GENE THERAPY','0969-7128',3.242000,0.011080,1.263340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Complement. Altern. Med.','BMC Complementary and Alternative Medicine','1472-6882',1.987000,0.009810,1.117960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Complement. Ther. Med.','COMPLEMENTARY THERAPIES IN MEDICINE','0965-2299',1.935000,0.003180,0.362960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ethik Med.','Ethik in der Medizin','0935-7335',0.463000,0.000090,0.009850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ethn. Health','ETHNICITY & HEALTH','1355-7858',2.055000,0.001950,0.222510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Bioethical Inq.','Journal of Bioethical Inquiry','1176-7529',1.204000,0.000840,0.095820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Forensic Med. Pathol.','AMERICAN JOURNAL OF FORENSIC MEDICINE AND PATHOLOGY','0195-7910',0.795000,0.001970,0.224330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. J. Forensic Sci.','Australian Journal of Forensic Sciences','0045-0618',0.833000,0.000650,0.073750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Forensic Sci.','JOURNAL OF FORENSIC SCIENCES','0022-1198',1.322000,0.009350,1.065740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Law Med. Ethics','JOURNAL OF LAW MEDICINE & ETHICS','1073-1105',1.613000,0.003960,0.451300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Qual. Theor. Dyn. Syst.','Qualitative Theory of Dynamical Systems','1575-5460',0.717000,0.000580,0.065920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sb. Math.','SBORNIK MATHEMATICS','1064-5616',0.526000,0.004390,0.500450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trans. Am. Math. Soc.','TRANSACTIONS OF THE AMERICAN MATHEMATICAL SOCIETY','0002-9947',1.196000,0.030720,3.501130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transform. Groups','TRANSFORMATION GROUPS','1083-4362',0.662000,0.003110,0.354840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Health Inf. Manag. J.','Health Information Management Journal','1833-3583',1.000000,0.000450,0.051110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Technol. Assess. Health Care','INTERNATIONAL JOURNAL OF TECHNOLOGY ASSESSMENT IN HEALTH CARE','0266-4623',1.030000,0.002570,0.293410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Mech.','ACTA MECHANICA','0001-5970',1.694000,0.007300,0.832210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Appl. Math. Mech.','Advances in Applied Mathematics and Mechanics','2070-0733',0.788000,0.001500,0.171110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neurosci.','JOURNAL OF NEUROSCIENCE','0270-6474',5.924000,0.352200,40.143370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pain','JOURNAL OF PAIN','1526-5900',4.463000,0.018370,2.093800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Psychiatry Neurosci.','JOURNAL OF PSYCHIATRY & NEUROSCIENCE','1180-4882',5.570000,0.005510,0.627620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Psychophysiol.','JOURNAL OF PSYCHOPHYSIOLOGY','0269-8803',1.167000,0.000730,0.082800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sleep Res.','JOURNAL OF SLEEP RESEARCH','0962-1105',3.093000,0.006550,0.746110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Learn. Mem.','LEARNING & MEMORY','1072-0502',2.906000,0.008850,1.008500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Motor Control','MOTOR CONTROL','1087-1640',1.037000,0.001000,0.114250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neural Netw.','NEURAL NETWORKS','0893-6080',3.216000,0.009580,1.092200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neural Regen. Res.','Neural Regeneration Research','1673-5374',0.968000,0.002980,0.339710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurocirugia','NEUROCIRUGIA','1130-1473',0.410000,0.000430,0.048640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dermatol. Ther.','Dermatologic Therapy','1396-0296',1.268000,0.003050,0.347400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cosmet. Laser Ther.','Journal of Cosmetic and Laser Therapy','1476-4172',1.000000,0.001540,0.175680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wound Repair Regen.','WOUND REPAIR AND REGENERATION','1067-1927',2.628000,0.005830,0.664930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Boll. Geofis. Teor. Appl.','Bollettino di Geofisica Teorica ed Applicata','0006-6729',0.778000,0.000800,0.091620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Seismol. Soc. Amer.','BULLETIN OF THE SEISMOLOGICAL SOCIETY OF AMERICA','0037-1106',2.311000,0.017590,2.005060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chinese J. Geophys.-Chinese Ed.','CHINESE JOURNAL OF GEOPHYSICS-CHINESE EDITION','0001-5733',0.984000,0.004650,0.530280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geochem. Geophys. Geosyst.','GEOCHEMISTRY GEOPHYSICS GEOSYSTEMS','1525-2027',2.993000,0.030520,3.478900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Fire Prot. Eng.','Journal of Fire Protection Engineering','1042-3915',0.417000,0.000310,0.035140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mar. Sci. Technol.','JOURNAL OF MARINE SCIENCE AND TECHNOLOGY','0948-4280',0.709000,0.000900,0.102950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Civil Eng.-Civil Eng.','PROCEEDINGS OF THE INSTITUTION OF CIVIL ENGINEERS-CIVIL ENGINEERING','0965-089X',0.348000,0.000340,0.038880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Mech. Eng. Part F-J. Rail Rapid Transit','PROCEEDINGS OF THE INSTITUTION OF MECHANICAL ENGINEERS PART F-JOURNAL OF RAIL AND RAPID TRANSIT','0954-4097',0.900000,0.001730,0.197250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Period. Polytech.-Civ. Eng.','Periodica Polytechnica-Civil Engineering','0553-6626',0.271000,0.000250,0.028650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Constr.','Revista de la Construccion','0718-915X',0.185000,0.000090,0.010570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Des. Tall Spec. Build.','STRUCTURAL DESIGN OF TALL AND SPECIAL BUILDINGS','1541-7794',0.898000,0.001510,0.171750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surv. Rev.','SURVEY REVIEW','0039-6265',0.573000,0.000490,0.056200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Thin-Walled Struct.','THIN-WALLED STRUCTURES','0263-8231',2.063000,0.008670,0.987750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transp. Res. Pt. e-Logist. Transp. Rev.','TRANSPORTATION RESEARCH PART E-LOGISTICS AND TRANSPORTATION REVIEW','1366-5545',2.279000,0.007920,0.902850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transp. Res. Record','TRANSPORTATION RESEARCH RECORD','0361-1981',0.522000,0.018910,2.155280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('China Ocean Eng.','CHINA OCEAN ENGINEERING','0890-5487',0.435000,0.000640,0.073130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Coast. Eng.','COASTAL ENGINEERING','0378-3839',2.841000,0.007790,0.887810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Coast Eng. J.','COASTAL ENGINEERING JOURNAL','0578-5634',0.703000,0.000640,0.072990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE J. Ocean. Eng.','IEEE JOURNAL OF OCEANIC ENGINEERING','0364-9059',1.648000,0.002840,0.323910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurosignals','NEUROSIGNALS','1424-862X',1.593000,0.000920,0.104940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('3 Biotech','3 Biotech','2190-5738',0.992000,0.000600,0.068900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biocontrol Sci. Technol.','BIOCONTROL SCIENCE AND TECHNOLOGY','0958-3157',0.848000,0.002130,0.242960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Gene Ther.','CANCER GENE THERAPY','0929-1903',2.532000,0.003830,0.436490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Liq. Cryst.','LIQUID CRYSTALS','0267-8292',2.244000,0.003830,0.436790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Chem.','PROGRESS IN CHEMISTRY','1005-281X',0.894000,0.002130,0.242910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pure Appl. Chem.','PURE AND APPLIED CHEMISTRY','0033-4545',2.615000,0.010820,1.233020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solvent Extr. Res. Dev.-Jpn.','SOLVENT EXTRACTION RESEARCH AND DEVELOPMENT-JAPAN','1341-7215',0.804000,0.000190,0.021500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Chem.','STRUCTURAL CHEMISTRY','1040-0400',1.854000,0.003570,0.407310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anal. Chim. Acta','ANALYTICA CHIMICA ACTA','0003-2670',4.712000,0.050960,5.808200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Geosci. Remote Sens. Lett.','IEEE Geoscience and Remote Sensing Letters','1545-598X',2.228000,0.016050,1.829710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Miner. Depos.','MINERALIUM DEPOSITA','0026-4598',3.467000,0.003930,0.447550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Period. Mineral.','Periodico di Mineralogia','0369-8963',0.600000,0.000380,0.043710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Alcohol','ALCOHOL','0741-8329',2.440000,0.003890,0.443490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Addict. Res.','EUROPEAN ADDICTION RESEARCH','1022-6877',2.367000,0.002410,0.274460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nicotine Tob. Res.','NICOTINE & TOBACCO RESEARCH','1462-2203',3.811000,0.023250,2.649940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Subst. Use Misuse','SUBSTANCE USE & MISUSE','1082-6084',1.133000,0.005510,0.628080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clean-Soil Air Water','CLEAN-Soil Air Water','1863-0650',1.716000,0.004450,0.507780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Agric. Sustain.','International Journal of Agricultural Sustainability','1473-5903',1.538000,0.001360,0.154910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Green Energy','International Journal of Green Energy','1543-5075',1.601000,0.001160,0.132040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Sustain. Dev. World Ecol.','INTERNATIONAL JOURNAL OF SUSTAINABLE DEVELOPMENT AND WORLD ECOLOGY','1350-4509',1.609000,0.001420,0.162340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ind. Ecol.','JOURNAL OF INDUSTRIAL ECOLOGY','1088-1980',3.265000,0.006480,0.739090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Acoust.','APPLIED ACOUSTICS','0003-682X',1.462000,0.005630,0.641510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ultrasound Med.','JOURNAL OF ULTRASOUND IN MEDICINE','0278-4297',1.544000,0.008890,1.012790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ultrasound Obstet. Gynecol.','ULTRASOUND IN OBSTETRICS & GYNECOLOGY','0960-7692',4.254000,0.017490,1.994050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asian J. Control','ASIAN JOURNAL OF CONTROL','1561-8625',1.407000,0.002890,0.328910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Assem. Autom.','ASSEMBLY AUTOMATION','0144-5154',1.176000,0.000760,0.086280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Automatika','Automatika','0005-1144',0.311000,0.000400,0.045960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chemometr.','JOURNAL OF CHEMOMETRICS','0886-9383',1.873000,0.002890,0.329470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Dyn. Syst. Meas. Control-Trans. ASME','JOURNAL OF DYNAMIC SYSTEMS MEASUREMENT AND CONTROL-TRANSACTIONS OF THE ASME','0022-0434',0.975000,0.003860,0.439710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Crit. Rev. Biotechnol.','CRITICAL REVIEWS IN BIOTECHNOLOGY','0738-8551',7.510000,0.003200,0.364760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cytotechnology','CYTOTECHNOLOGY','0920-9069',1.864000,0.002460,0.280040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Expert Opin. Biol. Ther.','EXPERT OPINION ON BIOLOGICAL THERAPY','1471-2598',3.438000,0.008910,1.016090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('FEMS Yeast Res.','FEMS YEAST RESEARCH','1567-1356',2.479000,0.005160,0.587860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genomics','GENOMICS','0888-7543',2.386000,0.007960,0.907460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Microbiol.','INTERNATIONAL MICROBIOLOGY','1139-6709',1.157000,0.001260,0.143380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Iran. J. Biotechnol.','Iranian Journal of Biotechnology','1728-3043',0.309000,0.000340,0.039060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biotechnol.','JOURNAL OF BIOTECHNOLOGY','0168-1656',2.667000,0.017680,2.015550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nanobiotechnol.','JOURNAL OF NANOBIOTECHNOLOGY','1477-3155',4.239000,0.003950,0.450440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lett. Appl. Microbiol.','LETTERS IN APPLIED MICROBIOLOGY','0266-8254',1.579000,0.006480,0.738630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microbes Environ.','MICROBES AND ENVIRONMENTS','1342-6311',2.075000,0.002760,0.314270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Biotechnol.','MOLECULAR BIOTECHNOLOGY','1073-6085',1.752000,0.004060,0.462980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Anal. Chem.','Current Analytical Chemistry','1573-4110',1.238000,0.000930,0.106560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Anal. Chem.','International Journal of Analytical Chemistry','1687-8760',0.719000,0.000440,0.050390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cult. Herit.','JOURNAL OF CULTURAL HERITAGE','1296-2074',1.533000,0.002860,0.325830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Label. Compd. Radiopharm.','JOURNAL OF LABELLED COMPOUNDS & RADIOPHARMACEUTICALS','0362-4803',1.532000,0.002340,0.266680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Radioanal. Nucl. Chem.','JOURNAL OF RADIOANALYTICAL AND NUCLEAR CHEMISTRY','0236-5731',0.983000,0.008610,0.980950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sep. Sci.','JOURNAL OF SEPARATION SCIENCE','1615-9306',2.741000,0.016770,1.911810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JALA','JALA','2211-0682',1.297000,0.001600,0.182600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microchem J.','MICROCHEMICAL JOURNAL','0026-265X',2.893000,0.008920,1.016170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytochem. Anal.','PHYTOCHEMICAL ANALYSIS','0958-0344',2.497000,0.003320,0.377940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Coord. Chem.','JOURNAL OF COORDINATION CHEMISTRY','0095-8972',1.756000,0.004520,0.514690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Organomet. Chem.','JOURNAL OF ORGANOMETALLIC CHEMISTRY','0022-328X',2.336000,0.014510,1.654170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Agric. Ecosyst. Environ.','AGRICULTURE ECOSYSTEMS & ENVIRONMENT','0167-8809',3.564000,0.024630,2.807120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Zool. Fenn.','ANNALES ZOOLOGICI FENNICI','0003-455X',0.753000,0.000910,0.104260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biotropica','BIOTROPICA','0006-3606',1.944000,0.006250,0.712060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Ecol.','BMC ECOLOGY','1472-6785',2.724000,0.002280,0.259460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Insect Sci.','Current Opinion in Insect Science','2214-5745',2.719000,0.000790,0.089550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Divers. Distrib.','DIVERSITY AND DISTRIBUTIONS','1366-9516',4.566000,0.017200,1.960790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Optim. Control Appl. Methods','OPTIMAL CONTROL APPLICATIONS & METHODS','0143-2087',1.097000,0.001960,0.223480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. Poult. Sci.','BRITISH POULTRY SCIENCE','0007-1668',0.933000,0.002880,0.328730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fourrages','Fourrages','0429-2766',0.202000,0.000130,0.014820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ital. J. Anim. Sci.','Italian Journal of Animal Science','1594-4077',0.841000,0.001790,0.204100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Large Anim. Rev.','Large Animal Review','1124-4593',0.143000,0.000090,0.009920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Eng. Agric.','APPLIED ENGINEERING IN AGRICULTURE','0883-8542',0.429000,0.001430,0.162920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aquac. Eng.','AQUACULTURAL ENGINEERING','0144-8609',1.381000,0.001400,0.159370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioresour. Technol.','BIORESOURCE TECHNOLOGY','0960-8524',4.917000,0.133500,15.216190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Korean Soc. Appl. Biol. Chem.','Journal of the Korean Society for Applied Biological Chemistry','1738-2203',0.655000,0.001440,0.163990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prep. Biochem. Biotechnol.','PREPARATIVE BIOCHEMISTRY & BIOTECHNOLOGY','1082-6068',1.114000,0.000750,0.085160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trends Biotechnol.','TRENDS IN BIOTECHNOLOGY','0167-7799',12.065000,0.019210,2.189810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Yeast','YEAST','0749-503X',2.259000,0.002960,0.337520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Soc. Bot. Pol.','ACTA SOCIETATIS BOTANICORUM POLONIAE','0001-6977',1.213000,0.001220,0.139460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Bot. Res.','Advances in Botanical Research','0065-2296',1.204000,0.001720,0.196060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anal. Jardin Bot. Madrid.','ANALES DEL JARDIN BOTANICO DE MADRID','0211-1322',0.679000,0.000270,0.031320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aob Plants','AoB Plants','2041-2851',2.079000,0.002220,0.252490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Veg. Sci.','APPLIED VEGETATION SCIENCE','1402-2001',2.308000,0.003150,0.359110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bangladesh J. Plant Taxon.','Bangladesh Journal of Plant Taxonomy','1028-2092',0.293000,0.000160,0.018260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bot. Rev.','BOTANICAL REVIEW','0006-8101',1.290000,0.001050,0.120120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Botany','Botany','1916-2790',1.317000,0.003080,0.350540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brittonia','BRITTONIA','0007-196X',0.652000,0.000630,0.071310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Heterocycl. Chem.','Advances in Heterocyclic Chemistry','0065-2725',3.308000,0.000460,0.052870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arkivoc','ARKIVOC','1551-7004',1.177000,0.003140,0.358440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Org. Chem.','CHINESE JOURNAL OF ORGANIC CHEMISTRY','0253-2786',1.309000,0.002400,0.273100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Chem. Sect B-Org. Chem. Incl. Med. Chem.','INDIAN JOURNAL OF CHEMISTRY SECTION B-ORGANIC CHEMISTRY INCLUDING MEDICINAL CHEMISTRY','0376-4699',0.471000,0.000870,0.099350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Org. Biomol. Chem.','ORGANIC & BIOMOLECULAR CHEMISTRY','1477-0520',3.559000,0.060400,6.884510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polycycl. Aromat. Compd.','POLYCYCLIC AROMATIC COMPOUNDS','1040-6638',0.959000,0.000500,0.056680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Synthesis','SYNTHESIS-STUTTGART','0039-7881',2.652000,0.019960,2.274740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tetrahedron-Asymmetry','TETRAHEDRON-ASYMMETRY','0957-4166',2.108000,0.008290,0.945040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Isr. J. Ecol. Evol.','Israel Journal of Ecology & Evolution','1565-9801',0.727000,0.000270,0.031010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Anim. Ecol.','JOURNAL OF ANIMAL ECOLOGY','0021-8790',4.827000,0.021600,2.462010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Arid. Environ.','JOURNAL OF ARID ENVIRONMENTS','0140-1963',1.623000,0.009560,1.090020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Trop. Ecol.','JOURNAL OF TROPICAL ECOLOGY','0266-4674',0.975000,0.002330,0.265670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oikos','OIKOS','0030-1299',3.586000,0.022120,2.521100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Paleobiology','PALEOBIOLOGY','0094-8373',2.959000,0.003690,0.420740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytocoenologia','PHYTOCOENOLOGIA','0340-269X',1.828000,0.000300,0.034460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polar Biol.','POLAR BIOLOGY','0722-4060',1.711000,0.007970,0.907900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('West. North Am. Naturalist','WESTERN NORTH AMERICAN NATURALIST','1527-0904',0.291000,0.000700,0.079250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wetlands','WETLANDS','0277-5212',1.504000,0.004670,0.532580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Food Agribus. Manag. Rev.','International Food and Agribusiness Management Review','1559-2448',0.435000,0.000510,0.058490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anim. Prod. Sci.','Animal Production Science','1836-0939',0.902000,0.004170,0.475470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Landbauforschung','Landbauforschung','0458-6859',0.435000,0.000270,0.030420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pesqui. Agropecu. Bras.','PESQUISA AGROPECUARIA BRASILEIRA','0100-204X',0.564000,0.003880,0.441680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Philipp. Agric. Sci.','PHILIPPINE AGRICULTURAL SCIENTIST','0031-7454',0.266000,0.000280,0.032020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Precis. Agric.','PRECISION AGRICULTURE','1385-2256',1.675000,0.002020,0.229930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tarim Bilim. Derg.','Tarim Bilimleri Dergisi-Journal of Agricultural Sciences','1300-7580',0.408000,0.000170,0.019920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aerosp. Am.','AEROSPACE AMERICA','0740-722X',0.034000,0.000120,0.013640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cosmic Res.','COSMIC RESEARCH','0010-9525',0.610000,0.000840,0.095830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Candollea','CANDOLLEA','0373-2967',0.386000,0.000280,0.032220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Caryologia','CARYOLOGIA','0008-7114',0.494000,0.000490,0.056240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryptogam. Bryol.','CRYPTOGAMIE BRYOLOGIE','1290-0796',1.389000,0.000480,0.055170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fottea','Fottea','1802-5439',2.026000,0.000780,0.088370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Tradit. Knowl.','Indian Journal of Traditional Knowledge','0972-5938',0.371000,0.000780,0.088890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Bryol.','JOURNAL OF BRYOLOGY','0373-6687',1.325000,0.000730,0.083670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nat. Prod.','JOURNAL OF NATURAL PRODUCTS','0163-3864',3.662000,0.023920,2.726000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Plant Biochem. Biotechnol.','JOURNAL OF PLANT BIOCHEMISTRY AND BIOTECHNOLOGY','0971-7811',1.352000,0.000950,0.108280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lichenologist','LICHENOLOGIST','0024-2829',1.290000,0.001550,0.176250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Plant Pathol.','MOLECULAR PLANT PATHOLOGY','1464-6722',4.335000,0.008140,0.927530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Not. Bot. Horti Agrobot. Cluj-Na.','Notulae Botanicae Horti Agrobotanici Cluj-Napoca','0255-965X',0.451000,0.001230,0.140700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Catal.','Advances in Catalysis','0360-0564',4.500000,0.000470,0.053040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Phys. Organ. Chem.','Advances in Physical Organic Chemistry','0065-3160',1.286000,0.000290,0.033350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Phys. Chem.','Annual Review of Physical Chemistry','0066-426X',13.527000,0.014050,1.601580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Calphad-Comput. Coupling Ph. Diagrams Thermochem.','CALPHAD-COMPUTER COUPLING OF PHASE DIAGRAMS AND THERMOCHEMISTRY','0364-5916',2.129000,0.003280,0.373820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Carbon','CARBON','0008-6223',6.198000,0.080080,9.127000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Mat.','CHEMISTRY OF MATERIALS','0897-4756',9.407000,0.126730,14.444940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Phys. Lett.','CHEMICAL PHYSICS LETTERS','0009-2614',1.860000,0.035780,4.077810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Theor. Chem.','Computational and Theoretical Chemistry','2210-271X',1.403000,0.007890,0.899530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('High Energy Chem.','HIGH ENERGY CHEMISTRY','0018-1439',0.690000,0.000570,0.064880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem. Phys.','JOURNAL OF CHEMICAL PHYSICS','0021-9606',2.894000,0.169150,19.279560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Fluoresc.','JOURNAL OF FLUORESCENCE','1053-0509',1.601000,0.004590,0.523000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Catal. B-Enzym.','JOURNAL OF MOLECULAR CATALYSIS B-ENZYMATIC','1381-1177',2.189000,0.007660,0.873000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Pharm. Educ.','AMERICAN JOURNAL OF PHARMACEUTICAL EDUCATION','0002-9459',1.196000,0.002150,0.244780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CBE-Life Sci. Educ.','CBE-Life Sciences Education','1931-7913',1.908000,0.003370,0.384310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Educ.','IEEE TRANSACTIONS ON EDUCATION','0018-9359',1.330000,0.001480,0.168440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Elec. Eng. Educ.','INTERNATIONAL JOURNAL OF ELECTRICAL ENGINEERING EDUCATION','0020-7209',0.302000,0.000150,0.017290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sci. Educ. Technol.','Journal of Science Education and Technology','1059-0145',1.124000,0.001960,0.223440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vet. Med. Educ.','JOURNAL OF VETERINARY MEDICAL EDUCATION','0748-321X',0.901000,0.000680,0.077290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Educ.','MEDICAL EDUCATION','0308-0110',3.369000,0.013520,1.540620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acad. Med.','ACADEMIC MEDICINE','1040-2446',4.194000,0.027090,3.087970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('East Mediterr. Health J.','EASTERN MEDITERRANEAN HEALTH JOURNAL','1020-3397',0.663000,0.002690,0.307090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Med. Inform.','INTERNATIONAL JOURNAL OF MEDICAL INFORMATICS','1386-5056',2.363000,0.005960,0.679440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Satell. Commun. Netw.','INTERNATIONAL JOURNAL OF SATELLITE COMMUNICATIONS AND NETWORKING','1542-0973',0.700000,0.000460,0.052820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Aerosp. Inf. Syst.','Journal of Aerospace Information Systems','1940-3151',0.302000,0.000190,0.021920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Spacecr. Rockets','JOURNAL OF SPACECRAFT AND ROCKETS','0022-4650',0.716000,0.003220,0.366450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Mech. Eng. Part G-J. Aerosp. Eng.','PROCEEDINGS OF THE INSTITUTION OF MECHANICAL ENGINEERS PART G-JOURNAL OF AEROSPACE ENGINEERING','0954-4100',0.653000,0.002500,0.284600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Aeosp. Sci.','PROGRESS IN AEROSPACE SCIENCES','0376-0421',3.811000,0.003400,0.387500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Plant Sci.','CANADIAN JOURNAL OF PLANT SCIENCE','0008-4220',0.727000,0.002280,0.259600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Soil Sci. Plant Anal.','COMMUNICATIONS IN SOIL SCIENCE AND PLANT ANALYSIS','0010-3624',0.529000,0.002840,0.323540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Crop Sci.','CROP SCIENCE','0011-183X',1.550000,0.009990,1.138330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Czech J. Genet. Plant Breed.','Czech Journal of Genetics and Plant Breeding','1212-1975',0.476000,0.000460,0.052710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genetika-Belgrade','Genetika-Belgrade','0534-0012',0.308000,0.000360,0.041030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Grassl. Sci.','GRASSLAND SCIENCE','1744-6961',0.820000,0.000520,0.058740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ind. Crop. Prod.','INDUSTRIAL CROPS AND PRODUCTS','0926-6690',3.449000,0.022660,2.582550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ITEA-Inf. Tec. Econ. Agrar.','ITEA-Informacion Tecnica Economica Agraria','1699-6887',0.389000,0.000220,0.025280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Legume Res.','Legume Research','0250-5371',0.145000,0.000130,0.015350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mycobiology','MYCOBIOLOGY','1229-8093',0.573000,0.000860,0.098580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Palynology','PALYNOLOGY','0191-6122',1.064000,0.000700,0.079330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharm. Biol.','PHARMACEUTICAL BIOLOGY','1388-0209',1.546000,0.004330,0.493990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phyton-Int. J. Exp. Bot.','PHYTON-INTERNATIONAL JOURNAL OF EXPERIMENTAL BOTANY','1851-5657',0.143000,0.000150,0.016900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phytoparasitica','PHYTOPARASITICA','0334-2123',1.034000,0.001340,0.153170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Breed.','PLANT BREEDING','0179-9541',1.502000,0.003400,0.388070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Mol. Biol. Rep.','PLANT MOLECULAR BIOLOGY REPORTER','0735-9640',2.304000,0.003930,0.448440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Pathol.','PLANT PATHOLOGY','0032-0862',2.383000,0.007830,0.892790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Sci.','PLANT SCIENCE','0168-9452',3.362000,0.014340,1.634330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Power Sources','JOURNAL OF POWER SOURCES','0378-7753',6.333000,0.132720,15.126910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Struct. Chem.','JOURNAL OF STRUCTURAL CHEMISTRY','0022-4766',0.536000,0.001570,0.178870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Simul.','MOLECULAR SIMULATION','0892-7022',1.678000,0.003590,0.409390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Intell. Syst. Technol.','ACM Transactions on Intelligent Systems and Technology','2157-6904',2.414000,0.012930,1.473750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Soft. Comput.','APPLIED SOFT COMPUTING','1568-4946',2.857000,0.023800,2.712200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Behav. Health Serv. Res.','JOURNAL OF BEHAVIORAL HEALTH SERVICES & RESEARCH','1094-3412',1.617000,0.001750,0.199070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Contin. Educ. Health Prof.','JOURNAL OF CONTINUING EDUCATION IN THE HEALTH PROFESSIONS','0894-1912',1.112000,0.001660,0.189620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Eval. Clin. Pract.','JOURNAL OF EVALUATION IN CLINICAL PRACTICE','1356-1294',1.053000,0.006380,0.727420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Healthc. Qual.','Journal for Healthcare Quality','1062-2551',1.507000,0.001650,0.187550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Patient Saf.','Journal of Patient Safety','1549-8417',2.446000,0.001830,0.208600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Sch. Health','JOURNAL OF SCHOOL HEALTH','0022-4391',1.547000,0.004620,0.527010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Milbank Q.','MILBANK QUARTERLY','0887-378X',4.375000,0.005950,0.678360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacoeconomics','PHARMACOECONOMICS','1170-7690',2.566000,0.005620,0.640550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Qual. Life Res.','QUALITY OF LIFE RESEARCH','0962-9343',2.429000,0.017550,1.999990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Support. Care Cancer','SUPPORTIVE CARE IN CANCER','0941-4355',2.535000,0.020320,2.315990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioelectrochemistry','BIOELECTROCHEMISTRY','1567-5394',3.556000,0.004450,0.507370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trans. Inst. Metal Finish.','TRANSACTIONS OF THE INSTITUTE OF METAL FINISHING','0020-2967',0.688000,0.000390,0.044540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Evol. Biol.','BMC EVOLUTIONARY BIOLOGY','1471-2148',3.406000,0.032050,3.653330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Range Manag. Agrofor.','Range Management and Agroforestry','0971-2070',0.391000,0.000050,0.005710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Fac. Agron.','Revista de la Facultad de Agronomia de la Universidad del Zulia','0378-7818',0.030000,0.000070,0.007870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Theor. Appl. Genet.','THEORETICAL AND APPLIED GENETICS','0040-5752',3.900000,0.017630,2.009600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Allergol. Immunopath.','ALLERGOLOGIA ET IMMUNOPATHOLOGIA','0301-0546',1.689000,0.001550,0.176540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Allergologie','ALLERGOLOGIE','0344-5062',0.161000,0.000060,0.007020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Contact Dermatitis','CONTACT DERMATITIS','0105-1873',5.692000,0.005510,0.627970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Allergy Asthma Rep.','CURRENT ALLERGY AND ASTHMA REPORTS','1529-7322',3.127000,0.004670,0.531860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Allergy Immunol. Pulmonol.','Pediatric Allergy Immunology and Pulmonology','2151-321X',0.941000,0.000630,0.071580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Postep. Dermatol. Alergol.','Postepy Dermatologii i Alergologii','1642-395X',1.342000,0.000760,0.086690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Anat. Embyrol. Cell Biol.','Advances in Anatomy Embryology and Cell Biology','0301-5556',1.000000,0.000350,0.039420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anat. Histol. Embryol.','ANATOMIA HISTOLOGIA EMBRYOLOGIA','0340-2096',0.615000,0.000800,0.090820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Morphol.','JOURNAL OF MORPHOLOGY','0362-2525',1.521000,0.004890,0.557420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Int. Androl.','Revista Internacional de Andrologia','1698-031X',0.238000,0.000040,0.004130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anaesthesist','ANAESTHESIST','0003-2417',0.964000,0.001290,0.147360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Anesthesiol.','BMC Anesthesiology','1471-2253',1.320000,0.001740,0.197940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. J. Pain','CLINICAL JOURNAL OF PAIN','0749-8047',2.712000,0.009750,1.111060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Oncol.','ACTA ONCOLOGICA','0284-186X',3.730000,0.013360,1.522870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anal. Cell. Pathol.','Analytical Cellular Pathology','2210-7177',0.459000,0.000640,0.073010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asia-Pac. J. Clin. Oncol.','Asia-Pacific Journal of Clinical Oncology','1743-7555',1.722000,0.001670,0.190430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Artif. Intell. Med.','ARTIFICIAL INTELLIGENCE IN MEDICINE','0933-3657',2.142000,0.002640,0.301470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Artif. Life','ARTIFICIAL LIFE','1064-5462',1.042000,0.000930,0.106550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Auton. Robot.','AUTONOMOUS ROBOTS','0929-5593',1.547000,0.004070,0.463790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Data Min. Knowl. Discov.','DATA MINING AND KNOWLEDGE DISCOVERY','1384-5810',2.714000,0.003700,0.422160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Approx. Reasoning','INTERNATIONAL JOURNAL OF APPROXIMATE REASONING','0888-613X',2.696000,0.005740,0.654450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Comput. Vis.','INTERNATIONAL JOURNAL OF COMPUTER VISION','0920-5691',4.270000,0.020910,2.383170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Fuzzy Syst.','International Journal of Fuzzy Systems','1562-2479',0.941000,0.001340,0.152810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Intell. Autom. Soft Comput.','INTELLIGENT AUTOMATION AND SOFT COMPUTING','1079-8587',0.351000,0.000370,0.041660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Intell. Data Anal.','Intelligent Data Analysis','1088-467X',0.631000,0.000900,0.102340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ambient Intell. Smart Environ.','Journal of Ambient Intelligence and Smart Environments','1876-1364',0.707000,0.000720,0.082590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Exp. Theor. Artif. Intell.','JOURNAL OF EXPERIMENTAL & THEORETICAL ARTIFICIAL INTELLIGENCE','0952-813X',1.703000,0.000600,0.068540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Evol. Biol.','Evolutionary Biology','0071-3260',2.267000,0.003480,0.396560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Invertebr. Syst.','INVERTEBRATE SYSTEMATICS','1445-5226',2.155000,0.001990,0.226680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Evol. Biochem. Physiol.','JOURNAL OF EVOLUTIONARY BIOCHEMISTRY AND PHYSIOLOGY','0022-0930',0.395000,0.000330,0.037790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Evol.','JOURNAL OF MOLECULAR EVOLUTION','0022-2844',1.847000,0.002780,0.317070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Development','DEVELOPMENT','0950-1991',6.059000,0.098280,11.201920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genesis','GENESIS','1526-954X',2.165000,0.006680,0.761580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('In Vitro Cell. Dev. Biol.-Anim.','IN VITRO CELLULAR & DEVELOPMENTAL BIOLOGY-ANIMAL','1071-2690',0.971000,0.002320,0.264010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sex. Dev.','Sexual Development','1661-5425',2.164000,0.001730,0.196810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Endocrinol.','Acta Endocrinologica-Bucharest','1841-0987',0.235000,0.000080,0.008950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Nutr. Metab.','ANNALS OF NUTRITION AND METABOLISM','0250-6807',2.461000,0.004390,0.500790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Avian Conserv. Ecol.','Avian Conservation and Ecology','1712-6568',1.474000,0.000610,0.070000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biota Neotrop.','BIOTA NEOTROPICA','1676-0603',0.555000,0.002690,0.306390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Conserv.-Bulgaria','Nature Conservation-Bulgaria','1314-6947',1.120000,0.000300,0.033900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. J. Oncol. Nurs.','Clinical Journal of Oncology Nursing','1092-1095',0.755000,0.002040,0.232950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Oncol.','CLINICAL ONCOLOGY','0936-6555',3.212000,0.006600,0.751850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Treat. Options Oncol.','CURRENT TREATMENT OPTIONS IN ONCOLOGY','1527-2729',2.127000,0.002180,0.248310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endocr.-Relat. Cancer','ENDOCRINE-RELATED CANCER','1351-0088',4.472000,0.011910,1.357350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Expert Rev. Anticancer Ther','Expert Review of Anticancer Therapy','1473-7140',2.094000,0.005950,0.678120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hematol. Oncol. Clin. North Am.','HEMATOLOGY-ONCOLOGY CLINICS OF NORTH AMERICA','0889-8588',2.806000,0.004650,0.529820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Clin. Oncol.','International Journal of Clinical Oncology','1341-9625',1.806000,0.004610,0.525500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Integr. Cancer Ther.','INTEGRATIVE CANCER THERAPIES','1534-7354',1.706000,0.001790,0.204180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cancer Educ.','JOURNAL OF CANCER EDUCATION','0885-8195',1.368000,0.003410,0.389190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin. Oncol.','JOURNAL OF CLINICAL ONCOLOGY','0732-183X',20.982000,0.324870,37.029080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr. Oncol. Nurs.','Journal of Pediatric Oncology Nursing','1043-4542',1.507000,0.001350,0.154330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Malayas. J. Comput. Sci.','Malaysian Journal of Computer Science','0127-9084',0.476000,0.000100,0.011910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mechatronics','MECHATRONICS','0957-4158',1.871000,0.005520,0.628950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neural Comput.','NEURAL COMPUTATION','0899-7667',1.626000,0.007730,0.880570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Anal. Data Min.','Statistical Analysis and Data Mining','1932-1864',0.574000,0.001910,0.217560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Syst. Sci. Int.','JOURNAL OF COMPUTER AND SYSTEMS SCIENCES INTERNATIONAL','1064-2307',0.503000,0.000500,0.057120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('User Model. User-Adapt. Interact.','USER MODELING AND USER-ADAPTED INTERACTION','0924-1868',2.292000,0.000990,0.113200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Archit. Code Optim.','ACM Transactions on Architecture and Code Optimization','1544-3566',0.585000,0.001490,0.170110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Embed. Comput. Syst.','ACM Transactions on Embedded Computing Systems','1539-9087',0.714000,0.002290,0.261500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM T. Reconfigurable Technol. Syst.','ACM Transactions on Reconfigurable Technology and Systems','1936-7406',0.500000,0.000650,0.073710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. ACM','COMMUNICATIONS OF THE ACM','0001-0782',3.301000,0.019370,2.208080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Stand. Interfaces','COMPUTER STANDARDS & INTERFACES','0920-5489',1.268000,0.001470,0.167520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Metab.','Cell Metabolism','1550-4131',17.303000,0.088610,10.100320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Endocrinol.','CLINICAL ENDOCRINOLOGY','0300-0664',3.487000,0.019250,2.194290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Endocrinol. Diabetes Obes.','Current Opinion in Endocrinology Diabetes and Obesity','1752-296X',3.119000,0.006030,0.686810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endocr. Res.','ENDOCRINE RESEARCH','0743-5800',1.476000,0.000720,0.082440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endocrine','ENDOCRINE','1355-008X',3.279000,0.008190,0.933740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Clin. Endocrinol. Diabet.','EXPERIMENTAL AND CLINICAL ENDOCRINOLOGY & DIABETES','0947-7349',1.665000,0.003310,0.376910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Horm.-Int. J. Endocrinol. Metab.','Hormones-International Journal of Endocrinology and Metabolism','1109-3099',1.190000,0.001810,0.206800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Bone Miner. Res.','JOURNAL OF BONE AND MINERAL RESEARCH','0884-0431',5.622000,0.041540,4.734270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lung Cancer','LUNG CANCER','0169-5002',3.767000,0.022310,2.543190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Rev. Cancer','NATURE REVIEWS CANCER','1474-175X',34.244000,0.087810,10.008690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oncol. Nurs. Forum','ONCOLOGY NURSING FORUM','0190-535X',2.708000,0.004030,0.458940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Hematol. Oncol.','PEDIATRIC HEMATOLOGY AND ONCOLOGY','0888-0018',1.090000,0.001980,0.225890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Strahlenther. Onkol.','STRAHLENTHERAPIE UND ONKOLOGIE','0179-7158',2.898000,0.005010,0.571540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Support. Care Cancer','SUPPORTIVE CARE IN CANCER','0941-4355',2.535000,0.020320,2.315990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Target. Oncol.','Targeted Oncology','1776-2596',3.197000,0.002280,0.260080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ther. Adv. Med. Oncol.','Therapeutic Advances in Medical Oncology','1758-8340',3.938000,0.001950,0.222540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Urol. Oncol.-Semin. Orig. Investig.','UROLOGIC ONCOLOGY-SEMINARS AND ORIGINAL INVESTIGATIONS','1078-1439',2.921000,0.010820,1.233290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Cardiol.','ACTA CARDIOLOGICA','0001-5385',0.600000,0.001450,0.164900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Computer','COMPUTER','0018-9162',1.115000,0.006220,0.708710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Dependable Secur. Comput.','IEEE Transactions on Dependable and Secure Computing','1545-5971',1.592000,0.002960,0.337710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Wirel. Commun.','IEEE WIRELESS COMMUNICATIONS','1536-1284',4.148000,0.015250,1.738430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Integration-VLSI J.','INTEGRATION-THE VLSI JOURNAL','0167-9260',0.703000,0.000890,0.101880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Syst. Architect.','JOURNAL OF SYSTEMS ARCHITECTURE','1383-7621',0.683000,0.001420,0.162130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('New Gener. Comput.','NEW GENERATION COMPUTING','0288-3635',0.533000,0.000310,0.034780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Internet. Technol.','ACM Transactions on Internet Technology','1533-5399',0.705000,0.000460,0.052770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cluster Comput.','Cluster Computing-The Journal of Networks Software Tools and Applications','1386-7857',1.514000,0.001300,0.148380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mammary Gland Biol. Neoplasia','JOURNAL OF MAMMARY GLAND BIOLOGY AND NEOPLASIA','1083-3021',3.143000,0.003600,0.410900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neuroendocrinol.','JOURNAL OF NEUROENDOCRINOLOGY','0953-8194',3.172000,0.009310,1.061210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr. Endocrinol. Metab.','JOURNAL OF PEDIATRIC ENDOCRINOLOGY & METABOLISM','0334-018X',0.912000,0.003640,0.414650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Trace Elem. Med. Biol.','JOURNAL OF TRACE ELEMENTS IN MEDICINE AND BIOLOGY','0946-672X',2.550000,0.002610,0.297170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Cell. Endocrinol.','MOLECULAR AND CELLULAR ENDOCRINOLOGY','0303-7207',3.859000,0.029700,3.385700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutr. Clin. Metab.','Nutrition Clinique et Metabolisme','0985-0562',0.398000,0.000080,0.008620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Obes. Facts','Obesity Facts','1662-4025',2.400000,0.003150,0.358600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Therm. Eng.','APPLIED THERMAL ENGINEERING','1359-4311',3.043000,0.032090,3.657370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Astron.','EXPERIMENTAL ASTRONOMY','0922-6435',2.867000,0.003320,0.377840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Icarus','ICARUS','0019-1035',3.383000,0.044450,5.066340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Astrobiol.','International Journal of Astrobiology','1473-5504',1.184000,0.001020,0.116820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mod. Phys. D','INTERNATIONAL JOURNAL OF MODERN PHYSICS D','0218-2718',1.963000,0.006980,0.795390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cosmol. Astropart. Phys.','JOURNAL OF COSMOLOGY AND ASTROPARTICLE PHYSICS','1475-7516',5.634000,0.060710,6.919640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('New Astron.','NEW ASTRONOMY','1384-1076',1.085000,0.003170,0.361320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Lett. B','PHYSICS LETTERS B','0370-2693',4.787000,0.095490,10.884190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Res. Astron. Astrophys.','Research in Astronomy and Astrophysics','1674-4527',1.292000,0.005570,0.634940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Audiol. Neuro-Otol.','AUDIOLOGY AND NEURO-OTOLOGY','1420-3030',1.776000,0.002720,0.309630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ear Hear.','EAR AND HEARING','0196-0202',2.517000,0.007740,0.882310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Speech Lang.','SEMINARS IN SPEECH AND LANGUAGE','0734-0478',0.907000,0.000580,0.066490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anim. Cogn.','ANIMAL COGNITION','1435-9448',2.161000,0.005460,0.622170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Behav. Brain Res.','BEHAVIOURAL BRAIN RESEARCH','0166-4328',3.002000,0.040340,4.597620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Behav. Med.','BEHAVIORAL MEDICINE','0896-4289',1.737000,0.000880,0.100590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anat. J. Cardiol.','Anatolian Journal of Cardiology','2149-2263',1.141000,0.001400,0.159010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiol. Clin.','CARDIOLOGY CLINICS','0733-8651',1.184000,0.001620,0.185010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiol. Rev.','Cardiology in Review','1061-5377',2.590000,0.002310,0.263790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiol. Young','CARDIOLOGY IN THE YOUNG','1047-9511',0.825000,0.003310,0.377150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiovasc. Drugs Ther.','CARDIOVASCULAR DRUGS AND THERAPY','0920-3206',3.189000,0.003250,0.370840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cardiovasc. Ther.','Cardiovascular Therapeutics','1755-5914',2.243000,0.003540,0.403450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Circulation','CIRCULATION','0009-7322',17.202000,0.269200,30.683530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Res. Cardiol.','Clinical Research in Cardiology','1861-0684',4.324000,0.007160,0.815880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Heart J. Suppl.','EUROPEAN HEART JOURNAL SUPPLEMENTS','1520-765X',0.455000,0.000270,0.030610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('EuroIntervention','EuroIntervention','1774-024X',3.863000,0.016570,1.888500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heart','HEART','1355-6037',5.693000,0.037480,4.271550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heart Surg. Forum','HEART SURGERY FORUM','1098-3511',0.343000,0.000840,0.095470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Herz','HERZ','0340-9937',0.751000,0.001480,0.168550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Heart J.','International Heart Journal','1349-2365',1.938000,0.001950,0.222150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiothorac. Vasc. Anesth.','JOURNAL OF CARDIOTHORACIC AND VASCULAR ANESTHESIA','1053-0770',1.519000,0.006860,0.782150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Multimedia','IEEE MULTIMEDIA','1070-986X',1.361000,0.001970,0.224920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Pervasive Comput.','IEEE PERVASIVE COMPUTING','1536-1268',1.836000,0.002410,0.274990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Multimedia','IEEE TRANSACTIONS ON MULTIMEDIA','1520-9210',2.536000,0.011940,1.360570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Serv. Comput.','IEEE Transactions on Services Computing','1939-1374',2.365000,0.003320,0.378480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEICE Trans. Fundam. Electron. Commun. Comput. Sci.','IEICE TRANSACTIONS ON FUNDAMENTALS OF ELECTRONICS COMMUNICATIONS AND COMPUTER SCIENCES','1745-1337',0.236000,0.002520,0.287350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Technol. Control','Information Technology and Control','1392-124X',0.633000,0.000340,0.039240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Retr. J.','Information Retrieval Journal','1386-4564',0.896000,0.000990,0.112450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Distrib. Sens. Netw.','International Journal of Distributed Sensor Networks','1550-1329',0.906000,0.004350,0.496290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Med. Inform.','INTERNATIONAL JOURNAL OF MEDICAL INFORMATICS','1386-5056',2.363000,0.005960,0.679440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Med. Inf. Assoc.','JOURNAL OF THE AMERICAN MEDICAL INFORMATICS ASSOCIATION','1067-5027',3.428000,0.016830,1.918400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem Inf. Model.','Journal of Chemical Information and Modeling','1549-9596',3.657000,0.024020,2.738350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cheminformatics','Journal of Cheminformatics','1758-2946',3.949000,0.005610,0.639600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Organ. End User Comput.','Journal of Organizational and End User Computing','1546-2234',0.156000,0.000180,0.020530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Strateg. Inf. Syst.','JOURNAL OF STRATEGIC INFORMATION SYSTEMS','0963-8687',2.595000,0.001280,0.146440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Geothermics','GEOTHERMICS','0375-6505',2.323000,0.002860,0.326080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Coal Geol.','INTERNATIONAL JOURNAL OF COAL GEOLOGY','0166-5162',3.294000,0.009630,1.097840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Exergy','International Journal of Exergy','1742-8297',1.377000,0.000820,0.093880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Energy South. Afr.','Journal of Energy in Southern Africa','1021-447X',0.237000,0.000190,0.021950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Comput.','ENGINEERING COMPUTATIONS','0264-4401',0.691000,0.001430,0.162940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Epilepsy Behav.','EPILEPSY & BEHAVIOR','1525-5050',2.332000,0.016180,1.844010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genes Brain Behav.','GENES BRAIN AND BEHAVIOR','1601-1848',3.275000,0.008100,0.923620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Horm. Behav.','HORMONES AND BEHAVIOR','0018-506X',3.340000,0.015950,1.817530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacol. Biochem. Behav.','PHARMACOLOGY BIOCHEMISTRY AND BEHAVIOR','0091-3057',2.537000,0.012530,1.428280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioconjugate Chem.','BIOCONJUGATE CHEMISTRY','1043-1802',4.500000,0.023390,2.666070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioinformatics','BIOINFORMATICS','1367-4803',5.766000,0.184410,21.019620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomed. Chromatogr.','BIOMEDICAL CHROMATOGRAPHY','0269-3879',1.729000,0.005590,0.637180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biotechniques','BIOTECHNIQUES','0736-6205',2.298000,0.005700,0.649530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Biotechnol.','CURRENT OPINION IN BIOTECHNOLOGY','0958-1669',8.314000,0.025970,2.959860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Drug Test. Anal.','Drug Testing and Analysis','1942-7603',2.859000,0.005070,0.578010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Immunol. Methods','JOURNAL OF IMMUNOLOGICAL METHODS','0022-1759',1.858000,0.009920,1.130730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Microbiol. Methods','JOURNAL OF MICROBIOLOGICAL METHODS','0167-7012',1.857000,0.011450,1.305450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiovasc. Pharmacol. Ther.','JOURNAL OF CARDIOVASCULAR PHARMACOLOGY AND THERAPEUTICS','1074-2484',2.538000,0.002930,0.333790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Cardiol.','PEDIATRIC CARDIOLOGY','0172-0643',1.452000,0.008940,1.018920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tex. Heart Inst. J.','TEXAS HEART INSTITUTE JOURNAL','1526-6702',0.788000,0.002880,0.328420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Naturae','Acta Naturae','2075-8251',1.770000,0.001290,0.146850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ageing Res. Rev.','AGEING RESEARCH REVIEWS','1568-1637',7.526000,0.009920,1.130270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Physiol.-Cell Physiol.','AMERICAN JOURNAL OF PHYSIOLOGY-CELL PHYSIOLOGY','0363-6143',3.395000,0.023620,2.692000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Commun. Adhes.','CELL COMMUNICATION AND ADHESION','1541-9061',1.955000,0.000510,0.057840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Online Inf. Rev.','ONLINE INFORMATION REVIEW','1468-4527',1.152000,0.001200,0.136660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photonic Netw. Commun.','PHOTONIC NETWORK COMMUNICATIONS','1387-974X',0.557000,0.000740,0.084030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Requir. Eng.','REQUIREMENTS ENGINEERING','0947-3602',1.105000,0.000820,0.093520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sigmod Rec.','SIGMOD RECORD','0163-5808',0.698000,0.001130,0.128540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sust. Comput.','Sustainable Computing-Informatics & Systems','2210-5379',0.569000,0.000540,0.061780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Big Data','Big Data','2167-6461',1.696000,0.000550,0.062150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Biol. Chem.','COMPUTATIONAL BIOLOGY AND CHEMISTRY','1476-9271',1.014000,0.001680,0.191110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Geosci.','COMPUTERS & GEOSCIENCES','0098-3004',2.474000,0.014800,1.686700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Math. Organ. Theory','Computational and Mathematical Organization Theory','1381-298X',0.370000,0.000400,0.045460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Music J.','COMPUTER MUSIC JOURNAL','0148-9267',0.279000,0.000100,0.011090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Eng. Sci.','INTERNATIONAL JOURNAL OF ENGINEERING SCIENCE','0020-7225',3.165000,0.008330,0.950000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Uncertain. Quantif.','International Journal for Uncertainty Quantification','2152-5080',1.000000,0.000880,0.099790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Integr. Comput.-Aided Eng.','INTEGRATED COMPUTER-AIDED ENGINEERING','1069-2509',4.981000,0.001240,0.141120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Meas. Sci. Technol.','MEASUREMENT SCIENCE and TECHNOLOGY','0957-0233',1.492000,0.017250,1.966100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Eng. Ethics','SCIENCE AND ENGINEERING ETHICS','1353-3452',1.454000,0.001770,0.201570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Multidiscip. Optim.','STRUCTURAL AND MULTIDISCIPLINARY OPTIMIZATION','1615-147X',2.208000,0.009470,1.078830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomaterials','BIOMATERIALS','0142-9612',8.387000,0.148530,16.929310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Virol. Methods','JOURNAL OF VIROLOGICAL METHODS','0166-0934',1.508000,0.012110,1.380750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Imaging','Molecular Imaging','1535-3508',2.216000,0.002630,0.300230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('New Biotech.','New Biotechnology','1871-6784',3.199000,0.005200,0.592420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plant Mol. Biol. Rep.','PLANT MOLECULAR BIOLOGY REPORTER','0735-9640',2.304000,0.003930,0.448440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Crystallogr. F-Struct. Biol. Commun.','Acta Crystallographica Section F-Structural Biology Communications','2053-230X',0.647000,0.005660,0.645040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Amino Acids','AMINO ACIDS','0939-4451',3.196000,0.018320,2.088180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Biochem..','Annual Review of Biochemistry','0066-4154',21.407000,0.035060,3.996230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochim. Biophys. Acta-Mol. Cell Res.','BIOCHIMICA ET BIOPHYSICA ACTA-MOLECULAR CELL RESEARCH','0167-4889',5.128000,0.033630,3.833540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochem. Biophys. Res. Commun.','BIOCHEMICAL AND BIOPHYSICAL RESEARCH COMMUNICATIONS','0006-291X',2.371000,0.090050,10.263940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioelectrochemistry','BIOELECTROCHEMISTRY','1567-5394',3.556000,0.004450,0.507370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioorg. Med. Chem.','BIOORGANIC & MEDICINAL CHEMISTRY','0968-0896',2.923000,0.037720,4.299600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Death Differ.','CELL DEATH AND DIFFERENTIATION','1350-9047',8.218000,0.035610,4.058630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell. Mol. Bioeng.','Cellular and Molecular Bioengineering','1865-5025',1.589000,0.001760,0.200450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Stress Chaperones','CELL STRESS & CHAPERONES','1355-8145',2.583000,0.004420,0.503520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cells Tissues Organs','CELLS TISSUES ORGANS','1422-6405',1.228000,0.003430,0.391020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cytokine','CYTOKINE','1043-4666',2.940000,0.014970,1.706020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cytopathology','CYTOPATHOLOGY','0956-5507',1.761000,0.001290,0.147210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Histochem. Cell Biol.','HISTOCHEMISTRY AND CELL BIOLOGY','0948-6143',2.780000,0.006510,0.741650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Immunol. Cell Biol.','IMMUNOLOGY AND CELL BIOLOGY','0818-9641',4.473000,0.010470,1.193160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Rev. Cell Mol. Biol.','International Review of Cell and Molecular Biology','1937-6448',3.752000,0.005150,0.587550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('INFORMS J. Comput.','INFORMS JOURNAL ON COMPUTING','1091-9856',1.246000,0.003760,0.428210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Comput. Integr. Manuf.','INTERNATIONAL JOURNAL OF COMPUTER INTEGRATED MANUFACTURING','0951-192X',1.319000,0.001820,0.206920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mod. Phys. C','INTERNATIONAL JOURNAL OF MODERN PHYSICS C','0129-1831',1.195000,0.002540,0.288980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Numer. Methods Fluids','INTERNATIONAL JOURNAL FOR NUMERICAL METHODS IN FLUIDS','0271-2091',1.447000,0.011670,1.329780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. RF Microw. Comput-Aid. Eng.','INTERNATIONAL JOURNAL OF RF AND MICROWAVE COMPUTER-AIDED ENGINEERING','1096-4290',0.524000,0.001090,0.124300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comb. Optim.','JOURNAL OF COMBINATORIAL OPTIMIZATION','1382-6905',1.080000,0.004400,0.501000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Biol.','JOURNAL OF COMPUTATIONAL BIOLOGY','1066-5277',1.537000,0.007550,0.860480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Stat. Comput. Simul.','JOURNAL OF STATISTICAL COMPUTATION AND SIMULATION','0094-9655',0.749000,0.005260,0.599600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Comput. Model.','MATHEMATICAL AND COMPUTER MODELLING','0895-7177',1.366000,0.012970,1.478580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Simul.-Trans. Soc. Model. Simul. Int.','SIMULATION-TRANSACTIONS OF THE SOCIETY FOR MODELING AND SIMULATION INTERNATIONAL','0037-5497',0.640000,0.001100,0.125010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Soft Comput.','SOFT COMPUTING','1432-7643',1.630000,0.006420,0.732010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Speech Commun.','SPEECH COMMUNICATION','0167-6393',1.038000,0.003390,0.386310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Multidiscip. Optim.','STRUCTURAL AND MULTIDISCIPLINARY OPTIMIZATION','1615-147X',2.208000,0.009470,1.078830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Transact. Des. Automat. Electron. Syst.','ACM TRANSACTIONS ON DESIGN AUTOMATION OF ELECTRONIC SYSTEMS','1084-4309',0.820000,0.000900,0.102350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Embed. Comput. Syst.','ACM Transactions on Embedded Computing Systems','1539-9087',0.714000,0.002290,0.261500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Knowl. Discov. Data','ACM Transactions on Knowledge Discovery from Data','1556-4681',1.000000,0.001510,0.172570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ACM Trans. Program. Lang. Syst.','ACM TRANSACTIONS ON PROGRAMMING LANGUAGES AND SYSTEMS','0164-0925',1.148000,0.001540,0.175030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Biomech.','CLINICAL BIOMECHANICS','0268-0033',1.636000,0.009880,1.126090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Oral Implant. Res.','CLINICAL ORAL IMPLANTS RESEARCH','0905-7161',3.464000,0.016950,1.932470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Biomed. Eng.','IEEE TRANSACTIONS ON BIOMEDICAL ENGINEERING','0018-9294',2.468000,0.024470,2.788940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IRBM','IRBM','1959-0318',0.628000,0.000640,0.072890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomater. Appl.','JOURNAL OF BIOMATERIALS APPLICATIONS','0885-3282',1.988000,0.002760,0.314870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mech. Behav. Biomed. Mater.','Journal of the Mechanical Behavior of Biomedical Materials','1751-6161',2.876000,0.014690,1.674630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. NeuroEng. Rehabil.','Journal of NeuroEngineering and Rehabilitation','1743-0003',2.419000,0.006790,0.773410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Biol. Eng. Comput.','MEDICAL & BIOLOGICAL ENGINEERING & COMPUTING','0140-0118',1.797000,0.005430,0.619120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Mech. Eng. Part H-J. Eng. Med.','PROCEEDINGS OF THE INSTITUTION OF MECHANICAL ENGINEERS PART H-JOURNAL OF ENGINEERING IN MEDICINE','0954-4119',0.996000,0.003180,0.362950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Technol. Health Care','TECHNOLOGY AND HEALTH CARE','0928-7329',0.678000,0.000890,0.101020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Tissue Eng. Regen. Med.','Tissue Engineering and Regenerative Medicine','1738-2696',0.941000,0.000700,0.080200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Catal. B-Environ.','APPLIED CATALYSIS B-ENVIRONMENTAL','0926-3373',8.328000,0.057140,6.512660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ecol. Eng.','ECOLOGICAL ENGINEERING','0925-8574',2.740000,0.017450,1.988890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Eng. Geosci.','ENVIRONMENTAL & ENGINEERING GEOSCIENCE','1078-7275',0.500000,0.000440,0.050530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Modell. Softw.','ENVIRONMENTAL MODELLING & SOFTWARE','1364-8152',4.207000,0.017740,2.021990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Sci. Technol. Lett.','Environmental Science & Technology Letters','2328-8930',4.839000,0.002370,0.270020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Boichem.','BMC BIOCHEMISTRY','1471-2091',1.290000,0.001920,0.218590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell. Mol. Biol.','CELLULAR AND MOLECULAR BIOLOGY','0145-5680',0.605000,0.000500,0.057380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Speciation Bioavail.','CHEMICAL SPECIATION AND BIOAVAILABILITY','0954-2299',0.457000,0.000210,0.023660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Lipidol.','Clinical Lipidology','1758-4299',0.769000,0.000950,0.108360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comp. Biochem. Physiol. D-Genomics Proteomics','Comparative Biochemistry and Physiology D-Genomics & Proteomics','1744-117X',2.254000,0.001710,0.194690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cytokine','CYTOKINE','1043-4666',2.940000,0.014970,1.706020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('DNA Cell Biol.','DNA AND CELL BIOLOGY','1044-5498',2.574000,0.004560,0.520000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Cytokine Netw.','EUROPEAN CYTOKINE NETWORK','1148-5493',2.562000,0.001250,0.142730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Food Funct.','Food & Function','2042-6496',2.686000,0.007960,0.907770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genes Genom.','Genes & Genomics','1976-9571',0.692000,0.001010,0.115400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomed. Sci.','JOURNAL OF BIOMEDICAL SCIENCE','1021-7770',2.935000,0.006370,0.726280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Histochem. Cytochem.','JOURNAL OF HISTOCHEMISTRY & CYTOCHEMISTRY','0022-1554',2.140000,0.004390,0.500320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Histotechnol.','JOURNAL OF HISTOTECHNOLOGY','0147-8885',0.086000,0.000050,0.006040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mech. Ageing Dev.','MECHANISMS OF AGEING AND DEVELOPMENT','0047-6374',2.892000,0.005650,0.644530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Cells','MOLECULES AND CELLS','1016-8478',2.670000,0.007990,0.910890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Membr. Biol.','MOLECULAR MEMBRANE BIOLOGY','0968-7688',1.983000,0.001530,0.174760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Cell Biol.','NATURE CELL BIOLOGY','1465-7392',18.699000,0.104400,11.899010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Med.','NATURE MEDICINE','1078-8956',30.357000,0.161790,18.440690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Protein Cell','Protein & Cell','1674-800X',3.817000,0.006920,0.788650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Cell Dev. Biol.','SEMINARS IN CELL & DEVELOPMENTAL BIOLOGY','1084-9521',5.181000,0.022080,2.516130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Computer','COMPUTER','0018-9162',1.115000,0.006220,0.708710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Discret. Math. Theor. Comput. Sci.','DISCRETE MATHEMATICS AND THEORETICAL COMPUTER SCIENCE','1462-7264',0.537000,0.001970,0.224010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Dependable Secur. Comput.','IEEE Transactions on Dependable and Secure Computing','1545-5971',1.592000,0.002960,0.337710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Multimedia','IEEE TRANSACTIONS ON MULTIMEDIA','1520-9210',2.536000,0.011940,1.360570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEICE Trans. Inf. Syst.','IEICE TRANSACTIONS ON INFORMATION AND SYSTEMS','1745-1361',0.226000,0.002260,0.257450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Inf. Vis.','Information Visualization','1473-8716',0.639000,0.000890,0.101980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. ACM','JOURNAL OF THE ACM','0004-5411',1.803000,0.008060,0.918490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vis. Lang. Comput.','JOURNAL OF VISUAL LANGUAGES AND COMPUTING','1045-926X',0.634000,0.000680,0.077760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Program.','MATHEMATICAL PROGRAMMING','0025-5610',2.062000,0.016570,1.888810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Random Struct. Algorithms','RANDOM STRUCTURES & ALGORITHMS','1042-9832',1.011000,0.004940,0.562520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Simul. Model. Pract. Theory','SIMULATION MODELLING PRACTICE AND THEORY','1569-190X',1.482000,0.003510,0.399850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Simul.-Trans. Soc. Model. Simul. Int.','SIMULATION-TRANSACTIONS OF THE SOCIETY FOR MODELING AND SIMULATION INTERNATIONAL','0037-5497',0.640000,0.001100,0.125010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Softw. Test. Verif. Reliab.','SOFTWARE TESTING VERIFICATION & RELIABILITY','0960-0833',1.082000,0.001250,0.142670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hazard. Mater.','JOURNAL OF HAZARDOUS MATERIALS','0304-3894',4.836000,0.097150,11.073720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Waste Manage.','WASTE MANAGEMENT','0956-053X',3.829000,0.019050,2.171390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adsorpt. Sci. Technol.','ADSORPTION SCIENCE & TECHNOLOGY','0263-6174',0.633000,0.000600,0.068920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Catal. B-Environ.','APPLIED CATALYSIS B-ENVIRONMENTAL','0926-3373',8.328000,0.057140,6.512660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioprocess. Biosyst. Eng.','BIOPROCESS AND BIOSYSTEMS ENGINEERING','1615-7591',1.901000,0.006150,0.701360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Eng. Sci.','CHEMICAL ENGINEERING SCIENCE','0009-2509',2.750000,0.035340,4.028230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Ind. Chem. Eng. Q.','Chemical Industry & Chemical Engineering Quarterly','1451-9372',0.617000,0.000600,0.068830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('China Pet. Process. Petrochem. T.','China Petroleum Processing & Petrochemical Technology','1008-6234',0.388000,0.000110,0.012840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Chem. Eng.','CHINESE JOURNAL OF CHEMICAL ENGINEERING','1004-9541',1.207000,0.003480,0.396530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Combust. Explos.','COMBUSTION EXPLOSION AND SHOCK WAVES','0010-5082',0.604000,0.001540,0.175930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Filtr. Sep.','FILTRATION & SEPARATION','0015-1882',0.124000,0.000150,0.016550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hum. Mol. Genet.','HUMAN MOLECULAR GENETICS','0964-6906',5.985000,0.095240,10.855170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Biochem. Cell Biol.','INTERNATIONAL JOURNAL OF BIOCHEMISTRY & CELL BIOLOGY','1357-2725',3.905000,0.025880,2.949860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mol. Sci.','INTERNATIONAL JOURNAL OF MOLECULAR SCIENCES','1422-0067',3.257000,0.055090,6.279270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biochem.','JOURNAL OF BIOCHEMISTRY','0021-924X',2.397000,0.008010,0.913390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biochem. Mol. Toxicol.','JOURNAL OF BIOCHEMICAL AND MOLECULAR TOXICOLOGY','1095-6670',2.303000,0.002010,0.228600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Med. Biochem.','Journal of Medical Biochemistry','1452-8258',0.742000,0.000170,0.018840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Recept. Signal Transduct.','JOURNAL OF RECEPTORS AND SIGNAL TRANSDUCTION','1079-9893',1.782000,0.001480,0.168690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Struct. Biol.','JOURNAL OF STRUCTURAL BIOLOGY','1047-8477',2.570000,0.025540,2.911150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Trace Elem. Med. Biol.','JOURNAL OF TRACE ELEMENTS IN MEDICINE AND BIOLOGY','0946-672X',2.550000,0.002610,0.297170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Metallomics','Metallomics','1756-5901',3.540000,0.010120,1.152970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Biochem. Parasitol.','MOLECULAR AND BIOCHEMICAL PARASITOLOGY','0166-6851',2.068000,0.005890,0.670810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Biol. Evol.','MOLECULAR BIOLOGY AND EVOLUTION','0737-4038',13.649000,0.103310,11.775050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anasthesiol. Intensivmed.','ANASTHESIOLOGIE & INTENSIVMEDIZIN','0170-5334',2.055000,0.000590,0.067790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. Crit. Care','Australian Critical Care','1036-7314',1.479000,0.000880,0.099990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Crit. Care','Current Opinion in Critical Care','1070-5295',2.706000,0.006820,0.777480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hum. Gene Ther. Clin. Dev.','Human Gene Therapy Clinical Development','2324-8637',2.889000,0.000480,0.055210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Crit. Care Med.','Pediatric Critical Care Medicine','1529-7535',2.659000,0.011210,1.278190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Combust. Flame','COMBUSTION AND FLAME','0010-2180',4.168000,0.026220,2.988220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Conv. Manag.','ENERGY CONVERSION AND MANAGEMENT','0196-8904',4.801000,0.033620,3.832110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heat Transf. Eng.','HEAT TRANSFER ENGINEERING','0145-7632',1.016000,0.002900,0.330750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Engine Res.','International Journal of Engine Research','1468-0874',1.479000,0.002010,0.228570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Appl. Fluid Mech.','Journal of Applied Fluid Mechanics','1735-3572',0.888000,0.000510,0.058590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Algebr. Eng. Commun. Comput.','APPLICABLE ALGEBRA IN ENGINEERING COMMUNICATION AND COMPUTING','0938-1279',0.370000,0.000930,0.106180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Big Data','Big Data','2167-6461',1.696000,0.000550,0.062150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Meth. Programs Biomed.','COMPUTER METHODS AND PROGRAMS IN BIOMEDICINE','0169-2607',1.862000,0.007960,0.906820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Connect. Sci.','CONNECTION SCIENCE','0954-0091',1.125000,0.000220,0.025470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Evol. Comput.','EVOLUTIONARY COMPUTATION','1063-6560',3.600000,0.002790,0.318210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Expert Syst.','EXPERT SYSTEMS','0266-4720',0.947000,0.000570,0.064630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Found. Comput. Math.','FOUNDATIONS OF COMPUTATIONAL MATHEMATICS','1615-3375',1.986000,0.005810,0.662180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Genet. Program. Evol. Mach.','Genetic Programming and Evolvable Machines','1389-2576',1.143000,0.000880,0.100500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Evol. Comput.','IEEE TRANSACTIONS ON EVOLUTIONARY COMPUTATION','1089-778X',5.908000,0.009080,1.035040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IET Comput. Digit. Tech.','IET Computers and Digital Techniques','1751-8601',0.517000,0.000480,0.054650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Gen. Syst.','INTERNATIONAL JOURNAL OF GENERAL SYSTEMS','0308-1079',1.677000,0.001050,0.119560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Complex.','JOURNAL OF COMPLEXITY','0885-064X',1.358000,0.003110,0.354520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comput. Syst. Sci. Int.','JOURNAL OF COMPUTER AND SYSTEMS SCIENCES INTERNATIONAL','1064-2307',0.503000,0.000500,0.057120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem. Eng. Data','JOURNAL OF CHEMICAL AND ENGINEERING DATA','0021-9568',1.835000,0.021810,2.486240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem. Eng. Jpn.','JOURNAL OF CHEMICAL ENGINEERING OF JAPAN','0021-9592',0.553000,0.001200,0.136270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Energ. Mater.','Journal of Energetic Materials','0737-0652',1.017000,0.000550,0.062350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ind. Eng. Chem.','JOURNAL OF INDUSTRIAL AND ENGINEERING CHEMISTRY','1226-086X',4.179000,0.013600,1.550550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Microw. Power Electromagn. Energy','JOURNAL OF MICROWAVE POWER AND ELECTROMAGNETIC ENERGY','0832-7823',0.925000,0.000330,0.038030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nat. Gas Sci. Eng.','Journal of Natural Gas Science and Engineering','1875-5100',2.045000,0.002880,0.328240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Kag. Kog. Ronbunshu','KAGAKU KOGAKU RONBUNSHU','0386-216X',0.410000,0.000210,0.024050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('KONA Powder Part. J.','KONA Powder and Particle Journal','0288-4534',1.780000,0.000580,0.065890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Process Biochem.','PROCESS BIOCHEMISTRY','1359-5113',2.529000,0.015120,1.723670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('React. Funct. Polym.','REACTIVE & FUNCTIONAL POLYMERS','1381-5148',2.725000,0.005920,0.675010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Chim.','REVISTA DE CHIMIE','0034-7752',0.956000,0.001280,0.146180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solid Fuel Chem.','Solid Fuel Chemistry','0361-5219',0.258000,0.000160,0.018490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surf. Coat. Int.','SURFACE COATINGS INTERNATIONAL','1754-0925',0.061000,0.000010,0.000940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Carcinog.','MOLECULAR CARCINOGENESIS','0899-1987',4.722000,0.007570,0.862500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Cell. Biol.','MOLECULAR AND CELLULAR BIOLOGY','0270-7306',4.427000,0.065530,7.468960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Genet. Genomics','MOLECULAR GENETICS AND GENOMICS','1617-4615',2.622000,0.004460,0.508320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Genet. Microbiol. Virol.','Molecular Genetics Microbiology and Virology','0891-4168',0.183000,0.000150,0.017600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Microbiol.','MOLECULAR MICROBIOLOGY','0950-382X',3.761000,0.053230,6.066610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Reprod. Dev.','MOLECULAR REPRODUCTION AND DEVELOPMENT','1040-452X',2.141000,0.004970,0.566350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mol. Syst. Biol.','Molecular Systems Biology','1744-4292',10.581000,0.036220,4.127840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurochem. Res.','NEUROCHEMICAL RESEARCH','0364-3190',2.472000,0.012310,1.403450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Acid Ther.','Nucleic Acid Therapeutics','2159-3337',2.813000,0.002450,0.279360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photochem. Photobiol.','PHOTOCHEMISTRY AND PHOTOBIOLOGY','0031-8655',2.008000,0.007830,0.892030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prep. Biochem. Biotechnol.','PREPARATIVE BIOCHEMISTRY & BIOTECHNOLOGY','1082-6068',1.114000,0.000750,0.085160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('RNA','RNA','1355-8382',4.344000,0.033650,3.835550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Russ. J. Bioorg. Chem.','RUSSIAN JOURNAL OF BIOORGANIC CHEMISTRY','1068-1620',0.660000,0.001060,0.121320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Signal.','Science Signaling','1945-0877',7.359000,0.043900,5.004050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Thermochim. Acta','THERMOCHIMICA ACTA','0040-6031',1.938000,0.015070,1.718160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('AATCC Rev.','AATCC REVIEW','1532-8813',0.239000,0.000160,0.018190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adsorpt. Sci. Technol.','ADSORPTION SCIENCE & TECHNOLOGY','0263-6174',0.633000,0.000600,0.068920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cent. Eur. J. Energ. Mater.','Central European Journal of Energetic Materials','1733-7178',1.280000,0.000760,0.086750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comb. Chem. High Throughput Screen','COMBINATORIAL CHEMISTRY & HIGH THROUGHPUT SCREENING','1386-2073',1.041000,0.001860,0.212030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Chem. Technol.','INDIAN JOURNAL OF CHEMICAL TECHNOLOGY','0971-457X',0.491000,0.000660,0.075090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Leather Chem. Assoc.','JOURNAL OF THE AMERICAN LEATHER CHEMISTS ASSOCIATION','0002-9726',0.707000,0.000240,0.027760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Food Saf. Food Qual.','Journal of Food Safety and Food Quality-Archiv fur Lebensmittelhygiene','0003-925X',0.083000,0.000210,0.024150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Oleo Sci.','Journal of Oleo Science','1345-8957',1.108000,0.002010,0.229010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microporous Mesoporous Mat.','MICROPOROUS AND MESOPOROUS MATERIALS','1387-1811',3.349000,0.026940,3.070180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Logic. Algebr. Program','JOURNAL OF LOGIC AND ALGEBRAIC PROGRAMMING','1567-8326',0.579000,0.001010,0.114580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Logic Comput.','JOURNAL OF LOGIC AND COMPUTATION','0955-792X',0.585000,0.001980,0.226100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Web Eng.','Journal of Web Engineering','1540-9589',0.622000,0.000160,0.018440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Log. Meth. Comput. Sci.','Logical Methods in Computer Science','1860-5974',0.569000,0.003170,0.361550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Perform. Eval.','PERFORMANCE EVALUATION','0166-5316',0.944000,0.002840,0.323780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Real-Time Syst.','REAL-TIME SYSTEMS','0922-6443',0.738000,0.000790,0.089630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Cem. Res.','ADVANCES IN CEMENT RESEARCH','0951-7197',0.949000,0.000830,0.094110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Build. Environ.','BUILDING AND ENVIRONMENT','0360-1323',3.394000,0.019030,2.169150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Constr. Build. Mater.','CONSTRUCTION AND BUILDING MATERIALS','0950-0618',2.421000,0.041500,4.730020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Energy Build.','ENERGY AND BUILDINGS','0378-7788',2.973000,0.027920,3.182500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Concr. Struct. Mater.','International Journal of Concrete Structures and Materials','1976-0485',1.411000,0.000750,0.085310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Perform. Constr. Facil.','JOURNAL OF PERFORMANCE OF CONSTRUCTED FACILITIES','0887-3828',0.893000,0.002090,0.238650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eng. Econ.','ENGINEERING ECONOMIST','0013-791X',1.207000,0.000410,0.046660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Eng. Manage.','IEEE TRANSACTIONS ON ENGINEERING MANAGEMENT','0018-9391',1.454000,0.002290,0.261060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IIE Trans.','IIE TRANSACTIONS','0740-817X',1.463000,0.004630,0.527890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ind. Robot','INDUSTRIAL ROBOT-AN INTERNATIONAL JOURNAL','0143-991X',0.422000,0.000670,0.076690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Ind. Ergon.','INTERNATIONAL JOURNAL OF INDUSTRIAL ERGONOMICS','0169-8141',1.000000,0.002190,0.249830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Simul. Model','International Journal of Simulation Modelling','1726-4529',1.683000,0.000460,0.052870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Manage. Eng.','JOURNAL OF MANAGEMENT IN ENGINEERING','0742-597X',1.840000,0.001330,0.151710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mater. Process. Technol.','JOURNAL OF MATERIALS PROCESSING TECHNOLOGY','0924-0136',2.359000,0.016400,1.869340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Assem. Autom.','ASSEMBLY AUTOMATION','0144-5154',1.176000,0.000760,0.086280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('CIRP Ann-Manuf. Technol.','CIRP ANNALS-MANUFACTURING TECHNOLOGY','0007-8506',2.492000,0.008350,0.952020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Comput. Integr. Manuf.','INTERNATIONAL JOURNAL OF COMPUTER INTEGRATED MANUFACTURING','0951-192X',1.319000,0.001820,0.206920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Ind. Eng.-Theory Appl. Pract.','INTERNATIONAL JOURNAL OF INDUSTRIAL ENGINEERING-THEORY APPLICATIONS AND PRACTICE','1943-670X',0.385000,0.000250,0.027990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mater. Form.','International Journal of Material Forming','1960-6206',1.241000,0.002240,0.255760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Precis Eng Manuf-Green Technol.','International Journal of Precision Engineering and Manufacturing-Green Technology','2288-6206',2.545000,0.000320,0.036360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Precis. Eng. Manuf.','International Journal of Precision Engineering and Manufacturing','2234-7593',1.075000,0.004690,0.534890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Adv. Mech. Des. Syst. Manuf.','Journal of Advanced Mechanical Design Systems and Manufacturing','1881-3054',0.331000,0.000650,0.073610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Manuf. Process.','MATERIALS AND MANUFACTURING PROCESSES','1042-6914',1.419000,0.004150,0.473080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Cells Mater.','EUROPEAN CELLS & MATERIALS','1473-2262',4.560000,0.006760,0.770170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stem Cell Res.','Stem Cell Research','1873-5061',3.892000,0.007450,0.849130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stem Cells','STEM CELLS','1066-5099',5.902000,0.040440,4.609490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stem Cells Int.','Stem Cells International','1687-966X',3.687000,0.003520,0.401490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Hum. Biol.','AMERICAN JOURNAL OF HUMAN BIOLOGY','1042-0533',1.875000,0.005630,0.642150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bioessays','BIOESSAYS','0265-9247',4.725000,0.017960,2.047120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Bull','BIOLOGY BULLETIN','1062-3590',0.358000,0.000810,0.092010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Lett.','Biology Letters','1744-9561',2.823000,0.025350,2.889340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biosystems','BIOSYSTEMS','0303-2647',1.495000,0.003450,0.392710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Brazilian J. Med. Biol. Res.','BRAZILIAN JOURNAL OF MEDICAL AND BIOLOGICAL RESEARCH','0100-879X',1.146000,0.004170,0.475190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Biol. Chem.','COMPUTATIONAL BIOLOGY AND CHEMISTRY','1476-9271',1.014000,0.001680,0.191110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Opin. Insect Sci.','Current Opinion in Insect Science','2214-5745',2.719000,0.000790,0.089550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('eLife','eLife','2050-084X',8.282000,0.068430,7.800110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hum. Biol.','HUMAN BIOLOGY','0018-7143',0.857000,0.001250,0.142680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Exp. Biol.','INDIAN JOURNAL OF EXPERIMENTAL BIOLOGY','0019-5189',1.165000,0.002350,0.267600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rep. Med. Chem.','Annual Reports in Medicinal Chemistry','0065-7743',1.000000,0.000660,0.075420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Nat. Compd.','CHEMISTRY OF NATURAL COMPOUNDS','0009-3130',0.473000,0.002160,0.245920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ChemMedChem','ChemMedChem','1860-7179',2.980000,0.013120,1.495020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Comput.-Aided Drug Des.','Current Computer-Aided Drug Design','1573-4099',1.155000,0.000640,0.073520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Asian Nat. Prod. Res.','JOURNAL OF ASIAN NATURAL PRODUCTS RESEARCH','1028-6020',1.009000,0.002870,0.327520);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ginseng Res.','Journal of Ginseng Research','1226-8453',3.898000,0.002320,0.264010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Lett. Drug Des. Discov.','Letters in Drug Design & Discovery','1570-1808',0.974000,0.001200,0.136720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Prod. Res.','NATURAL PRODUCT RESEARCH','1478-6419',1.057000,0.005880,0.669740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Bras. Farmacogn.-Braz. J. Pharmacogn.','Revista Brasileira de Farmacognosia-Brazilian Journal of Pharmacognosy','0102-695X',0.956000,0.001820,0.207200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sci. Technol. Built Environ.','Science and Technology for the Built Environment','2374-4731',0.000000,0.000000,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Struct. Concr.','Structural Concrete','1464-4177',1.023000,0.000910,0.103470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Emerg. Med. Australas.','Emergency Medicine Australasia','1742-6731',1.223000,0.002610,0.297460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Emerg. Nurs.','Journal of Emergency Nursing','0099-1767',0.872000,0.001480,0.168420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Crystallogr. Sect. C-Struct. Chem.','Acta Crystallographica Section C-Structural Chemistry','2053-2296',0.479000,0.001650,0.187940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cryst. Res. Technol.','CRYSTAL RESEARCH AND TECHNOLOGY','0232-1300',0.908000,0.003300,0.375680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. Dent. J.','AUSTRALIAN DENTAL JOURNAL','0045-0421',1.272000,0.002970,0.338430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Oral Health','BMC Oral Health','1472-6831',1.210000,0.002340,0.267280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. Dent. J.','BRITISH DENTAL JOURNAL','0007-0610',0.997000,0.002930,0.334460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Implant Dent. Relat. Res.','Clinical Implant Dentistry and Related Research','1523-0899',4.152000,0.007710,0.879090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Community Dent. Health','COMMUNITY DENTAL HEALTH','0265-539X',0.767000,0.001120,0.127750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solder. Surf. Mt. Technol.','SOLDERING & SURFACE MOUNT TECHNOLOGY','0954-0911',0.913000,0.000350,0.039360);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nav. Eng. J.','NAVAL ENGINEERS JOURNAL','0028-1425',0.157000,0.000220,0.025040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ocean Eng.','OCEAN ENGINEERING','0029-8018',1.488000,0.009720,1.107980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Inst. Mech. Eng. Part M- J. Eng. Marit. Environ.','Proceedings of the Institution of Mechanical Engineers Part M-Journal of Engineering for the Maritime Environment','1475-0902',0.902000,0.000750,0.085000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Coast. Eng.','COASTAL ENGINEERING','0378-3839',2.841000,0.007790,0.887810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Earthq. Eng. Struct. Dyn.','EARTHQUAKE ENGINEERING & STRUCTURAL DYNAMICS','0098-8847',2.127000,0.008000,0.911610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ITE J.-Inst. Transp. Eng.','ITE JOURNAL-INSTITUTE OF TRANSPORTATION ENGINEERS','0162-8178',0.174000,0.000370,0.042560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Adv. Transp.','JOURNAL OF ADVANCED TRANSPORTATION','0197-6729',1.292000,0.001420,0.162310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Anal. Methods Chem.','Journal of Analytical Methods in Chemistry','2090-8865',1.369000,0.000830,0.094700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Bridge Eng.','Journal of Bridge Engineering','1084-0702',1.069000,0.003710,0.422680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Math. Biosci.','MATHEMATICAL BIOSCIENCES','0025-5564',1.256000,0.004410,0.502770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Proc. Biol. Soc. Wash.','PROCEEDINGS OF THE BIOLOGICAL SOCIETY OF WASHINGTON','0006-324X',0.757000,0.000640,0.072900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Saudi J. Biol. Sci.','SAUDI JOURNAL OF BIOLOGICAL SCIENCES','1319-562X',1.781000,0.001490,0.170320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biochim. Biophys. Acta Mol. Cell Biol. Lipids','BIOCHIMICA ET BIOPHYSICA ACTA-MOLECULAR AND CELL BIOLOGY OF LIPIDS','1388-1981',4.779000,0.018360,2.093200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomicrofluidics','Biomicrofluidics','1932-1058',2.708000,0.008280,0.944100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Eng. News','CHEMICAL & ENGINEERING NEWS','0009-2347',0.330000,0.001880,0.213860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Lett.','CHEMISTRY LETTERS','0366-7022',1.550000,0.014410,1.642490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chem. Listy','CHEMICKE LISTY','0009-2770',0.279000,0.000510,0.058160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chim. Oggi-Chem. Today','CHIMICA OGGI-CHEMISTRY TODAY','0392-839X',0.538000,0.000790,0.089750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('C. R. Chim.','COMPTES RENDUS CHIMIE','1631-0748',1.798000,0.003910,0.445490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('HYLE','HYLE','1433-5158',0.500000,0.000100,0.010950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Chem. Sect A-Inorg. Bio-Inorg. Phys. Theor. Anal. Chem.','INDIAN JOURNAL OF CHEMISTRY SECTION A-INORGANIC BIO-INORGANIC PHYSICAL THEORETICAL & ANALYTICAL CHEMISTRY','0376-4710',0.729000,0.001160,0.132670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Braz. Chem. Soc.','JOURNAL OF THE BRAZILIAN CHEMICAL SOCIETY','0103-5053',1.096000,0.005340,0.608680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem Inf. Model.','Journal of Chemical Information and Modeling','1549-9596',3.657000,0.024020,2.738350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dent. Mater.','DENTAL MATERIALS','0109-5641',3.931000,0.013640,1.554740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Orthodont.','EUROPEAN JOURNAL OF ORTHODONTICS','0141-5387',1.440000,0.004860,0.553870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Adhes. Dent.','JOURNAL OF ADHESIVE DENTISTRY','1461-5185',1.594000,0.002110,0.240240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Dent. Educ.','JOURNAL OF DENTAL EDUCATION','0022-0337',0.830000,0.002260,0.257550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Oral Facial Pain Headache','Journal of Oral & Facial Pain and Headache','2333-0384',2.444000,0.000400,0.045890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Prosthodont. Res.','Journal of Prosthodontic Research','1883-1958',1.693000,0.001390,0.158180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Dermatopathol.','AMERICAN JOURNAL OF DERMATOPATHOLOGY','0193-1091',1.396000,0.005160,0.588660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ocean Eng.','OCEAN ENGINEERING','0029-8018',1.488000,0.009720,1.107980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sea Technol.','SEA TECHNOLOGY','0093-3651',0.047000,0.000220,0.024730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pet. Sci. Eng.','JOURNAL OF PETROLEUM SCIENCE AND ENGINEERING','0920-4105',1.655000,0.008750,0.997550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pet. Sci. Technol.','PETROLEUM SCIENCE AND TECHNOLOGY','1091-6466',0.418000,0.001950,0.222740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Petrophysics','Petrophysics','1529-9074',0.514000,0.000600,0.068650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('SPE Drill. Complet.','SPE DRILLING & COMPLETION','1064-6671',0.308000,0.000710,0.081040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('SPE Reserv. Eval. Eng.','SPE RESERVOIR EVALUATION & ENGINEERING','1094-6470',1.767000,0.003060,0.349180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Electron.','CHINESE JOURNAL OF ELECTRONICS','1022-4653',0.319000,0.000570,0.065320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comput. Netw.','Computer Networks','1389-1286',1.446000,0.013420,1.529580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electr. Commun. Jpn.','Electronics and Communications in Japan','1942-9533',0.113000,0.000270,0.030770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electr. Eng. Jpn.','ELECTRICAL ENGINEERING IN JAPAN','0424-7760',0.125000,0.000470,0.053050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('EPE J.','EPE Journal','0939-8368',0.156000,0.000210,0.023740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Antennas Propag. Mag.','IEEE ANTENNAS AND PROPAGATION MAGAZINE','1045-9243',0.896000,0.004980,0.567710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Antennas Wirel. Propag. Lett.','IEEE Antennas and Wireless Propagation Letters','1536-1225',1.751000,0.026090,2.974170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Circuits Syst. Mag.','IEEE Circuits and Systems Magazine','1531-636X',3.000000,0.001420,0.161850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Electron Device Lett.','IEEE ELECTRON DEVICE LETTERS','0741-3106',2.528000,0.030740,3.504260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pharm. Pharmacol.','JOURNAL OF PHARMACY AND PHARMACOLOGY','0022-3573',2.363000,0.006980,0.796090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microb. Drug Resist.','Microbial Drug Resistance','1076-6294',2.529000,0.004180,0.476390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Naunyn-Schmiedebergs Arch. Pharmacol.','NAUNYN-SCHMIEDEBERGS ARCHIVES OF PHARMACOLOGY','0028-1298',2.376000,0.004400,0.501380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nat. Rev. Drug Discov.','NATURE REVIEWS DRUG DISCOVERY','1474-1776',47.120000,0.062730,7.149820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuropsychopharmacology','NEUROPSYCHOPHARMACOLOGY','0893-133X',6.399000,0.049980,5.697170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pharmacogenet. Genomics','Pharmacogenetics and Genomics','1744-6872',2.857000,0.006060,0.690730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Soil Sci.','SOIL SCIENCE','0038-075X',0.713000,0.002020,0.230140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anal. Methods','Analytical Methods','1759-9660',1.915000,0.019460,2.217570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Annu. Rev. Anal. Chem.','Annual Review of Analytical Chemistry','1936-1327',8.000000,0.004670,0.532140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomol. NMR Assign.','Biomolecular NMR Assignments','1874-2718',0.687000,0.001100,0.125210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mass Spectrom.','INTERNATIONAL JOURNAL OF MASS SPECTROMETRY','1387-3806',2.183000,0.010330,1.177690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Anal. At. Spectrom.','JOURNAL OF ANALYTICAL ATOMIC SPECTROMETRY','0267-9477',3.379000,0.012440,1.418090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adapt. Phys. Act. Q.','ADAPTED PHYSICAL ACTIVITY QUARTERLY','0736-5829',1.487000,0.000550,0.063150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Physiol. Nutr. Metab.','Applied Physiology Nutrition and Metabolism','1715-5312',1.910000,0.008920,1.016580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Sport. Med. Rep.','Current Sports Medicine Reports','1537-890X',1.336000,0.002180,0.248480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exerc. Sport Sci. Rev.','EXERCISE AND SPORT SCIENCES REVIEWS','0091-6331',4.451000,0.004130,0.470890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neurotoxicology','NEUROTOXICOLOGY','0161-813X',2.738000,0.007630,0.869380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Sleep Biol. Rhythms','Sleep and Biological Rhythms','1446-9235',0.628000,0.000890,0.101790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transl. Stroke Res.','Translational Stroke Research','1868-4483',4.503000,0.004200,0.479160);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Visual Neurosci.','VISUAL NEUROSCIENCE','0952-5238',1.871000,0.002190,0.249240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuroradiology','NEURORADIOLOGY','0028-3940',2.274000,0.008440,0.962000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ATW-Int. J. Nucl. Power','ATW-INTERNATIONAL JOURNAL FOR NUCLEAR POWER','1431-5254',0.045000,0.000090,0.010700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Radiat. Biol.','INTERNATIONAL JOURNAL OF RADIATION BIOLOGY','0955-3002',1.779000,0.005210,0.593380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nucl. Mater.','JOURNAL OF NUCLEAR MATERIALS','0022-3115',2.199000,0.033630,3.833280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Eng. Technol.','Nuclear Engineering and Technology','1738-5733',0.792000,0.003080,0.350930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Z.Naturforsch.(C)','ZEITSCHRIFT FUR NATURFORSCHUNG SECTION C-A JOURNAL OF BIOSCIENCES','0939-5075',0.709000,0.000930,0.105540);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Energy Mater.','Advanced Energy Materials','1614-6832',15.230000,0.057520,6.556640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Mater.','ADVANCED MATERIALS','0935-9648',18.960000,0.326160,37.175700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fluct. Noise Lett.','FLUCTUATION AND NOISE LETTERS','0219-4775',0.815000,0.000530,0.059920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Photonics Technol. Lett.','IEEE PHOTONICS TECHNOLOGY LETTERS','1041-1135',1.945000,0.027620,3.148180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Sens. J.','IEEE SENSORS JOURNAL','1530-437X',1.889000,0.019340,2.204230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cryst. Growth','JOURNAL OF CRYSTAL GROWTH','0022-0248',1.462000,0.021970,2.504190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Exp. Nanosci.','Journal of Experimental Nanoscience','1745-8080',0.832000,0.000990,0.112680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Magn.','Journal of Magnetics','1226-1750',0.421000,0.000490,0.055730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nano Res.','Journal of Nano Research','1662-5250',0.366000,0.000470,0.053290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Appl. Sport Psychol.','JOURNAL OF APPLIED SPORT PSYCHOLOGY','1041-3200',1.369000,0.001360,0.155530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Kinesiology','Kinesiology','1331-1441',0.553000,0.000330,0.037700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Exerc. Sci.','PEDIATRIC EXERCISE SCIENCE','0899-8493',1.495000,0.002070,0.236120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Res. Q. Exerc. Sport','RESEARCH QUARTERLY FOR EXERCISE AND SPORT','0270-1367',1.702000,0.003140,0.357750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Inst. Stat. Math.','ANNALS OF THE INSTITUTE OF STATISTICAL MATHEMATICS','0020-3157',0.768000,0.003150,0.358640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radiochim. Acta','RADIOCHIMICA ACTA','0033-8230',1.100000,0.003080,0.350610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radioprotection','RADIOPROTECTION','0033-8451',0.508000,0.000320,0.036250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Paul. Enferm.','Acta Paulista de Enfermagem','0103-2100',0.294000,0.000650,0.073910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Appl. Nurs. Res.','APPLIED NURSING RESEARCH','0897-1897',1.043000,0.001460,0.165910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biol. Res. Nurs.','Biological Research for Nursing','1099-8004',1.604000,0.001770,0.201410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Contemp. Nurse.','Contemporary Nurse','1037-6178',0.886000,0.001390,0.157950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Cardiovasc. Nurs.','European Journal of Cardiovascular Nursing','1474-5151',2.491000,0.002390,0.272260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gastroenterol. Nurs.','Gastroenterology Nursing','1042-895X',0.493000,0.000540,0.061050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Ment. Health Nurs.','International Journal of Mental Health Nursing','1445-8330',1.943000,0.002020,0.230230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Psych. Nurses Assoc.','Journal of the American Psychiatric Nurses Association','1078-3903',1.535000,0.000690,0.078630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cardiovasc. Nurs.','Journal of Cardiovascular Nursing','0889-4655',2.172000,0.003150,0.359410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hum. Lact.','JOURNAL OF HUMAN LACTATION','0890-3344',2.233000,0.001960,0.223730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Korean Acad. Nurs.','Journal of Korean Academy of Nursing','2005-3673',0.549000,0.000730,0.082840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Midwifery Women Health','JOURNAL OF MIDWIFERY & WOMENS HEALTH','1526-9523',1.432000,0.002860,0.326400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Optoelectron. Adv. Mater.','JOURNAL OF OPTOELECTRONICS AND ADVANCED MATERIALS','1454-4164',0.383000,0.001590,0.180730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ovonic Res.','Journal of Ovonic Research','1842-2403',0.692000,0.000240,0.027040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Photonics Energy','Journal of Photonics for Energy','1947-7988',1.527000,0.001060,0.120930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vac. Sci. Technol. B','JOURNAL OF VACUUM SCIENCE & TECHNOLOGY B','1071-1023',1.398000,0.010290,1.172750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Zhejiang Univ.-SCI A','Journal of Zhejiang University-SCIENCE A','1673-565X',0.941000,0.001620,0.184870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanophotonics','Nanophotonics','2192-8606',4.333000,0.002820,0.321870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Opt. Laser Technol.','OPTICS AND LASER TECHNOLOGY','0030-3992',1.879000,0.009830,1.119870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plasma Chem. Plasma Process.','PLASMA CHEMISTRY AND PLASMA PROCESSING','0272-4324',1.811000,0.002500,0.285250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Photovoltaics','PROGRESS IN PHOTOVOLTAICS','1062-7995',7.365000,0.017020,1.940380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Econometrica','ECONOMETRICA','0012-9682',4.053000,0.046110,5.255150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Electron. Commun. Probab.','ELECTRONIC COMMUNICATIONS IN PROBABILITY','1083-589X',0.467000,0.004700,0.535590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ESAIM-Prob. Stat.','ESAIM-Probability and Statistics','1292-8100',0.600000,0.001440,0.164490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hacet. J. Math. Stat.','Hacettepe Journal of Mathematics and Statistics','1303-5010',0.277000,0.000750,0.085990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Appl. Stat.','JOURNAL OF APPLIED STATISTICS','0266-4763',0.419000,0.004540,0.517250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biopharm. Stat.','Journal of Biopharmaceutical Statistics','1054-3406',0.882000,0.003130,0.356970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Nonparametr. Stat.','JOURNAL OF NONPARAMETRIC STATISTICS','1048-5252',0.446000,0.003020,0.344070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Stat. Comput. Simul.','JOURNAL OF STATISTICAL COMPUTATION AND SIMULATION','0094-9655',0.749000,0.005260,0.599600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Stat. Plan. Infer.','JOURNAL OF STATISTICAL PLANNING AND INFERENCE','0378-3758',0.727000,0.014600,1.663650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Probab. Eng. Inform. Sci.','PROBABILITY IN THE ENGINEERING AND INFORMATIONAL SCIENCES','0269-9648',0.390000,0.000930,0.105800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Qual. Quant.','QUALITY & QUANTITY','0033-5177',0.867000,0.003660,0.416710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Biopharm. Res.','Statistics in Biopharmaceutical Research','1946-6315',0.672000,0.001410,0.160740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Methods Med. Res.','STATISTICAL METHODS IN MEDICAL RESEARCH','0962-2802',4.634000,0.007400,0.842960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Neerl.','STATISTICA NEERLANDICA','0039-0402',0.432000,0.001380,0.157650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Wound Ostomy Cont. Nurs.','Journal of Wound Ostomy and Continence Nursing','1071-5754',0.969000,0.001480,0.168890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JNP-J. Nurse Pract.','JNP-Journal for Nurse Practitioners','1555-4155',0.234000,0.000440,0.050250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nurs. Health Sci.','Nursing & Health Sciences','1441-0745',1.347000,0.002180,0.248570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nurs. Inq.','Nursing Inquiry','1320-7881',1.141000,0.001010,0.114940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Oncol. Nurs. Forum','ONCOLOGY NURSING FORUM','0190-535X',2.708000,0.004030,0.458940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Women Birth','Women and Birth','1871-5192',1.525000,0.001880,0.214080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Asia Pac. J. Clin. Nutr.','ASIA PACIFIC JOURNAL OF CLINICAL NUTRITION','0964-7058',1.350000,0.002940,0.334900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Top. Nutraceutical Res.','Current Topics in Nutraceutical Research','1540-7535',0.186000,0.000100,0.011250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Clin. Nutr.','EUROPEAN JOURNAL OF CLINICAL NUTRITION','0954-3007',2.935000,0.016500,1.880480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Lipid Sci. Technol.','EUROPEAN JOURNAL OF LIPID SCIENCE AND TECHNOLOGY','1438-7697',1.953000,0.006230,0.709620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Nutr.','EUROPEAN JOURNAL OF NUTRITION','1436-6207',3.239000,0.007880,0.897610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Geosci. Remote Sensing','IEEE TRANSACTIONS ON GEOSCIENCE AND REMOTE SENSING','0196-2892',3.360000,0.037590,4.284650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Imaging Sci. J.','IMAGING SCIENCE JOURNAL','1368-2199',0.454000,0.000350,0.040200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('ISPRS-J. Photogramm. Remote Sens.','ISPRS JOURNAL OF PHOTOGRAMMETRY AND REMOTE SENSING','0924-2716',4.188000,0.010780,1.228150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vis.','JOURNAL OF VISUALIZATION','1343-8875',0.720000,0.000840,0.095970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Remote Sens. Lett.','Remote Sensing Letters','2150-704X',1.487000,0.002600,0.296240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('SIAM J. Imaging Sci.','SIAM Journal on Imaging Sciences','1936-4954',2.687000,0.010910,1.243050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Virtual Real.','VIRTUAL REALITY','1359-4338',0.568000,0.000580,0.065690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Commun. Nonlinear Sci. Numer. Simul.','Communications in Nonlinear Science and Numerical Simulation','1007-5704',2.834000,0.022080,2.517050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plasma Chem. Plasma Process.','PLASMA CHEMISTRY AND PLASMA PROCESSING','0272-4324',1.811000,0.002500,0.285250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Plasma  Phys. Control. Fusion','PLASMA PHYSICS AND CONTROLLED FUSION','0741-3335',2.404000,0.015310,1.744610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Concepts Magn. Reson. Part A','CONCEPTS IN MAGNETIC RESONANCE PART A','1546-6086',0.526000,0.000680,0.078000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Chem. Theory Comput.','Journal of Chemical Theory and Computation','1549-9618',5.301000,0.063380,7.223620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stat. Sin.','STATISTICA SINICA','1017-0405',0.838000,0.012000,1.367390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stoch. Environ. Res. Risk Assess.','STOCHASTIC ENVIRONMENTAL RESEARCH AND RISK ASSESSMENT','1436-3240',2.237000,0.005200,0.592530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Stochastics','Stochastics-An International Journal of Probability and Stochastic Reports','1744-2508',0.630000,0.001930,0.220040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Util. Math.','UTILITAS MATHEMATICA','0315-3681',0.273000,0.001220,0.139280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Chir. Plast. Esthet.','Annales de Chirurgie Plastique Esthetique','0294-1260',0.581000,0.000790,0.089580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Ital. Chir.','Annali Italiani di Chirurgia','0003-469X',0.395000,0.000710,0.081100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bone Joint J.','Bone & Joint Journal','2049-4394',2.660000,0.008450,0.962570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Br. J. Oral Maxillofac. Surg.','BRITISH JOURNAL OF ORAL & MAXILLOFACIAL SURGERY','0266-4356',1.237000,0.005790,0.659400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Can. J. Plast. Surg.','Canadian Journal of Plastic Surgery','1195-2199',1.053000,0.000730,0.082690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Colorectal Dis.','Colorectal Disease','1462-8910',2.452000,0.017470,1.990780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Coll. Nutr.','JOURNAL OF THE AMERICAN COLLEGE OF NUTRITION','0731-5724',2.245000,0.002780,0.317280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin. Biochem. Nutr.','JOURNAL OF CLINICAL BIOCHEMISTRY AND NUTRITION','0912-0009',1.694000,0.002670,0.303910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Hum. Nutr. Diet.','JOURNAL OF HUMAN NUTRITION AND DIETETICS','0952-3871',2.583000,0.004840,0.551930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutr. Cancer','NUTRITION AND CANCER-AN INTERNATIONAL JOURNAL','0163-5581',2.241000,0.006400,0.729560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nutr. Res.','NUTRITION RESEARCH','0271-5317',2.523000,0.006600,0.752650);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('World Rev.Nutr.Diet.','World Review of Nutrition and Dietetics','0084-2230',1.112000,0.000750,0.085300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Obstet. Gynecol.','AMERICAN JOURNAL OF OBSTETRICS AND GYNECOLOGY','0002-9378',4.681000,0.049200,5.607610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Female Pelvic Med. Reconstr. Surg.','Female Pelvic Medicine and Reconstructive Surgery','2151-8378',1.331000,0.002190,0.249490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prog. Nucl. Magn. Reson. Spectrosc.','PROGRESS IN NUCLEAR MAGNETIC RESONANCE SPECTROSCOPY','0079-6565',7.231000,0.004200,0.479280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Phys.','AMERICAN JOURNAL OF PHYSICS','0002-9505',1.012000,0.004560,0.519800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Henri Poincare','ANNALES HENRI POINCARE','1424-0637',1.760000,0.005960,0.679330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Phys.-Berlin','ANNALEN DER PHYSIK','0003-3804',3.443000,0.005930,0.675610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Phys.','ANNALS OF PHYSICS','0003-4916',2.375000,0.013670,1.557640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cent. Eur. J. Phys.','CENTRAL EUROPEAN JOURNAL OF PHYSICS','1895-1082',0.948000,0.003630,0.413580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. Phys. B','Chinese Physics B','1674-1056',1.436000,0.018020,2.053940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Entropy','Entropy','1099-4300',1.743000,0.007950,0.906470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Found. Phys.','FOUNDATIONS OF PHYSICS','0015-9018',1.018000,0.003170,0.361080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Front. Phys.','Frontiers of Physics','2095-0462',2.462000,0.002690,0.306190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gen. Relativ. Gravit.','GENERAL RELATIVITY AND GRAVITATION','0001-7701',1.668000,0.007940,0.904580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('High Pressure Res.','HIGH PRESSURE RESEARCH','0895-7959',1.014000,0.001750,0.199620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Open Phys.','Open Physics','2391-5471',0.000000,0.000120,0.000000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. World','PHYSICS WORLD','0953-8585',0.228000,0.000570,0.065070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rep. Prog. Phys.','REPORTS ON PROGRESS IN PHYSICS','0034-4885',12.933000,0.033440,3.811730);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Mex. Fis.','REVISTA MEXICANA DE FISICA','0035-001X',0.406000,0.000730,0.082850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rom. J. Phys.','Romanian Journal of Physics','1221-146X',1.398000,0.001690,0.192780);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Waves Random Complex Media','Waves in Random and Complex Media','1745-5030',1.061000,0.000940,0.106610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('HPB','HPB','1365-182X',2.918000,0.010050,1.145720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Surg. Pathol.','INTERNATIONAL JOURNAL OF SURGICAL PATHOLOGY','1066-8969',0.782000,0.002270,0.258630);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Am. Coll. Surg.','JOURNAL OF THE AMERICAN COLLEGE OF SURGEONS','1072-7515',4.257000,0.037710,4.298120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Minimal Access Surg.','Journal of Minimal Access Surgery','0972-9941',0.830000,0.000870,0.099690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neurol. Neurosurg. Psychiatry','JOURNAL OF NEUROLOGY NEUROSURGERY AND PSYCHIATRY','0022-3050',6.431000,0.032840,3.742740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Surg. Oncol.','JOURNAL OF SURGICAL ONCOLOGY','0022-4790',3.151000,0.017880,2.037840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gynecol. Oncol.','GYNECOLOGIC ONCOLOGY','0090-8258',4.198000,0.036100,4.114910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Obstet. Anesth.','INTERNATIONAL JOURNAL OF OBSTETRIC ANESTHESIA','0959-289X',2.040000,0.002450,0.278790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mimim. Invasive Gynecol.','Journal of Minimally Invasive Gynecology','1553-4650',2.390000,0.006630,0.755640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Reprod. Med.','JOURNAL OF REPRODUCTIVE MEDICINE','0024-7758',0.840000,0.001670,0.190100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Womens Health','JOURNAL OF WOMENS HEALTH','1540-9996',2.032000,0.011650,1.327940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Atmos.-Ocean','ATMOSPHERE-OCEAN','0705-5900',1.742000,0.001850,0.211110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Navig.','JOURNAL OF NAVIGATION','0373-4633',1.267000,0.001390,0.158600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Mater.','ADVANCED MATERIALS','0935-9648',18.960000,0.326160,37.175700);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Phys.','ADVANCES IN PHYSICS','0001-8732',18.000000,0.005940,0.677250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mod. Phys. B','INTERNATIONAL JOURNAL OF MODERN PHYSICS B','0217-9792',0.850000,0.005580,0.635890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mater. Sci. Eng. B-Adv. Funct. Solid-State Mater.','Materials Science and Engineering B-Advanced Functional Solid-State Materials','0921-5107',2.331000,0.010860,1.238020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Status Solidi-Rapid Res. Lett.','Physica Status Solidi-Rapid Research Letters','1862-6254',2.578000,0.008390,0.956310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Small','Small','1613-6810',8.315000,0.077240,8.804330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Solid State Ion.','SOLID STATE IONICS','0167-2738',2.380000,0.015730,1.792920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Physiol.','Acta Physiologica','1748-1708',4.066000,0.009550,1.088110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Physiol. Biochem.','ARCHIVES OF PHYSIOLOGY AND BIOCHEMISTRY','1381-3455',1.536000,0.001240,0.140970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Pediatr. Surg.','Seminars in Pediatric Surgery','1055-8586',1.624000,0.002250,0.256660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surg. Innov.','Surgical Innovation','1553-3506',1.358000,0.002680,0.305370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surgery','SURGERY','0039-6060',3.309000,0.027920,3.182040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transpl. Int.','TRANSPLANT INTERNATIONAL','0934-0874',2.835000,0.010240,1.167290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('World J. Surg. Oncol.','World Journal of Surgical Oncology','1477-7819',1.286000,0.006970,0.794130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Telecommun.-Ann Telecommun.','Annals of Telecommunications-Annales des Telecommunications','0003-4347',0.722000,0.000780,0.088900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Freshw. Res.','MARINE AND FRESHWATER RESEARCH','1323-1650',1.583000,0.006250,0.712800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Geol.','MARINE GEOLOGY','0025-3227',2.503000,0.011460,1.306100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ocean Coastal Manage.','OCEAN & COASTAL MANAGEMENT','0964-5691',1.696000,0.006550,0.746110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Terr. Atmos. Ocean. Sci.','TERRESTRIAL ATMOSPHERIC AND OCEANIC SCIENCES','1017-0839',0.556000,0.001280,0.146290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('GISci. Remote Sens.','GIScience & Remote Sensing','1548-1603',2.482000,0.001240,0.141710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('GPS Solut.','GPS SOLUTIONS','1080-5370',2.991000,0.002920,0.332440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photogramm. Eng. Remote Sens.','PHOTOGRAMMETRIC ENGINEERING AND REMOTE SENSING','0099-1112',1.288000,0.003220,0.367230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photogramm. Fernerkund. Geoinf.','Photogrammetrie Fernerkundung Geoinformation','1432-8364',0.554000,0.000470,0.054060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Remote Sens. Lett.','Remote Sensing Letters','2150-704X',1.487000,0.002600,0.296240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Surv. Rev.','SURVEY REVIEW','0039-6265',0.573000,0.000490,0.056200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. J. Ophthalmol.','EUROPEAN JOURNAL OF OPHTHALMOLOGY','1120-6721',1.007000,0.004280,0.487850);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Graefes Arch. Clin. Exp. Ophthalmol.','GRAEFES ARCHIVE FOR CLINICAL AND EXPERIMENTAL OPHTHALMOLOGY','0721-832X',1.991000,0.013230,1.507760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. AAPOS','JOURNAL OF AAPOS','1091-8531',0.931000,0.004140,0.472320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Cataract. Refract. Surg.','JOURNAL OF CATARACT AND REFRACTIVE SURGERY','0886-3350',3.020000,0.018520,2.111400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Eye Mov. Res.','Journal of Eye Movement Research','1995-8692',0.568000,0.000480,0.054510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell. Physiol. Biochem.','CELLULAR PHYSIOLOGY AND BIOCHEMISTRY','1015-8987',4.652000,0.012220,1.392810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chronobiol. Int.','CHRONOBIOLOGY INTERNATIONAL','0742-0528',3.540000,0.007270,0.828810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Comp. Biochem. Physiol. A-Mol. Integr. Physiol.','COMPARATIVE BIOCHEMISTRY AND PHYSIOLOGY A-MOLECULAR & INTEGRATIVE PHYSIOLOGY','1095-6433',2.039000,0.008780,1.001260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biol. Rhythms','JOURNAL OF BIOLOGICAL RHYTHMS','0748-7304',2.824000,0.003900,0.444090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Musculoskelet. Neuronal  Interact.','JOURNAL OF MUSCULOSKELETAL & NEURONAL INTERACTIONS','1108-7161',1.638000,0.002440,0.278090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('KOREAN J. PHYSIOL. PHARMACOL.','KOREAN JOURNAL OF PHYSIOLOGY & PHARMACOLOGY','1226-4512',1.544000,0.001320,0.149920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Exerc. Sci.','PEDIATRIC EXERCISE SCIENCE','0899-8493',1.495000,0.002070,0.236120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Bras. Med. Esporte','Revista Brasileira de Medicina do Esporte','1517-8692',0.173000,0.000310,0.035770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Eur. Phys. J. A','EUROPEAN PHYSICAL JOURNAL A','1434-6001',2.373000,0.011830,1.348870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mod. Phys. E-Nucl. Phys.','INTERNATIONAL JOURNAL OF MODERN PHYSICS E-NUCLEAR PHYSICS','0218-3013',1.229000,0.003750,0.427840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Instrum. Methods Phys. Res. Sect. B-Beam Interact. Mater. Atoms','NUCLEAR INSTRUMENTS & METHODS IN PHYSICS RESEARCH SECTION B-BEAM INTERACTIONS WITH MATERIALS AND ATOMS','0168-583X',1.389000,0.022730,2.591270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nukleonika','NUKLEONIKA','0029-5922',0.546000,0.000790,0.089770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Commun. Mag.','IEEE COMMUNICATIONS MAGAZINE','0163-6804',5.125000,0.040450,4.610270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Netw.','IEEE NETWORK','0890-8044',2.899000,0.006150,0.700870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Pervasive Comput.','IEEE PERVASIVE COMPUTING','1536-1268',1.836000,0.002410,0.274990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Commun.','IEEE TRANSACTIONS ON COMMUNICATIONS','0090-6778',2.298000,0.035120,4.003370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Antennas Propag.','International Journal of Antennas and Propagation','1687-5869',0.750000,0.003900,0.444400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Distrib. Sens. Netw.','International Journal of Distributed Sensor Networks','1550-1329',0.906000,0.004350,0.496290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Internet Res.','Internet Research','1066-2243',3.017000,0.001100,0.125560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IT Prof.','IT Professional','1520-9202',1.067000,0.000940,0.106620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Lightwave Technol.','JOURNAL OF LIGHTWAVE TECHNOLOGY','0733-8724',2.567000,0.030200,3.441910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Opt. Fiber Technol.','OPTICAL FIBER TECHNOLOGY','1068-5200',1.600000,0.002680,0.306040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Peer Peer Netw. Appl.','Peer-to-Peer Networking and Applications','1936-6442',1.000000,0.000380,0.042810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Wirel. Pers. Commun.','WIRELESS PERSONAL COMMUNICATIONS','0929-6212',0.701000,0.005160,0.588040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Occup. Hyg.','ANNALS OF OCCUPATIONAL HYGIENE','0003-4878',1.743000,0.004140,0.471420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Environ. Contam. Toxicol.','ARCHIVES OF ENVIRONMENTAL CONTAMINATION AND TOXICOLOGY','0090-4341',2.039000,0.005830,0.664230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Toxicol.','ARCHIVES OF TOXICOLOGY','0340-5761',6.637000,0.012220,1.393230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Biomarkers','BIOMARKERS','1354-750X',2.016000,0.003900,0.444660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ophthalmic Surg. Lasers Imag. Retin.','Ophthalmic Surgery Lasers & Imaging Retina','2325-8160',1.212000,0.004220,0.481350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. Opt. Lett.','Chinese Optics Letters','1671-7694',1.899000,0.004490,0.511760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Optomechatronics','International Journal of Optomechatronics','1559-9612',0.627000,0.000300,0.034500);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Eur. Opt. Soc.-Rapid Publ.','Journal of the European Optical Society-Rapid Publications','1990-2573',1.199000,0.001590,0.181130);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Lumines.','JOURNAL OF LUMINESCENCE','0022-2313',2.693000,0.021830,2.487750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mod. Opt.','JOURNAL OF MODERN OPTICS','0950-0340',1.267000,0.006440,0.733670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Opt. Soc. Korea.','Journal of the Optical Society of Korea','1226-4776',0.827000,0.001070,0.121760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Photonics Energy','Journal of Photonics for Energy','1947-7988',1.527000,0.001060,0.120930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. X-Ray Sci. Technol.','Journal of X-Ray Science and Technology','0895-3996',1.111000,0.000840,0.095750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Lett. B','PHYSICS LETTERS B','0370-2693',4.787000,0.095490,10.884190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Gen. Relativ. Gravit.','GENERAL RELATIVITY AND GRAVITATION','0001-7701',1.668000,0.007940,0.904580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Phys. G-Nucl. Part. Phys.','JOURNAL OF PHYSICS G-NUCLEAR AND PARTICLE PHYSICS','0954-3899',2.448000,0.014370,1.638390);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Phys. Atom. Nuclei','PHYSICS OF ATOMIC NUCLEI','1063-7788',0.457000,0.002300,0.262550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Geom. Methods Mod. Phys.','INTERNATIONAL JOURNAL OF GEOMETRIC METHODS IN MODERN PHYSICS','0219-8878',0.769000,0.002460,0.280080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Mod. Phys. B','INTERNATIONAL JOURNAL OF MODERN PHYSICS B','0217-9792',0.850000,0.005580,0.635890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Noncommutative Geom.','Journal of Noncommutative Geometry','1661-6952',0.649000,0.001820,0.207680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Open Syst. Inf. Dyn.','OPEN SYSTEMS & INFORMATION DYNAMICS','1230-1612',1.306000,0.000960,0.109930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('DNA Repair','DNA REPAIR','1568-7864',3.929000,0.015790,1.799250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Drugs','DRUGS','0012-6667',4.883000,0.013810,1.574440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Environ. Toxicol.','ENVIRONMENTAL TOXICOLOGY','1520-4081',2.868000,0.004300,0.489960);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biochem. Mol. Toxicol.','JOURNAL OF BIOCHEMICAL AND MOLECULAR TOXICOLOGY','1095-6670',2.303000,0.002010,0.228600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Environ. Pathol. Toxicol. Oncol.','JOURNAL OF ENVIRONMENTAL PATHOLOGY TOXICOLOGY AND ONCOLOGY','0731-8898',1.246000,0.000510,0.057590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Environ. Sci. Health Pt. C-Environ. Carcinog. Ecotoxicol. Rev.','JOURNAL OF ENVIRONMENTAL SCIENCE AND HEALTH PART C-ENVIRONMENTAL CARCINOGENESIS & ECOTOXICOLOGY REVIEWS','1059-0501',3.667000,0.000780,0.089150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mycotoxin Res.','Mycotoxin Research','0178-7888',2.000000,0.001120,0.128200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Toxicol Environ. Chem.','TOXICOLOGICAL AND ENVIRONMENTAL CHEMISTRY','0277-2248',0.634000,0.001920,0.219280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Toxins','Toxins','2072-6651',3.571000,0.010010,1.141210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Laser Phys. Lett.','LASER PHYSICS LETTERS','1612-2011',2.391000,0.010420,1.187270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Light-Sci. Appl.','Light-Science & Applications','2047-7538',13.600000,0.007660,0.873170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nanophotonics','Nanophotonics','2192-8606',4.333000,0.002820,0.321870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Photonics Nanostruct.','Photonics and Nanostructures-Fundamentals and Applications','1569-4410',1.505000,0.001960,0.223690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ornis Fenn.','ORNIS FENNICA','0030-5685',0.867000,0.000580,0.065800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Sports Med.','AMERICAN JOURNAL OF SPORTS MEDICINE','0363-5465',4.517000,0.041400,4.718580);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Clin. Orthop. Rel. Res.','CLINICAL ORTHOPAEDICS AND RELATED RESEARCH','0009-921X',3.127000,0.040840,4.655490);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Foot Ankle Clin.','Foot and Ankle Clinics','1083-7515',0.794000,0.001240,0.141330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Foot Ankle Surg.','Foot and Ankle Surgery','1268-7731',1.092000,0.002090,0.238270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hand Clin.','HAND CLINICS','0749-0712',1.384000,0.002310,0.263770);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('e-Polymers','E-POLYMERS','1618-7229',0.812000,0.000590,0.067100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Macromol. Sci. Part B-Phys.','Journal of Macromolecular Science Part B-Physics','0022-2348',0.620000,0.001580,0.180340);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Photopolym Sci. Technol.','JOURNAL OF PHOTOPOLYMER SCIENCE AND TECHNOLOGY','0914-9244',0.857000,0.001240,0.141590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Polym. Sci. Pol. Chem.','JOURNAL OF POLYMER SCIENCE PART A-POLYMER CHEMISTRY','0887-624X',3.114000,0.024000,2.735010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('KGK-Kautsch. Gummi Kunstst.','KGK-Kautschuk Gummi Kunststoffe','0948-3276',0.359000,0.000240,0.027020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polym. Int.','POLYMER INTERNATIONAL','0959-8103',2.414000,0.008450,0.963040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polym. Sci. Ser. A','POLYMER SCIENCE SERIES A','0965-545X',0.760000,0.001430,0.162920);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Polym. Test','POLYMER TESTING','0142-9418',2.350000,0.006170,0.703120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Adv. Polym. Technol.','ADVANCES IN POLYMER TECHNOLOGY','0730-6679',1.114000,0.001090,0.124120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Carbohydr. Polym.','CARBOHYDRATE POLYMERS','0144-8617',4.219000,0.058370,6.653110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bone Marrow Transplant.','BONE MARROW TRANSPLANTATION','0268-3369',3.636000,0.017080,1.946460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cell Transplant.','CELL TRANSPLANTATION','0963-6897',3.427000,0.010520,1.198680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Transplant.','PEDIATRIC TRANSPLANTATION','1397-3142',1.284000,0.005570,0.634740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Veh. Des.','INTERNATIONAL JOURNAL OF VEHICLE DESIGN','0143-3369',0.757000,0.000720,0.082610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Intell. Transport. Syst.','Journal of Intelligent Transportation Systems','1547-2450',1.565000,0.001030,0.117530);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transp. Plan. Technol.','TRANSPORTATION PLANNING AND TECHNOLOGY','0308-1060',0.706000,0.000870,0.099600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transp. Res. Pt. A-Policy Pract.','TRANSPORTATION RESEARCH PART A-POLICY AND PRACTICE','0965-8564',1.994000,0.010170,1.158970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Transportmetrica B-Transp. Dyn.','Transportmetrica B-Transport Dynamics','2168-0566',2.560000,0.000390,0.044060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Venom. Anim. Toxins Trop. Dis.','JOURNAL OF VENOMOUS ANIMALS AND TOXINS INCLUDING TROPICAL DISEASES','1678-9199',1.488000,0.000880,0.100320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Malar. J.','MALARIA JOURNAL','1475-2875',3.079000,0.031030,3.537210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Soc. Bras. Med. Trop.','Revista da Sociedade Brasileira de Medicina Tropical','0037-8682',0.949000,0.003180,0.362080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trans. Roy. Soc. Trop. Med. Hyg.','TRANSACTIONS OF THE ROYAL SOCIETY OF TROPICAL MEDICINE AND HYGIENE','0035-9203',1.631000,0.006140,0.699480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Trop. Med. Int. Health','TROPICAL MEDICINE & INTERNATIONAL HEALTH','1360-2276',2.519000,0.014580,1.662290);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BJU Int.','BJU INTERNATIONAL','1464-4096',4.387000,0.039920,4.550180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Orthop.','Indian Journal of Orthopaedics','0019-5413',0.640000,0.001700,0.193840);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Orthop. Surg. Res.','Journal of Orthopaedic Surgery and Research','1749-799X',1.215000,0.002820,0.321400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Orthop. Surg.','Journal of Orthopaedic Surgery','1022-5536',0.542000,0.002070,0.235880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Knee Surg. Sports Traumatol. Arthrosc.','KNEE SURGERY SPORTS TRAUMATOLOGY ARTHROSCOPY','0942-2056',3.097000,0.024260,2.765660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Skeletal Radiol.','SKELETAL RADIOLOGY','0364-2348',1.527000,0.007790,0.887370);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Otolaryngol.','AMERICAN JOURNAL OF OTOLARYNGOLOGY','0196-0709',0.933000,0.003780,0.430310);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Folia Phoniatr. Logop.','FOLIA PHONIATRICA ET LOGOPAEDICA','1021-7762',0.391000,0.001120,0.127120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hear. Res.','HEARING RESEARCH','0378-5955',3.565000,0.013780,1.571000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('HNO','HNO','0017-6192',0.852000,0.001300,0.147880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Audiol.','INTERNATIONAL JOURNAL OF AUDIOLOGY','1499-2027',1.681000,0.004580,0.522480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Laryngol. Otol.','JOURNAL OF LARYNGOLOGY AND OTOLOGY','0022-2151',0.736000,0.005030,0.573010);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vestib. Res.-Equilib. Orientat.','JOURNAL OF VESTIBULAR RESEARCH-EQUILIBRIUM & ORIENTATION','0957-4271',1.047000,0.000980,0.111210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Laryngoscope','LARYNGOSCOPE','0023-852X',2.272000,0.029200,3.328620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Geriatr. Psychiatr.','AMERICAN JOURNAL OF GERIATRIC PSYCHIATRY','1064-7481',3.130000,0.010810,1.232690);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Early Interv. Psychiatry','Early Intervention in Psychiatry','1751-7885',2.889000,0.003250,0.370550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Epidemiol. Psychiatr. Sci.','Epidemiology and Psychiatric Sciences','2045-7960',2.847000,0.001570,0.178970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Harv. Rev. Psychiatr.','HARVARD REVIEW OF PSYCHIATRY','1067-3229',2.328000,0.002310,0.262740);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Psychiat. Clin.','INTERNATIONAL JOURNAL OF PSYCHIATRY IN CLINICAL PRACTICE','1365-1501',1.278000,0.001170,0.133260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. Urol. Nephrol.','INTERNATIONAL UROLOGY AND NEPHROLOGY','0301-1623',1.292000,0.005880,0.670190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('LUTS','LUTS-Lower Urinary Tract Symptoms','1757-5664',0.231000,0.000230,0.026000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Urol. J.','Urology Journal','1735-1308',0.737000,0.001200,0.136440);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Urology','UROLOGY','0090-4295',2.187000,0.029940,3.412230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arq. Bras. Med. Vet. Zootec.','ARQUIVO BRASILEIRO DE MEDICINA VETERINARIA E ZOOTECNIA','0102-0935',0.210000,0.001830,0.208670);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Otolaryngol. Clin. N. Am.','OTOLARYNGOLOGIC CLINICS OF NORTH AMERICA','0030-6665',1.264000,0.003490,0.397860);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ann. Paleontol.','ANNALES DE PALEONTOLOGIE','0753-3969',0.894000,0.000410,0.046660);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Mar. Micropaleontol.','MARINE MICROPALEONTOLOGY','0377-8398',1.859000,0.002610,0.297980);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Palaeobiodiversity Palaeoenvironments','Palaeobiodiversity and Palaeoenvironments','1867-1594',1.322000,0.001140,0.130420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Palaeontol. electron.','PALAEONTOLOGIA ELECTRONICA','1935-3952',1.234000,0.001640,0.187140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Paleontol. Res.','PALEONTOLOGICAL RESEARCH','1342-8144',0.807000,0.000410,0.046710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Palynology','PALYNOLOGY','0191-6122',1.064000,0.000700,0.079330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Palaeobot. Palynology','REVIEW OF PALAEOBOTANY AND PALYNOLOGY','0034-6667',2.158000,0.004780,0.545110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Helminthologia','HELMINTHOLOGIA','0440-6605',0.602000,0.000600,0.068260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Psychiatr. Res.','JOURNAL OF PSYCHIATRIC RESEARCH','0022-3956',4.465000,0.024740,2.819480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Psychosomat. Res.','JOURNAL OF PSYCHOSOMATIC RESEARCH','0022-3999',2.840000,0.012110,1.380830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuropsychobiology','NEUROPSYCHOBIOLOGY','0302-282X',1.763000,0.003030,0.345460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuropsychopharmacology','NEUROPSYCHOPHARMACOLOGY','0893-133X',6.399000,0.049980,5.697170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychiatr. Enfant','PSYCHIATRIE DE L ENFANT','0079-726X',0.089000,0.000010,0.001320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychiatry Res.','PSYCHIATRY RESEARCH','0165-1781',2.466000,0.029800,3.397030);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychiatry-Interpers. Biol. Process.','PSYCHIATRY-INTERPERSONAL AND BIOLOGICAL PROCESSES','0033-2747',3.318000,0.001890,0.214930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychogeriatrics','Psychogeriatrics','1346-3500',1.000000,0.001060,0.120710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychosomatics','PSYCHOSOMATICS','0033-3182',1.906000,0.004260,0.485930);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Subst. Use Misuse','SUBSTANCE USE & MISUSE','1082-6084',1.133000,0.005510,0.628080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Z. Psychosom. Med. Psychother.','ZEITSCHRIFT FUR PSYCHOSOMATISCHE MEDIZIN UND PSYCHOTHERAPIE','1438-3608',0.659000,0.000260,0.029380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Avian Dis.','AVIAN DISEASES','0005-2086',1.104000,0.004070,0.463880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Vet. Res.','BMC Veterinary Research','1746-6148',1.643000,0.009120,1.039260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Fish Shellfish Immunol.','FISH & SHELLFISH IMMUNOLOGY','1050-4648',3.025000,0.014970,1.706830);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('In Practice','IN PRACTICE','0263-841X',0.117000,0.000320,0.036070);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Isr. J. Vet. Med.','ISRAEL JOURNAL OF VETERINARY MEDICINE','0334-9152',0.293000,0.000260,0.029480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ital. J. Anim. Sci.','Italian Journal of Animal Science','1594-4077',0.841000,0.001790,0.204100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Aquat. Anim. Health','JOURNAL OF AQUATIC ANIMAL HEALTH','0899-7659',0.859000,0.000850,0.096450);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. S. Afr. Vet. Assoc.','Journal of the South African Veterinary Association','1019-9128',0.441000,0.000540,0.061320);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vet. Cardiol.','Journal of Veterinary Cardiology','1760-2734',0.631000,0.000930,0.105550);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Vet.-Recife','Medicina Veterinaria-Recife','1809-4678',0.100000,0.000030,0.003640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Prev. Vet. Med.','PREVENTIVE VETERINARY MEDICINE','0167-5877',2.182000,0.009700,1.105350);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Bras. Parasitol. Vet.','REVISTA BRASILEIRA DE PARASITOLOGIA VETERINARIA','1984-2961',0.990000,0.001710,0.195150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Rev. Bras. Parasitol. Vet.','REVISTA BRASILEIRA DE PARASITOLOGIA VETERINARIA','1984-2961',0.990000,0.001710,0.195150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Pathol.','AMERICAN JOURNAL OF PATHOLOGY','0002-9440',4.206000,0.056150,6.400220);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Surg. Pathol.','AMERICAN JOURNAL OF SURGICAL PATHOLOGY','0147-5185',4.951000,0.026090,2.973230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Endocr. Pathol.','ENDOCRINE PATHOLOGY','1046-3976',1.817000,0.001450,0.165040);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Mol. Pathol.','EXPERIMENTAL AND MOLECULAR PATHOLOGY','0014-4800',2.638000,0.005350,0.609460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Expert Rev. Mol. Diagn.','EXPERT REVIEW OF MOLECULAR DIAGNOSTICS','1473-7159',3.333000,0.004550,0.518680);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Histol. Histopath.','HISTOLOGY AND HISTOPATHOLOGY','0213-3911',1.875000,0.006520,0.743430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hum. Pathol.','HUMAN PATHOLOGY','0046-8177',2.791000,0.018370,2.093620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Indian J. Pathol. Microbiol.','Indian Journal of Pathology and Microbiology','0377-4929',0.522000,0.001760,0.200090);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Mol. Diagn.','JOURNAL OF MOLECULAR DIAGNOSTICS','1525-1578',5.201000,0.008820,1.004910);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Dev. Psychobiol.','DEVELOPMENTAL PSYCHOBIOLOGY','0012-1630',2.128000,0.006770,0.771590);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Hum. Psychopharmacol.-Clin. Exp.','HUMAN PSYCHOPHARMACOLOGY-CLINICAL AND EXPERIMENTAL','0885-6222',2.440000,0.003330,0.379710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Sport Psychol.','INTERNATIONAL JOURNAL OF SPORT PSYCHOLOGY','0047-0767',0.871000,0.000600,0.067950);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Child Psychol. Psychiatry','JOURNAL OF CHILD PSYCHOLOGY AND PSYCHIATRY','0021-9630',6.615000,0.024690,2.813600);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Multisens. Res.','Multisensory Research','2213-4794',1.036000,0.000320,0.036610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Neuropsychology','NEUROPSYCHOLOGY','0894-4105',2.879000,0.007870,0.897470);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psycho-Oncologie','Psycho-Oncologie','1778-3798',0.176000,0.000030,0.003020);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Psychother. Psychosom.','PSYCHOTHERAPY AND PSYCHOSOMATICS','0033-3190',7.632000,0.004630,0.527810);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Schweiz. Arch. Tierheilkd.','SCHWEIZER ARCHIV FUR TIERHEILKUNDE','0036-7281',0.492000,0.000510,0.058190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Slov. Vet. Res.','Slovenian Veterinary Research','1580-4003',0.091000,0.000120,0.013620);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Physiol.-Heart Circul. Physiol.','AMERICAN JOURNAL OF PHYSIOLOGY-HEART AND CIRCULATORY PHYSIOLOGY','0363-6135',3.324000,0.036800,4.194280);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Atherosclerosis','ATHEROSCLEROSIS','0021-9150',3.942000,0.044610,5.084200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Heart Vessels','HEART AND VESSELS','0910-8327',2.293000,0.002670,0.304420);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Dis. Child.-Fetal Neonatal Ed.','Archives of Disease in Childhood-Fetal and Neonatal Edition','1359-2998',3.969000,0.009510,1.084150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Early Hum. Dev.','EARLY HUMAN DEVELOPMENT','0378-3782',1.913000,0.010000,1.139900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Child Health Care','Journal of Child Health Care','1367-4935',1.242000,0.001040,0.118460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Child Neurol.','JOURNAL OF CHILD NEUROLOGY','0883-0738',1.434000,0.009580,1.091480);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neurosurg.-Pediatr.','Journal of Neurosurgery-Pediatrics','1933-0707',1.757000,0.009700,1.105640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr. Orthop.-Part B','JOURNAL OF PEDIATRIC ORTHOPAEDICS-PART B','1060-152X',0.449000,0.001750,0.199110);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr. Urol','Journal of Pediatric Urology','1477-5131',1.170000,0.004750,0.541640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Pediatr.','JOURNAL OF PEDIATRICS','0022-3476',3.890000,0.044840,5.111100);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Perinat. Med.','JOURNAL OF PERINATAL MEDICINE','0300-5577',1.798000,0.004410,0.502080);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cancer Radiother.','Cancer Radiotherapie','1278-3218',1.299000,0.001530,0.173900);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Contrast Media Mol. Imaging','Contrast Media & Molecular Imaging','1555-4309',3.286000,0.002930,0.333510);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. Med. Imaging Rev.','Current Medical Imaging Reviews','1573-4056',0.613000,0.000830,0.094750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('IEEE Trans. Med. Imaging','IEEE TRANSACTIONS ON MEDICAL IMAGING','0278-0062',3.756000,0.024430,2.784400);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Hyperthermia','INTERNATIONAL JOURNAL OF HYPERTHERMIA','0265-6736',3.361000,0.003770,0.430240);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Int. J. Radiat. Res.','International Journal of Radiation Research','2322-3243',0.322000,0.000110,0.013000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Biomed. Opt.','JOURNAL OF BIOMEDICAL OPTICS','1083-3668',2.556000,0.025750,2.934970);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Clin. Ultrasound','JOURNAL OF CLINICAL ULTRASOUND','0091-2751',0.862000,0.002360,0.269120);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Med. Imaging Health Inform.','Journal of Medical Imaging and Health Informatics','2156-7018',0.877000,0.000960,0.109060);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Neuroimaging','JOURNAL OF NEUROIMAGING','1051-2284',1.625000,0.003690,0.420200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Ultrasound Med.','JOURNAL OF ULTRASOUND IN MEDICINE','0278-4297',1.544000,0.008890,1.012790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('JACC-Cardiovasc. Imag.','JACC-Cardiovascular Imaging','1936-878X',7.815000,0.023520,2.680250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Image Anal.','MEDICAL IMAGE ANALYSIS','1361-8415',4.565000,0.010690,1.218710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Med. Ultrason.','Medical Ultrasonography','1844-4172',1.167000,0.001370,0.156190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Vasc. Interv. Radiol.','JOURNAL OF VASCULAR AND INTERVENTIONAL RADIOLOGY','1051-0443',2.570000,0.013000,1.482260);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Microvasc. Res.','MICROVASCULAR RESEARCH','0026-2862',2.300000,0.005560,0.633640);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Antivir. Ther.','ANTIVIRAL THERAPY','1359-6535',2.916000,0.009820,1.118790);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Curr. HIV Res.','CURRENT HIV RESEARCH','1570-162X',1.562000,0.003030,0.345570);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Med. Virol.','JOURNAL OF MEDICAL VIROLOGY','0146-6615',1.998000,0.013580,1.548210);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('South. Afr. J. HIV Med.','SOUTHERN AFRICAN JOURNAL OF HIV MEDICINE','1608-9693',0.529000,0.000470,0.053710);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Viruses-Basel','Viruses-Basel','1999-4915',3.042000,0.015710,1.790330);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Theriol.','ACTA THERIOLOGICA','0001-7051',0.944000,0.001150,0.131000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anim. Cells Syst.','Animal Cells and Systems','1976-8354',0.481000,0.000380,0.043050);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Anim. Cogn.','ANIMAL COGNITION','1435-9448',2.161000,0.005460,0.622170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Paediatr. Respir. Rev.','Paediatric Respiratory Reviews','1526-0542',2.536000,0.002700,0.307990);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr.  Anesth.','PEDIATRIC ANESTHESIA','1155-5645',2.082000,0.006070,0.691750);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Clin. N. Am.','PEDIATRIC CLINICS OF NORTH AMERICA','0031-3955',2.424000,0.004860,0.554250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Crit. Care Med.','Pediatric Critical Care Medicine','1529-7535',2.659000,0.011210,1.278190);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Emerg. Care','PEDIATRIC EMERGENCY CARE','0749-5161',0.923000,0.006340,0.722430);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Infect. Dis. J.','PEDIATRIC INFECTIOUS DISEASE JOURNAL','0891-3668',2.587000,0.023750,2.706880);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Neurol.','PEDIATRIC NEUROLOGY','0887-8994',1.866000,0.008310,0.947460);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Pediatr. Neurosurg.','PEDIATRIC NEUROSURGERY','1016-2291',0.245000,0.000940,0.106800);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('AAPS PharmSciTech','AAPS PHARMSCITECH','1530-9932',1.954000,0.005800,0.661250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Acta Pharmacol. Sin.','ACTA PHARMACOLOGICA SINICA','1671-4083',3.166000,0.009940,1.133150);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Antiviral Res.','ANTIVIRAL RESEARCH','0166-3542',4.909000,0.018080,2.061000);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Arch. Pharm. Res.','ARCHIVES OF PHARMACAL RESEARCH','0253-6269',2.490000,0.007910,0.901300);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bol. Latinoam. Caribe Plantas M.','Boletin Latinoamericano y del Caribe de Plantas Medicinales y Aromaticas','0717-7917',0.297000,0.000260,0.029180);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('NMR Biomed.','NMR IN BIOMEDICINE','0952-3480',2.983000,0.014830,1.689890);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Nucl. Med. Biol.','NUCLEAR MEDICINE AND BIOLOGY','0969-8051',2.429000,0.005950,0.677720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Radioprotection','RADIOPROTECTION','0033-8451',0.508000,0.000320,0.036250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Semin. Radiat. Oncol.','SEMINARS IN RADIATION ONCOLOGY','1053-4296',3.556000,0.003900,0.444720);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Phys. Med. Rehabil.','AMERICAN JOURNAL OF PHYSICAL MEDICINE & REHABILITATION','0894-9115',2.064000,0.007260,0.827380);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Am. J. Speech-Lang. Pathol.','AMERICAN JOURNAL OF SPEECH-LANGUAGE PATHOLOGY','1058-0360',1.413000,0.002400,0.273870);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Commun. Disord.','JOURNAL OF COMMUNICATION DISORDERS','0021-9924',1.278000,0.002170,0.247200);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Electromyogr. Kinesiol.','JOURNAL OF ELECTROMYOGRAPHY AND KINESIOLOGY','1050-6411',1.530000,0.006640,0.756940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. NeuroEng. Rehabil.','Journal of NeuroEngineering and Rehabilitation','1743-0003',2.419000,0.006790,0.773410);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Aust. Mammal.','AUSTRALIAN MAMMALOGY','0310-0049',0.872000,0.000690,0.078170);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Bull. Mens. Soc. Linn. Lyon','BULLETIN MENSUEL DE LA SOCIETE LINNEENNE DE LYON','0366-1326',0.067000,0.000040,0.004940);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Copeia','COPEIA','0045-8511',1.144000,0.002090,0.238270);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Cybium','CYBIUM','0399-0974',0.487000,0.000650,0.074250);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Ethol. Ecol. Evol.','ETHOLOGY ECOLOGY & EVOLUTION','0394-9370',1.655000,0.001150,0.130610);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Exp. Anim.','EXPERIMENTAL ANIMALS','1341-1357',1.247000,0.001270,0.145230);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Herpetol. Conserv. Biol.','Herpetological Conservation and Biology','2151-0733',0.768000,0.001240,0.141760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Integr. Zool.','Integrative Zoology','1749-4877',1.722000,0.001790,0.203760);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Amer. Assoc. Lab. Anim. Sci.','Journal of the American Association for Laboratory Animal Science','1559-6109',0.906000,0.002060,0.234560);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('J. Comp. Physiol. A -Neuroethol. Sens. Neural Behav. Physiol.','JOURNAL OF COMPARATIVE PHYSIOLOGY A-NEUROETHOLOGY SENSORY NEURAL AND BEHAVIORAL PHYSIOLOGY','0340-7594',1.988000,0.004890,0.556820);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('BMC Pharmacol. Toxicol.','BMC Pharmacology & Toxicology','2050-6511',2.030000,0.001420,0.162140);
INSERT IGNORE INTO tx_tuwinformations_journals (abbreviation,title,issn,impact_factor,eigenfactor,normeigenfactor) VALUES ('Chin. J. Nat. Med.','Chinese Journal of Natural Medicines','2095-6975',1.382000,0.001850,0.210310);
INSERT IGNORE INTO tx_tuwinformati